include(RunCMake)
set(RunCMake_TEST_TIMEOUT 60)

file(WRITE "${RunCMake_BINARY_DIR}/NotAGenerator-build/CPackConfig.cmake" [[
set(CPACK_PACKAGE_NAME "Test")
set(CPACK_PACKAGE_VERSION "1")
]])
set(RunCMake_TEST_NO_CLEAN 1)
run_cmake_command(NotAGenerator ${CMAKE_CPACK_COMMAND} -G NotAGenerator)
unset(RunCMake_TEST_NO_CLEAN)

function(run_MultiConfig)
  set(RunCMake_TEST_BINARY_DIR "${RunCMake_BINARY_DIR}/MultiConfig-build")
  run_cmake(MultiConfig)
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(MultiConfig-build-dbg ${CMAKE_COMMAND} --build . --config Debug)
  run_cmake_command(MultiConfig-build-rel ${CMAKE_COMMAND} --build . --config Release)
  run_cmake_command(MultiConfig-package ${CMAKE_CPACK_COMMAND} -G ZIP -C "Debug\;Release")
  set(zip_glob "${RunCMake_TEST_BINARY_DIR}/MultiConfig-0.1.1-*.zip")
  file(GLOB zips "${zip_glob}")
  set(zip_found 0)
  foreach(zip IN LISTS zips)
    set(zip_found 1)
    run_cmake_command(MultiConfig-check ${CMAKE_COMMAND} -E tar tf "${zip}")
  endforeach()
  if(NOT zip_found)
    message(SEND_ERROR "No package file found at\n ${zip_glob}")
  endif()
endfunction()

if(RunCMake_GENERATOR MATCHES "Visual Studio|Xcode")
  run_MultiConfig()
endif()

function(run_cpack_test name)
  set(RunCMake_TEST_BINARY_DIR "${RunCMake_BINARY_DIR}/${name}-build")
  run_cmake(${name})
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-package ${CMAKE_CPACK_COMMAND} -G ZIP)
endfunction()

run_cpack_test(ProjectConfigMissing)
run_cpack_test(ProjectConfigRelative)
