
include(RunCMake)

run_cmake(no-arguments)
run_cmake(bad-option)

function(check_list_syntax name test)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-${test}-build)
  set(RunCMake_TEST_VARIANT_DESCRIPTION " - ${name}")
  run_cmake_with_options(${test} ${ARGN})
endfunction()

## Unexpected arguments
### sub-commands with one argument
foreach (subcommand IN ITEMS LENGTH POP_BACK POP_FRONT REMOVE_DUPLICATES REVERSE)
  check_list_syntax (${subcommand} unexpected-arg "-DLIST_ARGUMENTS=${subcommand},ARG1,ARG2")
endforeach()

### sub-commands with two arguments
foreach (subcommand IN ITEMS FIND JOIN)
  check_list_syntax (${subcommand} unexpected-arg "-DLIST_ARGUMENTS=${subcommand},ARG1,ARG2,ARG3")
endforeach()

### sub-commands with three arguments
foreach (subcommand IN ITEMS SUBLIST FILTER)
  check_list_syntax (${subcommand} unexpected-arg "-DLIST_ARGUMENTS=${subcommand},ARG1,ARG2,ARG3,ARG4")
endforeach()

# TRANSFORM sub-commands
  set(RunCMake-stderr-file "TRANSFORM-unexpected-arg-stderr.txt")
foreach (action IN ITEMS TOLOWER TOUPPER STRIP)
  check_list_syntax (TRANSFORM-${action} unexpected-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,${action},ARG2")
endforeach()
foreach (action IN ITEMS APPEND PREPEND)
  check_list_syntax (TRANSFORM-${action} unexpected-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,${action},ARG2,ARG3")
endforeach()
foreach (action IN ITEMS REPLACE)
  check_list_syntax (TRANSFORM-${action} unexpected-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,${action},ARG2,ARG3,ARG4")
endforeach()
check_list_syntax (TRANSFORM-SELECTOR-REGEX unexpected-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,STRIP,REGEX,ARG2,ARG3")
check_list_syntax (TRANSFORM-SELECTOR-FOR unexpected-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,STRIP,FOR,1,2,3,4")
unset(RunCMake-stderr-file)

## Missing arguments
### sub-command with, at least, two arguments
foreach (subcommand IN ITEMS GET APPEND PREPEND REMOVE_ITEM REMOVE_AT TRANSFORM)
  check_list_syntax (${subcommand} missing-arg "-DLIST_ARGUMENTS=${subcommand},ARG1")
endforeach()

### sub-command with, at least, three arguments
foreach (subcommand IN ITEMS INSERT)
  check_list_syntax (${subcommand} missing-arg "-DLIST_ARGUMENTS=${subcommand},ARG1,ARG2")
endforeach()

# TRANSFORM sub-commands
set(RunCMake-stderr-file "TRANSFORM-missing-arg-stderr.txt")
foreach (action IN ITEMS APPEND PREPEND)
  check_list_syntax (TRANSFORM-${action} missing-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,${action}")
endforeach()
check_list_syntax (TRANSFORM-REPLACE-1 missing-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,REPLACE,ARG2")
check_list_syntax (TRANSFORM-REPLACE-2 missing-arg "-DLIST_ARGUMENTS=TRANSFORM,ARG1,REPLACE")
unset(RunCMake-stderr-file)


run_cmake(GET-wrong-index1)
run_cmake(GET-wrong-index2)
run_cmake(GET-wrong-index3)
run_cmake(SUBLIST-wrong-argument1)
run_cmake(SUBLIST-wrong-argument2)
run_cmake(INSERT-wrong-index1)
run_cmake(INSERT-wrong-index2)
run_cmake(REMOVE_AT-wrong-index1)
run_cmake(REMOVE_AT-wrong-index2)
run_cmake(REMOVE_AT-wrong-index3)
run_cmake(FILTER-wrong-operator)
run_cmake(FILTER-wrong-regex)
run_cmake(TRANSFORM-wrong-action)
run_cmake(TRANSFORM-REPLACE-wrong-regex)
run_cmake(TRANSFORM-REPLACE-invalid-replace1)
run_cmake(TRANSFORM-REPLACE-invalid-replace2)
run_cmake(TRANSFORM-selector-REGEX-no-arguments)
run_cmake(TRANSFORM-selector-REGEX-wrong-regex)
run_cmake(TRANSFORM-selector-AT-no-arguments)
run_cmake(TRANSFORM-selector-AT-wrong-argument)
run_cmake(TRANSFORM-selector-AT-wrong-index)
run_cmake(TRANSFORM-selector-FOR-no-arguments)
run_cmake(TRANSFORM-selector-FOR-missing-arguments)
run_cmake(TRANSFORM-selector-FOR-wrong-argument)
run_cmake(TRANSFORM-selector-FOR-wrong-index)
run_cmake(TRANSFORM-selector-FOR-zero-step)
run_cmake(TRANSFORM-selector-FOR-negative-step)
run_cmake(TRANSFORM-selector-FOR-backwards-range)
run_cmake(SORT-wrong-option)
run_cmake(SORT-wrong-COMPARE-option)
run_cmake(SORT-wrong-CASE-option)
run_cmake(SORT-wrong-ORDER-option)
run_cmake(SORT-duplicate-COMPARE-option)
run_cmake(SORT-duplicate-CASE-option)
run_cmake(SORT-duplicate-ORDER-option)


function(check_list_execution name)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  set(RunCMake_TEST_NO_CLEAN 1)
  set(RunCMake_TEST_VARIANT_DESCRIPTION " - ${name}")
  run_cmake_with_options(generate -DLIST_TEST=${name})
  run_cmake_command(check "${CMAKE_COMMAND}" "-DRunCMake_SOURCE_DIR=${RunCMake_SOURCE_DIR}" -P "${RunCMake_TEST_BINARY_DIR}/${name}.cmake")
endfunction()

check_list_execution (LENGTH)
check_list_execution (GET)
check_list_execution (JOIN)
check_list_execution (SUBLIST)
check_list_execution (FIND)
check_list_execution (APPEND)
check_list_execution (PREPEND)
check_list_execution (INSERT)
check_list_execution (POP_BACK)
check_list_execution (POP_FRONT)
check_list_execution (REMOVE_ITEM)
check_list_execution (REMOVE_AT)
check_list_execution (REMOVE_DUPLICATES)
check_list_execution (TRANSFORM-TOUPPER)
check_list_execution (TRANSFORM-TOLOWER)
check_list_execution (TRANSFORM-STRIP)
check_list_execution (TRANSFORM-APPEND)
check_list_execution (TRANSFORM-PREPEND)
check_list_execution (TRANSFORM-REPLACE)
check_list_execution (REVERSE)
check_list_execution (SORT)

run_cmake_with_options(CMP0186-OLD -DCMAKE_POLICY_DEFAULT_CMP0186=OLD)
run_cmake_with_options(CMP0186-NEW -DCMAKE_POLICY_DEFAULT_CMP0186=NEW)
