
include ("${RunCMake_SOURCE_DIR}/check_errors.cmake")
unset (errors)

set (path "/a/b")
cmake_path(HAS_ROOT_NAME path output)
if (output)
  list (APPEND errors "ROOT_NAME: ${path} has root name")
endif()
cmake_path(HAS_ROOT_DIRECTORY path output)
if (NOT output)
  list (APPEND errors "ROOT_DIRECTORY: ${path} does not have root directory")
endif()
cmake_path(HAS_ROOT_PATH path output)
if (NOT output)
  list (APPEND errors "ROOT_PATH: ${path} does not have root path")
endif()

set (path "a/b")
cmake_path(HAS_ROOT_PATH path output)
if (output)
  list (APPEND errors "ROOT_PATH: ${path} has root path")
endif()

set (path "/a/b")
cmake_path(HAS_FILENAME path output)
if (NOT output)
  list (APPEND errors "FILENAME: ${path} does not have filename")
endif()
set (path "a.b")
cmake_path(HAS_FILENAME path output)
if (NOT output)
  list (APPEND errors "FILENAME: ${path} does not have filename")
endif()
set (path "/a/b/")
cmake_path(HAS_FILENAME path output)
if (output)
  list (APPEND errors "FILENAME: ${path} has filename")
endif()
set (path "/")
cmake_path(HAS_FILENAME path output)
if (output)
  list (APPEND errors "FILENAME: ${path} has filename")
endif()

set (path "/a/b")
cmake_path(HAS_STEM path output)
if (NOT output)
  list (APPEND errors "STEM: ${path} does not have stem")
endif()
set (path "a.b")
cmake_path(HAS_STEM path output)
if (NOT output)
  list (APPEND errors "STEM: ${path} does not have stem")
endif()
set (path ".a")
cmake_path(HAS_STEM path output)
if (NOT output)
  list (APPEND errors "STEM: ${path} does not have stem")
endif()
set (path "/a/")
cmake_path(HAS_STEM path output)
if (output)
  list (APPEND errors "STEM: ${path} has stem")
endif()
set (path "/")
cmake_path(HAS_STEM path output)
if (output)
  list (APPEND errors "STEM: ${path} has stem")
endif()

set (path "/a/b.c")
cmake_path(HAS_EXTENSION path output)
if (NOT output)
  list (APPEND errors "EXTENSION: ${path} does not have extension")
endif()
set (path "b.c")
cmake_path(HAS_EXTENSION path output)
if (NOT output)
  list (APPEND errors "EXTENSION: ${path} does not have extension")
endif()
set (path "/.a")
cmake_path(HAS_EXTENSION path output)
if (output)
  list (APPEND errors "EXTENSION: ${path} has extension")
endif()
set (path "/a/")
cmake_path(HAS_EXTENSION path output)
if (output)
  list (APPEND errors "EXTENSION: ${path} has extension")
endif()
set (path "/")
cmake_path(HAS_EXTENSION path output)
if (output)
  list (APPEND errors "EXTENSION: ${path} has extension")
endif()

set (path "/a/b")
cmake_path(HAS_RELATIVE_PART path output)
if (NOT output)
  list (APPEND errors "RELATIVE_PART: ${path} does not have relative part")
endif()
set (path "/")
cmake_path(HAS_RELATIVE_PART path output)
if (output)
  list (APPEND errors "RELATIVE_PART: ${path} has relative part")
endif()

set (path "/a/b")
cmake_path(HAS_PARENT_PATH path output)
if (NOT output)
  list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
endif()
set (path "/")
cmake_path(HAS_PARENT_PATH path output)
if (NOT output)
  list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
endif()
set (path "a")
cmake_path(HAS_PARENT_PATH path output)
if (output)
  list (APPEND errors "PARENT_PATH: ${path} has parent path")
endif()

if (WIN32)
  set (path "c:/a/b")
  cmake_path(HAS_ROOT_NAME path output)
  if (NOT output)
    list (APPEND errors "ROOT_NAME: ${path} does not have root name")
  endif()
  cmake_path(HAS_ROOT_DIRECTORY path output)
  if (NOT output)
    list (APPEND errors "ROOT_DIRECTORY: ${path} does not have root directory")
  endif()
  cmake_path(HAS_ROOT_PATH path output)
  if (NOT output)
    list (APPEND errors "ROOT_PATH: ${path} does not have root path")
  endif()

  set (path "c:a/b")
  cmake_path(HAS_ROOT_NAME path output)
  if (NOT output)
    list (APPEND errors "ROOT_NAME: ${path} does not have root name")
  endif()
  cmake_path(HAS_ROOT_DIRECTORY path output)
  if (output)
    list (APPEND errors "ROOT_DIRECTORY: ${path} has root directory")
  endif()
  cmake_path(HAS_ROOT_PATH path output)
  if (NOT output)
    list (APPEND errors "ROOT_PATH: ${path} does not have root path")
  endif()

  set (path "//host/b")
  cmake_path(HAS_ROOT_NAME path output)
  if (NOT output)
    list (APPEND errors "ROOT_NAME: ${path} does not have root name")
  endif()
  cmake_path(HAS_ROOT_DIRECTORY path output)
  if (NOT output)
    list (APPEND errors "ROOT_DIRECTORY: ${path} does not have root directory")
  endif()
  cmake_path(HAS_ROOT_PATH path output)
  if (NOT output)
    list (APPEND errors "ROOT_PATH: ${path} does not have root path")
  endif()

  set (path "//host")
  cmake_path(HAS_ROOT_NAME path output)
  if (NOT output)
    list (APPEND errors "ROOT_NAME: ${path} does not have root name")
  endif()
  cmake_path(HAS_ROOT_DIRECTORY path output)
  if (output)
    list (APPEND errors "ROOT_DIRECTORY: ${path} has root directory")
  endif()
  cmake_path(HAS_ROOT_PATH path output)
  if (NOT output)
    list (APPEND errors "ROOT_PATH: ${path} does not have root path")
  endif()

  set (path "c:/a/b")
  cmake_path(HAS_RELATIVE_PART path output)
  if (NOT output)
    list (APPEND errors "RELATIVE_PART: ${path} does not have relative part")
  endif()

  set (path "c:a/b")
  cmake_path(HAS_RELATIVE_PART path output)
  if (NOT output)
    list (APPEND errors "RELATIVE_PART: ${path} does not have relative part")
  endif()

  set (path "//host/b")
  cmake_path(HAS_RELATIVE_PART path output)
  if (NOT output)
    list (APPEND errors "RELATIVE_PART: ${path} does not have relative part")
  endif()

  set (path "c:/a/b")
  cmake_path(HAS_PARENT_PATH path output)
  if (NOT output)
    list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
  endif()

  set (path "c:/")
  cmake_path(HAS_PARENT_PATH path output)
  if (NOT output)
    list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
  endif()

  set (path "c:")
  cmake_path(HAS_PARENT_PATH path output)
  if (NOT output)
    list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
  endif()

  set (path "//host/")
  cmake_path(HAS_PARENT_PATH path output)
  if (NOT output)
    list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
  endif()

  set (path "//host")
  cmake_path(HAS_PARENT_PATH path output)
  if (NOT output)
    list (APPEND errors "PARENT_PATH: ${path} does not have parent path")
  endif()
endif()


check_errors (HAS ${errors})
