/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     wangpeng <wangpeng@uniontech.com>
*
* Maintainer: wangpeng <wangpeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "dstyleoption.h"
#include "dwindowquitfullbutton.h"

#include <DStyledIconEngine>

DWIDGET_BEGIN_NAMESPACE

DWindowQuitFullButton::DWindowQuitFullButton(QWidget * parent)
    : DIconButton(parent)
{
    //DStyle::SP_TitleQuitFullButton
    auto iconEngine = new DStyledIconEngine(DDrawUtils::drawTitleQuitFullButton, QStringLiteral("TitleQuitFullButton"));
    setIcon(QIcon(iconEngine));
    setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Expanding);
    setFlat(true);
}

QSize DWindowQuitFullButton::sizeHint() const
{
    return iconSize();
}

void DWindowQuitFullButton::initStyleOption(DStyleOptionButton *option) const
{
    DIconButton::initStyleOption(option);

    option->features |= QStyleOptionButton::ButtonFeature(DStyleOptionButton::TitleBarButton);
}

DWIDGET_END_NAMESPACE
