#! /bin/sh
# Copyright (C) 2012 Red Hat, Inc.
# This file is part of elfutils.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# elfutils is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. $srcdir/test-subr.sh

# common.h
# #define ONE 1
# #define TWO 2
# #define THREE 3
#
# #define WORLD "World"
#
# int say (const char *prefix);
#
# #define A 'a'
# #define B b
# #define C "C"
#
# #ifdef THREE
# #undef THREE
# #define THREE(ARG1,ARG2,ARG3) ARG3
# #endif

# hello.c
# #include "common.h"
#
# int
# main (int argc, char **argv)
# {
#   return say (WORLD);
# }

# world.c
# #include "common.h"
#
# int
# say (const char *prefix)
# {
#   return prefix ? ONE : TWO;
# }

# gcc -g3 -c hello.c
# gcc -g3 -c world.c
# gcc -g3 -o testfilemacro hello.o world.o

testfiles testfilemacro

testrun_compare ${abs_top_builddir}/src/readelf --debug-dump=macro testfilemacro <<\EOF

DWARF section [32] '.debug_macro' at offset 0x2480:

 Offset:             0x0
 Version:            4
 Flag:               0x2 (debug_line_offset)
 Offset length:      4
 .debug_line offset: 0x0

 #include offset 0x1a
 start_file 0, [1] /home/mark/src/tests/hello.c
  start_file 1, [2] /home/mark/src/tests/common.h
   #include offset 0x582
  end_file
 end_file

 Offset:             0x1a
 Version:            4
 Flag:               0x0
 Offset length:      4

 #define __STDC__ 1, line 1 (indirect)
 #define __STDC_HOSTED__ 1, line 1 (indirect)
 #define __GNUC__ 4, line 1 (indirect)
 #define __GNUC_MINOR__ 7, line 1 (indirect)
 #define __GNUC_PATCHLEVEL__ 1, line 1 (indirect)
 #define __VERSION__ "4.7.1 20120629 (Red Hat 4.7.1-1)", line 1 (indirect)
 #define __GNUC_RH_RELEASE__ 1, line 1 (indirect)
 #define __ATOMIC_RELAXED 0, line 1 (indirect)
 #define __ATOMIC_SEQ_CST 5, line 1 (indirect)
 #define __ATOMIC_ACQUIRE 2, line 1 (indirect)
 #define __ATOMIC_RELEASE 3, line 1 (indirect)
 #define __ATOMIC_ACQ_REL 4, line 1 (indirect)
 #define __ATOMIC_CONSUME 1, line 1 (indirect)
 #define __FINITE_MATH_ONLY__ 0, line 1 (indirect)
 #define _LP64 1, line 1 (indirect)
 #define __LP64__ 1, line 1 (indirect)
 #define __SIZEOF_INT__ 4, line 1 (indirect)
 #define __SIZEOF_LONG__ 8, line 1 (indirect)
 #define __SIZEOF_LONG_LONG__ 8, line 1 (indirect)
 #define __SIZEOF_SHORT__ 2, line 1 (indirect)
 #define __SIZEOF_FLOAT__ 4, line 1 (indirect)
 #define __SIZEOF_DOUBLE__ 8, line 1 (indirect)
 #define __SIZEOF_LONG_DOUBLE__ 16, line 1 (indirect)
 #define __SIZEOF_SIZE_T__ 8, line 1 (indirect)
 #define __CHAR_BIT__ 8, line 1 (indirect)
 #define __BIGGEST_ALIGNMENT__ 16, line 1 (indirect)
 #define __ORDER_LITTLE_ENDIAN__ 1234, line 1 (indirect)
 #define __ORDER_BIG_ENDIAN__ 4321, line 1 (indirect)
 #define __ORDER_PDP_ENDIAN__ 3412, line 1 (indirect)
 #define __BYTE_ORDER__ __ORDER_LITTLE_ENDIAN__, line 1 (indirect)
 #define __FLOAT_WORD_ORDER__ __ORDER_LITTLE_ENDIAN__, line 1 (indirect)
 #define __SIZEOF_POINTER__ 8, line 1 (indirect)
 #define __SIZE_TYPE__ long unsigned int, line 1 (indirect)
 #define __PTRDIFF_TYPE__ long int, line 1 (indirect)
 #define __WCHAR_TYPE__ int, line 1 (indirect)
 #define __WINT_TYPE__ unsigned int, line 1 (indirect)
 #define __INTMAX_TYPE__ long int, line 1 (indirect)
 #define __UINTMAX_TYPE__ long unsigned int, line 1 (indirect)
 #define __CHAR16_TYPE__ short unsigned int, line 1 (indirect)
 #define __CHAR32_TYPE__ unsigned int, line 1 (indirect)
 #define __SIG_ATOMIC_TYPE__ int, line 1 (indirect)
 #define __INT8_TYPE__ signed char, line 1 (indirect)
 #define __INT16_TYPE__ short int, line 1 (indirect)
 #define __INT32_TYPE__ int, line 1 (indirect)
 #define __INT64_TYPE__ long int, line 1 (indirect)
 #define __UINT8_TYPE__ unsigned char, line 1 (indirect)
 #define __UINT16_TYPE__ short unsigned int, line 1 (indirect)
 #define __UINT32_TYPE__ unsigned int, line 1 (indirect)
 #define __UINT64_TYPE__ long unsigned int, line 1 (indirect)
 #define __INT_LEAST8_TYPE__ signed char, line 1 (indirect)
 #define __INT_LEAST16_TYPE__ short int, line 1 (indirect)
 #define __INT_LEAST32_TYPE__ int, line 1 (indirect)
 #define __INT_LEAST64_TYPE__ long int, line 1 (indirect)
 #define __UINT_LEAST8_TYPE__ unsigned char, line 1 (indirect)
 #define __UINT_LEAST16_TYPE__ short unsigned int, line 1 (indirect)
 #define __UINT_LEAST32_TYPE__ unsigned int, line 1 (indirect)
 #define __UINT_LEAST64_TYPE__ long unsigned int, line 1 (indirect)
 #define __INT_FAST8_TYPE__ signed char, line 1 (indirect)
 #define __INT_FAST16_TYPE__ long int, line 1 (indirect)
 #define __INT_FAST32_TYPE__ long int, line 1 (indirect)
 #define __INT_FAST64_TYPE__ long int, line 1 (indirect)
 #define __UINT_FAST8_TYPE__ unsigned char, line 1 (indirect)
 #define __UINT_FAST16_TYPE__ long unsigned int, line 1 (indirect)
 #define __UINT_FAST32_TYPE__ long unsigned int, line 1 (indirect)
 #define __UINT_FAST64_TYPE__ long unsigned int, line 1 (indirect)
 #define __INTPTR_TYPE__ long int, line 1 (indirect)
 #define __UINTPTR_TYPE__ long unsigned int, line 1 (indirect)
 #define __GXX_ABI_VERSION 1002, line 1 (indirect)
 #define __SCHAR_MAX__ 127, line 1 (indirect)
 #define __SHRT_MAX__ 32767, line 1 (indirect)
 #define __INT_MAX__ 2147483647, line 1 (indirect)
 #define __LONG_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __LONG_LONG_MAX__ 9223372036854775807LL, line 1 (indirect)
 #define __WCHAR_MAX__ 2147483647, line 1 (indirect)
 #define __WCHAR_MIN__ (-__WCHAR_MAX__ - 1), line 1 (indirect)
 #define __WINT_MAX__ 4294967295U, line 1 (indirect)
 #define __WINT_MIN__ 0U, line 1 (indirect)
 #define __PTRDIFF_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __SIZE_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __INTMAX_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __INTMAX_C(c) c ## L, line 1 (indirect)
 #define __UINTMAX_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __UINTMAX_C(c) c ## UL, line 1 (indirect)
 #define __SIG_ATOMIC_MAX__ 2147483647, line 1 (indirect)
 #define __SIG_ATOMIC_MIN__ (-__SIG_ATOMIC_MAX__ - 1), line 1 (indirect)
 #define __INT8_MAX__ 127, line 1 (indirect)
 #define __INT16_MAX__ 32767, line 1 (indirect)
 #define __INT32_MAX__ 2147483647, line 1 (indirect)
 #define __INT64_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __UINT8_MAX__ 255, line 1 (indirect)
 #define __UINT16_MAX__ 65535, line 1 (indirect)
 #define __UINT32_MAX__ 4294967295U, line 1 (indirect)
 #define __UINT64_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __INT_LEAST8_MAX__ 127, line 1 (indirect)
 #define __INT8_C(c) c, line 1 (indirect)
 #define __INT_LEAST16_MAX__ 32767, line 1 (indirect)
 #define __INT16_C(c) c, line 1 (indirect)
 #define __INT_LEAST32_MAX__ 2147483647, line 1 (indirect)
 #define __INT32_C(c) c, line 1 (indirect)
 #define __INT_LEAST64_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __INT64_C(c) c ## L, line 1 (indirect)
 #define __UINT_LEAST8_MAX__ 255, line 1 (indirect)
 #define __UINT8_C(c) c, line 1 (indirect)
 #define __UINT_LEAST16_MAX__ 65535, line 1 (indirect)
 #define __UINT16_C(c) c, line 1 (indirect)
 #define __UINT_LEAST32_MAX__ 4294967295U, line 1 (indirect)
 #define __UINT32_C(c) c ## U, line 1 (indirect)
 #define __UINT_LEAST64_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __UINT64_C(c) c ## UL, line 1 (indirect)
 #define __INT_FAST8_MAX__ 127, line 1 (indirect)
 #define __INT_FAST16_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __INT_FAST32_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __INT_FAST64_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __UINT_FAST8_MAX__ 255, line 1 (indirect)
 #define __UINT_FAST16_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __UINT_FAST32_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __UINT_FAST64_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __INTPTR_MAX__ 9223372036854775807L, line 1 (indirect)
 #define __UINTPTR_MAX__ 18446744073709551615UL, line 1 (indirect)
 #define __FLT_EVAL_METHOD__ 0, line 1 (indirect)
 #define __DEC_EVAL_METHOD__ 2, line 1 (indirect)
 #define __FLT_RADIX__ 2, line 1 (indirect)
 #define __FLT_MANT_DIG__ 24, line 1 (indirect)
 #define __FLT_DIG__ 6, line 1 (indirect)
 #define __FLT_MIN_EXP__ (-125), line 1 (indirect)
 #define __FLT_MIN_10_EXP__ (-37), line 1 (indirect)
 #define __FLT_MAX_EXP__ 128, line 1 (indirect)
 #define __FLT_MAX_10_EXP__ 38, line 1 (indirect)
 #define __FLT_DECIMAL_DIG__ 9, line 1 (indirect)
 #define __FLT_MAX__ 3.40282346638528859812e+38F, line 1 (indirect)
 #define __FLT_MIN__ 1.17549435082228750797e-38F, line 1 (indirect)
 #define __FLT_EPSILON__ 1.19209289550781250000e-7F, line 1 (indirect)
 #define __FLT_DENORM_MIN__ 1.40129846432481707092e-45F, line 1 (indirect)
 #define __FLT_HAS_DENORM__ 1, line 1 (indirect)
 #define __FLT_HAS_INFINITY__ 1, line 1 (indirect)
 #define __FLT_HAS_QUIET_NAN__ 1, line 1 (indirect)
 #define __DBL_MANT_DIG__ 53, line 1 (indirect)
 #define __DBL_DIG__ 15, line 1 (indirect)
 #define __DBL_MIN_EXP__ (-1021), line 1 (indirect)
 #define __DBL_MIN_10_EXP__ (-307), line 1 (indirect)
 #define __DBL_MAX_EXP__ 1024, line 1 (indirect)
 #define __DBL_MAX_10_EXP__ 308, line 1 (indirect)
 #define __DBL_DECIMAL_DIG__ 17, line 1 (indirect)
 #define __DBL_MAX__ ((double)1.79769313486231570815e+308L), line 1 (indirect)
 #define __DBL_MIN__ ((double)2.22507385850720138309e-308L), line 1 (indirect)
 #define __DBL_EPSILON__ ((double)2.22044604925031308085e-16L), line 1 (indirect)
 #define __DBL_DENORM_MIN__ ((double)4.94065645841246544177e-324L), line 1 (indirect)
 #define __DBL_HAS_DENORM__ 1, line 1 (indirect)
 #define __DBL_HAS_INFINITY__ 1, line 1 (indirect)
 #define __DBL_HAS_QUIET_NAN__ 1, line 1 (indirect)
 #define __LDBL_MANT_DIG__ 64, line 1 (indirect)
 #define __LDBL_DIG__ 18, line 1 (indirect)
 #define __LDBL_MIN_EXP__ (-16381), line 1 (indirect)
 #define __LDBL_MIN_10_EXP__ (-4931), line 1 (indirect)
 #define __LDBL_MAX_EXP__ 16384, line 1 (indirect)
 #define __LDBL_MAX_10_EXP__ 4932, line 1 (indirect)
 #define __DECIMAL_DIG__ 21, line 1 (indirect)
 #define __LDBL_MAX__ 1.18973149535723176502e+4932L, line 1 (indirect)
 #define __LDBL_MIN__ 3.36210314311209350626e-4932L, line 1 (indirect)
 #define __LDBL_EPSILON__ 1.08420217248550443401e-19L, line 1 (indirect)
 #define __LDBL_DENORM_MIN__ 3.64519953188247460253e-4951L, line 1 (indirect)
 #define __LDBL_HAS_DENORM__ 1, line 1 (indirect)
 #define __LDBL_HAS_INFINITY__ 1, line 1 (indirect)
 #define __LDBL_HAS_QUIET_NAN__ 1, line 1 (indirect)
 #define __DEC32_MANT_DIG__ 7, line 1 (indirect)
 #define __DEC32_MIN_EXP__ (-94), line 1 (indirect)
 #define __DEC32_MAX_EXP__ 97, line 1 (indirect)
 #define __DEC32_MIN__ 1E-95DF, line 1 (indirect)
 #define __DEC32_MAX__ 9.999999E96DF, line 1 (indirect)
 #define __DEC32_EPSILON__ 1E-6DF, line 1 (indirect)
 #define __DEC32_SUBNORMAL_MIN__ 0.000001E-95DF, line 1 (indirect)
 #define __DEC64_MANT_DIG__ 16, line 1 (indirect)
 #define __DEC64_MIN_EXP__ (-382), line 1 (indirect)
 #define __DEC64_MAX_EXP__ 385, line 1 (indirect)
 #define __DEC64_MIN__ 1E-383DD, line 1 (indirect)
 #define __DEC64_MAX__ 9.999999999999999E384DD, line 1 (indirect)
 #define __DEC64_EPSILON__ 1E-15DD, line 1 (indirect)
 #define __DEC64_SUBNORMAL_MIN__ 0.000000000000001E-383DD, line 1 (indirect)
 #define __DEC128_MANT_DIG__ 34, line 1 (indirect)
 #define __DEC128_MIN_EXP__ (-6142), line 1 (indirect)
 #define __DEC128_MAX_EXP__ 6145, line 1 (indirect)
 #define __DEC128_MIN__ 1E-6143DL, line 1 (indirect)
 #define __DEC128_MAX__ 9.999999999999999999999999999999999E6144DL, line 1 (indirect)
 #define __DEC128_EPSILON__ 1E-33DL, line 1 (indirect)
 #define __DEC128_SUBNORMAL_MIN__ 0.000000000000000000000000000000001E-6143DL, line 1 (indirect)
 #define __REGISTER_PREFIX__ , line 1 (indirect)
 #define __USER_LABEL_PREFIX__ , line 1 (indirect)
 #define __GNUC_GNU_INLINE__ 1, line 1 (indirect)
 #define __NO_INLINE__ 1, line 1 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1 1, line 1 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1, line 1 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1, line 1 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1, line 1 (indirect)
 #define __GCC_ATOMIC_BOOL_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_CHAR_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_CHAR16_T_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_CHAR32_T_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_WCHAR_T_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_SHORT_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_INT_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_LONG_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_LLONG_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_ATOMIC_TEST_AND_SET_TRUEVAL 1, line 1 (indirect)
 #define __GCC_ATOMIC_POINTER_LOCK_FREE 2, line 1 (indirect)
 #define __GCC_HAVE_DWARF2_CFI_ASM 1, line 1 (indirect)
 #define __PRAGMA_REDEFINE_EXTNAME 1, line 1 (indirect)
 #define __SIZEOF_INT128__ 16, line 1 (indirect)
 #define __SIZEOF_WCHAR_T__ 4, line 1 (indirect)
 #define __SIZEOF_WINT_T__ 4, line 1 (indirect)
 #define __SIZEOF_PTRDIFF_T__ 8, line 1 (indirect)
 #define __amd64 1, line 1 (indirect)
 #define __amd64__ 1, line 1 (indirect)
 #define __x86_64 1, line 1 (indirect)
 #define __x86_64__ 1, line 1 (indirect)
 #define __k8 1, line 1 (indirect)
 #define __k8__ 1, line 1 (indirect)
 #define __MMX__ 1, line 1 (indirect)
 #define __SSE__ 1, line 1 (indirect)
 #define __SSE2__ 1, line 1 (indirect)
 #define __SSE_MATH__ 1, line 1 (indirect)
 #define __SSE2_MATH__ 1, line 1 (indirect)
 #define __gnu_linux__ 1, line 1 (indirect)
 #define __linux 1, line 1 (indirect)
 #define __linux__ 1, line 1 (indirect)
 #define linux 1, line 1 (indirect)
 #define __unix 1, line 1 (indirect)
 #define __unix__ 1, line 1 (indirect)
 #define unix 1, line 1 (indirect)
 #define __ELF__ 1, line 1 (indirect)
 #define __DECIMAL_BID_FORMAT__ 1, line 1 (indirect)

 Offset:             0x582
 Version:            4
 Flag:               0x0
 Offset length:      4

 #define ONE 1, line 1 (indirect)
 #define TWO 2, line 2 (indirect)
 #define THREE 3, line 3 (indirect)
 #define WORLD "World", line 5 (indirect)
 #define A 'a', line 9 (indirect)
 #define B b, line 10
 #define C "C", line 11 (indirect)
 #undef THREE, line 14 (indirect)
 #define THREE(ARG1,ARG2,ARG3) ARG3, line 15 (indirect)

 Offset:             0x5bc
 Version:            4
 Flag:               0x2 (debug_line_offset)
 Offset length:      4
 .debug_line offset: 0x47

 #include offset 0x1a
 start_file 0, [1] /home/mark/src/tests/world.c
  start_file 1, [2] /home/mark/src/tests/common.h
   #include offset 0x582
  end_file
 end_file

EOF

# Same sources as above, but now using clang
# gcc -g3 -c hello.c
# gcc -g3 -c world.c
# gcc -g3 -o testfilemacro hello.o world.o

# clang -gdwarf-5 -fdebug-macro -c hello.c
# clang -gdwarf-5 -fdebug-macro -c world.c
# clang -gdwarf-5 -fdebug-macro -o testfileclangmacro hello.o world.o

testfiles testfileclangmacro

testrun_compare ${abs_top_builddir}/src/readelf --debug-dump=macro testfileclangmacro <<\EOF

DWARF section [33] '.debug_macro' at offset 0x5b9b:

 Offset:             0x0
 Version:            5
 Flag:               0x2 (debug_line_offset)
 Offset length:      4
 .debug_line offset: 0x0

 start_file 0, [0] /home/mark/src/tests/hello.c
  start_file 1, [1] ./common.h
   #define ONE 1 (9), line 1 (strx)
   #define TWO 2 (10), line 2 (strx)
   #define THREE 3 (11), line 3 (strx)
   #define WORLD "World" (12), line 5 (strx)
   #define A 'a' (13), line 9 (strx)
   #define B b (14), line 10 (strx)
   #define C "C" (15), line 11 (strx)
   #undef THREE (16), line 14 (strx)
   #define THREE(ARG1,ARG2,ARG3) ARG3 (17), line 15 (strx)
  end_file
 end_file
 #define __llvm__ 1 (18), line 0 (strx)
 #define __clang__ 1 (19), line 0 (strx)
 #define __clang_major__ 17 (20), line 0 (strx)
 #define __clang_minor__ 0 (21), line 0 (strx)
 #define __clang_patchlevel__ 6 (22), line 0 (strx)
 #define __clang_version__ "17.0.6 (Fedora 17.0.6-2.fc39)" (23), line 0 (strx)
 #define __GNUC__ 4 (24), line 0 (strx)
 #define __GNUC_MINOR__ 2 (25), line 0 (strx)
 #define __GNUC_PATCHLEVEL__ 1 (26), line 0 (strx)
 #define __GXX_ABI_VERSION 1002 (27), line 0 (strx)
 #define __ATOMIC_RELAXED 0 (28), line 0 (strx)
 #define __ATOMIC_CONSUME 1 (29), line 0 (strx)
 #define __ATOMIC_ACQUIRE 2 (30), line 0 (strx)
 #define __ATOMIC_RELEASE 3 (31), line 0 (strx)
 #define __ATOMIC_ACQ_REL 4 (32), line 0 (strx)
 #define __ATOMIC_SEQ_CST 5 (33), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_WORK_ITEM 0 (34), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_WORK_GROUP 1 (35), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_DEVICE 2 (36), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_ALL_SVM_DEVICES 3 (37), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_SUB_GROUP 4 (38), line 0 (strx)
 #define __FPCLASS_SNAN 0x0001 (39), line 0 (strx)
 #define __FPCLASS_QNAN 0x0002 (40), line 0 (strx)
 #define __FPCLASS_NEGINF 0x0004 (41), line 0 (strx)
 #define __FPCLASS_NEGNORMAL 0x0008 (42), line 0 (strx)
 #define __FPCLASS_NEGSUBNORMAL 0x0010 (43), line 0 (strx)
 #define __FPCLASS_NEGZERO 0x0020 (44), line 0 (strx)
 #define __FPCLASS_POSZERO 0x0040 (45), line 0 (strx)
 #define __FPCLASS_POSSUBNORMAL 0x0080 (46), line 0 (strx)
 #define __FPCLASS_POSNORMAL 0x0100 (47), line 0 (strx)
 #define __FPCLASS_POSINF 0x0200 (48), line 0 (strx)
 #define __PRAGMA_REDEFINE_EXTNAME 1 (49), line 0 (strx)
 #define __VERSION__ "Clang 17.0.6 (Fedora 17.0.6-2.fc39)" (50), line 0 (strx)
 #define __OBJC_BOOL_IS_BOOL 0 (51), line 0 (strx)
 #define __CONSTANT_CFSTRINGS__ 1 (52), line 0 (strx)
 #define __clang_literal_encoding__ "UTF-8" (53), line 0 (strx)
 #define __clang_wide_literal_encoding__ "UTF-32" (54), line 0 (strx)
 #define __ORDER_LITTLE_ENDIAN__ 1234 (55), line 0 (strx)
 #define __ORDER_BIG_ENDIAN__ 4321 (56), line 0 (strx)
 #define __ORDER_PDP_ENDIAN__ 3412 (57), line 0 (strx)
 #define __BYTE_ORDER__ __ORDER_LITTLE_ENDIAN__ (58), line 0 (strx)
 #define __LITTLE_ENDIAN__ 1 (59), line 0 (strx)
 #define _LP64 1 (60), line 0 (strx)
 #define __LP64__ 1 (61), line 0 (strx)
 #define __CHAR_BIT__ 8 (62), line 0 (strx)
 #define __BOOL_WIDTH__ 8 (63), line 0 (strx)
 #define __SHRT_WIDTH__ 16 (64), line 0 (strx)
 #define __INT_WIDTH__ 32 (65), line 0 (strx)
 #define __LONG_WIDTH__ 64 (66), line 0 (strx)
 #define __LLONG_WIDTH__ 64 (67), line 0 (strx)
 #define __BITINT_MAXWIDTH__ 8388608 (68), line 0 (strx)
 #define __SCHAR_MAX__ 127 (69), line 0 (strx)
 #define __SHRT_MAX__ 32767 (70), line 0 (strx)
 #define __INT_MAX__ 2147483647 (71), line 0 (strx)
 #define __LONG_MAX__ 9223372036854775807L (72), line 0 (strx)
 #define __LONG_LONG_MAX__ 9223372036854775807LL (73), line 0 (strx)
 #define __WCHAR_MAX__ 2147483647 (74), line 0 (strx)
 #define __WCHAR_WIDTH__ 32 (75), line 0 (strx)
 #define __WINT_MAX__ 4294967295U (76), line 0 (strx)
 #define __WINT_WIDTH__ 32 (77), line 0 (strx)
 #define __INTMAX_MAX__ 9223372036854775807L (78), line 0 (strx)
 #define __INTMAX_WIDTH__ 64 (79), line 0 (strx)
 #define __SIZE_MAX__ 18446744073709551615UL (80), line 0 (strx)
 #define __SIZE_WIDTH__ 64 (81), line 0 (strx)
 #define __UINTMAX_MAX__ 18446744073709551615UL (82), line 0 (strx)
 #define __UINTMAX_WIDTH__ 64 (83), line 0 (strx)
 #define __PTRDIFF_MAX__ 9223372036854775807L (84), line 0 (strx)
 #define __PTRDIFF_WIDTH__ 64 (85), line 0 (strx)
 #define __INTPTR_MAX__ 9223372036854775807L (86), line 0 (strx)
 #define __INTPTR_WIDTH__ 64 (87), line 0 (strx)
 #define __UINTPTR_MAX__ 18446744073709551615UL (88), line 0 (strx)
 #define __UINTPTR_WIDTH__ 64 (89), line 0 (strx)
 #define __SIZEOF_DOUBLE__ 8 (90), line 0 (strx)
 #define __SIZEOF_FLOAT__ 4 (91), line 0 (strx)
 #define __SIZEOF_INT__ 4 (92), line 0 (strx)
 #define __SIZEOF_LONG__ 8 (93), line 0 (strx)
 #define __SIZEOF_LONG_DOUBLE__ 16 (94), line 0 (strx)
 #define __SIZEOF_LONG_LONG__ 8 (95), line 0 (strx)
 #define __SIZEOF_POINTER__ 8 (96), line 0 (strx)
 #define __SIZEOF_SHORT__ 2 (97), line 0 (strx)
 #define __SIZEOF_PTRDIFF_T__ 8 (98), line 0 (strx)
 #define __SIZEOF_SIZE_T__ 8 (99), line 0 (strx)
 #define __SIZEOF_WCHAR_T__ 4 (100), line 0 (strx)
 #define __SIZEOF_WINT_T__ 4 (101), line 0 (strx)
 #define __SIZEOF_INT128__ 16 (102), line 0 (strx)
 #define __INTMAX_TYPE__ long int (103), line 0 (strx)
 #define __INTMAX_FMTd__ "ld" (104), line 0 (strx)
 #define __INTMAX_FMTi__ "li" (105), line 0 (strx)
 #define __INTMAX_C_SUFFIX__ L (106), line 0 (strx)
 #define __UINTMAX_TYPE__ long unsigned int (107), line 0 (strx)
 #define __UINTMAX_FMTo__ "lo" (108), line 0 (strx)
 #define __UINTMAX_FMTu__ "lu" (109), line 0 (strx)
 #define __UINTMAX_FMTx__ "lx" (110), line 0 (strx)
 #define __UINTMAX_FMTX__ "lX" (111), line 0 (strx)
 #define __UINTMAX_C_SUFFIX__ UL (112), line 0 (strx)
 #define __PTRDIFF_TYPE__ long int (113), line 0 (strx)
 #define __PTRDIFF_FMTd__ "ld" (114), line 0 (strx)
 #define __PTRDIFF_FMTi__ "li" (115), line 0 (strx)
 #define __INTPTR_TYPE__ long int (116), line 0 (strx)
 #define __INTPTR_FMTd__ "ld" (117), line 0 (strx)
 #define __INTPTR_FMTi__ "li" (118), line 0 (strx)
 #define __SIZE_TYPE__ long unsigned int (119), line 0 (strx)
 #define __SIZE_FMTo__ "lo" (120), line 0 (strx)
 #define __SIZE_FMTu__ "lu" (121), line 0 (strx)
 #define __SIZE_FMTx__ "lx" (122), line 0 (strx)
 #define __SIZE_FMTX__ "lX" (123), line 0 (strx)
 #define __WCHAR_TYPE__ int (124), line 0 (strx)
 #define __WINT_TYPE__ unsigned int (125), line 0 (strx)
 #define __SIG_ATOMIC_MAX__ 2147483647 (126), line 0 (strx)
 #define __SIG_ATOMIC_WIDTH__ 32 (127), line 0 (strx)
 #define __CHAR16_TYPE__ unsigned short (128), line 0 (strx)
 #define __CHAR32_TYPE__ unsigned int (129), line 0 (strx)
 #define __UINTPTR_TYPE__ long unsigned int (130), line 0 (strx)
 #define __UINTPTR_FMTo__ "lo" (131), line 0 (strx)
 #define __UINTPTR_FMTu__ "lu" (132), line 0 (strx)
 #define __UINTPTR_FMTx__ "lx" (133), line 0 (strx)
 #define __UINTPTR_FMTX__ "lX" (134), line 0 (strx)
 #define __FLT16_DENORM_MIN__ 5.9604644775390625e-8F16 (135), line 0 (strx)
 #define __FLT16_HAS_DENORM__ 1 (136), line 0 (strx)
 #define __FLT16_DIG__ 3 (137), line 0 (strx)
 #define __FLT16_DECIMAL_DIG__ 5 (138), line 0 (strx)
 #define __FLT16_EPSILON__ 9.765625e-4F16 (139), line 0 (strx)
 #define __FLT16_HAS_INFINITY__ 1 (140), line 0 (strx)
 #define __FLT16_HAS_QUIET_NAN__ 1 (141), line 0 (strx)
 #define __FLT16_MANT_DIG__ 11 (142), line 0 (strx)
 #define __FLT16_MAX_10_EXP__ 4 (143), line 0 (strx)
 #define __FLT16_MAX_EXP__ 16 (144), line 0 (strx)
 #define __FLT16_MAX__ 6.5504e+4F16 (145), line 0 (strx)
 #define __FLT16_MIN_10_EXP__ (-4) (146), line 0 (strx)
 #define __FLT16_MIN_EXP__ (-13) (147), line 0 (strx)
 #define __FLT16_MIN__ 6.103515625e-5F16 (148), line 0 (strx)
 #define __FLT_DENORM_MIN__ 1.40129846e-45F (149), line 0 (strx)
 #define __FLT_HAS_DENORM__ 1 (150), line 0 (strx)
 #define __FLT_DIG__ 6 (151), line 0 (strx)
 #define __FLT_DECIMAL_DIG__ 9 (152), line 0 (strx)
 #define __FLT_EPSILON__ 1.19209290e-7F (153), line 0 (strx)
 #define __FLT_HAS_INFINITY__ 1 (154), line 0 (strx)
 #define __FLT_HAS_QUIET_NAN__ 1 (155), line 0 (strx)
 #define __FLT_MANT_DIG__ 24 (156), line 0 (strx)
 #define __FLT_MAX_10_EXP__ 38 (157), line 0 (strx)
 #define __FLT_MAX_EXP__ 128 (158), line 0 (strx)
 #define __FLT_MAX__ 3.40282347e+38F (159), line 0 (strx)
 #define __FLT_MIN_10_EXP__ (-37) (160), line 0 (strx)
 #define __FLT_MIN_EXP__ (-125) (161), line 0 (strx)
 #define __FLT_MIN__ 1.17549435e-38F (162), line 0 (strx)
 #define __DBL_DENORM_MIN__ 4.9406564584124654e-324 (163), line 0 (strx)
 #define __DBL_HAS_DENORM__ 1 (164), line 0 (strx)
 #define __DBL_DIG__ 15 (165), line 0 (strx)
 #define __DBL_DECIMAL_DIG__ 17 (166), line 0 (strx)
 #define __DBL_EPSILON__ 2.2204460492503131e-16 (167), line 0 (strx)
 #define __DBL_HAS_INFINITY__ 1 (168), line 0 (strx)
 #define __DBL_HAS_QUIET_NAN__ 1 (169), line 0 (strx)
 #define __DBL_MANT_DIG__ 53 (170), line 0 (strx)
 #define __DBL_MAX_10_EXP__ 308 (171), line 0 (strx)
 #define __DBL_MAX_EXP__ 1024 (172), line 0 (strx)
 #define __DBL_MAX__ 1.7976931348623157e+308 (173), line 0 (strx)
 #define __DBL_MIN_10_EXP__ (-307) (174), line 0 (strx)
 #define __DBL_MIN_EXP__ (-1021) (175), line 0 (strx)
 #define __DBL_MIN__ 2.2250738585072014e-308 (176), line 0 (strx)
 #define __LDBL_DENORM_MIN__ 3.64519953188247460253e-4951L (177), line 0 (strx)
 #define __LDBL_HAS_DENORM__ 1 (178), line 0 (strx)
 #define __LDBL_DIG__ 18 (179), line 0 (strx)
 #define __LDBL_DECIMAL_DIG__ 21 (180), line 0 (strx)
 #define __LDBL_EPSILON__ 1.08420217248550443401e-19L (181), line 0 (strx)
 #define __LDBL_HAS_INFINITY__ 1 (182), line 0 (strx)
 #define __LDBL_HAS_QUIET_NAN__ 1 (183), line 0 (strx)
 #define __LDBL_MANT_DIG__ 64 (184), line 0 (strx)
 #define __LDBL_MAX_10_EXP__ 4932 (185), line 0 (strx)
 #define __LDBL_MAX_EXP__ 16384 (186), line 0 (strx)
 #define __LDBL_MAX__ 1.18973149535723176502e+4932L (187), line 0 (strx)
 #define __LDBL_MIN_10_EXP__ (-4931) (188), line 0 (strx)
 #define __LDBL_MIN_EXP__ (-16381) (189), line 0 (strx)
 #define __LDBL_MIN__ 3.36210314311209350626e-4932L (190), line 0 (strx)
 #define __POINTER_WIDTH__ 64 (191), line 0 (strx)
 #define __BIGGEST_ALIGNMENT__ 16 (192), line 0 (strx)
 #define __WINT_UNSIGNED__ 1 (193), line 0 (strx)
 #define __INT8_TYPE__ signed char (194), line 0 (strx)
 #define __INT8_FMTd__ "hhd" (195), line 0 (strx)
 #define __INT8_FMTi__ "hhi" (196), line 0 (strx)
 #define __INT8_C_SUFFIX__ (197), line 0 (strx)
 #define __INT16_TYPE__ short (198), line 0 (strx)
 #define __INT16_FMTd__ "hd" (199), line 0 (strx)
 #define __INT16_FMTi__ "hi" (200), line 0 (strx)
 #define __INT16_C_SUFFIX__ (201), line 0 (strx)
 #define __INT32_TYPE__ int (202), line 0 (strx)
 #define __INT32_FMTd__ "d" (203), line 0 (strx)
 #define __INT32_FMTi__ "i" (204), line 0 (strx)
 #define __INT32_C_SUFFIX__ (205), line 0 (strx)
 #define __INT64_TYPE__ long int (206), line 0 (strx)
 #define __INT64_FMTd__ "ld" (207), line 0 (strx)
 #define __INT64_FMTi__ "li" (208), line 0 (strx)
 #define __INT64_C_SUFFIX__ L (209), line 0 (strx)
 #define __UINT8_TYPE__ unsigned char (210), line 0 (strx)
 #define __UINT8_FMTo__ "hho" (211), line 0 (strx)
 #define __UINT8_FMTu__ "hhu" (212), line 0 (strx)
 #define __UINT8_FMTx__ "hhx" (213), line 0 (strx)
 #define __UINT8_FMTX__ "hhX" (214), line 0 (strx)
 #define __UINT8_C_SUFFIX__ (215), line 0 (strx)
 #define __UINT8_MAX__ 255 (216), line 0 (strx)
 #define __INT8_MAX__ 127 (217), line 0 (strx)
 #define __UINT16_TYPE__ unsigned short (218), line 0 (strx)
 #define __UINT16_FMTo__ "ho" (219), line 0 (strx)
 #define __UINT16_FMTu__ "hu" (220), line 0 (strx)
 #define __UINT16_FMTx__ "hx" (221), line 0 (strx)
 #define __UINT16_FMTX__ "hX" (222), line 0 (strx)
 #define __UINT16_C_SUFFIX__ (223), line 0 (strx)
 #define __UINT16_MAX__ 65535 (224), line 0 (strx)
 #define __INT16_MAX__ 32767 (225), line 0 (strx)
 #define __UINT32_TYPE__ unsigned int (226), line 0 (strx)
 #define __UINT32_FMTo__ "o" (227), line 0 (strx)
 #define __UINT32_FMTu__ "u" (228), line 0 (strx)
 #define __UINT32_FMTx__ "x" (229), line 0 (strx)
 #define __UINT32_FMTX__ "X" (230), line 0 (strx)
 #define __UINT32_C_SUFFIX__ U (231), line 0 (strx)
 #define __UINT32_MAX__ 4294967295U (232), line 0 (strx)
 #define __INT32_MAX__ 2147483647 (233), line 0 (strx)
 #define __UINT64_TYPE__ long unsigned int (234), line 0 (strx)
 #define __UINT64_FMTo__ "lo" (235), line 0 (strx)
 #define __UINT64_FMTu__ "lu" (236), line 0 (strx)
 #define __UINT64_FMTx__ "lx" (237), line 0 (strx)
 #define __UINT64_FMTX__ "lX" (238), line 0 (strx)
 #define __UINT64_C_SUFFIX__ UL (239), line 0 (strx)
 #define __UINT64_MAX__ 18446744073709551615UL (240), line 0 (strx)
 #define __INT64_MAX__ 9223372036854775807L (241), line 0 (strx)
 #define __INT_LEAST8_TYPE__ signed char (242), line 0 (strx)
 #define __INT_LEAST8_MAX__ 127 (243), line 0 (strx)
 #define __INT_LEAST8_WIDTH__ 8 (244), line 0 (strx)
 #define __INT_LEAST8_FMTd__ "hhd" (245), line 0 (strx)
 #define __INT_LEAST8_FMTi__ "hhi" (246), line 0 (strx)
 #define __UINT_LEAST8_TYPE__ unsigned char (247), line 0 (strx)
 #define __UINT_LEAST8_MAX__ 255 (248), line 0 (strx)
 #define __UINT_LEAST8_FMTo__ "hho" (249), line 0 (strx)
 #define __UINT_LEAST8_FMTu__ "hhu" (250), line 0 (strx)
 #define __UINT_LEAST8_FMTx__ "hhx" (251), line 0 (strx)
 #define __UINT_LEAST8_FMTX__ "hhX" (252), line 0 (strx)
 #define __INT_LEAST16_TYPE__ short (253), line 0 (strx)
 #define __INT_LEAST16_MAX__ 32767 (254), line 0 (strx)
 #define __INT_LEAST16_WIDTH__ 16 (255), line 0 (strx)
 #define __INT_LEAST16_FMTd__ "hd" (256), line 0 (strx)
 #define __INT_LEAST16_FMTi__ "hi" (257), line 0 (strx)
 #define __UINT_LEAST16_TYPE__ unsigned short (258), line 0 (strx)
 #define __UINT_LEAST16_MAX__ 65535 (259), line 0 (strx)
 #define __UINT_LEAST16_FMTo__ "ho" (260), line 0 (strx)
 #define __UINT_LEAST16_FMTu__ "hu" (261), line 0 (strx)
 #define __UINT_LEAST16_FMTx__ "hx" (262), line 0 (strx)
 #define __UINT_LEAST16_FMTX__ "hX" (263), line 0 (strx)
 #define __INT_LEAST32_TYPE__ int (264), line 0 (strx)
 #define __INT_LEAST32_MAX__ 2147483647 (265), line 0 (strx)
 #define __INT_LEAST32_WIDTH__ 32 (266), line 0 (strx)
 #define __INT_LEAST32_FMTd__ "d" (267), line 0 (strx)
 #define __INT_LEAST32_FMTi__ "i" (268), line 0 (strx)
 #define __UINT_LEAST32_TYPE__ unsigned int (269), line 0 (strx)
 #define __UINT_LEAST32_MAX__ 4294967295U (270), line 0 (strx)
 #define __UINT_LEAST32_FMTo__ "o" (271), line 0 (strx)
 #define __UINT_LEAST32_FMTu__ "u" (272), line 0 (strx)
 #define __UINT_LEAST32_FMTx__ "x" (273), line 0 (strx)
 #define __UINT_LEAST32_FMTX__ "X" (274), line 0 (strx)
 #define __INT_LEAST64_TYPE__ long int (275), line 0 (strx)
 #define __INT_LEAST64_MAX__ 9223372036854775807L (276), line 0 (strx)
 #define __INT_LEAST64_WIDTH__ 64 (277), line 0 (strx)
 #define __INT_LEAST64_FMTd__ "ld" (278), line 0 (strx)
 #define __INT_LEAST64_FMTi__ "li" (279), line 0 (strx)
 #define __UINT_LEAST64_TYPE__ long unsigned int (280), line 0 (strx)
 #define __UINT_LEAST64_MAX__ 18446744073709551615UL (281), line 0 (strx)
 #define __UINT_LEAST64_FMTo__ "lo" (282), line 0 (strx)
 #define __UINT_LEAST64_FMTu__ "lu" (283), line 0 (strx)
 #define __UINT_LEAST64_FMTx__ "lx" (284), line 0 (strx)
 #define __UINT_LEAST64_FMTX__ "lX" (285), line 0 (strx)
 #define __INT_FAST8_TYPE__ signed char (286), line 0 (strx)
 #define __INT_FAST8_MAX__ 127 (287), line 0 (strx)
 #define __INT_FAST8_WIDTH__ 8 (288), line 0 (strx)
 #define __INT_FAST8_FMTd__ "hhd" (289), line 0 (strx)
 #define __INT_FAST8_FMTi__ "hhi" (290), line 0 (strx)
 #define __UINT_FAST8_TYPE__ unsigned char (291), line 0 (strx)
 #define __UINT_FAST8_MAX__ 255 (292), line 0 (strx)
 #define __UINT_FAST8_FMTo__ "hho" (293), line 0 (strx)
 #define __UINT_FAST8_FMTu__ "hhu" (294), line 0 (strx)
 #define __UINT_FAST8_FMTx__ "hhx" (295), line 0 (strx)
 #define __UINT_FAST8_FMTX__ "hhX" (296), line 0 (strx)
 #define __INT_FAST16_TYPE__ short (297), line 0 (strx)
 #define __INT_FAST16_MAX__ 32767 (298), line 0 (strx)
 #define __INT_FAST16_WIDTH__ 16 (299), line 0 (strx)
 #define __INT_FAST16_FMTd__ "hd" (300), line 0 (strx)
 #define __INT_FAST16_FMTi__ "hi" (301), line 0 (strx)
 #define __UINT_FAST16_TYPE__ unsigned short (302), line 0 (strx)
 #define __UINT_FAST16_MAX__ 65535 (303), line 0 (strx)
 #define __UINT_FAST16_FMTo__ "ho" (304), line 0 (strx)
 #define __UINT_FAST16_FMTu__ "hu" (305), line 0 (strx)
 #define __UINT_FAST16_FMTx__ "hx" (306), line 0 (strx)
 #define __UINT_FAST16_FMTX__ "hX" (307), line 0 (strx)
 #define __INT_FAST32_TYPE__ int (308), line 0 (strx)
 #define __INT_FAST32_MAX__ 2147483647 (309), line 0 (strx)
 #define __INT_FAST32_WIDTH__ 32 (310), line 0 (strx)
 #define __INT_FAST32_FMTd__ "d" (311), line 0 (strx)
 #define __INT_FAST32_FMTi__ "i" (312), line 0 (strx)
 #define __UINT_FAST32_TYPE__ unsigned int (313), line 0 (strx)
 #define __UINT_FAST32_MAX__ 4294967295U (314), line 0 (strx)
 #define __UINT_FAST32_FMTo__ "o" (315), line 0 (strx)
 #define __UINT_FAST32_FMTu__ "u" (316), line 0 (strx)
 #define __UINT_FAST32_FMTx__ "x" (317), line 0 (strx)
 #define __UINT_FAST32_FMTX__ "X" (318), line 0 (strx)
 #define __INT_FAST64_TYPE__ long int (319), line 0 (strx)
 #define __INT_FAST64_MAX__ 9223372036854775807L (320), line 0 (strx)
 #define __INT_FAST64_WIDTH__ 64 (321), line 0 (strx)
 #define __INT_FAST64_FMTd__ "ld" (322), line 0 (strx)
 #define __INT_FAST64_FMTi__ "li" (323), line 0 (strx)
 #define __UINT_FAST64_TYPE__ long unsigned int (324), line 0 (strx)
 #define __UINT_FAST64_MAX__ 18446744073709551615UL (325), line 0 (strx)
 #define __UINT_FAST64_FMTo__ "lo" (326), line 0 (strx)
 #define __UINT_FAST64_FMTu__ "lu" (327), line 0 (strx)
 #define __UINT_FAST64_FMTx__ "lx" (328), line 0 (strx)
 #define __UINT_FAST64_FMTX__ "lX" (329), line 0 (strx)
 #define __USER_LABEL_PREFIX__ (330), line 0 (strx)
 #define __FINITE_MATH_ONLY__ 0 (331), line 0 (strx)
 #define __GNUC_STDC_INLINE__ 1 (332), line 0 (strx)
 #define __GCC_ATOMIC_TEST_AND_SET_TRUEVAL 1 (333), line 0 (strx)
 #define __CLANG_ATOMIC_BOOL_LOCK_FREE 2 (334), line 0 (strx)
 #define __CLANG_ATOMIC_CHAR_LOCK_FREE 2 (335), line 0 (strx)
 #define __CLANG_ATOMIC_CHAR16_T_LOCK_FREE 2 (336), line 0 (strx)
 #define __CLANG_ATOMIC_CHAR32_T_LOCK_FREE 2 (337), line 0 (strx)
 #define __CLANG_ATOMIC_WCHAR_T_LOCK_FREE 2 (338), line 0 (strx)
 #define __CLANG_ATOMIC_SHORT_LOCK_FREE 2 (339), line 0 (strx)
 #define __CLANG_ATOMIC_INT_LOCK_FREE 2 (340), line 0 (strx)
 #define __CLANG_ATOMIC_LONG_LOCK_FREE 2 (341), line 0 (strx)
 #define __CLANG_ATOMIC_LLONG_LOCK_FREE 2 (342), line 0 (strx)
 #define __CLANG_ATOMIC_POINTER_LOCK_FREE 2 (343), line 0 (strx)
 #define __GCC_ATOMIC_BOOL_LOCK_FREE 2 (344), line 0 (strx)
 #define __GCC_ATOMIC_CHAR_LOCK_FREE 2 (345), line 0 (strx)
 #define __GCC_ATOMIC_CHAR16_T_LOCK_FREE 2 (346), line 0 (strx)
 #define __GCC_ATOMIC_CHAR32_T_LOCK_FREE 2 (347), line 0 (strx)
 #define __GCC_ATOMIC_WCHAR_T_LOCK_FREE 2 (348), line 0 (strx)
 #define __GCC_ATOMIC_SHORT_LOCK_FREE 2 (349), line 0 (strx)
 #define __GCC_ATOMIC_INT_LOCK_FREE 2 (350), line 0 (strx)
 #define __GCC_ATOMIC_LONG_LOCK_FREE 2 (351), line 0 (strx)
 #define __GCC_ATOMIC_LLONG_LOCK_FREE 2 (352), line 0 (strx)
 #define __GCC_ATOMIC_POINTER_LOCK_FREE 2 (353), line 0 (strx)
 #define __NO_INLINE__ 1 (354), line 0 (strx)
 #define __FLT_RADIX__ 2 (355), line 0 (strx)
 #define __DECIMAL_DIG__ __LDBL_DECIMAL_DIG__ (356), line 0 (strx)
 #define __ELF__ 1 (357), line 0 (strx)
 #define __GCC_ASM_FLAG_OUTPUTS__ 1 (358), line 0 (strx)
 #define __code_model_small__ 1 (359), line 0 (strx)
 #define __amd64__ 1 (360), line 0 (strx)
 #define __amd64 1 (361), line 0 (strx)
 #define __x86_64 1 (362), line 0 (strx)
 #define __x86_64__ 1 (363), line 0 (strx)
 #define __SEG_GS 1 (364), line 0 (strx)
 #define __SEG_FS 1 (365), line 0 (strx)
 #define __seg_gs __attribute__((address_space(256))) (366), line 0 (strx)
 #define __seg_fs __attribute__((address_space(257))) (367), line 0 (strx)
 #define __k8 1 (368), line 0 (strx)
 #define __k8__ 1 (369), line 0 (strx)
 #define __tune_k8__ 1 (370), line 0 (strx)
 #define __REGISTER_PREFIX__ (371), line 0 (strx)
 #define __NO_MATH_INLINES 1 (372), line 0 (strx)
 #define __FXSR__ 1 (373), line 0 (strx)
 #define __SSE2__ 1 (374), line 0 (strx)
 #define __SSE2_MATH__ 1 (375), line 0 (strx)
 #define __SSE__ 1 (376), line 0 (strx)
 #define __SSE_MATH__ 1 (377), line 0 (strx)
 #define __MMX__ 1 (378), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1 1 (379), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1 (380), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1 (381), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1 (382), line 0 (strx)
 #define __SIZEOF_FLOAT128__ 16 (383), line 0 (strx)
 #define unix 1 (384), line 0 (strx)
 #define __unix 1 (385), line 0 (strx)
 #define __unix__ 1 (386), line 0 (strx)
 #define linux 1 (387), line 0 (strx)
 #define __linux 1 (388), line 0 (strx)
 #define __linux__ 1 (389), line 0 (strx)
 #define __gnu_linux__ 1 (390), line 0 (strx)
 #define __FLOAT128__ 1 (391), line 0 (strx)
 #define __STDC__ 1 (392), line 0 (strx)
 #define __STDC_HOSTED__ 1 (393), line 0 (strx)
 #define __STDC_VERSION__ 201710L (394), line 0 (strx)
 #define __STDC_UTF_16__ 1 (395), line 0 (strx)
 #define __STDC_UTF_32__ 1 (396), line 0 (strx)
 #define __GCC_HAVE_DWARF2_CFI_ASM 1 (397), line 0 (strx)

 Offset:             0x5ad
 Version:            5
 Flag:               0x2 (debug_line_offset)
 Offset length:      4
 .debug_line offset: 0x79

 start_file 0, [0] /home/mark/src/tests/world.c
  start_file 1, [1] ./common.h
   #define ONE 1 (7), line 1 (strx)
   #define TWO 2 (8), line 2 (strx)
   #define THREE 3 (9), line 3 (strx)
   #define WORLD "World" (10), line 5 (strx)
   #define A 'a' (11), line 9 (strx)
   #define B b (12), line 10 (strx)
   #define C "C" (13), line 11 (strx)
   #undef THREE (14), line 14 (strx)
   #define THREE(ARG1,ARG2,ARG3) ARG3 (15), line 15 (strx)
  end_file
 end_file
 #define __llvm__ 1 (16), line 0 (strx)
 #define __clang__ 1 (17), line 0 (strx)
 #define __clang_major__ 17 (18), line 0 (strx)
 #define __clang_minor__ 0 (19), line 0 (strx)
 #define __clang_patchlevel__ 6 (20), line 0 (strx)
 #define __clang_version__ "17.0.6 (Fedora 17.0.6-2.fc39)" (21), line 0 (strx)
 #define __GNUC__ 4 (22), line 0 (strx)
 #define __GNUC_MINOR__ 2 (23), line 0 (strx)
 #define __GNUC_PATCHLEVEL__ 1 (24), line 0 (strx)
 #define __GXX_ABI_VERSION 1002 (25), line 0 (strx)
 #define __ATOMIC_RELAXED 0 (26), line 0 (strx)
 #define __ATOMIC_CONSUME 1 (27), line 0 (strx)
 #define __ATOMIC_ACQUIRE 2 (28), line 0 (strx)
 #define __ATOMIC_RELEASE 3 (29), line 0 (strx)
 #define __ATOMIC_ACQ_REL 4 (30), line 0 (strx)
 #define __ATOMIC_SEQ_CST 5 (31), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_WORK_ITEM 0 (32), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_WORK_GROUP 1 (33), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_DEVICE 2 (34), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_ALL_SVM_DEVICES 3 (35), line 0 (strx)
 #define __OPENCL_MEMORY_SCOPE_SUB_GROUP 4 (36), line 0 (strx)
 #define __FPCLASS_SNAN 0x0001 (37), line 0 (strx)
 #define __FPCLASS_QNAN 0x0002 (38), line 0 (strx)
 #define __FPCLASS_NEGINF 0x0004 (39), line 0 (strx)
 #define __FPCLASS_NEGNORMAL 0x0008 (40), line 0 (strx)
 #define __FPCLASS_NEGSUBNORMAL 0x0010 (41), line 0 (strx)
 #define __FPCLASS_NEGZERO 0x0020 (42), line 0 (strx)
 #define __FPCLASS_POSZERO 0x0040 (43), line 0 (strx)
 #define __FPCLASS_POSSUBNORMAL 0x0080 (44), line 0 (strx)
 #define __FPCLASS_POSNORMAL 0x0100 (45), line 0 (strx)
 #define __FPCLASS_POSINF 0x0200 (46), line 0 (strx)
 #define __PRAGMA_REDEFINE_EXTNAME 1 (47), line 0 (strx)
 #define __VERSION__ "Clang 17.0.6 (Fedora 17.0.6-2.fc39)" (48), line 0 (strx)
 #define __OBJC_BOOL_IS_BOOL 0 (49), line 0 (strx)
 #define __CONSTANT_CFSTRINGS__ 1 (50), line 0 (strx)
 #define __clang_literal_encoding__ "UTF-8" (51), line 0 (strx)
 #define __clang_wide_literal_encoding__ "UTF-32" (52), line 0 (strx)
 #define __ORDER_LITTLE_ENDIAN__ 1234 (53), line 0 (strx)
 #define __ORDER_BIG_ENDIAN__ 4321 (54), line 0 (strx)
 #define __ORDER_PDP_ENDIAN__ 3412 (55), line 0 (strx)
 #define __BYTE_ORDER__ __ORDER_LITTLE_ENDIAN__ (56), line 0 (strx)
 #define __LITTLE_ENDIAN__ 1 (57), line 0 (strx)
 #define _LP64 1 (58), line 0 (strx)
 #define __LP64__ 1 (59), line 0 (strx)
 #define __CHAR_BIT__ 8 (60), line 0 (strx)
 #define __BOOL_WIDTH__ 8 (61), line 0 (strx)
 #define __SHRT_WIDTH__ 16 (62), line 0 (strx)
 #define __INT_WIDTH__ 32 (63), line 0 (strx)
 #define __LONG_WIDTH__ 64 (64), line 0 (strx)
 #define __LLONG_WIDTH__ 64 (65), line 0 (strx)
 #define __BITINT_MAXWIDTH__ 8388608 (66), line 0 (strx)
 #define __SCHAR_MAX__ 127 (67), line 0 (strx)
 #define __SHRT_MAX__ 32767 (68), line 0 (strx)
 #define __INT_MAX__ 2147483647 (69), line 0 (strx)
 #define __LONG_MAX__ 9223372036854775807L (70), line 0 (strx)
 #define __LONG_LONG_MAX__ 9223372036854775807LL (71), line 0 (strx)
 #define __WCHAR_MAX__ 2147483647 (72), line 0 (strx)
 #define __WCHAR_WIDTH__ 32 (73), line 0 (strx)
 #define __WINT_MAX__ 4294967295U (74), line 0 (strx)
 #define __WINT_WIDTH__ 32 (75), line 0 (strx)
 #define __INTMAX_MAX__ 9223372036854775807L (76), line 0 (strx)
 #define __INTMAX_WIDTH__ 64 (77), line 0 (strx)
 #define __SIZE_MAX__ 18446744073709551615UL (78), line 0 (strx)
 #define __SIZE_WIDTH__ 64 (79), line 0 (strx)
 #define __UINTMAX_MAX__ 18446744073709551615UL (80), line 0 (strx)
 #define __UINTMAX_WIDTH__ 64 (81), line 0 (strx)
 #define __PTRDIFF_MAX__ 9223372036854775807L (82), line 0 (strx)
 #define __PTRDIFF_WIDTH__ 64 (83), line 0 (strx)
 #define __INTPTR_MAX__ 9223372036854775807L (84), line 0 (strx)
 #define __INTPTR_WIDTH__ 64 (85), line 0 (strx)
 #define __UINTPTR_MAX__ 18446744073709551615UL (86), line 0 (strx)
 #define __UINTPTR_WIDTH__ 64 (87), line 0 (strx)
 #define __SIZEOF_DOUBLE__ 8 (88), line 0 (strx)
 #define __SIZEOF_FLOAT__ 4 (89), line 0 (strx)
 #define __SIZEOF_INT__ 4 (90), line 0 (strx)
 #define __SIZEOF_LONG__ 8 (91), line 0 (strx)
 #define __SIZEOF_LONG_DOUBLE__ 16 (92), line 0 (strx)
 #define __SIZEOF_LONG_LONG__ 8 (93), line 0 (strx)
 #define __SIZEOF_POINTER__ 8 (94), line 0 (strx)
 #define __SIZEOF_SHORT__ 2 (95), line 0 (strx)
 #define __SIZEOF_PTRDIFF_T__ 8 (96), line 0 (strx)
 #define __SIZEOF_SIZE_T__ 8 (97), line 0 (strx)
 #define __SIZEOF_WCHAR_T__ 4 (98), line 0 (strx)
 #define __SIZEOF_WINT_T__ 4 (99), line 0 (strx)
 #define __SIZEOF_INT128__ 16 (100), line 0 (strx)
 #define __INTMAX_TYPE__ long int (101), line 0 (strx)
 #define __INTMAX_FMTd__ "ld" (102), line 0 (strx)
 #define __INTMAX_FMTi__ "li" (103), line 0 (strx)
 #define __INTMAX_C_SUFFIX__ L (104), line 0 (strx)
 #define __UINTMAX_TYPE__ long unsigned int (105), line 0 (strx)
 #define __UINTMAX_FMTo__ "lo" (106), line 0 (strx)
 #define __UINTMAX_FMTu__ "lu" (107), line 0 (strx)
 #define __UINTMAX_FMTx__ "lx" (108), line 0 (strx)
 #define __UINTMAX_FMTX__ "lX" (109), line 0 (strx)
 #define __UINTMAX_C_SUFFIX__ UL (110), line 0 (strx)
 #define __PTRDIFF_TYPE__ long int (111), line 0 (strx)
 #define __PTRDIFF_FMTd__ "ld" (112), line 0 (strx)
 #define __PTRDIFF_FMTi__ "li" (113), line 0 (strx)
 #define __INTPTR_TYPE__ long int (114), line 0 (strx)
 #define __INTPTR_FMTd__ "ld" (115), line 0 (strx)
 #define __INTPTR_FMTi__ "li" (116), line 0 (strx)
 #define __SIZE_TYPE__ long unsigned int (117), line 0 (strx)
 #define __SIZE_FMTo__ "lo" (118), line 0 (strx)
 #define __SIZE_FMTu__ "lu" (119), line 0 (strx)
 #define __SIZE_FMTx__ "lx" (120), line 0 (strx)
 #define __SIZE_FMTX__ "lX" (121), line 0 (strx)
 #define __WCHAR_TYPE__ int (122), line 0 (strx)
 #define __WINT_TYPE__ unsigned int (123), line 0 (strx)
 #define __SIG_ATOMIC_MAX__ 2147483647 (124), line 0 (strx)
 #define __SIG_ATOMIC_WIDTH__ 32 (125), line 0 (strx)
 #define __CHAR16_TYPE__ unsigned short (126), line 0 (strx)
 #define __CHAR32_TYPE__ unsigned int (127), line 0 (strx)
 #define __UINTPTR_TYPE__ long unsigned int (128), line 0 (strx)
 #define __UINTPTR_FMTo__ "lo" (129), line 0 (strx)
 #define __UINTPTR_FMTu__ "lu" (130), line 0 (strx)
 #define __UINTPTR_FMTx__ "lx" (131), line 0 (strx)
 #define __UINTPTR_FMTX__ "lX" (132), line 0 (strx)
 #define __FLT16_DENORM_MIN__ 5.9604644775390625e-8F16 (133), line 0 (strx)
 #define __FLT16_HAS_DENORM__ 1 (134), line 0 (strx)
 #define __FLT16_DIG__ 3 (135), line 0 (strx)
 #define __FLT16_DECIMAL_DIG__ 5 (136), line 0 (strx)
 #define __FLT16_EPSILON__ 9.765625e-4F16 (137), line 0 (strx)
 #define __FLT16_HAS_INFINITY__ 1 (138), line 0 (strx)
 #define __FLT16_HAS_QUIET_NAN__ 1 (139), line 0 (strx)
 #define __FLT16_MANT_DIG__ 11 (140), line 0 (strx)
 #define __FLT16_MAX_10_EXP__ 4 (141), line 0 (strx)
 #define __FLT16_MAX_EXP__ 16 (142), line 0 (strx)
 #define __FLT16_MAX__ 6.5504e+4F16 (143), line 0 (strx)
 #define __FLT16_MIN_10_EXP__ (-4) (144), line 0 (strx)
 #define __FLT16_MIN_EXP__ (-13) (145), line 0 (strx)
 #define __FLT16_MIN__ 6.103515625e-5F16 (146), line 0 (strx)
 #define __FLT_DENORM_MIN__ 1.40129846e-45F (147), line 0 (strx)
 #define __FLT_HAS_DENORM__ 1 (148), line 0 (strx)
 #define __FLT_DIG__ 6 (149), line 0 (strx)
 #define __FLT_DECIMAL_DIG__ 9 (150), line 0 (strx)
 #define __FLT_EPSILON__ 1.19209290e-7F (151), line 0 (strx)
 #define __FLT_HAS_INFINITY__ 1 (152), line 0 (strx)
 #define __FLT_HAS_QUIET_NAN__ 1 (153), line 0 (strx)
 #define __FLT_MANT_DIG__ 24 (154), line 0 (strx)
 #define __FLT_MAX_10_EXP__ 38 (155), line 0 (strx)
 #define __FLT_MAX_EXP__ 128 (156), line 0 (strx)
 #define __FLT_MAX__ 3.40282347e+38F (157), line 0 (strx)
 #define __FLT_MIN_10_EXP__ (-37) (158), line 0 (strx)
 #define __FLT_MIN_EXP__ (-125) (159), line 0 (strx)
 #define __FLT_MIN__ 1.17549435e-38F (160), line 0 (strx)
 #define __DBL_DENORM_MIN__ 4.9406564584124654e-324 (161), line 0 (strx)
 #define __DBL_HAS_DENORM__ 1 (162), line 0 (strx)
 #define __DBL_DIG__ 15 (163), line 0 (strx)
 #define __DBL_DECIMAL_DIG__ 17 (164), line 0 (strx)
 #define __DBL_EPSILON__ 2.2204460492503131e-16 (165), line 0 (strx)
 #define __DBL_HAS_INFINITY__ 1 (166), line 0 (strx)
 #define __DBL_HAS_QUIET_NAN__ 1 (167), line 0 (strx)
 #define __DBL_MANT_DIG__ 53 (168), line 0 (strx)
 #define __DBL_MAX_10_EXP__ 308 (169), line 0 (strx)
 #define __DBL_MAX_EXP__ 1024 (170), line 0 (strx)
 #define __DBL_MAX__ 1.7976931348623157e+308 (171), line 0 (strx)
 #define __DBL_MIN_10_EXP__ (-307) (172), line 0 (strx)
 #define __DBL_MIN_EXP__ (-1021) (173), line 0 (strx)
 #define __DBL_MIN__ 2.2250738585072014e-308 (174), line 0 (strx)
 #define __LDBL_DENORM_MIN__ 3.64519953188247460253e-4951L (175), line 0 (strx)
 #define __LDBL_HAS_DENORM__ 1 (176), line 0 (strx)
 #define __LDBL_DIG__ 18 (177), line 0 (strx)
 #define __LDBL_DECIMAL_DIG__ 21 (178), line 0 (strx)
 #define __LDBL_EPSILON__ 1.08420217248550443401e-19L (179), line 0 (strx)
 #define __LDBL_HAS_INFINITY__ 1 (180), line 0 (strx)
 #define __LDBL_HAS_QUIET_NAN__ 1 (181), line 0 (strx)
 #define __LDBL_MANT_DIG__ 64 (182), line 0 (strx)
 #define __LDBL_MAX_10_EXP__ 4932 (183), line 0 (strx)
 #define __LDBL_MAX_EXP__ 16384 (184), line 0 (strx)
 #define __LDBL_MAX__ 1.18973149535723176502e+4932L (185), line 0 (strx)
 #define __LDBL_MIN_10_EXP__ (-4931) (186), line 0 (strx)
 #define __LDBL_MIN_EXP__ (-16381) (187), line 0 (strx)
 #define __LDBL_MIN__ 3.36210314311209350626e-4932L (188), line 0 (strx)
 #define __POINTER_WIDTH__ 64 (189), line 0 (strx)
 #define __BIGGEST_ALIGNMENT__ 16 (190), line 0 (strx)
 #define __WINT_UNSIGNED__ 1 (191), line 0 (strx)
 #define __INT8_TYPE__ signed char (192), line 0 (strx)
 #define __INT8_FMTd__ "hhd" (193), line 0 (strx)
 #define __INT8_FMTi__ "hhi" (194), line 0 (strx)
 #define __INT8_C_SUFFIX__ (195), line 0 (strx)
 #define __INT16_TYPE__ short (196), line 0 (strx)
 #define __INT16_FMTd__ "hd" (197), line 0 (strx)
 #define __INT16_FMTi__ "hi" (198), line 0 (strx)
 #define __INT16_C_SUFFIX__ (199), line 0 (strx)
 #define __INT32_TYPE__ int (200), line 0 (strx)
 #define __INT32_FMTd__ "d" (201), line 0 (strx)
 #define __INT32_FMTi__ "i" (202), line 0 (strx)
 #define __INT32_C_SUFFIX__ (203), line 0 (strx)
 #define __INT64_TYPE__ long int (204), line 0 (strx)
 #define __INT64_FMTd__ "ld" (205), line 0 (strx)
 #define __INT64_FMTi__ "li" (206), line 0 (strx)
 #define __INT64_C_SUFFIX__ L (207), line 0 (strx)
 #define __UINT8_TYPE__ unsigned char (208), line 0 (strx)
 #define __UINT8_FMTo__ "hho" (209), line 0 (strx)
 #define __UINT8_FMTu__ "hhu" (210), line 0 (strx)
 #define __UINT8_FMTx__ "hhx" (211), line 0 (strx)
 #define __UINT8_FMTX__ "hhX" (212), line 0 (strx)
 #define __UINT8_C_SUFFIX__ (213), line 0 (strx)
 #define __UINT8_MAX__ 255 (214), line 0 (strx)
 #define __INT8_MAX__ 127 (215), line 0 (strx)
 #define __UINT16_TYPE__ unsigned short (216), line 0 (strx)
 #define __UINT16_FMTo__ "ho" (217), line 0 (strx)
 #define __UINT16_FMTu__ "hu" (218), line 0 (strx)
 #define __UINT16_FMTx__ "hx" (219), line 0 (strx)
 #define __UINT16_FMTX__ "hX" (220), line 0 (strx)
 #define __UINT16_C_SUFFIX__ (221), line 0 (strx)
 #define __UINT16_MAX__ 65535 (222), line 0 (strx)
 #define __INT16_MAX__ 32767 (223), line 0 (strx)
 #define __UINT32_TYPE__ unsigned int (224), line 0 (strx)
 #define __UINT32_FMTo__ "o" (225), line 0 (strx)
 #define __UINT32_FMTu__ "u" (226), line 0 (strx)
 #define __UINT32_FMTx__ "x" (227), line 0 (strx)
 #define __UINT32_FMTX__ "X" (228), line 0 (strx)
 #define __UINT32_C_SUFFIX__ U (229), line 0 (strx)
 #define __UINT32_MAX__ 4294967295U (230), line 0 (strx)
 #define __INT32_MAX__ 2147483647 (231), line 0 (strx)
 #define __UINT64_TYPE__ long unsigned int (232), line 0 (strx)
 #define __UINT64_FMTo__ "lo" (233), line 0 (strx)
 #define __UINT64_FMTu__ "lu" (234), line 0 (strx)
 #define __UINT64_FMTx__ "lx" (235), line 0 (strx)
 #define __UINT64_FMTX__ "lX" (236), line 0 (strx)
 #define __UINT64_C_SUFFIX__ UL (237), line 0 (strx)
 #define __UINT64_MAX__ 18446744073709551615UL (238), line 0 (strx)
 #define __INT64_MAX__ 9223372036854775807L (239), line 0 (strx)
 #define __INT_LEAST8_TYPE__ signed char (240), line 0 (strx)
 #define __INT_LEAST8_MAX__ 127 (241), line 0 (strx)
 #define __INT_LEAST8_WIDTH__ 8 (242), line 0 (strx)
 #define __INT_LEAST8_FMTd__ "hhd" (243), line 0 (strx)
 #define __INT_LEAST8_FMTi__ "hhi" (244), line 0 (strx)
 #define __UINT_LEAST8_TYPE__ unsigned char (245), line 0 (strx)
 #define __UINT_LEAST8_MAX__ 255 (246), line 0 (strx)
 #define __UINT_LEAST8_FMTo__ "hho" (247), line 0 (strx)
 #define __UINT_LEAST8_FMTu__ "hhu" (248), line 0 (strx)
 #define __UINT_LEAST8_FMTx__ "hhx" (249), line 0 (strx)
 #define __UINT_LEAST8_FMTX__ "hhX" (250), line 0 (strx)
 #define __INT_LEAST16_TYPE__ short (251), line 0 (strx)
 #define __INT_LEAST16_MAX__ 32767 (252), line 0 (strx)
 #define __INT_LEAST16_WIDTH__ 16 (253), line 0 (strx)
 #define __INT_LEAST16_FMTd__ "hd" (254), line 0 (strx)
 #define __INT_LEAST16_FMTi__ "hi" (255), line 0 (strx)
 #define __UINT_LEAST16_TYPE__ unsigned short (256), line 0 (strx)
 #define __UINT_LEAST16_MAX__ 65535 (257), line 0 (strx)
 #define __UINT_LEAST16_FMTo__ "ho" (258), line 0 (strx)
 #define __UINT_LEAST16_FMTu__ "hu" (259), line 0 (strx)
 #define __UINT_LEAST16_FMTx__ "hx" (260), line 0 (strx)
 #define __UINT_LEAST16_FMTX__ "hX" (261), line 0 (strx)
 #define __INT_LEAST32_TYPE__ int (262), line 0 (strx)
 #define __INT_LEAST32_MAX__ 2147483647 (263), line 0 (strx)
 #define __INT_LEAST32_WIDTH__ 32 (264), line 0 (strx)
 #define __INT_LEAST32_FMTd__ "d" (265), line 0 (strx)
 #define __INT_LEAST32_FMTi__ "i" (266), line 0 (strx)
 #define __UINT_LEAST32_TYPE__ unsigned int (267), line 0 (strx)
 #define __UINT_LEAST32_MAX__ 4294967295U (268), line 0 (strx)
 #define __UINT_LEAST32_FMTo__ "o" (269), line 0 (strx)
 #define __UINT_LEAST32_FMTu__ "u" (270), line 0 (strx)
 #define __UINT_LEAST32_FMTx__ "x" (271), line 0 (strx)
 #define __UINT_LEAST32_FMTX__ "X" (272), line 0 (strx)
 #define __INT_LEAST64_TYPE__ long int (273), line 0 (strx)
 #define __INT_LEAST64_MAX__ 9223372036854775807L (274), line 0 (strx)
 #define __INT_LEAST64_WIDTH__ 64 (275), line 0 (strx)
 #define __INT_LEAST64_FMTd__ "ld" (276), line 0 (strx)
 #define __INT_LEAST64_FMTi__ "li" (277), line 0 (strx)
 #define __UINT_LEAST64_TYPE__ long unsigned int (278), line 0 (strx)
 #define __UINT_LEAST64_MAX__ 18446744073709551615UL (279), line 0 (strx)
 #define __UINT_LEAST64_FMTo__ "lo" (280), line 0 (strx)
 #define __UINT_LEAST64_FMTu__ "lu" (281), line 0 (strx)
 #define __UINT_LEAST64_FMTx__ "lx" (282), line 0 (strx)
 #define __UINT_LEAST64_FMTX__ "lX" (283), line 0 (strx)
 #define __INT_FAST8_TYPE__ signed char (284), line 0 (strx)
 #define __INT_FAST8_MAX__ 127 (285), line 0 (strx)
 #define __INT_FAST8_WIDTH__ 8 (286), line 0 (strx)
 #define __INT_FAST8_FMTd__ "hhd" (287), line 0 (strx)
 #define __INT_FAST8_FMTi__ "hhi" (288), line 0 (strx)
 #define __UINT_FAST8_TYPE__ unsigned char (289), line 0 (strx)
 #define __UINT_FAST8_MAX__ 255 (290), line 0 (strx)
 #define __UINT_FAST8_FMTo__ "hho" (291), line 0 (strx)
 #define __UINT_FAST8_FMTu__ "hhu" (292), line 0 (strx)
 #define __UINT_FAST8_FMTx__ "hhx" (293), line 0 (strx)
 #define __UINT_FAST8_FMTX__ "hhX" (294), line 0 (strx)
 #define __INT_FAST16_TYPE__ short (295), line 0 (strx)
 #define __INT_FAST16_MAX__ 32767 (296), line 0 (strx)
 #define __INT_FAST16_WIDTH__ 16 (297), line 0 (strx)
 #define __INT_FAST16_FMTd__ "hd" (298), line 0 (strx)
 #define __INT_FAST16_FMTi__ "hi" (299), line 0 (strx)
 #define __UINT_FAST16_TYPE__ unsigned short (300), line 0 (strx)
 #define __UINT_FAST16_MAX__ 65535 (301), line 0 (strx)
 #define __UINT_FAST16_FMTo__ "ho" (302), line 0 (strx)
 #define __UINT_FAST16_FMTu__ "hu" (303), line 0 (strx)
 #define __UINT_FAST16_FMTx__ "hx" (304), line 0 (strx)
 #define __UINT_FAST16_FMTX__ "hX" (305), line 0 (strx)
 #define __INT_FAST32_TYPE__ int (306), line 0 (strx)
 #define __INT_FAST32_MAX__ 2147483647 (307), line 0 (strx)
 #define __INT_FAST32_WIDTH__ 32 (308), line 0 (strx)
 #define __INT_FAST32_FMTd__ "d" (309), line 0 (strx)
 #define __INT_FAST32_FMTi__ "i" (310), line 0 (strx)
 #define __UINT_FAST32_TYPE__ unsigned int (311), line 0 (strx)
 #define __UINT_FAST32_MAX__ 4294967295U (312), line 0 (strx)
 #define __UINT_FAST32_FMTo__ "o" (313), line 0 (strx)
 #define __UINT_FAST32_FMTu__ "u" (314), line 0 (strx)
 #define __UINT_FAST32_FMTx__ "x" (315), line 0 (strx)
 #define __UINT_FAST32_FMTX__ "X" (316), line 0 (strx)
 #define __INT_FAST64_TYPE__ long int (317), line 0 (strx)
 #define __INT_FAST64_MAX__ 9223372036854775807L (318), line 0 (strx)
 #define __INT_FAST64_WIDTH__ 64 (319), line 0 (strx)
 #define __INT_FAST64_FMTd__ "ld" (320), line 0 (strx)
 #define __INT_FAST64_FMTi__ "li" (321), line 0 (strx)
 #define __UINT_FAST64_TYPE__ long unsigned int (322), line 0 (strx)
 #define __UINT_FAST64_MAX__ 18446744073709551615UL (323), line 0 (strx)
 #define __UINT_FAST64_FMTo__ "lo" (324), line 0 (strx)
 #define __UINT_FAST64_FMTu__ "lu" (325), line 0 (strx)
 #define __UINT_FAST64_FMTx__ "lx" (326), line 0 (strx)
 #define __UINT_FAST64_FMTX__ "lX" (327), line 0 (strx)
 #define __USER_LABEL_PREFIX__ (328), line 0 (strx)
 #define __FINITE_MATH_ONLY__ 0 (329), line 0 (strx)
 #define __GNUC_STDC_INLINE__ 1 (330), line 0 (strx)
 #define __GCC_ATOMIC_TEST_AND_SET_TRUEVAL 1 (331), line 0 (strx)
 #define __CLANG_ATOMIC_BOOL_LOCK_FREE 2 (332), line 0 (strx)
 #define __CLANG_ATOMIC_CHAR_LOCK_FREE 2 (333), line 0 (strx)
 #define __CLANG_ATOMIC_CHAR16_T_LOCK_FREE 2 (334), line 0 (strx)
 #define __CLANG_ATOMIC_CHAR32_T_LOCK_FREE 2 (335), line 0 (strx)
 #define __CLANG_ATOMIC_WCHAR_T_LOCK_FREE 2 (336), line 0 (strx)
 #define __CLANG_ATOMIC_SHORT_LOCK_FREE 2 (337), line 0 (strx)
 #define __CLANG_ATOMIC_INT_LOCK_FREE 2 (338), line 0 (strx)
 #define __CLANG_ATOMIC_LONG_LOCK_FREE 2 (339), line 0 (strx)
 #define __CLANG_ATOMIC_LLONG_LOCK_FREE 2 (340), line 0 (strx)
 #define __CLANG_ATOMIC_POINTER_LOCK_FREE 2 (341), line 0 (strx)
 #define __GCC_ATOMIC_BOOL_LOCK_FREE 2 (342), line 0 (strx)
 #define __GCC_ATOMIC_CHAR_LOCK_FREE 2 (343), line 0 (strx)
 #define __GCC_ATOMIC_CHAR16_T_LOCK_FREE 2 (344), line 0 (strx)
 #define __GCC_ATOMIC_CHAR32_T_LOCK_FREE 2 (345), line 0 (strx)
 #define __GCC_ATOMIC_WCHAR_T_LOCK_FREE 2 (346), line 0 (strx)
 #define __GCC_ATOMIC_SHORT_LOCK_FREE 2 (347), line 0 (strx)
 #define __GCC_ATOMIC_INT_LOCK_FREE 2 (348), line 0 (strx)
 #define __GCC_ATOMIC_LONG_LOCK_FREE 2 (349), line 0 (strx)
 #define __GCC_ATOMIC_LLONG_LOCK_FREE 2 (350), line 0 (strx)
 #define __GCC_ATOMIC_POINTER_LOCK_FREE 2 (351), line 0 (strx)
 #define __NO_INLINE__ 1 (352), line 0 (strx)
 #define __FLT_RADIX__ 2 (353), line 0 (strx)
 #define __DECIMAL_DIG__ __LDBL_DECIMAL_DIG__ (354), line 0 (strx)
 #define __ELF__ 1 (355), line 0 (strx)
 #define __GCC_ASM_FLAG_OUTPUTS__ 1 (356), line 0 (strx)
 #define __code_model_small__ 1 (357), line 0 (strx)
 #define __amd64__ 1 (358), line 0 (strx)
 #define __amd64 1 (359), line 0 (strx)
 #define __x86_64 1 (360), line 0 (strx)
 #define __x86_64__ 1 (361), line 0 (strx)
 #define __SEG_GS 1 (362), line 0 (strx)
 #define __SEG_FS 1 (363), line 0 (strx)
 #define __seg_gs __attribute__((address_space(256))) (364), line 0 (strx)
 #define __seg_fs __attribute__((address_space(257))) (365), line 0 (strx)
 #define __k8 1 (366), line 0 (strx)
 #define __k8__ 1 (367), line 0 (strx)
 #define __tune_k8__ 1 (368), line 0 (strx)
 #define __REGISTER_PREFIX__ (369), line 0 (strx)
 #define __NO_MATH_INLINES 1 (370), line 0 (strx)
 #define __FXSR__ 1 (371), line 0 (strx)
 #define __SSE2__ 1 (372), line 0 (strx)
 #define __SSE2_MATH__ 1 (373), line 0 (strx)
 #define __SSE__ 1 (374), line 0 (strx)
 #define __SSE_MATH__ 1 (375), line 0 (strx)
 #define __MMX__ 1 (376), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1 1 (377), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1 (378), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1 (379), line 0 (strx)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1 (380), line 0 (strx)
 #define __SIZEOF_FLOAT128__ 16 (381), line 0 (strx)
 #define unix 1 (382), line 0 (strx)
 #define __unix 1 (383), line 0 (strx)
 #define __unix__ 1 (384), line 0 (strx)
 #define linux 1 (385), line 0 (strx)
 #define __linux 1 (386), line 0 (strx)
 #define __linux__ 1 (387), line 0 (strx)
 #define __gnu_linux__ 1 (388), line 0 (strx)
 #define __FLOAT128__ 1 (389), line 0 (strx)
 #define __STDC__ 1 (390), line 0 (strx)
 #define __STDC_HOSTED__ 1 (391), line 0 (strx)
 #define __STDC_VERSION__ 201710L (392), line 0 (strx)
 #define __STDC_UTF_16__ 1 (393), line 0 (strx)
 #define __STDC_UTF_32__ 1 (394), line 0 (strx)
 #define __GCC_HAVE_DWARF2_CFI_ASM 1 (395), line 0 (strx)

EOF
