/*-
 * SPDX-FileCopyrightText: (c) 2003, 2004 Lev Walkin <vlm@lionet.info>. All rights reserved.
 * SPDX-License-Identifier: BSD-1-Clause
 */
#ifndef _PER_DECODER_H
#define _PER_DECODER_H

#include <asn_application.h>
#include <per_support.h>

#ifdef __cplusplus
extern "C"
{
#endif

    struct asn_TYPE_descriptor_s; /* Forward declaration */

    /*
     * Unaligned PER decoder of a "complete encoding" as per X.691#10.1.
     * On success, this call always returns (.consumed >= 1), as per
     * X.691#10.1.3.
     */
    asn_dec_rval_t uper_decode_complete(
        struct asn_codec_ctx_s *opt_codec_ctx,
        struct asn_TYPE_descriptor_s *td, /* Type to decode */
        void **sptr,                      /* Pointer to a target structure's pointer */
        const void *buffer,               /* Data to be decoded */
        size_t size                       /* Size of data buffer */
    );

    /*
     * Unaligned PER decoder of any ASN.1 type. May be invoked by the
     * application. WARNING: This call returns the number of BITS read from the
     * stream. Beware.
     */
    asn_dec_rval_t uper_decode(
        struct asn_codec_ctx_s *opt_codec_ctx,
        struct asn_TYPE_descriptor_s *td, /* Type to decode */
        void **sptr,                      /* Pointer to a target structure's pointer */
        const void *buffer,               /* Data to be decoded */
        size_t size,                      /* Size of data buffer */
        int skip_bits,                    /* Number of unused leading bits, 0..7 */
        int unused_bits                   /* Number of unused tailing bits, 0..7 */
    );

    /*
     * Type of the type-specific PER decoder function.
     */
    typedef asn_dec_rval_t(per_type_decoder_f)(
        asn_codec_ctx_t *opt_codec_ctx,
        struct asn_TYPE_descriptor_s *type_descriptor,
        asn_per_constraints_t *constraints, void **struct_ptr,
        asn_per_data_t *per_data);

#ifdef __cplusplus
}
#endif

#endif /* _PER_DECODER_H_ */
