/* Generated table of exp(x) table values.

   See decexptables.c to understand how, or fix these
   values if such is neeeded.

   Copyright (C) 2019 Free Software Foundation, Inc.

   This file is part of the Decimal Floating Point C Library.

   This is adapted, derived, and in some spiritual form based on
   the version found in glibc's float128/ibm128 variant.

   The Decimal Floating Point C Library is free software; you can
   redistribute it and/or modify it under the terms of the GNU Lesser
   General Public License version 2.1.

   The Decimal Floating Point C Library is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU Lesser General Public License version 2.1 for more details.

   You should have received a copy of the GNU Lesser General Public
   License version 2.1 along with the Decimal Floating Point C Library;
   if not, write to the Free Software Foundation, Inc., 59 Temple Place,
   Suite 330, Boston, MA 02111-1307 USA.

   Please see libdfp/COPYING.txt for more information.  */

static const struct { _Decimal128 hi; _Decimal128 lo; _Decimal128 out; } exptbl1[] = {
/* -115*/ {  -1.150000000000000025929395276898197DL,  -1.631178252788966923612452239613374E-34DL, 0.31663676937905321DL}, /* -1.1500000000000000259293952768981971631178252788966923612452239613374 */
/* -114*/ {  -1.140000000000000003690091417863443DL,  -4.005738324545395227346263894610616E-34DL, 0.31981902181630389DL}, /* -1.1400000000000000036900914178634434005738324545395227346263894610616 */
/* -113*/ {  -1.130000000000000013746527716130344DL,  -3.817213937620391020932490213163613E-34DL, 0.32303325642225293DL}, /* -1.1300000000000000137465277161303443817213937620391020932490213163613 */
/* -112*/ {  -1.120000000000000002030572639375420DL,   1.004037183332575827294383822500818E-34DL, 0.32627979462303948DL}, /* -1.1200000000000000020305726393754198995962816667424172705616177499182 */
/* -111*/ {  -1.110000000000000018265212586474885DL,   4.504544827816227830204569174087079E-34DL, 0.32955896107518906DL}, /* -1.1100000000000000182652125864748845495455172183772169795430825912921 */
/* -110*/ {  -1.100000000000000009880242134262292DL,    6.52322169518478402408032789476881E-35DL, 0.33287108369807955DL}, /* -1.1000000000000000098802421342622919347677830481521597591967210523119 */
/* -109*/ {  -1.090000000000000008641777560821863DL,    6.39590808108476942184950429716320E-35DL, 0.33621649370673334DL}, /* -1.0900000000000000086417775608218629360409191891523057815049570283680 */
/* -108*/ {  -1.080000000000000003578110203130581DL,   -6.07116735490600918432822745139808E-35DL, 0.33959552564493915DL}, /* -1.0800000000000000035781102031305810607116735490600918432822745139808 */
/* -107*/ {  -1.070000000000000023711380552893507DL,   2.170347655948701655822647069424509E-34DL, 0.34300851741870666DL}, /* -1.0700000000000000237113805528935067829652344051298344177352930575491 */
/* -106*/ {  -1.060000000000000028007924990046802DL,   1.896644568299061348494572871321041E-34DL, 0.34645581033005743DL}, /* -1.0600000000000000280079249900468018103355431700938651505427128678959 */
/* -105*/ {  -1.050000000000000013350371274443016DL,  -4.853068849051848747170167786680317E-34DL, 0.34993774911115535DL}, /* -1.0500000000000000133503712744430164853068849051848747170167786680317 */
/* -104*/ {  -1.040000000000000023065356554704527DL,  -3.782006658568085913334416267296502E-34DL, 0.35345468195878014DL}, /* -1.0400000000000000230653565547045273782006658568085913334416267296502 */
/* -103*/ {  -1.030000000000000027359216190294787DL,   4.996476240271316359730670611824607E-34DL, 0.35700696056914736DL}, /* -1.0300000000000000273592161902947865003523759728683640269329388175393 */
/* -102*/ {  -1.020000000000000022965773259822058DL,   2.057321693732806264971899487769904E-34DL, 0.36059494017307829DL}, /* -1.0200000000000000229657732598220577942678306267193735028100512230096 */
/* -101*/ {  -1.010000000000000026788956212868941DL,  -2.219823572624973992837661168526449E-34DL, 0.36421897957152331DL}, /* -1.0100000000000000267889562128689412219823572624973992837661168526449 */
/* -100*/ {  -1.000000000000000004337083271304365DL,  -2.959129118397923743514075830096060E-34DL, 0.36787944117144232DL}, /* -1.0000000000000000043370832713043652959129118397923743514075830096060 */
/*  -99*/ { -0.9900000000000000014304560343820544DL,   2.015395147562517982584427471781273E-35DL, 0.37157669102204569DL}, /* -0.99000000000000000143045603438205437984604852437482017415572528218727 */
/*  -98*/ { -0.9800000000000000232187837214156324DL,  -2.788328666162741608693864188509849E-35DL, 0.37531109885139953DL}, /* -0.98000000000000002321878372141563242788328666162741608693864188509849 */
/*  -97*/ { -0.9700000000000000222283924121181217DL,    2.60823025215148520947443726533572E-36DL, 0.37908303810339881DL}, /* -0.97000000000000002222839241211812169739176974784851479052556273466428 */
/*  -96*/ { -0.9600000000000000072697625490367156DL,   1.190482751035209593392738058147621E-35DL, 0.38289288597511202DL}, /* -0.96000000000000000726976254903671558809517248964790406607261941852379 */
/*  -95*/ { -0.9500000000000000178813763077542779DL,  -2.929547446774495279380800045637966E-35DL, 0.38674102345450120DL}, /* -0.95000000000000001788137630775427792929547446774495279380800045637966 */
/*  -94*/ { -0.9400000000000000042564763373701189DL,    -7.3009526470411793935067954914541E-37DL, 0.39062783535852110DL}, /* -0.94000000000000000425647633737011890073009526470411793935067954914541 */
/*  -93*/ { -0.9300000000000000246644740992793798DL,    5.84447942174861236678357091100829E-36DL, 0.39455371037160112DL}, /* -0.93000000000000002466447409927937979415552057825138763321642908899171 */
/*  -92*/ { -0.9200000000000000063753074555491881DL,   1.029721621108536490992157379131912E-35DL, 0.39851904108451417DL}, /* -0.92000000000000000637530745554918808970278378891463509007842620868088 */
/*  -91*/ { -0.9100000000000000116023627551977526DL,   4.607076398148452154063612933475211E-35DL, 0.40252422403363597DL}, /* -0.91000000000000001160236275519775255392923601851547845936387066524789 */
/*  -90*/ { -0.9000000000000000046325499075541287DL,  -3.764378830435444963767220204076549E-35DL, 0.40656965974059911DL}, /* -0.90000000000000000463254990755412873764378830435444963767220204076549 */
/*  -89*/ { -0.8900000000000000198557549997541326DL,  -3.558316132624823377206724155498325E-35DL, 0.41065575275234548DL}, /* -0.89000000000000001985575499975413263558316132624823377206724155498325 */
/*  -88*/ { -0.8800000000000000168261601935447973DL,   -3.07828266590652746410729156431687E-36DL, 0.41478291168158136DL}, /* -0.88000000000000001682616019354479730307828266590652746410729156431687 */
/*  -87*/ { -0.8700000000000000060134764463451961DL,  -1.062024505340556209395454238907581E-35DL, 0.41895154924763898DL}, /* -0.87000000000000000601347644634519611062024505340556209395454238907581 */
/*  -86*/ { -0.8600000000000000159604080803129187DL,   1.906280774879003300804802968665121E-35DL, 0.42316208231774881DL}, /* -0.86000000000000001596040808031291868093719225120996699195197031334879 */
/*  -85*/ { -0.8500000000000000232103515802448746DL,   3.401553151671943208704633818033125E-35DL, 0.42741493194872666DL}, /* -0.85000000000000002321035158024487456598446848328056791295366181966875 */
/*  -84*/ { -0.8400000000000000068961636248668966DL,  -4.996342543506936360879788793077432E-35DL, 0.43171052342907969DL}, /* -0.84000000000000000689616362486689664996342543506936360879788793077432 */
/*  -83*/ { -0.8300000000000000062502398019297108DL,   1.902212443023736128055721626350174E-35DL, 0.43604928632153559DL}, /* -0.83000000000000000625023980192971078097787556976263871944278373649826 */
/*  -82*/ { -0.8200000000000000057922225828700798DL,   4.402617377257060165575989788202151E-35DL, 0.44043165450599926DL}, /* -0.82000000000000000579222258287007975597382622742939834424010211797849 */
/*  -81*/ { -0.8100000000000000100738769944207711DL,  -2.896646684559549347884389302728737E-35DL, 0.44485806622294113DL}, /* -0.81000000000000001007387699442077112896646684559549347884389302728737 */
/*  -80*/ { -0.8000000000000000031827513897868280DL,  -2.022275827062475024777157768355787E-35DL, 0.44932896411722159DL}, /* -0.80000000000000000318275138978682802022275827062475024777157768355787 */
/*  -79*/ { -0.7900000000000000046429101081142434DL,   3.109708904498090242282849092096451E-35DL, 0.45384479528235582DL}, /* -0.79000000000000000464291010811424336890291095501909757717150907903549 */
/*  -78*/ { -0.7800000000000000111632425052370337DL,  -4.423563806505859610180552563781712E-35DL, 0.45840601130522354DL}, /* -0.78000000000000001116324250523703374423563806505859610180552563781712 */
/*  -77*/ { -0.7700000000000000070306243415634389DL,   1.468127806459499120392332341448067E-35DL, 0.46301306831122807DL}, /* -0.77000000000000000703062434156343888531872193540500879607667658551933 */
/*  -76*/ { -0.7600000000000000084311561775911594DL,   3.763259426859501796493362394516058E-35DL, 0.46766642700990923DL}, /* -0.76000000000000000843115617759115936236740573140498203506637605483942 */
/*  -75*/ { -0.7500000000000000151112446669289434DL,   -5.68565219334019879575699707064207E-36DL, 0.47236655274101470DL}, /* -0.75000000000000001511124466692894340568565219334019879575699707064207 */
/*  -74*/ { -0.7400000000000000165292602338424848DL,   -6.56597357922996879238116554976345E-36DL, 0.47711391552103438DL}, /* -0.74000000000000001652926023384248480656597357922996879238116554976345 */
/*  -73*/ { -0.7300000000000000145112106236453536DL,   2.839976916614712339325382080623104E-35DL, 0.48190899009020242DL}, /* -0.73000000000000001451121062364535357160023083385287660674617919376896 */
/*  -72*/ { -0.7200000000000000001153926814059806DL,   4.182220124021585838899624235533900E-35DL, 0.48675225595997165DL}, /* -0.72000000000000000011539268140598055817779875978414161100375764466100 */
/*  -71*/ { -0.7100000000000000047654695146388903DL,   1.241722530055559884779152447608094E-35DL, 0.49164419746096510DL}, /* -0.71000000000000000476546951463889028758277469944440115220847552391906 */
/*  -70*/ { -0.7000000000000000094743039261866248DL,   -1.51145605812277482325845205506660E-36DL, 0.49658530379140951DL}, /* -0.70000000000000000947430392618662480151145605812277482325845205506660 */
/*  -69*/ { -0.6900000000000000078095459530132748DL,   4.205712885544979803865524341193840E-35DL, 0.50157606906605553DL}, /* -0.69000000000000000780954595301327475794287114455020196134475658806160 */
/*  -68*/ { -0.6800000000000000187659459769299573DL,   2.654807970471794312188822946593776E-35DL, 0.50661699236558960DL}, /* -0.68000000000000001876594597692995727345192029528205687811177053406224 */
/*  -67*/ { -0.6700000000000000162229535139215082DL,  -4.844940576250191795973797110414045E-35DL, 0.51170857778654247DL}, /* -0.67000000000000001622295351392150824844940576250191795973797110414045 */
/*  -66*/ { -0.6600000000000000146674769174142831DL,   2.800500623512289599069475065282629E-35DL, 0.51685133449169923DL}, /* -0.66000000000000001466747691741428307199499376487710400930524934717371 */
/*  -65*/ { -0.6500000000000000151224442158888976DL,    9.31254000466666011358498673716800E-36DL, 0.52204577676101604DL}, /* -0.65000000000000001512244421588889759068745999533333988641501326283200 */
/*  -64*/ { -0.6400000000000000137375283206703796DL,   1.202749340483432949005267457757852E-35DL, 0.52729242404304855DL}, /* -0.64000000000000001373752832067037958797250659516567050994732542242148 */
/*  -63*/ { -0.6300000000000000178776804308684260DL,   -4.46776391332198478139054511242677E-36DL, 0.53259180100689718DL}, /* -0.63000000000000001787768043086842600446776391332198478139054511242677 */
/*  -62*/ { -0.6200000000000000033119811949766168DL,   3.133489251733464823466919699877129E-35DL, 0.53794443759467449DL}, /* -0.62000000000000000331198119497661676866510748266535176533080300122871 */
/*  -61*/ { -0.6100000000000000130903703162041874DL,   2.282442893704041637074878132823554E-35DL, 0.54335086907449978DL}, /* -0.61000000000000001309037031620418737717557106295958362925121867176446 */
/*  -60*/ { -0.6000000000000000047893644091435427DL,   -6.65857653915735882573272028518870E-36DL, 0.54881163609402643DL}, /* -0.60000000000000000478936440914354270665857653915735882573272028518870 */
/*  -59*/ { -0.5900000000000000096429696157587440DL,   3.079273971268332699701668518916040E-35DL, 0.55432728473450703DL}, /* -0.59000000000000000964296961575874396920726028731667300298331481083960 */
/*  -58*/ { -0.5800000000000000044864986573941783DL,    9.94558061878269558266329709612164E-36DL, 0.55989836656540203DL}, /* -0.58000000000000000448649865739417829005441938121730441733670290387836 */
/*  -57*/ { -0.5700000000000000129007624382764139DL,   4.586845971428207520030184076635003E-35DL, 0.56552543869953709DL}, /* -0.57000000000000001290076243827641385413154028571792479969815923364997 */
/*  -56*/ { -0.5600000000000000098252073050379834DL,   1.043626666861934897796057249219387E-35DL, 0.57120906384881488DL}, /* -0.56000000000000000982520730503798338956373333138065102203942750780613 */
/*  -55*/ { -0.5500000000000000092198140447841667DL,    4.11200437372352380013088762974227E-36DL, 0.57694981038048669DL}, /* -0.55000000000000000921981404478416669588799562627647619986911237025773 */
/*  -54*/ { -0.5400000000000000085588484984024173DL,  -3.446183477171773241239920036965358E-35DL, 0.58274825237398966DL}, /* -0.54000000000000000855884849840241733446183477171773241239920036965358 */
/*  -53*/ { -0.5300000000000000102198666513110409DL,    9.77781100936281627469711630292088E-36DL, 0.58860496967835519DL}, /* -0.53000000000000001021986665131104089022218899063718372530288369707912 */
/*  -52*/ { -0.5200000000000000151016307779306470DL,   3.481509025880925033445695881635641E-35DL, 0.59452054797019433DL}, /* -0.52000000000000001510163077793064696518490974119074966554304118364359 */
/*  -51*/ { -0.5100000000000000046611012286479418DL,   4.219616588572582334170357681737600E-35DL, 0.60049557881226594DL}, /* -0.51000000000000000466110122864794175780383411427417665829642318262400 */
/*  -50*/ { -0.5000000000000000059416609486791900DL,   1.630299283417957604033567034911433E-35DL, 0.60653065971263342DL}, /* -0.50000000000000000594166094867918998369700716582042395966432965088567 */
/*  -49*/ { -0.4900000000000000146722048761634920DL,   2.108568826391117233833424751345792E-35DL, 0.61262639418441606DL}, /* -0.49000000000000001467220487616349197891431173608882766166575248654208 */
/*  -48*/ { -0.4800000000000000046493846231282029DL,  -2.301719248027444802075930304571102E-35DL, 0.61878339180614085DL}, /* -0.48000000000000000464938462312820292301719248027444802075930304571102 */
/*  -47*/ { -0.4700000000000000099224815278975110DL,  -4.362692408019101189863060142190428E-35DL, 0.62500226828270079DL}, /* -0.47000000000000000992248152789751104362692408019101189863060142190428 */
/*  -46*/ { -0.4600000000000000147243392096711187DL,   2.964796216254485657704165676513443E-35DL, 0.63128364550692596DL}, /* -0.46000000000000001472433920967111867035203783745514342295834323486557 */
/*  -45*/ { -0.4500000000000000049303711423598200DL,   2.014144374194723075102498568052000E-35DL, 0.63762815162177329DL}, /* -0.45000000000000000493037114235981997985855625805276924897501431948000 */
/*  -44*/ { -0.4400000000000000132479837330620542DL,    9.09646530167314409242139492228246E-36DL, 0.64403642108314135DL}, /* -0.44000000000000001324798373306205419090353469832685590757860507771754 */
/*  -43*/ { -0.4300000000000000071006163264366420DL,  -4.751105355975183554395070818087605E-35DL, 0.65050909472331654DL}, /* -0.43000000000000000710061632643664204751105355975183554395070818087605 */
/*  -42*/ { -0.4200000000000000024392076394054798DL,   -7.87251489855629853146771247089974E-36DL, 0.65704681981505678DL}, /* -0.42000000000000000243920763940547980787251489855629853146771247089974 */
/*  -41*/ { -0.4100000000000000089058258270839333DL,  -3.389946313745578848876784237580113E-35DL, 0.66365025013631936DL}, /* -0.41000000000000000890582582708393333389946313745578848876784237580113 */
/*  -40*/ { -0.4000000000000000011105634234728620DL,  -4.910159372413460909659463763913372E-35DL, 0.67032004603563930DL}, /* -0.40000000000000000111056342347286204910159372413460909659463763913372 */
/*  -39*/ { -0.3900000000000000145852922539363195DL,  -1.136728400089548202462305173331512E-35DL, 0.67705687449816469DL}, /* -0.39000000000000001458529225393631951136728400089548202462305173331512 */
/*  -38*/ { -0.3800000000000000120995304820839371DL,   2.835846229982982585197079034190416E-35DL, 0.68386140921235585DL}, /* -0.38000000000000001209953048208393707164153770017017414802920965809584 */
/*  -37*/ { -0.3700000000000000138330173272594016DL,   4.439933587270775130420492650134835E-35DL, 0.69073433063735465DL}, /* -0.37000000000000001383301732725940155560066412729224869579507349865165 */
/*  -36*/ { -0.3600000000000000103330570272269671DL,  -4.038813821891508925598059913674907E-35DL, 0.69767632607103105DL}, /* -0.36000000000000001033305702722696714038813821891508925598059913674907 */
/*  -35*/ { -0.3500000000000000061797847339369236DL,  -4.784534107549280647193338986605337E-35DL, 0.70468808971871343DL}, /* -0.35000000000000000617978473393692364784534107549280647193338986605337 */
/*  -34*/ { -0.3400000000000000071370684451130993DL,   -6.54671601977071209072360941094523E-36DL, 0.71177032276260971DL}, /* -0.34000000000000000713706844511309930654671601977071209072360941094523 */
/*  -33*/ { -0.3300000000000000132912825544035403DL,  -2.636860460148353432403822564175908E-35DL, 0.71892373343192616DL}, /* -0.33000000000000001329128255440354032636860460148353432403822564175908 */
/*  -32*/ { -0.3200000000000000066860207499399053DL,    4.05694078364900742628802132970359E-36DL, 0.72614903707369092DL}, /* -0.32000000000000000668602074993990529594305921635099257371197867029641 */
/*  -31*/ { -0.3100000000000000053075844548532029DL,  -1.591672143094653110259347299741918E-35DL, 0.73344695622428926DL}, /* -0.31000000000000000530758445485320291591672143094653110259347299741918 */
/*  -30*/ { -0.3000000000000000081894230054640677DL,  -1.882638203745795023883601216794926E-35DL, 0.74081822068171786DL}, /* -0.30000000000000000818942300546406771882638203745795023883601216794926 */
/*  -29*/ { -0.2900000000000000068082333177873105DL,   2.841393194468598049930021575411088E-35DL, 0.74826356757856521DL}, /* -0.29000000000000000680823331778731047158606805531401950069978424588912 */
/*  -28*/ { -0.2800000000000000028303080495938733DL,   3.108220470061523055592230557584679E-35DL, 0.75578374145572547DL}, /* -0.28000000000000000283030804959387326891779529938476944407769442415321 */
/*  -27*/ { -0.2700000000000000074412939589012340DL,  -3.621472324226468840384729934987745E-35DL, 0.76337949433685318DL}, /* -0.27000000000000000744129395890123403621472324226468840384729934987745 */
/*  -26*/ { -0.2600000000000000047428162560905864DL,  -2.501469089177051957349838773010467E-35DL, 0.77105158580356628DL}, /* -0.26000000000000000474281625609058642501469089177051957349838773010467 */
/*  -25*/ { -0.2500000000000000105870081877182149DL,  -2.401871002165074163022160614705544E-35DL, 0.77880078307140486DL}, /* -0.25000000000000001058700818771821492401871002165074163022160614705544 */
/*  -24*/ { -0.2400000000000000117197536520202762DL,  -4.565173334420911125114134994783830E-35DL, 0.78662786106655340DL}, /* -0.24000000000000001171975365202027624565173334420911125114134994783830 */
/*  -23*/ { -0.2300000000000000102836130088398631DL,  -4.258314734362222371652186012279340E-35DL, 0.79453360250333400DL}, /* -0.23000000000000001028361300883986314258314734362222371652186012279340 */
/*  -22*/ { -0.2200000000000000037186111908782166DL,   1.994274823350710863543914384570978E-35DL, 0.80251879796247848DL}, /* -0.22000000000000000371861119087821658005725176649289136456085615429022 */
/*  -21*/ { -0.2100000000000000121365906140649571DL,   2.750022839775115132477491327899369E-35DL, 0.81058424597018709DL}, /* -0.21000000000000001213659061406495707249977160224884867522508672100631 */
/*  -20*/ { -0.2000000000000000105894831432980897DL,  -1.081280876003986385238245236808560E-35DL, 0.81873075307798185DL}, /* -0.20000000000000001058948314329808971081280876003986385238245236808560 */
/*  -19*/ { -0.1900000000000000090804327390410434DL,   4.918808002577730650614496821043885E-35DL, 0.82695913394336231DL}, /* -0.19000000000000000908043273904104335081191997422269349385503178956115 */
/*  -18*/ { -0.1800000000000000015712100779954446DL,  -2.957605310124555008128758477631307E-35DL, 0.83527021141127202DL}, /* -0.18000000000000000157121007799544462957605310124555008128758477631307 */
/*  -17*/ { -0.1700000000000000024018100696556985DL,  -3.976290694704978364409912515523093E-35DL, 0.84366481659638368DL}, /* -0.17000000000000000240181006965569853976290694704978364409912515523093 */
/*  -16*/ { -0.1600000000000000099236151116321384DL,   1.915057335019646763517033528666509E-35DL, 0.85214378896621133DL}, /* -0.16000000000000000992361511163213838084942664980353236482966471333491 */
/*  -15*/ { -0.1500000000000000083989389694853641DL,   1.588421722119487986319563194942631E-35DL, 0.86070797642505780DL}, /* -0.15000000000000000839893896948536408411578277880512013680436805057369 */
/*  -14*/ { -0.1400000000000000111151928200672986DL,  -1.240920337005073557908007830323297E-35DL, 0.86935823539880581DL}, /* -0.14000000000000001111519282006729861240920337005073557908007830323297 */
/*  -13*/ { -0.1300000000000000042513288165544647DL,   4.422972273490793845434295217976185E-35DL, 0.87809543092056132DL}, /* -0.13000000000000000425132881655446465577027726509206154565704782023815 */
/*  -12*/ { -0.1200000000000000062323123923376231DL,   4.603832635546452492681811574919340E-35DL, 0.88692043671715751DL}, /* -0.12000000000000000623231239233762305396167364453547507318188425080660 */
/*  -11*/ { -0.1100000000000000007555579277546368DL,   4.456874883540724422425424031631504E-35DL, 0.89583413529652825DL}, /* -0.11000000000000000075555792775463675543125116459275577574575968368496 */
/*  -10*/ { -0.1000000000000000034970360380484229DL,   3.575099528158402178959124067472918E-35DL, 0.90483741803595957DL}, /* -0.10000000000000000349703603804842286424900471841597821040875932527082 */
/*   -9*/ {-0.09000000000000000738278073364692376DL,      4.492879073800548599038565212904E-39DL, 0.91393118527122818DL}, /* -0.090000000000000007382780733646923759995507120926199451400961434787096 */
/*   -8*/ {-0.08000000000000000315318850214927654DL,  -3.564724836098317820614500125400545E-36DL, 0.92311634638663578DL}, /* -0.080000000000000003153188502149276543564724836098317820614500125400545 */
/*   -7*/ {-0.07000000000000000950024811766607704DL,  -2.629629886621770491616415478708226E-36DL, 0.93239381990594822DL}, /* -0.070000000000000009500248117666077042629629886621770491616415478708226 */
/*   -6*/ {-0.06000000000000001012689737526410228DL,   4.370619288189243024174263759109193E-36DL, 0.94176453358424870DL}, /* -0.060000000000000010126897375264102275629380711810756975825736240890807 */
/*   -5*/ {-0.05000000000000000955755266354549993DL,   3.542008243301166158047037958269120E-36DL, 0.95122942450071400DL}, /* -0.050000000000000009557552663545499926457991756698833841952962041730880 */
/*   -4*/ {-0.04000000000000000982443218740121569DL,     2.1358835750823519860946084420289E-38DL, 0.96078943915232320DL}, /* -0.040000000000000009824432187401215689978641164249176480139053915579711 */
/*   -3*/ {-0.03000000000000000714365527203765389DL,  -3.089448382802923640134265820839973E-36DL, 0.97044553354850817DL}, /* -0.030000000000000007143655272037653893089448382802923640134265820839973 */
/*   -2*/ {-0.02000000000000000226567752508097945DL,   -4.53117194934723103291999106185586E-37DL, 0.98019867330675530DL}, /* -0.020000000000000002265677525080979450453117194934723103291999106185586 */
/*   -1*/ {-0.01000000000000000360982432939380284DL,  -4.696787851801675436112248782012899E-36DL, 0.99004983374916805DL}, /* -0.010000000000000003609824329393802844696787851801675436112248782012899 */
/*    0*/ {                                   0.0DL,                                       0.0DL, 1.0DL}, /* 0 */
/*    1*/ {0.009999999999999943030388655826201010DL,  -2.372254121557678227216506080856409E-37DL, 1.0100501670841680DL}, /* 0.0099999999999999430303886558262010097627745878442321772783493919143591 */
/*    2*/ { 0.01999999999999999004104040853671938DL,  -4.267759120661057230567335693177808E-36DL, 1.0202013400267558DL}, /* 0.019999999999999990041040408536719375732240879338942769432664306822192 */
/*    3*/ { 0.02999999999999994603115603706990803DL,  -4.279332989163700276757576401900886E-36DL, 1.0304545339535168DL}, /* 0.029999999999999946031156037069908025720667010836299723242423598099114 */
/*    4*/ { 0.03999999999999997429211397366745506DL,  -1.294177656768788970325479972626057E-36DL, 1.0408107741923882DL}, /* 0.039999999999999974292113973667455058705822343231211029674520027373943 */
/*    5*/ { 0.04999999999999996223855314468149881DL,  -3.085865976426933221102462905552351E-36DL, 1.0512710963760240DL}, /* 0.049999999999999962238553144681498806914134023573066778897537094447649 */
/*    6*/ { 0.05999999999999997906958001259662179DL,   3.350899829087289275297986159088195E-36DL, 1.0618365465453596DL}, /* 0.059999999999999979069580012596621793350899829087289275297986159088195 */
/*    7*/ { 0.06999999999999992629137443274088158DL,    7.71299929703528263519435699417020E-37DL, 1.0725081812542164DL}, /* 0.069999999999999926291374432740881580771299929703528263519435699417020 */
/*    8*/ { 0.07999999999999994974924986826440512DL,  -2.425605969772230471459786579647189E-36DL, 1.0832870676749585DL}, /* 0.079999999999999949749249868264405117574394030227769528540213420352811 */
/*    9*/ { 0.08999999999999994710815407983317594DL,   3.480197992608898913009686394268578E-36DL, 1.0941742837052103DL}, /* 0.089999999999999947108154079833175943480197992608898913009686394268578 */
/*   10*/ { 0.09999999999999997754943835321595453DL,  -2.389908088545654290055903876532337E-36DL, 1.1051709180756476DL}, /* 0.099999999999999977549438353215954527610091911454345709944096123467663 */
/*   11*/ {  0.1099999999999999180305157016660333DL,   3.371494551052161078876765408440227E-35DL, 1.1162780704588712DL}, /* 0.10999999999999991803051570166603333371494551052161078876765408440227 */
/*   12*/ {  0.1199999999999999366035785649883766DL,   2.988138644461091206818338151979926E-35DL, 1.1274968515793756DL}, /* 0.11999999999999993660357856498837662988138644461091206818338151979926 */
/*   13*/ {  0.1299999999999999731164826492632402DL,  -2.891904566535245889950877146746917E-35DL, 1.1388283833246218DL}, /* 0.12999999999999997311648264926324017108095433464754110049122853253083 */
/*   14*/ {  0.1399999999999999407762183879173281DL,   3.862354128672716294708636650400208E-35DL, 1.1502737988572272DL}, /* 0.13999999999999994077621838791732813862354128672716294708636650400208 */
/*   15*/ {  0.1499999999999999805336945817485437DL,   -4.12013961534405932938899554655501E-36DL, 1.1618342427282831DL}, /* 0.14999999999999998053369458174854369587986038465594067061100445344499 */
/*   16*/ {  0.1599999999999999701591080640817036DL,   -9.75858371754055537048875548223021E-36DL, 1.1735108709918102DL}, /* 0.15999999999999997015910806408170359024141628245944462951124451776979 */
/*   17*/ {  0.1699999999999999881643505054907384DL,   3.841027952643363630440545617249817E-35DL, 1.1853048513203655DL}, /* 0.16999999999999998816435050549073843841027952643363630440545617249817 */
/*   18*/ {  0.1799999999999999458103215238788451DL,  -2.506229307106022125234888001721075E-35DL, 1.1972173631218101DL}, /* 0.17999999999999994581032152387884507493770692893977874765111998278925 */
/*   19*/ {  0.1899999999999999517999842079957757DL,   1.028702801535974508348200278535293E-35DL, 1.2092495976572514DL}, /* 0.18999999999999995179998420799577571028702801535974508348200278535293 */
/*   20*/ {  0.1999999999999999722277751806162190DL,  -2.499751014700494949585934087360922E-35DL, 1.2214027581601698DL}, /* 0.19999999999999997222777518061621897500248985299505050414065912639078 */
/*   21*/ {  0.2099999999999999585537528251502436DL,   3.693951884567556620314157525362059E-35DL, 1.2336780599567432DL}, /* 0.20999999999999995855375282515024363693951884567556620314157525362059 */
/*   22*/ {  0.2199999999999999843346205704434004DL,   -7.81229442005957252873394375295673E-36DL, 1.2460767305873808DL}, /* 0.21999999999999998433462057044340039218770557994042747126605624704327 */
/*   23*/ {  0.2299999999999999500944923878250613DL,   3.121802677808763922784846365747500E-35DL, 1.2586000099294778DL}, /* 0.22999999999999995009449238782506133121802677808763922784846365747500 */
/*   24*/ {  0.2399999999999999279343148209259127DL,   3.565185328468159790462357279231514E-35DL, 1.2712491503214046DL}, /* 0.23999999999999992793431482092591273565185328468159790462357279231514 */
/*   25*/ {  0.2499999999999999345235542261014160DL,   3.119419573615166602805292389989429E-35DL, 1.2840254166877414DL}, /* 0.24999999999999993452355422610141603119419573615166602805292389989429 */
/*   26*/ {  0.2599999999999999244380525243888592DL,     5.8715188955204674378547573361543E-37DL, 1.2969300866657717DL}, /* 0.25999999999999992443805252438885920058715188955204674378547573361543 */
/*   27*/ {  0.2699999999999999512086078436326465DL,  -4.484277062689557971297868182827159E-35DL, 1.3099644507332473DL}, /* 0.26999999999999995120860784363264645515722937310442028702131817172841 */
/*   28*/ {  0.2799999999999999730622411794417158DL,   2.584889270645954245045771490040830E-35DL, 1.3231298123374369DL}, /* 0.27999999999999997306224117944171582584889270645954245045771490040830 */
/*   29*/ {  0.2899999999999999974724437686729514DL,   2.800758480263757597193278857772072E-35DL, 1.3364274880254721DL}, /* 0.28999999999999999747244376867295142800758480263757597193278857772072 */
/*   30*/ {  0.2999999999999999970487696261494337DL,  -4.323069682155933737786604130976586E-35DL, 1.3498588075760031DL}, /* 0.29999999999999999704876962614943365676930317844066262213395869023414 */
/*   31*/ {  0.3099999999999999309377873333747022DL,  -4.951664051398934951063731904598217E-35DL, 1.3634251141321777DL}, /* 0.30999999999999993093778733337470215048335948601065048936268095401783 */
/*   32*/ {  0.3199999999999999386208896103503430DL,  -2.048797930841130991339226049555905E-35DL, 1.3771277643359570DL}, /* 0.31999999999999993862088961035034297951202069158869008660773950444095 */
/*   33*/ {  0.3299999999999999523765164352735705DL,  -2.893576107266867242304542209326239E-35DL, 1.3909681284637802DL}, /* 0.32999999999999995237651643527357047106423892733132757695457790673761 */
/*   34*/ {  0.3399999999999999310681407732279234DL,   1.330583744452166233268900766955833E-35DL, 1.4049475905635937DL}, /* 0.33999999999999993106814077322792341330583744452166233268900766955833 */
/*   35*/ {  0.3499999999999999659844270910211188DL,   4.001195305453781543210524178907096E-35DL, 1.4190675485932572DL}, /* 0.34999999999999996598442709102111884001195305453781543210524178907096 */
/*   36*/ {  0.3599999999999999596912684799901759DL,  -4.190723541260660875041234331364515E-35DL, 1.4333294145603402DL}, /* 0.35999999999999995969126847999017585809276458739339124958765668635485 */
/*   37*/ {  0.3699999999999999574612973180578600DL,  -3.328474427061444750747467496224030E-35DL, 1.4477346146633244DL}, /* 0.36999999999999995746129731805785996671525572938555249252532503775970 */
/*   38*/ {  0.3799999999999999784230567448722615DL,    4.58909601361632125434289145262621E-36DL, 1.4622845894342245DL}, /* 0.37999999999999997842305674487226150458909601361632125434289145262621 */
/*   39*/ {  0.3899999999999999478153377513296423DL,  -1.774612813918731335026256537359798E-35DL, 1.4769807938826425DL}, /* 0.38999999999999994781533775132964228225387186081268664973743462640202 */
/*   40*/ {  0.3999999999999999880516437480756520DL,  -3.616609782010357794242695677475119E-35DL, 1.4918246976412703DL}, /* 0.39999999999999998805164374807565196383390217989642205757304322524881 */
/*   41*/ {  0.4099999999999999484974025439776915DL,    9.31066136198967507432117539501195E-36DL, 1.5068177851128535DL}, /* 0.40999999999999994849740254397769150931066136198967507432117539501195 */
/*   42*/ {  0.4199999999999999369567224309269637DL,  -3.610541964074748262280327786938250E-35DL, 1.5219615556186337DL}, /* 0.41999999999999993695672243092696366389458035925251737719672213061750 */
/*   43*/ {  0.4299999999999999988935793516309980DL,   1.383332560683834692548201536217032E-35DL, 1.5372575235482814DL}, /* 0.42999999999999999889357935163099801383332560683834692548201536217032 */
/*   44*/ {  0.4399999999999999729182171984056534DL,  -2.234149967161881128887600647463492E-35DL, 1.5527072185113360DL}, /* 0.43999999999999997291821719840565337765850032838118871112399352536508 */
/*   45*/ {  0.4499999999999999928715724597911719DL,    7.15124342469308834938283257351181E-36DL, 1.5683121854901688DL}, /* 0.44999999999999999287157245979117190715124342469308834938283257351181 */
/*   46*/ {  0.4599999999999999527404889401460487DL,   4.935319072000364156867393126029238E-35DL, 1.5840739849944817DL}, /* 0.45999999999999995274048894014604874935319072000364156867393126029238 */
/*   47*/ {  0.4699999999999999743133754981520684DL,    9.62270796136439921050070481359484E-36DL, 1.5999941932173602DL}, /* 0.46999999999999997431337549815206840962270796136439921050070481359484 */
/*   48*/ {  0.4799999999999999491715857919495064DL,  -1.587588909609169743812940949667233E-35DL, 1.6160744021928933DL}, /* 0.47999999999999994917158579194950638412411090390830256187059050332767 */
/*   49*/ {  0.4899999999999999570411558287086243DL,   1.824540458101455499718877238932613E-35DL, 1.6323162199553789DL}, /* 0.48999999999999995704115582870862431824540458101455499718877238932613 */
/*   50*/ {  0.4999999999999999715848569310202914DL,   -6.49798398809088715638843848888831E-36DL, 1.6487212707001281DL}, /* 0.49999999999999997158485693102029139350201601190911284361156151111169 */
/*   51*/ {  0.5099999999999999949383262132505637DL,   1.053765711425643434943452867243354E-35DL, 1.6652911949458863DL}, /* 0.50999999999999999493832621325056371053765711425643434943452867243354 */
/*   52*/ {  0.5199999999999999721095225735053250DL,   4.102422581068322391627502699639732E-35DL, 1.6820276496988863DL}, /* 0.51999999999999997210952257350532504102422581068322391627502699639732 */
/*   53*/ {  0.5299999999999999679678735810986540DL,   -2.39327021200058566807282127228416E-36DL, 1.6989323086185506DL}, /* 0.52999999999999996796787358109865399760672978799941433192717872771584 */
/*   54*/ {  0.5399999999999999649725473485665604DL,  -1.542098919037352662290121943553334E-35DL, 1.7160068621848584DL}, /* 0.53999999999999996497254734856656038457901080962647337709878056446666 */
/*   55*/ {  0.5499999999999999787556021033540542DL,   3.185389102008994990862034835424083E-35DL, 1.7332530178673952DL}, /* 0.54999999999999997875560210335405423185389102008994990862034835424083 */
/*   56*/ {  0.5599999999999999528467052398208618DL,  -3.371111546659521512001649280637822E-35DL, 1.7506725002961010DL}, /* 0.55999999999999995284670523982086176628888453340478487998350719362178 */
/*   57*/ {  0.5699999999999999708070716179612720DL,  -3.180786315242368408069667359767309E-35DL, 1.7682670514337351DL}, /* 0.56999999999999997080707161796127196819213684757631591930332640232691 */
/*   58*/ {  0.5799999999999999539408323238629760DL,   1.262222683088251942516543707907527E-35DL, 1.7860384307500733DL}, /* 0.57999999999999995394083232386297601262222683088251942516543707907527 */
/*   59*/ {  0.5899999999999999775889153557427505DL,  -4.452393696470805226490877426343796E-35DL, 1.8039884153978569DL}, /* 0.58999999999999997758891535574275045547606303529194773509122573656204 */
/*   60*/ {  0.5999999999999999589075269668937687DL,  -4.591292699935926923564222012301036E-35DL, 1.8221188003905089DL}, /* 0.59999999999999995890752696689376865408707300064073076435777987698964 */
/*   61*/ {  0.6099999999999999699375951705439584DL,   4.609456967700400090228081136290545E-35DL, 1.8404313987816374DL}, /* 0.60999999999999996993759517054395844609456967700400090228081136290545 */
/*   62*/ {  0.6199999999999999762431072821921964DL,    2.30314002955488720763483668111097E-36DL, 1.8589280418463420DL}, /* 0.61999999999999997624310728219219640230314002955488720763483668111097 */
/*   63*/ {  0.6299999999999999827236939728108834DL,  -1.343361803332455327050855534009085E-35DL, 1.8776105792643431DL}, /* 0.62999999999999998272369397281088338656638196667544672949144465990915 */
/*   64*/ {  0.6399999999999999718732826819559937DL,   1.166497514585744341028702135879508E-35DL, 1.8964808793049513DL}, /* 0.63999999999999997187328268195599371166497514585744341028702135879508 */
/*   65*/ {  0.6499999999999999633802124547807363DL,  -4.794181381478172663713801448789315E-35DL, 1.9155408290138960DL}, /* 0.64999999999999996338021245478073625205818618521827336286198551210685 */
/*   66*/ {  0.6599999999999999887878793164000277DL,   3.711820776966570696735191442663657E-35DL, 1.9347923344020315DL}, /* 0.65999999999999998878787931640002773711820776966570696735191442663657 */
/*   67*/ {  0.6699999999999999507943610603678241DL,    7.99905053589091206408677043481874E-36DL, 1.9542373206359394DL}, /* 0.66999999999999995079436106036782410799905053589091206408677043481874 */
/*   68*/ {  0.6799999999999999526049023862759551DL,  -1.518992420692740621518107309264089E-35DL, 1.9738777322304475DL}, /* 0.67999999999999995260490238627595508481007579307259378481892690735911 */
/*   69*/ {  0.6899999999999999855046290731733935DL,    9.18821263626717204827266987417614E-36DL, 1.9937155332430823DL}, /* 0.68999999999999998550462907317339350918821263626717204827266987417614 */
/*   70*/ {  0.6999999999999999892615665725181396DL,   -2.76591960606986296355515010720995E-36DL, 2.0137527074704765DL}, /* 0.69999999999999998926156657251813959723408039393013703644484989279005 */
/*   71*/ {  0.7099999999999999941029629696429502DL,   3.073825178840377201221110222469081E-35DL, 2.0339912586467506DL}, /* 0.70999999999999999410296296964295023073825178840377201221110222469081 */
/*   72*/ {  0.7199999999999999790937666191896853DL,   3.722341760995845198335315765444945E-35DL, 2.0544332106438877DL}, /* 0.71999999999999997909376661918968533722341760995845198335315765444945 */
/*   73*/ {  0.7299999999999999783206610535420449DL,   1.672229174080049506150160484619879E-35DL, 2.0750806076741226DL}, /* 0.72999999999999997832066105354204491672229174080049506150160484619879 */
/*   74*/ {  0.7399999999999999698758299545939937DL,   1.829469516888001513409610709245729E-35DL, 2.0959355144943645DL}, /* 0.73999999999999996987582995459399371829469516888001513409610709245729 */
/*   75*/ {  0.7499999999999999676214599518455623DL,  -2.195417394914335076719823214862160E-35DL, 2.1170000166126746DL}, /* 0.74999999999999996762145995184556227804582605085664923280176785137840 */
/*   76*/ {  0.7599999999999999988327320673668373DL,   1.630253303153719799707100603711402E-35DL, 2.1382762204968186DL}, /* 0.75999999999999999883273206736683731630253303153719799707100603711402 */
/*   77*/ {  0.7699999999999999961164536321274888DL,   2.575916079805019430153095529615091E-35DL, 2.1597662537849150DL}, /* 0.76999999999999999611645363212748882575916079805019430153095529615091 */
/*   78*/ {  0.7799999999999999923772354086109276DL,  -3.222139325218461447518734977400488E-35DL, 2.1814722654982011DL}, /* 0.77999999999999999237723540861092756777860674781538552481265022599512 */
/*   79*/ {  0.7899999999999999731234716166752549DL,  -2.783459045278374666563670216258951E-35DL, 2.2033964262559366DL}, /* 0.78999999999999997312347161667525487216540954721625333436329783741049 */
/*   80*/ {  0.7999999999999999979422811448823120DL,    6.49149407675995124816841146451568E-36DL, 2.2255409284924676DL}, /* 0.79999999999999999794228114488231200649149407675995124816841146451568 */
/*   81*/ {  0.8099999999999999914678668727494530DL,  -4.412533947827227549132285252811140E-35DL, 2.2479079866764714DL}, /* 0.80999999999999999146786687274945295587466052172772450867714747188860 */
/*   82*/ {  0.8199999999999999644637678930898609DL,    1.95324270482112719265953655169763E-36DL, 2.2704998375324057DL}, /* 0.81999999999999996446376789308986090195324270482112719265953655169763 */
/*   83*/ {  0.8299999999999999617726213743955618DL,   -8.15139492289999870215458162502752E-36DL, 2.2933187402641828DL}, /* 0.82999999999999996177262137439556179184860507710000129784541837497248 */
/*   84*/ {  0.8399999999999999855375907493644694DL,   2.186910779599535385445797596416920E-35DL, 2.3163669767810917DL}, /* 0.83999999999999998553759074936446942186910779599535385445797596416920 */
/*   85*/ {  0.8499999999999999842477393939922678DL,    6.94189429512050928487740695861545E-36DL, 2.3396468519259909DL}, /* 0.84999999999999998424773939399226780694189429512050928487740695861545 */
/*   86*/ {  0.8599999999999999795731806998919870DL,   1.892203403398260672430853796957485E-35DL, 2.3631606937057949DL}, /* 0.85999999999999997957318069989198701892203403398260672430853796957485 */
/*   87*/ {  0.8699999999999999658056111088070633DL,    2.28402755260533965213007821295732E-36DL, 2.3869108535242766DL}, /* 0.86999999999999996580561110880706330228402755260533965213007821295732 */
/*   88*/ {  0.8799999999999999788913305764341246DL,  -1.644736637370199754049339088715547E-35DL, 2.4108997064172098DL}, /* 0.87999999999999997889133057643412458355263362629800245950660911284453 */
/*   89*/ {  0.8899999999999999890007922495963922DL,  -4.043120183056261909373382856112196E-35DL, 2.4351296512898745DL}, /* 0.88999999999999998900079224959639215956879816943738090626617143887804 */
/*   90*/ {  0.8999999999999999740608042516289843DL,  -2.967202792093451646194524675666312E-35DL, 2.4596031111569496DL}, /* 0.89999999999999997406080425162898427032797207906548353805475324333688 */
/*   91*/ {  0.9099999999999999648505144414472565DL,  -3.893842435745205698747140897434906E-35DL, 2.4843225333848165DL}, /* 0.90999999999999996485051444144725646106157564254794301252859102565094 */
/*   92*/ {  0.9199999999999999716123516000861795DL,  -1.452876611552029609029039919926118E-35DL, 2.5092903899362976DL}, /* 0.91999999999999997161235160008617948547123388447970390970960080073882 */
/*   93*/ {  0.9299999999999999683881138006365302DL,   1.064115634691885815654449860755124E-35DL, 2.5345091776178546DL}, /* 0.92999999999999996838811380063653021064115634691885815654449860755124 */
/*   94*/ {  0.9399999999999999624448658818966580DL,   2.662471082457531497554507653498685E-35DL, 2.5599814183292714DL}, /* 0.93999999999999996244486588189665802662471082457531497554507653498685 */
/*   95*/ {  0.9499999999999999617165798392195964DL,  -4.794670670821793715083590578525826E-35DL, 2.5857096593158461DL}, /* 0.94999999999999996171657983921959635205329329178206284916409421474174 */
/*   96*/ {  0.9599999999999999929438196641814695DL,  -1.452114728041942099011292482841868E-35DL, 2.6116964734231177DL}, /* 0.95999999999999999294381966418146948547885271958057900988707517158132 */
/*   97*/ {  0.9699999999999999877870001491766461DL,    4.28701924294605306998034837793072E-36DL, 2.6379444593541525DL}, /* 0.96999999999999998778700014917664610428701924294605306998034837793072 */
/*   98*/ {  0.9799999999999999856040315335295947DL,   2.044849558358869467854362177617495E-35DL, 2.6644562419294171DL}, /* 0.97999999999999998560403153352959472044849558358869467854362177617495 */
/*   99*/ {  0.9899999999999999668925616405719718DL,  -1.658702605461413934937097899755699E-35DL, 2.6912344723492622DL}, /* 0.98999999999999996689256164057197178341297394538586065062902100244301 */
/*  100*/ {  0.9999999999999999869916772053772291DL,   4.548135604384143010146700548839538E-35DL, 2.7182818284590452DL}, /* 0.99999999999999998699167720537722914548135604384143010146700548839538 */
/*  101*/ {   1.009999999999999965767139579790223DL,   3.601513046619562018796377283735441E-34DL, 2.7456010150169164DL}, /* 1.0099999999999999657671395797902233601513046619562018796377283735441 */
/*  102*/ {   1.019999999999999993942293561404648DL,   3.730866437244956181140313691450094E-34DL, 2.7731947639642979DL}, /* 1.0199999999999999939422935614046483730866437244956181140313691450094 */
/*  103*/ {   1.029999999999999996654929454490962DL,    2.89757639956390316847801291723256E-35DL, 2.8010658346990791DL}, /* 1.0299999999999999966549294544909620289757639956390316847801291723256 */
/*  104*/ {   1.039999999999999993100746281332857DL,   -7.07382685607169315994801568074103E-35DL, 2.8292170143515595DL}, /* 1.0399999999999999931007462813328569292617314392830684005198431925897 */
/*  105*/ {   1.049999999999999968553084857623810DL,   4.819084497499176212039105570262194E-34DL, 2.8576511180631637DL}, /* 1.0499999999999999685530848576238104819084497499176212039105570262194 */
/*  106*/ {   1.059999999999999983979406854886227DL,  -1.589196614189879376828932377029492E-34DL, 2.8863709892679582DL}, /* 1.0599999999999999839794068548862268410803385810120623171067622970508 */
/*  107*/ {   1.069999999999999974659261076110862DL,  -4.200899781771498092073508665925681E-34DL, 2.9153794999769966DL}, /* 1.0699999999999999746592610761108615799100218228501907926491334074319 */
/*  108*/ {   1.079999999999999994525685717007351DL,    1.97384790105783792285937353543025E-35DL, 2.9446795510655238DL}, /* 1.0799999999999999945256857170073510197384790105783792285937353543025 */
/*  109*/ {   1.089999999999999994515667960928965DL,  -1.637325670249408405677290460066226E-34DL, 2.9742740725630653DL}, /* 1.0899999999999999945156679609289648362674329750591594322709539933774 */
/*  110*/ {   1.099999999999999995986104676815397DL,  -1.617557447950622751183232606724166E-34DL, 3.0041660239464331DL}, /* 1.0999999999999999959861046768153968382442552049377248816767393275834 */
/*  111*/ {   1.109999999999999972759095757784914DL,  -4.858578171948130606519668404570159E-34DL, 3.0343583944356755DL}, /* 1.1099999999999999727590957577849135141421828051869393480331595429841 */
/*  112*/ {   1.119999999999999985327646893094380DL,  -2.398975825761466027924374849980706E-34DL, 3.0648542032930020DL}, /* 1.1199999999999999853276468930943797601024174238533972075625150019294 */
/*  113*/ {   1.129999999999999970800050870184745DL,   4.595214570223683960651314798457171E-34DL, 3.0956565001247114DL}, /* 1.1299999999999999708000508701847454595214570223683960651314798457171 */
/*  114*/ {   1.139999999999999982048060589919116DL,   1.663850832756932133460319975287214E-34DL, 3.1267683651861557DL}, /* 1.1399999999999999820480605899191161663850832756932133460319975287214 */
/*  115*/ {   1.149999999999999991371426189832193DL,  -4.340087884324080923718640074357865E-34DL, 3.1581929096897676DL}, /* 1.1499999999999999913714261898321925659912115675919076281359925642135 */
#define EXPTBL1OFF 115
};
static const struct { _Decimal128 hi; _Decimal128 lo; _Decimal128 out; } exptbl2[] = {
/* -101*/ {-0.01010000000000000134742967582185215DL,  -3.555081502403364855476995732833092E-36DL, 0.98995083371587730DL}, /* -0.010100000000000001347429675821852153555081502403364855476995732833092 */
/* -100*/ {-0.01000000000000000360982432939380284DL,  -4.696787851801675436112248782012899E-36DL, 0.99004983374916805DL}, /* -0.010000000000000003609824329393802844696787851801675436112248782012899 */
/*  -99*/ {-0.009900000000000001571499732657582502DL,  -4.599043484773712960974818825130425E-37DL, 0.99014884368295715DL}, /* -0.0099000000000000015714997326575825024599043484773712960974818825130425 */
/*  -98*/ {-0.009800000000000004664431362691968088DL,   3.316095749479630121862265243008320E-37DL, 0.99024786351823469DL}, /* -0.0098000000000000046644313626919680876683904250520369878137734756991680 */
/*  -97*/ {-0.009700000000000001127160821715787758DL,   3.235588210696139598694818153560089E-37DL, 0.99034689325599088DL}, /* -0.0097000000000000011271608217157877576764411789303860401305181846439911 */
/*  -96*/ {-0.009600000000000008507699972008981421DL,   2.941143373013429470936868953075637E-37DL, 0.99044593289721600DL}, /* -0.0096000000000000085076999720089814207058856626986570529063131046924363 */
/*  -95*/ {-0.009500000000000002990706833295158337DL,   1.556272883020559240262146604878836E-37DL, 0.99054498244290047DL}, /* -0.0095000000000000029907068332951583368443727116979440759737853395121164 */
/*  -94*/ {-0.009400000000000000183707471914676834DL,   2.785442776568736151576387308710930E-37DL, 0.99064404189403477DL}, /* -0.0094000000000000001837074719146768337214557223431263848423612691289070 */
/*  -93*/ {-0.009300000000000004640216465271936966DL,  -3.522177994893014396091415602248900E-37DL, 0.99074311125160949DL}, /* -0.0093000000000000046402164652719369663522177994893014396091415602248900 */
/*  -92*/ {-0.009200000000000009875259571104486746DL,  -3.906321222669514821481239289833877E-37DL, 0.99084219051661533DL}, /* -0.0092000000000000098752595711044867463906321222669514821481239289833877 */
/*  -91*/ {-0.009100000000000008472305049754282066DL,  -1.071646616431443449107973406436655E-37DL, 0.99094127969004309DL}, /* -0.0091000000000000084723050497542820661071646616431443449107973406436655 */
/*  -90*/ {-0.009000000000000002184133786060159243DL,  -3.302739127433412391023781244630209E-37DL, 0.99104037877288366DL}, /* -0.0090000000000000021841337860601592433302739127433412391023781244630209 */
/*  -89*/ {-0.008900000000000001938253104175289865DL,   1.271702177917797827301921135063354E-37DL, 0.99113948776612802DL}, /* -0.0089000000000000019382531041752898648728297822082202172698078864936646 */
/*  -88*/ {-0.008800000000000007665530282267543782DL,   2.019947733681416497407129340198784E-37DL, 0.99123860667076726DL}, /* -0.0088000000000000076655302822675437817980052266318583502592870659801216 */
/*  -87*/ {-0.008700000000000008315687005376328172DL,  -4.313507799592932960419659425556302E-37DL, 0.99133773548779258DL}, /* -0.0087000000000000083156870053763281724313507799592932960419659425556302 */
/*  -86*/ {-0.008600000000000002045528895628054736DL,    9.56630940563740876833886878551756E-38DL, 0.99143687421819527DL}, /* -0.0086000000000000020455288956280547359043369059436259123166113121448244 */
/*  -85*/ {-0.008500000000000006309703081348332552DL,   -5.79566058796097160457174028838082E-38DL, 0.99153602286296670DL}, /* -0.0085000000000000063097030813483325520579566058796097160457174028838082 */
/*  -84*/ {-0.008400000000000007439278493834124562DL,   2.647364021588740616777990487552107E-37DL, 0.99163518142309837DL}, /* -0.0084000000000000074392784938341245617352635978411259383222009512447893 */
/*  -83*/ {-0.008300000000000001000684253337262622DL,   4.553696177941104837528578598049854E-37DL, 0.99173434989958187DL}, /* -0.0083000000000000010006842533372626215446303822058895162471421401950146 */
/*  -82*/ {-0.008200000000000001883428207664283194DL,  -3.466062870728783993497138406519859E-37DL, 0.99183352829340887DL}, /* -0.0082000000000000018834282076642831943466062870728783993497138406519859 */
/*  -81*/ {-0.008100000000000003975118069424820117DL,   4.634267190123983935582355629599509E-37DL, 0.99193271660557116DL}, /* -0.0081000000000000039751180694248201165365732809876016064417644370400491 */
/*  -80*/ {-0.008000000000000000342599562761743009DL,  -2.496705661725816359815997474589120E-37DL, 0.99203191483706063DL}, /* -0.0080000000000000003425995627617430092496705661725816359815997474589120 */
/*  -79*/ {-0.007900000000000003400990641979544831DL,   3.976507546180633061659865833512732E-37DL, 0.99213112298886925DL}, /* -0.0079000000000000034009906419795448306023492453819366938340134166487268 */
/*  -78*/ {-0.007800000000000004600786062828445219DL,   3.606375487801643409924705378641626E-37DL, 0.99223034106198911DL}, /* -0.0078000000000000046007860628284452186393624512198356590075294621358374 */
/*  -77*/ {-0.007700000000000004680227066074346624DL,  -2.416576471516799652223744605032261E-37DL, 0.99232956905741239DL}, /* -0.0077000000000000046802270660743466242416576471516799652223744605032261 */
/*  -76*/ {-0.007600000000000003594366558554815242DL,  -2.118478178282793564854880265470767E-37DL, 0.99242880697613137DL}, /* -0.0076000000000000035943665585548152422118478178282793564854880265470767 */
/*  -75*/ {-0.007500000000000000525458114302131103DL,   -6.45250005889263092359907346114433E-38DL, 0.99252805481913843DL}, /* -0.0075000000000000005254581143021311030645250005889263092359907346114433 */
/*  -74*/ {-0.007400000000000003967614336353740065DL,   -9.23095865657968380228125638480017E-38DL, 0.99262731258742604DL}, /* -0.0074000000000000039676143363537400650923095865657968380228125638480017 */
/*  -73*/ {-0.007300000000000001512347443497917017DL,  -3.339240178307202200280824176970328E-37DL, 0.99272658028198679DL}, /* -0.0073000000000000015123474434979170173339240178307202200280824176970328 */
/*  -72*/ {-0.007200000000000000158055991750538824DL,   -9.65661970048505532612879806637555E-38DL, 0.99282585790381335DL}, /* -0.0072000000000000001580559917505388240965661970048505532612879806637555 */
/*  -71*/ {-0.007100000000000006167815362178042759DL,    5.50117340734335459244108577511099E-38DL, 0.99292514545389849DL}, /* -0.0071000000000000061678153621780427589449882659265664540755891422488901 */
/*  -70*/ {-0.007000000000000004939251059387853498DL,   4.888986707625784510317462471123613E-37DL, 0.99302444293323510DL}, /* -0.0070000000000000049392510593878534975111013292374215489682537528876387 */
/*  -69*/ {-0.006900000000000001301922182768210423DL,  -2.408966811817165334332083487133350E-37DL, 0.99312375034281615DL}, /* -0.0069000000000000013019221827682104232408966811817165334332083487133350 */
/*  -68*/ {-0.006800000000000009449373180878594813DL,  -2.708629013349557162076651355358145E-37DL, 0.99322306768363470DL}, /* -0.0068000000000000094493731808785948132708629013349557162076651355358145 */
/*  -67*/ {-0.006700000000000002608324349802913528DL,  -2.527584425665719587725898000819480E-37DL, 0.99332239495668395DL}, /* -0.0067000000000000026083243498029135282527584425665719587725898000819480 */
/*  -66*/ {-0.006600000000000003665114821799069502DL,   3.430537288878300313885251515524966E-37DL, 0.99342173216295715DL}, /* -0.0066000000000000036651148217990695016569462711121699686114748484475034 */
/*  -65*/ {-0.006500000000000004629180506981071556DL,   2.041467032358122211300449277361391E-37DL, 0.99352107930344768DL}, /* -0.0065000000000000046291805069810715557958532967641877788699550722638609 */
/*  -64*/ {-0.006400000000000006915307935537805770DL,  -3.419174650022075949672367122922426E-37DL, 0.99362043637914901DL}, /* -0.0064000000000000069153079355378057703419174650022075949672367122922426 */
/*  -63*/ {-0.006300000000000001222532381975370260DL,  -4.407929897855470118539431882795278E-37DL, 0.99371980339105472DL}, /* -0.0063000000000000012225323819753702604407929897855470118539431882795278 */
/*  -62*/ {-0.006200000000000007798263223048900559DL,   3.809384507790659269107044504684599E-37DL, 0.99381918034015846DL}, /* -0.0062000000000000077982632230489005586190615492209340730892955495315401 */
/*  -61*/ {-0.006100000000000006005203917564756817DL,  -3.187882667559020569621775878851110E-37DL, 0.99391856722745402DL}, /* -0.0061000000000000060052039175647568173187882667559020569621775878851110 */
/*  -60*/ {-0.006000000000000004773051336915063464DL,   1.643441146863815157511289797625255E-37DL, 0.99401796405393526DL}, /* -0.0060000000000000047730513369150634638356558853136184842488710202374745 */
/*  -59*/ {-0.005900000000000002357015000040265424DL,   2.333605233378441272819138400646741E-37DL, 0.99411737082059615DL}, /* -0.0059000000000000023570150000402654237666394766621558727180861599353259 */
/*  -58*/ {-0.005800000000000006469487709106113847DL,   4.647226955981889396744954436187151E-37DL, 0.99421678752843075DL}, /* -0.0058000000000000064694877091061138465352773044018110603255045563812849 */
/*  -57*/ {-0.005700000000000004113826591787044811DL,   1.586824479683037436583140792691021E-37DL, 0.99431621417843324DL}, /* -0.0057000000000000041138265917870448108413175520316962563416859207308979 */
/*  -56*/ {-0.005600000000000001829332202992022861DL,  -4.502308952457263758448128464854515E-37DL, 0.99441565077159788DL}, /* -0.0056000000000000018293322029920228614502308952457263758448128464854515 */
/*  -55*/ {-0.005500000000000005581176785988861151DL,  -3.202651472838700427757656776140268E-37DL, 0.99451509730891903DL}, /* -0.0055000000000000055811767859888611513202651472838700427757656776140268 */
/*  -54*/ {-0.005400000000000000662396043151264013DL,  -4.353377545139996005265791152331261E-37DL, 0.99461455379139117DL}, /* -0.0054000000000000006623960431512640134353377545139996005265791152331261 */
/*  -53*/ {-0.005300000000000001979925083605363519DL,  -1.934979571803929750721775566740304E-37DL, 0.99471402022000885DL}, /* -0.0053000000000000019799250836053635191934979571803929750721775566740304 */
/*  -52*/ {-0.005200000000000003789114011413296010DL,  -4.445120725471684497171562600760647E-37DL, 0.99481349659576674DL}, /* -0.0052000000000000037891140114132960104445120725471684497171562600760647 */
/*  -51*/ {-0.005100000000000009867440025780374925DL,   4.903663403278888749486896811042088E-37DL, 0.99491298291965960DL}, /* -0.0051000000000000098674400257803749245096336596721111250513103188957912 */
/*  -50*/ {-0.005000000000000003369369044449226821DL,  -2.155011966990978975892575706082521E-37DL, 0.99501247919268231DL}, /* -0.0050000000000000033693690444492268212155011966990978975892575706082521 */
/*  -49*/ {-0.004900000000000007141385294333478519DL,   4.026012993861446566380562864940198E-37DL, 0.99511198541582981DL}, /* -0.0049000000000000071413852943334785185973987006138553433619437135059802 */
/*  -48*/ {-0.004800000000000003327222402974959821DL,   3.899020381881509427644281282888559E-37DL, 0.99521150159009718DL}, /* -0.0048000000000000033272224029749598206100979618118490572355718717111441 */
/*  -47*/ {-0.004700000000000003727983335040528454DL,   2.739444226857369712742305578895760E-37DL, 0.99531102771647957DL}, /* -0.0047000000000000037279833350405284537260555773142630287257694421104240 */
/*  -46*/ {-0.004600000000000009612887885088135376DL,   -6.91125967452406622805376105988785E-38DL, 0.99541056379597224DL}, /* -0.0046000000000000096128878850881353760691125967452406622805376105988785 */
/*  -45*/ {-0.004500000000000001689433274234421263DL,   1.838073319740191095309305758930394E-37DL, 0.99551010982957057DL}, /* -0.0045000000000000016894332742344212628161926680259808904690694241069606 */
/*  -44*/ {-0.004400000000000000388253523575229817DL,  -2.346728811675348625698808994796505E-37DL, 0.99560966581827000DL}, /* -0.0044000000000000003882535235752298172346728811675348625698808994796505 */
/*  -43*/ {-0.004300000000000005594702812241332948DL,  -3.516869642334560192207040762532618E-37DL, 0.99570923176306609DL}, /* -0.0043000000000000055947028122413329483516869642334560192207040762532618 */
/*  -42*/ {-0.004200000000000006711211384926555374DL,  -4.223786311520486141550636086970780E-37DL, 0.99580880766495451DL}, /* -0.0042000000000000067112113849265553744223786311520486141550636086970780 */
/*  -41*/ {-0.004100000000000002754692593493499197DL,   2.334281303980764000680180358234847E-37DL, 0.99590839352493102DL}, /* -0.0041000000000000027546925934934991967665718696019235999319819641765153 */
/*  -40*/ {-0.004000000000000002361734455693267594DL,   1.642746021385537603535809116010338E-37DL, 0.99600798934399147DL}, /* -0.0040000000000000023617344556932675938357253978614462396464190883989662 */
/*  -39*/ {-0.003900000000000003715635359066460962DL,   4.347908714507960255970906877904578E-37DL, 0.99610759512313182DL}, /* -0.0039000000000000037156353590664609615652091285492039744029093122095422 */
/*  -38*/ {-0.003800000000000004599699372786615660DL,    5.52274094534222917162226816015652E-38DL, 0.99620721086334813DL}, /* -0.0038000000000000045996993727866156599447725905465777082837773183984348 */
/*  -37*/ {-0.003700000000000002407433916769531985DL,   -2.55295887070950206044293585193564E-38DL, 0.99630683656563656DL}, /* -0.0037000000000000024074339167695319850255295887070950206044293585193564 */
/*  -36*/ {-0.003600000000000004188807250046609816DL,    9.67722117691423431129345492179707E-38DL, 0.99640647223099336DL}, /* -0.0036000000000000041888072500466098159032277882308576568870654507820293 */
/*  -35*/ {-0.003500000000000006585295599668152214DL,  -4.980944685471986940482401227249038E-37DL, 0.99650611786041489DL}, /* -0.0035000000000000065852955996681522144980944685471986940482401227249038 */
/*  -34*/ {-0.003400000000000005879141807515843924DL,   4.136336770562693906163305688160243E-37DL, 0.99660577345489761DL}, /* -0.0034000000000000058791418075158439235863663229437306093836694311839757 */
/*  -33*/ {-0.003300000000000008036587284071613255DL,    6.46669862618729409504217997047804E-38DL, 0.99670543901543807DL}, /* -0.0033000000000000080365872840716132549353330137381270590495782002952196 */
/*  -32*/ {-0.003200000000000008648925613976813681DL,   1.249793895367495690416828815787183E-37DL, 0.99680511454303293DL}, /* -0.0032000000000000086489256139768136808750206104632504309583171184212817 */
/*  -31*/ {-0.003100000000000002978734774070105236DL,   -3.84145025072161799018638115700510E-38DL, 0.99690480003867895DL}, /* -0.0031000000000000029787347740701052360384145025072161799018638115700510 */
/*  -30*/ {-0.003000000000000006030129514172508008DL,  -1.823837080845498074876832580894102E-37DL, 0.99700449550337297DL}, /* -0.0030000000000000060301295141725080081823837080845498074876832580894102 */
/*  -29*/ {-0.002900000000000002403678602877357381DL,   1.817448439336241436396051750835610E-37DL, 0.99710420093811196DL}, /* -0.0029000000000000024036786028773573808182551560663758563603948249164390 */
/*  -28*/ {-0.002800000000000006489837260286029452DL,   -1.17237765749408536345292769161272E-38DL, 0.99720391634389296DL}, /* -0.0028000000000000064898372602860294520117237765749408536345292769161272 */
/*  -27*/ {-0.002700000000000002301833102576831676DL,    6.14197845247687528573988640408833E-38DL, 0.99730364172171314DL}, /* -0.0027000000000000023018331025768316759385802154752312471426011359591167 */
/*  -26*/ {-0.002600000000000003657053033774334866DL,   4.203060356383344980859749065434276E-37DL, 0.99740337707256974DL}, /* -0.0026000000000000036570530337743348655796939643616655019140250934565724 */
/*  -25*/ {-0.002500000000000004046984629668410971DL,  -1.980535257482684909727738395123121E-37DL, 0.99750312239746012DL}, /* -0.0025000000000000040469846296684109711980535257482684909727738395123121 */
/*  -24*/ {-0.002400000000000006729461167324801757DL,   4.754010830651199185215514597921209E-37DL, 0.99760287769738173DL}, /* -0.0024000000000000067294611673248017565245989169348800814784485402078791 */
/*  -23*/ {-0.002300000000000004687723906869028747DL,   -8.56951993571693138303077513871429E-38DL, 0.99770264297333213DL}, /* -0.0023000000000000046877239068690287470856951993571693138303077513871429 */
/*  -22*/ {-0.002200000000000000689604740743689812DL,  -1.328956192829148494637881205555037E-37DL, 0.99780241822630897DL}, /* -0.0022000000000000006896047407436898121328956192829148494637881205555037 */
/*  -21*/ {-0.002100000000000007292632344915003129DL,   3.836341566646717097877325059384435E-37DL, 0.99790220345730999DL}, /* -0.0021000000000000072926323449150031286163658433353282902122674940615565 */
/*  -20*/ {-0.002000000000000006769054745480319557DL,   2.817554416523659062911838624391810E-37DL, 0.99800199866733306DL}, /* -0.0020000000000000067690547454803195567182445583476340937088161375608190 */
/*  -19*/ {-0.001900000000000001226067753797336330DL,    9.01834546133313938677118632508016E-38DL, 0.99810180385737613DL}, /* -0.0019000000000000012260677537973363299098165453866686061322881367491984 */
/*  -18*/ {-0.001800000000000002587881051549495909DL,  -4.540678919010118293051296446603349E-37DL, 0.99820161902843724DL}, /* -0.0018000000000000025878810515494959094540678919010118293051296446603349 */
/*  -17*/ {-0.001700000000000002549763844358589193DL,   4.408173476717596707018316200264471E-37DL, 0.99830144418151455DL}, /* -0.0017000000000000025497638443585891925591826523282403292981683799735529 */
/*  -16*/ {-0.001600000000000002646193554886082075DL,   4.187540668818093380693372580663793E-37DL, 0.99840127931760631DL}, /* -0.0016000000000000026461935548860820745812459331181906619306627419336207 */
/*  -15*/ {-0.001500000000000004240923539723796050DL,   2.419184011886686925722645779680781E-37DL, 0.99850112443771087DL}, /* -0.0015000000000000042409235397237960497580815988113313074277354220319219 */
/*  -14*/ {-0.001400000000000008537065794073883881DL,  -3.258660260945607234950158529065609E-37DL, 0.99860097954282668DL}, /* -0.0014000000000000085370657940738838813258660260945607234950158529065609 */
/*  -13*/ {-0.001300000000000006574160178721025071DL,  -2.004989991336931333353996951334403E-37DL, 0.99870084463395230DL}, /* -0.0013000000000000065741601787210250712004989991336931333353996951334403 */
/*  -12*/ {-0.001200000000000009279274940680545694DL,   3.444629159379459039704134264056769E-37DL, 0.99880071971208637DL}, /* -0.0012000000000000092792749406805456936555370840620540960295865735943231 */
/*  -11*/ {-0.001100000000000007423037633563871635DL,   2.905213767054785453575624034704746E-37DL, 0.99890060477822765DL}, /* -0.0011000000000000074230376335638716347094786232945214546424375965295254 */
/*  -10*/ {-0.001000000000000001669724246830580958DL,  -3.029715054035350603469646403255140E-37DL, 0.99900049983337499DL}, /* -0.0010000000000000016697242468305809583029715054035350603469646403255140 */
/*   -9*/ {-0.0009000000000000025823110520350323009DL,  -4.258889631209145537120359965960775E-38DL, 0.99910040487852733DL}, /* -0.00090000000000000258231105203503230094258889631209145537120359965960775 */
/*   -8*/ {-0.0008000000000000006035133315420144957DL,  -4.377683374444908323649878850236165E-38DL, 0.99920031991468373DL}, /* -0.00080000000000000060351333154201449574377683374444908323649878850236165 */
/*   -7*/ {-0.0007000000000000061038512524989144887DL,   1.576308431004307143461105527586017E-38DL, 0.99930024494284333DL}, /* -0.00070000000000000610385125249891448868423691568995692856538894472413983 */
/*   -6*/ {-0.0006000000000000093576777170311863918DL,   3.197119030147998531611274381335534E-38DL, 0.99940017996400539DL}, /* -0.00060000000000000935767771703118639176802880969852001468388725618664466 */
/*   -5*/ {-0.0005000000000000005732249073180395231DL,  -4.076204586887440057886727761656892E-38DL, 0.99950012497916927DL}, /* -0.00050000000000000057322490731803952314076204586887440057886727761656892 */
/*   -4*/ {-0.0004000000000000099186390174521401899DL,  -4.773833679735122723881185509823283E-38DL, 0.99960007998933439DL}, /* -0.00040000000000000991863901745214018994773833679735122723881185509823283 */
/*   -3*/ {-0.0003000000000000074819952743828027453DL,  -2.707205359164316312033616691535839E-38DL, 0.99970004499550033DL}, /* -0.00030000000000000748199527438280274532707205359164316312033616691535839 */
/*   -2*/ {-0.0002000000000000033313329555219027674DL,   3.622826753336425543347874037070900E-38DL, 0.99980001999866673DL}, /* -0.00020000000000000333133295552190276736377173246663574456652125962929100 */
/*   -1*/ {-0.0001000000000000075006666972231746539DL,   2.551982382600467977921054322527655E-38DL, 0.99990000499983333DL}, /* -0.00010000000000000750066669722317465387448017617399532022078945677472345 */
/*    0*/ {                                   0.0DL,                                       0.0DL, 1.0DL}, /* 0 */
/*    1*/ {0.00009999999999992917366631945594958631DL,   4.986086800566190361345750277687689E-39DL, 1.0001000050001666DL}, /* 0.000099999999999929173666319455949586314986086800566190361345750277687689 */
/*    2*/ {0.0001999999999999999973337777396847618DL,    5.99647374038289917292399793950373E-39DL, 1.0002000200013334DL}, /* 0.00019999999999999999733377773968476180599647374038289917292399793950373 */
/*    3*/ {0.0002999999999999624910033745179007332DL,   3.239598673704582104706175018403200E-38DL, 1.0003000450045003DL}, /* 0.00029999999999996249100337451790073323239598673704582104706175018403200 */
/*    4*/ {0.0003999999999999665946924399243422515DL,  -3.443518944393337473570852353916333E-38DL, 1.0004000800106677DL}, /* 0.00039999999999996659469243992434225146556481055606662526429147646083667 */
/*    5*/ {0.0004999999999999622584371303108317891DL,   2.928084731842011157391696774115782E-38DL, 1.0005001250208359DL}, /* 0.00049999999999996225843713031083178912928084731842011157391696774115782 */
/*    6*/ {0.0005999999999999993523239167002923417DL,   1.447647480058814046294178721376742E-38DL, 1.0006001800360054DL}, /* 0.00059999999999999935232391670029234171447647480058814046294178721376742 */
/*    7*/ {0.0006999999999999278164660784409894242DL,   2.689822003772992761393417568099483E-38DL, 1.0007002450571766DL}, /* 0.00069999999999992781646607844098942422689822003772992761393417568099483 */
/*    8*/ {0.0007999999999999972711531537710064902DL,   -8.53534345256294924401320875921668E-39DL, 1.0008003200853504DL}, /* 0.00079999999999999727115315377100649019146465654743705075598679124078332 */
/*    9*/ {0.0008999999999999576166739564261402900DL,  -1.167081068713009919405702186032448E-38DL, 1.0009004051215273DL}, /* 0.00089999999999995761667395642614028998832918931286990080594297813967552 */
/*   10*/ {0.0009999999999999583735914746759970210DL,   2.541499338445992237858661838207142E-38DL, 1.0010005001667083DL}, /* 0.00099999999999995837359147467599702102541499338445992237858661838207142 */
/*   11*/ {0.001099999999999949132607363201264936DL,  -1.776519287080824827178673684295364E-37DL, 1.0011006052218943DL}, /* 0.0010999999999999491326073632012649358223480712919175172821326315704636 */
/*   12*/ {0.001199999999999979284725339502913244DL,  -1.809658046905763343065542014349768E-37DL, 1.0012007202880864DL}, /* 0.0011999999999999792847253395029132438190341953094236656934457985650232 */
/*   13*/ {0.001299999999999998221192140693135036DL,   3.144614769759439384872198383998619E-37DL, 1.0013008453662857DL}, /* 0.0012999999999999982211921406931350363144614769759439384872198383998619 */
/*   14*/ {0.001399999999999955233590417517794461DL,  -3.043775834660834625681620343607209E-37DL, 1.0014009804574934DL}, /* 0.0013999999999999552335904175177944606956224165339165374318379656392791 */
/*   15*/ {0.001499999999999999204121011092366037DL,    7.33917425973476523798248711258932E-38DL, 1.0015011255627110DL}, /* 0.0014999999999999992041210110923660370733917425973476523798248711258932 */
/*   16*/ {0.001599999999999979295180544716219802DL,   -5.36583674428934041891820401331438E-38DL, 1.0016012806829398DL}, /* 0.0015999999999999792951805447162198019463416325571065958108179598668562 */
/*   17*/ {0.001699999999999944239923537547957493DL,  -4.595556505506184214972714695153706E-37DL, 1.0017014458191814DL}, /* 0.0016999999999999442399235375479574925404443494493815785027285304846294 */
/*   18*/ {0.001799999999999942592175790121994110DL,  -2.882570161387632149037962797021028E-37DL, 1.0018016209724375DL}, /* 0.0017999999999999425921757901219941097117429838612367850962037202978972 */
/*   19*/ {0.001899999999999922906341285964407263DL,   -7.99604526981790631673128105959663E-38DL, 1.0019018061437098DL}, /* 0.0018999999999999229063412859644072629200395473018209368326871894040337 */
/*   20*/ {0.001999999999999933377796780986928864DL,  -4.201282470595763072969668134487256E-37DL, 1.0020020013340002DL}, /* 0.0019999999999999333777967809869288635798717529404236927030331865512744 */
/*   21*/ {0.002099999999999922202640759957893508DL,   4.630318792995669175471887102989199E-37DL, 1.0021022065443106DL}, /* 0.0020999999999999222026407599578935084630318792995669175471887102989199 */
/*   22*/ {0.002199999999999937178171901792294795DL,   2.818449909661297095678477010657704E-37DL, 1.0022024217756431DL}, /* 0.0021999999999999371781719017922947952818449909661297095678477010657704 */
/*   23*/ {0.002299999999999926102570053972599659DL,   2.724921576560134636451459399842551E-37DL, 1.0023026470289998DL}, /* 0.0022999999999999261025700539725996592724921576560134636451459399842551 */
/*   24*/ {0.002399999999999936335466552177389279DL,  -1.326400217665140520231236684732746E-37DL, 1.0024028823053830DL}, /* 0.0023999999999999363354665521773892788673599782334859479768763315267254 */
/*   25*/ {0.002499999999999915237549223063807028DL,  -3.598550941893420571118352652060420E-37DL, 1.0025031276057950DL}, /* 0.0024999999999999152375492230638070276401449058106579428881647347939580 */
/*   26*/ {0.002599999999999909691232535083372451DL,  -2.080170317435304594148312432639319E-37DL, 1.0026033829312383DL}, /* 0.0025999999999999096912325350833724507919829682564695405851687567360681 */
/*   27*/ {0.002699999999999966310542813808501028DL,   2.520918902804661671534506914792743E-37DL, 1.0027036482827155DL}, /* 0.0026999999999999663105428138085010282520918902804661671534506914792743 */
/*   28*/ {0.002799999999999931990466972723162677DL,   -6.63628451274417159591480854382229E-38DL, 1.0028039236612291DL}, /* 0.0027999999999999319904669727231626769336371548725582840408519145617771 */
/*   29*/ {0.002899999999999952548905347750076138DL,    6.90469959891714993025708526350103E-38DL, 1.0029042090677820DL}, /* 0.0028999999999999525489053477500761380690469959891714993025708526350103 */
/*   30*/ {0.002999999999999974064987769692197497DL,   2.972403357256809213010123789749420E-37DL, 1.0030045045033770DL}, /* 0.0029999999999999740649877696921974972972403357256809213010123789749420 */
/*   31*/ {0.003099999999999942349885884162253398DL,   1.097556448669742674451657930762603E-37DL, 1.0031048099690170DL}, /* 0.0030999999999999423498858841622533981097556448669742674451657930762603 */
/*   32*/ {0.003199999999999902617466468945751060DL,  -4.601436017322314671216332781088332E-37DL, 1.0032051254657051DL}, /* 0.0031999999999999026174664689457510595398563982677685328783667218911668 */
/*   33*/ {0.003299999999999999424600489417535218DL,  -1.478252619099834703167090640458590E-37DL, 1.0033054509944446DL}, /* 0.0032999999999999994246004894175352178521747380900165296832909359541410 */
/*   34*/ {0.003399999999999978308605331755828544DL,  -4.808744576630104682240837577168280E-37DL, 1.0034057865562385DL}, /* 0.0033999999999999783086053317558285435191255423369895317759162422831720 */
/*   35*/ {0.003499999999999983181626938412718941DL,  -3.677589343676413365467230018680207E-37DL, 1.0035061321520903DL}, /* 0.0034999999999999831816269384127189406322410656323586634532769981319793 */
/*   36*/ {0.003599999999999958277606956304032762DL,   -1.59284178433729944590614332681327E-38DL, 1.0036064877830034DL}, /* 0.0035999999999999582776069563040327619840715821566270055409385667318673 */
/*   37*/ {0.003699999999999947134155927929514457DL,   4.578997729139367767703082105286181E-37DL, 1.0037068534499814DL}, /* 0.0036999999999999471341559279295144574578997729139367767703082105286181 */
/*   38*/ {0.003799999999999992912190928554255592DL,  -3.541542264547828539539142035424877E-37DL, 1.0038072291540280DL}, /* 0.0037999999999999929121909285542555916458457735452171460460857964575123 */
/*   39*/ {0.003899999999999939164603025537634878DL,   1.473214664072677494464027465562023E-37DL, 1.0039076148961468DL}, /* 0.0038999999999999391646030255376348781473214664072677494464027465562023 */
/*   40*/ {0.003999999999999927930049157167710824DL,  -2.021627915112355499890155508618673E-37DL, 1.0040080106773418DL}, /* 0.0039999999999999279300491571677108237978372084887644500109844491381327 */
/*   41*/ {0.004099999999999901619538091399732083DL,  -3.931662115864895727124438443864117E-37DL, 1.0041084164986169DL}, /* 0.0040999999999999016195380913997320826068337884135104272875561556135883 */
/*   42*/ {0.004199999999999901848869857119211876DL,   3.670432838979653062998309741971700E-37DL, 1.0042088323609762DL}, /* 0.0041999999999999018488698571192118763670432838979653062998309741971700 */
/*   43*/ {0.004299999999999969808120909806883308DL,    1.19648344090272193377255220668829E-38DL, 1.0043092582654239DL}, /* 0.0042999999999999698081209098068833080119648344090272193377255220668829 */
/*   44*/ {0.004399999999999947129922157682228399DL,     9.7429415364129858639763359736956E-39DL, 1.0044096942129641DL}, /* 0.0043999999999999471299221576822283990097429415364129858639763359736956 */
/*   45*/ {0.004499999999999973734285991298161872DL,    7.10628626967216067076384345490594E-38DL, 1.0045101402046013DL}, /* 0.0044999999999999737342859912981618720710628626967216067076384345490594 */
/*   46*/ {0.004599999999999989964206485892511183DL,    3.37722331971858831701595101489364E-38DL, 1.0046105962413399DL}, /* 0.0045999999999999899642064858925111830337722331971858831701595101489364 */
/*   47*/ {0.004699999999999935737636974553234142DL,   3.824564678003816041153483280540874E-37DL, 1.0047110623241844DL}, /* 0.0046999999999999357376369745532341423824564678003816041153483280540874 */
/*   48*/ {0.004799999999999949580011340261286376DL,   2.287494518663337676284484025620175E-37DL, 1.0048115384541396DL}, /* 0.0047999999999999495800113402612863762287494518663337676284484025620175 */
/*   49*/ {0.004899999999999970470159581679539846DL,   2.080010664081774332653586333331270E-37DL, 1.0049120246322102DL}, /* 0.0048999999999999704701595816795398462080010664081774332653586333331270 */
/*   50*/ {0.004999999999999936932560614345534614DL,   2.907440075506350341189730768525575E-37DL, 1.0050125208594010DL}, /* 0.0049999999999999369325606143455346142907440075506350341189730768525575 */
/*   51*/ {0.005099999999999986010174619279534640DL,   -7.49226784387386252880108003051140E-38DL, 1.0051130271367171DL}, /* 0.0050999999999999860101746192795346399250773215612613747119891996948860 */
/*   52*/ {0.005199999999999955748449113798610856DL,   4.917701700932931257093691038591343E-37DL, 1.0052135434651634DL}, /* 0.0051999999999999557484491137986108564917701700932931257093691038591343 */
/*   53*/ {0.005299999999999982163211162450383323DL,  -1.575773592684010629384702816731650E-37DL, 1.0053140698457452DL}, /* 0.0052999999999999821632111624503833228424226407315989370615297183268350 */
/*   54*/ {0.005399999999999902312976054092351177DL,   1.311316623637348088371254996679697E-37DL, 1.0054146062794676DL}, /* 0.0053999999999999023129760540923511771311316623637348088371254996679697 */
/*   55*/ {0.005499999999999950598975500576745640DL,  -2.009639475029458746852868056083049E-37DL, 1.0055151527673362DL}, /* 0.0054999999999999505989755005767456397990360524970541253147131943916951 */
/*   56*/ {0.005599999999999963023994386116666109DL,  -4.768906456626033201950091385609253E-37DL, 1.0056157093103563DL}, /* 0.0055999999999999630239943861166661085231093543373966798049908614390747 */
/*   57*/ {0.005699999999999973971267601080584357DL,  -4.456137020777351468970063010716326E-37DL, 1.0057162759095335DL}, /* 0.0056999999999999739712676010805843565543862979222648531029936989283674 */
/*   58*/ {0.005799999999999917830277414273159918DL,    8.04764585917654841704844265614868E-38DL, 1.0058168525658734DL}, /* 0.0057999999999999178302774142731599180804764585917654841704844265614868 */
/*   59*/ {0.005899999999999927271958157709947605DL,  -1.162410313252122640892410490411705E-37DL, 1.0059174392803819DL}, /* 0.0058999999999999272719581577099476048837589686747877359107589509588295 */
/*   60*/ {0.005999999999999935532383895959909067DL,  -2.993579491599309556770359727888619E-37DL, 1.0060180360540648DL}, /* 0.0059999999999999355323838959599090667006420508400690443229640272111381 */
/*   61*/ {0.006099999999999974678040273380718327DL,  -3.768027279871761018366151194474413E-37DL, 1.0061186428879281DL}, /* 0.0060999999999999746780402733807183266231972720128238981633848805525587 */
/*   62*/ {0.006199999999999976782584885711088078DL,  -3.670898133820869872542438418554496E-37DL, 1.0062192597829778DL}, /* 0.0061999999999999767825848857110880776329101866179130127457561581445504 */
/*   63*/ {0.006299999999999972710801165919241854DL,   -1.86154785291864917468829784176158E-38DL, 1.0063198867402201DL}, /* 0.0062999999999999727108011659192418539813845214708135082531170215823842 */
/*   64*/ {0.006399999999999992697170944378118669DL,   2.642077153104879546815204274450841E-37DL, 1.0064205237606613DL}, /* 0.0063999999999999926971709443781186692642077153104879546815204274450841 */
/*   65*/ {0.006499999999999966984081067432206847DL,   2.190973900030727767704087850390990E-37DL, 1.0065211708453077DL}, /* 0.0064999999999999669840810674322068472190973900030727767704087850390990 */
/*   66*/ {0.006599999999999924546162854344536372DL,  -2.473339430765169033832732431626390E-37DL, 1.0066218279951658DL}, /* 0.0065999999999999245461628543445363717526660569234830966167267568373610 */
/*   67*/ {0.006699999999999993030937917773998482DL,   3.895930083607962252580528551628354E-37DL, 1.0067224952112423DL}, /* 0.0066999999999999930309379177739984823895930083607962252580528551628354 */
/*   68*/ {0.006799999999999902087949946501509050DL,    3.32634458131883654657735259040860E-38DL, 1.0068231724945436DL}, /* 0.0067999999999999020879499465015090500332634458131883654657735259040860 */
/*   69*/ {0.006899999999999976681493823948530120DL,   1.581503952955507599271362135254605E-37DL, 1.0069238598460768DL}, /* 0.0068999999999999766814938239485301201581503952955507599271362135254605 */
/*   70*/ {0.006999999999999945153671145970201710DL,   3.533185374133590828736273337038321E-37DL, 1.0070245572668485DL}, /* 0.0069999999999999451536711459702017103533185374133590828736273337038321 */
/*   71*/ {0.007099999999999932437801864420682041DL,  -1.124569238146672143802134408348873E-37DL, 1.0071252647578658DL}, /* 0.0070999999999999324378018644206820408875430761853327856197865591651127 */
/*   72*/ {0.007199999999999963437239301603468150DL,  -1.126229986869745123558583235756226E-37DL, 1.0072259823201358DL}, /* 0.0071999999999999634372393016034681498873770013130254876441416764243774 */
/*   73*/ {0.007299999999999963065372641565340278DL,   2.489883076114805033559242606376250E-37DL, 1.0073267099546656DL}, /* 0.0072999999999999630653726415653402782489883076114805033559242606376250 */
/*   74*/ {0.007399999999999954811081939377238857DL,   -9.00290609343470485174776816012945E-38DL, 1.0074274476624625DL}, /* 0.0073999999999999548110819393772388569099709390656529514825223183987055 */
/*   75*/ {0.007499999999999961426657365229907339DL,  -2.935850072364068014186071018462989E-37DL, 1.0075281954445339DL}, /* 0.0074999999999999614266573652299073387064149927635931985813928981537011 */
/*   76*/ {0.007599999999999905675286934676274448DL,   1.387706240956188017787349912301427E-37DL, 1.0076289533018872DL}, /* 0.0075999999999999056752869346762744481387706240956188017787349912301427 */
/*   77*/ {0.007699999999999908069919502032280957DL,   4.658938377500461983441698675727273E-37DL, 1.0077297212355301DL}, /* 0.0076999999999999080699195020322809574658938377500461983441698675727273 */
/*   78*/ {0.007799999999999989095302727366878098DL,   4.293557180816538773055583101267744E-37DL, 1.0078304992464703DL}, /* 0.0077999999999999890953027273668780984293557180816538773055583101267744 */
/*   79*/ {0.007899999999999970034872827790994274DL,   -4.65597497733265001555145825153202E-38DL, 1.0079312873357154DL}, /* 0.0078999999999999700348728277909942739534402502266734998444854174846798 */
/*   80*/ {0.007999999999999969076308122657984520DL,   4.591803574198067803007502074791379E-37DL, 1.0080320855042734DL}, /* 0.0079999999999999690763081226579845204591803574198067803007502074791379 */
/*   81*/ {0.008099999999999905186746400835367237DL,   -3.46151846958789719526570277598104E-38DL, 1.0081328937531522DL}, /* 0.0080999999999999051867464008353672369653848153041210280473429722401896 */
/*   82*/ {0.008199999999999994119145040408370164DL,   2.045597364061223006795740022101201E-37DL, 1.0082337120833601DL}, /* 0.0081999999999999941191450404083701642045597364061223006795740022101201 */
/*   83*/ {0.008299999999999954866426200579611557DL,   3.597473429888188206089853956395207E-37DL, 1.0083345404959050DL}, /* 0.0082999999999999548664262005796115573597473429888188206089853956395207 */
/*   84*/ {0.008399999999999902371488628637780042DL,   1.150300193134754086327999066629848E-37DL, 1.0084353789917953DL}, /* 0.0083999999999999023714886286377800421150300193134754086327999066629848 */
/*   85*/ {0.008499999999999950704864020932981006DL,   1.088931385332407042225464572133042E-37DL, 1.0085362275720395DL}, /* 0.0084999999999999507048640209329810061088931385332407042225464572133042 */
/*   86*/ {0.008599999999999915624081926942944002DL,  -4.289111746827240188121587535517167E-37DL, 1.0086370862376459DL}, /* 0.0085999999999999156240819269429440015710888253172759811878412464482833 */
/*   87*/ {0.008699999999999909515451179332179292DL,  -3.119488610094169313212930121785059E-37DL, 1.0087379549896232DL}, /* 0.0086999999999999095154511793321792916880511389905830686787069878214941 */
/*   88*/ {0.008799999999999944740331172539067802DL,     7.6637271452068612966609666223824E-39DL, 1.0088388338289801DL}, /* 0.0087999999999999447403311725390678020076637271452068612966609666223824 */
/*   89*/ {0.008899999999999933675133099948193535DL,   -5.39465735465107969917775791698656E-38DL, 1.0089397227567253DL}, /* 0.0088999999999999336751330999481935349460534264534892030082224208301344 */
/*   90*/ {0.008999999999999986063424823680307113DL,   3.916451878662975799280659238620603E-37DL, 1.0090406217738678DL}, /* 0.0089999999999999860634248236803071133916451878662975799280659238620603 */
/*   91*/ {0.009099999999999913436623645986953550DL,   2.167947224596748294285310260202282E-37DL, 1.0091415308814164DL}, /* 0.0090999999999999134366236459869535502167947224596748294285310260202282 */
/*   92*/ {0.009199999999999922842619817976014959DL,    5.04409233478720657084791419915129E-38DL, 1.0092424500803804DL}, /* 0.0091999999999999228426198179760149590504409233478720657084791419915129 */
/*   93*/ {0.009299999999999923117871658598794643DL,   4.058664104356623647643948269814280E-37DL, 1.0093433793717689DL}, /* 0.0092999999999999231178716585987946434058664104356623647643948269814280 */
/*   94*/ {0.009399999999999921284102371390697721DL,   1.476132130284581822628057078835741E-37DL, 1.0094443187565912DL}, /* 0.0093999999999999212841023713906977211476132130284581822628057078835741 */
/*   95*/ {0.009499999999999923434723236577804172DL,   2.671096911176662384377415042607315E-37DL, 1.0095452682358567DL}, /* 0.0094999999999999234347232365778041722671096911176662384377415042607315 */
/*   96*/ {0.009599999999999934725299541487378699DL,  -2.154209822184693481095783378746521E-37DL, 1.0096462278105749DL}, /* 0.0095999999999999347252995414873786987845790177815306518904216621253479 */
/*   97*/ {0.009699999999999959364021370506538886DL,  -4.034672316447823447641072105344248E-37DL, 1.0097471974817554DL}, /* 0.0096999999999999593640213705065388855965327683552176552358927894655752 */
/*   98*/ {0.009799999999999901577392901298544774DL,   1.996410546487510634818001085024846E-37DL, 1.0098481772504078DL}, /* 0.0097999999999999015773929012985447741996410546487510634818001085024846 */
/*   99*/ {0.009899999999999961709760300278596708DL,   -1.92309389614924474910364590395838E-38DL, 1.0099491671175421DL}, /* 0.0098999999999999617097603002785967079807690610385075525089635409604162 */
/*  100*/ {0.009999999999999943030388655826201010DL,  -2.372254121557678227216506080856409E-37DL, 1.0100501670841680DL}, /* 0.0099999999999999430303886558262010097627745878442321772783493919143591 */
/*  101*/ { 0.01009999999999994488755566145173056DL,   -3.03605356869859805360283197008916E-37DL, 1.0101511771512956DL}, /* 0.010099999999999944887555661451730559696394643130140194639716802991084 */
#define EXPTBL2OFF 101
};
