/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <rtl/ustring.hxx>

inline constexpr OUString HID_INSWIN_POS = u"SC_HID_INSWIN_POS"_ustr;
inline constexpr OUString HID_INSWIN_CALC = u"SC_HID_INSWIN_CALC"_ustr;
inline constexpr OUString HID_INSWIN_CANCEL = u"SC_HID_INSWIN_CANCEL"_ustr;
inline constexpr OUString HID_INSWIN_OK = u"SC_HID_INSWIN_OK"_ustr;
inline constexpr OUString HID_INSWIN_SUMME = u"SC_HID_INSWIN_SUMME"_ustr;
inline constexpr OUString HID_INSWIN_FUNC = u"SC_HID_INSWIN_FUNC"_ustr;
inline constexpr OUString HID_INSWIN_INPUT = u"SC_HID_INSWIN_INPUT"_ustr;

// Help IDs for document window ----------------------------------------------
inline constexpr OUString HID_SC_WIN_GRIDWIN = u"SC_HID_SC_WIN_GRIDWIN"_ustr;
inline constexpr OUString HID_SC_WIN_PREVIEW = u"SC_HID_SC_WIN_PREVIEW"_ustr;

inline constexpr OUString HID_SC_HEADER_EDIT = u"SC_HID_SC_HEADER_EDIT"_ustr;
inline constexpr OUString HID_SC_FOOTER_EDIT = u"SC_HID_SC_FOOTER_EDIT"_ustr;

inline constexpr OUString HID_SC_SCENWIN_TOP = u"SC_HID_SC_SCENWIN_TOP"_ustr;
inline constexpr OUString HID_SC_SCENWIN_BOTTOM = u"SC_HID_SC_SCENWIN_BOTTOM"_ustr;

inline constexpr OUString HID_SC_INPUTWIN = u"SC_HID_SC_INPUTWIN"_ustr;

inline constexpr OUString HID_SC_RENAME_NAME = u"SC_HID_SC_RENAME_NAME"_ustr;
inline constexpr OUString HID_SC_APPEND_NAME = u"SC_HID_SC_APPEND_NAME"_ustr;

inline constexpr OUString HID_SC_ADD_AUTOFMT = u"SC_HID_SC_ADD_AUTOFMT"_ustr;
inline constexpr OUString HID_SC_AUTOFMT_NAME = u"SC_HID_SC_AUTOFMT_NAME"_ustr;

//  wrong group - HID_SC_DLG_START is full
inline constexpr OUString HID_SC_REN_AFMT_NAME = u"SC_HID_SC_REN_AFMT_NAME"_ustr;

inline constexpr OUString HID_CHG_PROTECT = u"SC_HID_CHG_PROTECT"_ustr;


inline constexpr OUString HID_SC_REN_AFMT_DLG = u"SC_HID_SC_REN_AFMT_DLG"_ustr;

// Help IDs for Submenus (max.50) --------------------------------------------
inline constexpr OUString HID_PASSWD_TABLE = u"SC_HID_PASSWD_TABLE"_ustr;
inline constexpr OUString HID_PASSWD_DOC = u"SC_HID_PASSWD_DOC"_ustr;
inline constexpr OUString HID_PASSWD_DOC_CONFIRM = u"SC_HID_PASSWD_DOC_CONFIRM"_ustr;


// Other help IDs (max.70) ---------------------------------------------------
inline constexpr OUString HID_SELECTTABLES = u"SC_HID_SELECTTABLES"_ustr;
inline constexpr OUString HID_GOTOTABLE  = u"SC_HID_GOTOTABLE"_ustr;
inline constexpr OUString HID_GOTOTABLEMASK  = u"SC_HID_GOTOTABLEMASK"_ustr;


// Analysis Addin Functions (max.120) ----------------------------------------
inline constexpr OUString HID_AAI_FUNC_WORKDAY = u"SC_HID_AAI_FUNC_WORKDAY"_ustr;
inline constexpr OUString HID_AAI_FUNC_YEARFRAC = u"SC_HID_AAI_FUNC_YEARFRAC"_ustr;
inline constexpr OUString HID_AAI_FUNC_EDATE = u"SC_HID_AAI_FUNC_EDATE"_ustr;
inline constexpr OUString HID_AAI_FUNC_WEEKNUM = u"SC_HID_AAI_FUNC_WEEKNUM"_ustr;
inline constexpr OUString HID_AAI_FUNC_EOMONTH = u"SC_HID_AAI_FUNC_EOMONTH"_ustr;
inline constexpr OUString HID_AAI_FUNC_NETWORKDAYS = u"SC_HID_AAI_FUNC_NETWORKDAYS"_ustr;
inline constexpr OUString HID_AAI_FUNC_AMORDEGRC = u"SC_HID_AAI_FUNC_AMORDEGRC"_ustr;
inline constexpr OUString HID_AAI_FUNC_AMORLINC = u"SC_HID_AAI_FUNC_AMORLINC"_ustr;
inline constexpr OUString HID_AAI_FUNC_ACCRINT = u"SC_HID_AAI_FUNC_ACCRINT"_ustr;
inline constexpr OUString HID_AAI_FUNC_ACCRINTM = u"SC_HID_AAI_FUNC_ACCRINTM"_ustr;
inline constexpr OUString HID_AAI_FUNC_RECEIVED = u"SC_HID_AAI_FUNC_RECEIVED"_ustr;
inline constexpr OUString HID_AAI_FUNC_DISC = u"SC_HID_AAI_FUNC_DISC"_ustr;
inline constexpr OUString HID_AAI_FUNC_DURATION = u"SC_HID_AAI_FUNC_DURATION"_ustr;
inline constexpr OUString HID_AAI_FUNC_EFFECT = u"SC_HID_AAI_FUNC_EFFECT"_ustr;
inline constexpr OUString HID_AAI_FUNC_CUMPRINC = u"SC_HID_AAI_FUNC_CUMPRINC"_ustr;
inline constexpr OUString HID_AAI_FUNC_CUMIPMT = u"SC_HID_AAI_FUNC_CUMIPMT"_ustr;
inline constexpr OUString HID_AAI_FUNC_PRICE = u"SC_HID_AAI_FUNC_PRICE"_ustr;
inline constexpr OUString HID_AAI_FUNC_PRICEDISC = u"SC_HID_AAI_FUNC_PRICEDISC"_ustr;
inline constexpr OUString HID_AAI_FUNC_PRICEMAT = u"SC_HID_AAI_FUNC_PRICEMAT"_ustr;
inline constexpr OUString HID_AAI_FUNC_MDURATION = u"SC_HID_AAI_FUNC_MDURATION"_ustr;
inline constexpr OUString HID_AAI_FUNC_NOMINAL = u"SC_HID_AAI_FUNC_NOMINAL"_ustr;
inline constexpr OUString HID_AAI_FUNC_DOLLARFR = u"SC_HID_AAI_FUNC_DOLLARFR"_ustr;
inline constexpr OUString HID_AAI_FUNC_DOLLARDE = u"SC_HID_AAI_FUNC_DOLLARDE"_ustr;
inline constexpr OUString HID_AAI_FUNC_YIELD = u"SC_HID_AAI_FUNC_YIELD"_ustr;
inline constexpr OUString HID_AAI_FUNC_YIELDDISC = u"SC_HID_AAI_FUNC_YIELDDISC"_ustr;
inline constexpr OUString HID_AAI_FUNC_YIELDMAT = u"SC_HID_AAI_FUNC_YIELDMAT"_ustr;
inline constexpr OUString HID_AAI_FUNC_TBILLEQ = u"SC_HID_AAI_FUNC_TBILLEQ"_ustr;
inline constexpr OUString HID_AAI_FUNC_TBILLPRICE = u"SC_HID_AAI_FUNC_TBILLPRICE"_ustr;
inline constexpr OUString HID_AAI_FUNC_TBILLYIELD = u"SC_HID_AAI_FUNC_TBILLYIELD"_ustr;
inline constexpr OUString HID_AAI_FUNC_ODDFPRICE = u"SC_HID_AAI_FUNC_ODDFPRICE"_ustr;
inline constexpr OUString HID_AAI_FUNC_ODDFYIELD = u"SC_HID_AAI_FUNC_ODDFYIELD"_ustr;
inline constexpr OUString HID_AAI_FUNC_ODDLPRICE = u"SC_HID_AAI_FUNC_ODDLPRICE"_ustr;
inline constexpr OUString HID_AAI_FUNC_ODDLYIELD = u"SC_HID_AAI_FUNC_ODDLYIELD"_ustr;
inline constexpr OUString HID_AAI_FUNC_XIRR = u"SC_HID_AAI_FUNC_XIRR"_ustr;
inline constexpr OUString HID_AAI_FUNC_XNPV = u"SC_HID_AAI_FUNC_XNPV"_ustr;
inline constexpr OUString HID_AAI_FUNC_INTRATE = u"SC_HID_AAI_FUNC_INTRATE"_ustr;
inline constexpr OUString HID_AAI_FUNC_COUPNCD = u"SC_HID_AAI_FUNC_COUPNCD"_ustr;
inline constexpr OUString HID_AAI_FUNC_COUPDAYS = u"SC_HID_AAI_FUNC_COUPDAYS"_ustr;
inline constexpr OUString HID_AAI_FUNC_COUPDAYSNC = u"SC_HID_AAI_FUNC_COUPDAYSNC"_ustr;
inline constexpr OUString HID_AAI_FUNC_COUPDAYBS = u"SC_HID_AAI_FUNC_COUPDAYBS"_ustr;
inline constexpr OUString HID_AAI_FUNC_COUPPCD = u"SC_HID_AAI_FUNC_COUPPCD"_ustr;
inline constexpr OUString HID_AAI_FUNC_COUPNUM = u"SC_HID_AAI_FUNC_COUPNUM"_ustr;
inline constexpr OUString HID_AAI_FUNC_FVSCHEDULE = u"SC_HID_AAI_FUNC_FVSCHEDULE"_ustr;
inline constexpr OUString HID_AAI_FUNC_ISEVEN = u"SC_HID_AAI_FUNC_ISEVEN"_ustr;
inline constexpr OUString HID_AAI_FUNC_ISODD = u"SC_HID_AAI_FUNC_ISODD"_ustr;
inline constexpr OUString HID_AAI_FUNC_GCD = u"SC_HID_AAI_FUNC_GCD"_ustr;
inline constexpr OUString HID_AAI_FUNC_LCM = u"SC_HID_AAI_FUNC_LCM"_ustr;
inline constexpr OUString HID_AAI_FUNC_MULTINOMIAL = u"SC_HID_AAI_FUNC_MULTINOMIAL"_ustr;
inline constexpr OUString HID_AAI_FUNC_SERIESSUM = u"SC_HID_AAI_FUNC_SERIESSUM"_ustr;
inline constexpr OUString HID_AAI_FUNC_QUOTIENT = u"SC_HID_AAI_FUNC_QUOTIENT"_ustr;
inline constexpr OUString HID_AAI_FUNC_MROUND = u"SC_HID_AAI_FUNC_MROUND"_ustr;
inline constexpr OUString HID_AAI_FUNC_SQRTPI = u"SC_HID_AAI_FUNC_SQRTPI"_ustr;
inline constexpr OUString HID_AAI_FUNC_RANDBETWEEN = u"SC_HID_AAI_FUNC_RANDBETWEEN"_ustr;
inline constexpr OUString HID_AAI_FUNC_BESSELI = u"SC_HID_AAI_FUNC_BESSELI"_ustr;
inline constexpr OUString HID_AAI_FUNC_BESSELJ = u"SC_HID_AAI_FUNC_BESSELJ"_ustr;
inline constexpr OUString HID_AAI_FUNC_BESSELK = u"SC_HID_AAI_FUNC_BESSELK"_ustr;
inline constexpr OUString HID_AAI_FUNC_BESSELY = u"SC_HID_AAI_FUNC_BESSELY"_ustr;
inline constexpr OUString HID_AAI_FUNC_BIN2DEC = u"SC_HID_AAI_FUNC_BIN2DEC"_ustr;
inline constexpr OUString HID_AAI_FUNC_BIN2HEX = u"SC_HID_AAI_FUNC_BIN2HEX"_ustr;
inline constexpr OUString HID_AAI_FUNC_BIN2OCT = u"SC_HID_AAI_FUNC_BIN2OCT"_ustr;
inline constexpr OUString HID_AAI_FUNC_DELTA = u"SC_HID_AAI_FUNC_DELTA"_ustr;
inline constexpr OUString HID_AAI_FUNC_DEC2BIN = u"SC_HID_AAI_FUNC_DEC2BIN"_ustr;
inline constexpr OUString HID_AAI_FUNC_DEC2HEX = u"SC_HID_AAI_FUNC_DEC2HEX"_ustr;
inline constexpr OUString HID_AAI_FUNC_DEC2OCT = u"SC_HID_AAI_FUNC_DEC2OCT"_ustr;
inline constexpr OUString HID_AAI_FUNC_ERF = u"SC_HID_AAI_FUNC_ERF"_ustr;
inline constexpr OUString HID_AAI_FUNC_ERFC = u"SC_HID_AAI_FUNC_ERFC"_ustr;
inline constexpr OUString HID_AAI_FUNC_GESTEP = u"SC_HID_AAI_FUNC_GESTEP"_ustr;
inline constexpr OUString HID_AAI_FUNC_HEX2BIN = u"SC_HID_AAI_FUNC_HEX2BIN"_ustr;
inline constexpr OUString HID_AAI_FUNC_HEX2DEC = u"SC_HID_AAI_FUNC_HEX2DEC"_ustr;
inline constexpr OUString HID_AAI_FUNC_HEX2OCT = u"SC_HID_AAI_FUNC_HEX2OCT"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMABS = u"SC_HID_AAI_FUNC_IMABS"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMAGINARY = u"SC_HID_AAI_FUNC_IMAGINARY"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMPOWER = u"SC_HID_AAI_FUNC_IMPOWER"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMARGUMENT = u"SC_HID_AAI_FUNC_IMARGUMENT"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMCOS = u"SC_HID_AAI_FUNC_IMCOS"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMDIV = u"SC_HID_AAI_FUNC_IMDIV"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMEXP = u"SC_HID_AAI_FUNC_IMEXP"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMCONJUGATE = u"SC_HID_AAI_FUNC_IMCONJUGATE"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMLN = u"SC_HID_AAI_FUNC_IMLN"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMLOG10 = u"SC_HID_AAI_FUNC_IMLOG10"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMLOG2 = u"SC_HID_AAI_FUNC_IMLOG2"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMPRODUCT = u"SC_HID_AAI_FUNC_IMPRODUCT"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMREAL = u"SC_HID_AAI_FUNC_IMREAL"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSIN = u"SC_HID_AAI_FUNC_IMSIN"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSUB = u"SC_HID_AAI_FUNC_IMSUB"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSUM = u"SC_HID_AAI_FUNC_IMSUM"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSQRT = u"SC_HID_AAI_FUNC_IMSQRT"_ustr;
inline constexpr OUString HID_AAI_FUNC_COMPLEX = u"SC_HID_AAI_FUNC_COMPLEX"_ustr;
inline constexpr OUString HID_AAI_FUNC_OCT2BIN = u"SC_HID_AAI_FUNC_OCT2BIN"_ustr;
inline constexpr OUString HID_AAI_FUNC_OCT2DEZ = u"SC_HID_AAI_FUNC_OCT2DEZ"_ustr;
inline constexpr OUString HID_AAI_FUNC_OCT2HEX = u"SC_HID_AAI_FUNC_OCT2HEX"_ustr;
inline constexpr OUString HID_AAI_FUNC_CONVERT = u"SC_HID_AAI_FUNC_CONVERT"_ustr;
inline constexpr OUString HID_AAI_FUNC_FACTDOUBLE = u"SC_HID_AAI_FUNC_FACTDOUBLE"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMTAN = u"SC_HID_AAI_FUNC_IMTAN"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSEC = u"SC_HID_AAI_FUNC_IMSEC"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMCSC = u"SC_HID_AAI_FUNC_IMCSC"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMCOT = u"SC_HID_AAI_FUNC_IMCOT"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSINH = u"SC_HID_AAI_FUNC_IMSINH"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMCOSH = u"SC_HID_AAI_FUNC_IMCOSH"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMSECH = u"SC_HID_AAI_FUNC_IMSECH"_ustr;
inline constexpr OUString HID_AAI_FUNC_IMCSCH = u"SC_HID_AAI_FUNC_IMCSCH"_ustr;

inline constexpr OUString HID_UPDATE_LINK_WARNING = u"cui/ui/baselinksdialog/UPDATE_NOW"_ustr;

// DateFunc Addin Functions (max.20) -----------------------------------------
inline constexpr OUString HID_DAI_FUNC_DAYSINMONTH = u"SC_HID_DAI_FUNC_DAYSINMONTH"_ustr;
inline constexpr OUString HID_DAI_FUNC_DAYSINYEAR = u"SC_HID_DAI_FUNC_DAYSINYEAR"_ustr;
inline constexpr OUString HID_DAI_FUNC_WEEKSINYEAR = u"SC_HID_DAI_FUNC_WEEKSINYEAR"_ustr;
inline constexpr OUString HID_DAI_FUNC_DIFFMONTHS = u"SC_HID_DAI_FUNC_DIFFMONTHS"_ustr;
inline constexpr OUString HID_DAI_FUNC_DIFFWEEKS = u"SC_HID_DAI_FUNC_DIFFWEEKS"_ustr;
inline constexpr OUString HID_DAI_FUNC_DIFFYEARS = u"SC_HID_DAI_FUNC_DIFFYEARS"_ustr;
inline constexpr OUString HID_DAI_FUNC_ROT13 = u"SC_HID_DAI_FUNC_ROT13"_ustr;

// PricingFunc Addin Functions  -----------------------------------------

inline constexpr OUString HID_PAI_FUNC_OPT_BARRIER = u"SC_HID_PAI_FUNC_OPT_BARRIER"_ustr;
inline constexpr OUString HID_PAI_FUNC_OPT_TOUCH = u"SC_HID_PAI_FUNC_OPT_TOUCH"_ustr;
inline constexpr OUString HID_PAI_FUNC_OPT_PROB_HIT = u"SC_HID_PAI_FUNC_OPT_PROB_HIT"_ustr;
inline constexpr OUString HID_PAI_FUNC_OPT_PROB_INMONEY = u"SC_HID_PAI_FUNC_OPT_PROB_INMONEY"_ustr;

// End help IDs ------------------------------------------------------------

inline constexpr OUString HID_FUNC_DBANZAHL = u"SC_HID_FUNC_DBANZAHL"_ustr;
inline constexpr OUString HID_FUNC_DBANZAHL2 = u"SC_HID_FUNC_DBANZAHL2"_ustr;
inline constexpr OUString HID_FUNC_DBMITTELWERT = u"SC_HID_FUNC_DBMITTELWERT"_ustr;
inline constexpr OUString HID_FUNC_DBAUSZUG = u"SC_HID_FUNC_DBAUSZUG"_ustr;
inline constexpr OUString HID_FUNC_DBMAX = u"SC_HID_FUNC_DBMAX"_ustr;
inline constexpr OUString HID_FUNC_DBMIN = u"SC_HID_FUNC_DBMIN"_ustr;
inline constexpr OUString HID_FUNC_DBPRODUKT = u"SC_HID_FUNC_DBPRODUKT"_ustr;
inline constexpr OUString HID_FUNC_DBSTDABW = u"SC_HID_FUNC_DBSTDABW"_ustr;
inline constexpr OUString HID_FUNC_DBSTDABWN = u"SC_HID_FUNC_DBSTDABWN"_ustr;
inline constexpr OUString HID_FUNC_DBSUMME = u"SC_HID_FUNC_DBSUMME"_ustr;
inline constexpr OUString HID_FUNC_DBVARIANZ = u"SC_HID_FUNC_DBVARIANZ"_ustr;
inline constexpr OUString HID_FUNC_DBVARIANZEN = u"SC_HID_FUNC_DBVARIANZEN"_ustr;

inline constexpr OUString HID_FUNC_DATUM = u"SC_HID_FUNC_DATUM"_ustr;
inline constexpr OUString HID_FUNC_DATWERT = u"SC_HID_FUNC_DATWERT"_ustr;
inline constexpr OUString HID_FUNC_TAG = u"SC_HID_FUNC_TAG"_ustr;
inline constexpr OUString HID_FUNC_TAGE360 = u"SC_HID_FUNC_TAGE360"_ustr;
inline constexpr OUString HID_FUNC_STUNDE = u"SC_HID_FUNC_STUNDE"_ustr;
inline constexpr OUString HID_FUNC_MINUTE = u"SC_HID_FUNC_MINUTE"_ustr;
inline constexpr OUString HID_FUNC_MONAT = u"SC_HID_FUNC_MONAT"_ustr;
inline constexpr OUString HID_FUNC_JETZT = u"SC_HID_FUNC_JETZT"_ustr;
inline constexpr OUString HID_FUNC_SEKUNDE = u"SC_HID_FUNC_SEKUNDE"_ustr;
inline constexpr OUString HID_FUNC_ZEIT = u"SC_HID_FUNC_ZEIT"_ustr;
inline constexpr OUString HID_FUNC_ZEITWERT = u"SC_HID_FUNC_ZEITWERT"_ustr;
inline constexpr OUString HID_FUNC_HEUTE = u"SC_HID_FUNC_HEUTE"_ustr;
inline constexpr OUString HID_FUNC_WOCHENTAG = u"SC_HID_FUNC_WOCHENTAG"_ustr;
inline constexpr OUString HID_FUNC_JAHR = u"SC_HID_FUNC_JAHR"_ustr;
inline constexpr OUString HID_FUNC_TAGE = u"SC_HID_FUNC_TAGE"_ustr;
inline constexpr OUString HID_FUNC_DATEDIF = u"SC_HID_FUNC_DATEDIF"_ustr;
inline constexpr OUString HID_FUNC_KALENDERWOCHE = u"SC_HID_FUNC_KALENDERWOCHE"_ustr;
inline constexpr OUString HID_FUNC_OSTERSONNTAG = u"SC_HID_FUNC_OSTERSONNTAG"_ustr;
inline constexpr OUString HID_FUNC_ISOWEEKNUM = u"SC_HID_FUNC_ISOWEEKNUM"_ustr;

inline constexpr OUString HID_FUNC_BW = u"SC_HID_FUNC_BW"_ustr;
inline constexpr OUString HID_FUNC_ZW = u"SC_HID_FUNC_ZW"_ustr;
inline constexpr OUString HID_FUNC_ZZR = u"SC_HID_FUNC_ZZR"_ustr;
inline constexpr OUString HID_FUNC_RMZ = u"SC_HID_FUNC_RMZ"_ustr;
inline constexpr OUString HID_FUNC_ZINS = u"SC_HID_FUNC_ZINS"_ustr;
inline constexpr OUString HID_FUNC_ZINSZ = u"SC_HID_FUNC_ZINSZ"_ustr;
inline constexpr OUString HID_FUNC_KAPZ = u"SC_HID_FUNC_KAPZ"_ustr;
inline constexpr OUString HID_FUNC_KUMKAPITAL = u"SC_HID_FUNC_KUMKAPITAL"_ustr;
inline constexpr OUString HID_FUNC_KUMZINSZ = u"SC_HID_FUNC_KUMZINSZ"_ustr;
inline constexpr OUString HID_FUNC_DIA = u"SC_HID_FUNC_DIA"_ustr;
inline constexpr OUString HID_FUNC_LIA = u"SC_HID_FUNC_LIA"_ustr;
inline constexpr OUString HID_FUNC_GDA = u"SC_HID_FUNC_GDA"_ustr;
inline constexpr OUString HID_FUNC_GDA2 = u"SC_HID_FUNC_GDA2"_ustr;
inline constexpr OUString HID_FUNC_VDB = u"SC_HID_FUNC_VDB"_ustr;
inline constexpr OUString HID_FUNC_EFFEKTIV = u"SC_HID_FUNC_EFFEKTIV"_ustr;
inline constexpr OUString HID_FUNC_NOMINAL = u"SC_HID_FUNC_NOMINAL"_ustr;
inline constexpr OUString HID_FUNC_NBW = u"SC_HID_FUNC_NBW"_ustr;
inline constexpr OUString HID_FUNC_IKV = u"SC_HID_FUNC_IKV"_ustr;
inline constexpr OUString HID_FUNC_LAUFZEIT = u"SC_HID_FUNC_LAUFZEIT"_ustr;
inline constexpr OUString HID_FUNC_ZGZ = u"SC_HID_FUNC_ZGZ"_ustr;
inline constexpr OUString HID_FUNC_QIKV = u"SC_HID_FUNC_QIKV"_ustr;
inline constexpr OUString HID_FUNC_ISPMT = u"SC_HID_FUNC_ISPMT"_ustr;

inline constexpr OUString HID_FUNC_ISTBEZUG = u"SC_HID_FUNC_ISTBEZUG"_ustr;
inline constexpr OUString HID_FUNC_ISTFEHL = u"SC_HID_FUNC_ISTFEHL"_ustr;
inline constexpr OUString HID_FUNC_ISTFEHLER = u"SC_HID_FUNC_ISTFEHLER"_ustr;
inline constexpr OUString HID_FUNC_ISTLEER = u"SC_HID_FUNC_ISTLEER"_ustr;
inline constexpr OUString HID_FUNC_ISTLOG = u"SC_HID_FUNC_ISTLOG"_ustr;
inline constexpr OUString HID_FUNC_ISTNV = u"SC_HID_FUNC_ISTNV"_ustr;
inline constexpr OUString HID_FUNC_ISTKTEXT = u"SC_HID_FUNC_ISTKTEXT"_ustr;
inline constexpr OUString HID_FUNC_ISTTEXT = u"SC_HID_FUNC_ISTTEXT"_ustr;
inline constexpr OUString HID_FUNC_ISTZAHL = u"SC_HID_FUNC_ISTZAHL"_ustr;
inline constexpr OUString HID_FUNC_ISTFORMEL = u"SC_HID_FUNC_ISTFORMEL"_ustr;
inline constexpr OUString HID_FUNC_N = u"SC_HID_FUNC_N"_ustr;
inline constexpr OUString HID_FUNC_NV = u"SC_HID_FUNC_NV"_ustr;
inline constexpr OUString HID_FUNC_TYP = u"SC_HID_FUNC_TYP"_ustr;
inline constexpr OUString HID_FUNC_AKTUELL = u"SC_HID_FUNC_AKTUELL"_ustr;
inline constexpr OUString HID_FUNC_FORMEL = u"SC_HID_FUNC_FORMEL"_ustr;
inline constexpr OUString HID_FUNC_ZELLE = u"SC_HID_FUNC_ZELLE"_ustr;
inline constexpr OUString HID_FUNC_INFO = u"SC_HID_FUNC_INFO"_ustr;

inline constexpr OUString HID_FUNC_FALSCH = u"SC_HID_FUNC_FALSCH"_ustr;
inline constexpr OUString HID_FUNC_NICHT = u"SC_HID_FUNC_NICHT"_ustr;
inline constexpr OUString HID_FUNC_WAHR = u"SC_HID_FUNC_WAHR"_ustr;
inline constexpr OUString HID_FUNC_WENN = u"SC_HID_FUNC_WENN"_ustr;
inline constexpr OUString HID_FUNC_IFERROR = u"SC_HID_FUNC_IFERROR"_ustr;
inline constexpr OUString HID_FUNC_IFNA = u"SC_HID_FUNC_IFNA"_ustr;
inline constexpr OUString HID_FUNC_ODER = u"SC_HID_FUNC_ODER"_ustr;
inline constexpr OUString HID_FUNC_UND = u"SC_HID_FUNC_UND"_ustr;
inline constexpr OUString HID_FUNC_XOR = u"SC_HID_FUNC_XOR"_ustr;

inline constexpr OUString HID_FUNC_ABS = u"SC_HID_FUNC_ABS"_ustr;
inline constexpr OUString HID_FUNC_POTENZ = u"SC_HID_FUNC_POTENZ"_ustr;
inline constexpr OUString HID_FUNC_ANZAHLLEEREZELLEN = u"SC_HID_FUNC_ANZAHLLEEREZELLEN"_ustr;
inline constexpr OUString HID_FUNC_PI = u"SC_HID_FUNC_PI"_ustr;
inline constexpr OUString HID_FUNC_SUMME = u"SC_HID_FUNC_SUMME"_ustr;
inline constexpr OUString HID_FUNC_QUADRATESUMME = u"SC_HID_FUNC_QUADRATESUMME"_ustr;
inline constexpr OUString HID_FUNC_PRODUKT = u"SC_HID_FUNC_PRODUKT"_ustr;
inline constexpr OUString HID_FUNC_SUMMEWENN = u"SC_HID_FUNC_SUMMEWENN"_ustr;
inline constexpr OUString HID_FUNC_AVERAGEIF = u"SC_HID_FUNC_AVERAGEIF"_ustr;
inline constexpr OUString HID_FUNC_SUMIFS = u"SC_HID_FUNC_SUMIFS"_ustr;
inline constexpr OUString HID_FUNC_AVERAGEIFS = u"SC_HID_FUNC_AVERAGEIFS"_ustr;
inline constexpr OUString HID_FUNC_COUNTIFS = u"SC_HID_FUNC_COUNTIFS"_ustr;
inline constexpr OUString HID_FUNC_ZAEHLENWENN = u"SC_HID_FUNC_ZAEHLENWENN"_ustr;
inline constexpr OUString HID_FUNC_WURZEL = u"SC_HID_FUNC_WURZEL"_ustr;
inline constexpr OUString HID_FUNC_ZUFALLSZAHL = u"SC_HID_FUNC_ZUFALLSZAHL"_ustr;
inline constexpr OUString HID_FUNC_ISTGERADE = u"SC_HID_FUNC_ISTGERADE"_ustr;
inline constexpr OUString HID_FUNC_ISTUNGERADE = u"SC_HID_FUNC_ISTUNGERADE"_ustr;
inline constexpr OUString HID_FUNC_KOMBINATIONEN = u"SC_HID_FUNC_KOMBINATIONEN"_ustr;
inline constexpr OUString HID_FUNC_KOMBINATIONEN2 = u"SC_HID_FUNC_KOMBINATIONEN2"_ustr;
inline constexpr OUString HID_FUNC_ARCCOS = u"SC_HID_FUNC_ARCCOS"_ustr;
inline constexpr OUString HID_FUNC_ARCSIN = u"SC_HID_FUNC_ARCSIN"_ustr;
inline constexpr OUString HID_FUNC_ARCOSHYP = u"SC_HID_FUNC_ARCOSHYP"_ustr;
inline constexpr OUString HID_FUNC_ARSINHYP = u"SC_HID_FUNC_ARSINHYP"_ustr;
inline constexpr OUString HID_FUNC_ARCCOT = u"SC_HID_FUNC_ARCCOT"_ustr;
inline constexpr OUString HID_FUNC_ARCTAN = u"SC_HID_FUNC_ARCTAN"_ustr;
inline constexpr OUString HID_FUNC_ARCOTHYP = u"SC_HID_FUNC_ARCOTHYP"_ustr;
inline constexpr OUString HID_FUNC_ARTANHYP = u"SC_HID_FUNC_ARTANHYP"_ustr;
inline constexpr OUString HID_FUNC_COS = u"SC_HID_FUNC_COS"_ustr;
inline constexpr OUString HID_FUNC_SIN = u"SC_HID_FUNC_SIN"_ustr;
inline constexpr OUString HID_FUNC_COT = u"SC_HID_FUNC_COT"_ustr;
inline constexpr OUString HID_FUNC_TAN = u"SC_HID_FUNC_TAN"_ustr;
inline constexpr OUString HID_FUNC_COSHYP = u"SC_HID_FUNC_COSHYP"_ustr;
inline constexpr OUString HID_FUNC_SINHYP = u"SC_HID_FUNC_SINHYP"_ustr;
inline constexpr OUString HID_FUNC_COTHYP = u"SC_HID_FUNC_COTHYP"_ustr;
inline constexpr OUString HID_FUNC_TANHYP = u"SC_HID_FUNC_TANHYP"_ustr;
inline constexpr OUString HID_FUNC_ARCTAN2 = u"SC_HID_FUNC_ARCTAN2"_ustr;
inline constexpr OUString HID_FUNC_COSECANT = u"SC_HID_FUNC_COSECANT"_ustr;
inline constexpr OUString HID_FUNC_SECANT = u"SC_HID_FUNC_SECANT"_ustr;
inline constexpr OUString HID_FUNC_SECANTHYP = u"SC_HID_FUNC_SECANTHYP"_ustr;
inline constexpr OUString HID_FUNC_COSECANTHYP = u"SC_HID_FUNC_COSECANTHYP"_ustr;
inline constexpr OUString HID_FUNC_DEG = u"SC_HID_FUNC_DEG"_ustr;
inline constexpr OUString HID_FUNC_RAD = u"SC_HID_FUNC_RAD"_ustr;
inline constexpr OUString HID_FUNC_EXP = u"SC_HID_FUNC_EXP"_ustr;
inline constexpr OUString HID_FUNC_LOG = u"SC_HID_FUNC_LOG"_ustr;
inline constexpr OUString HID_FUNC_LN = u"SC_HID_FUNC_LN"_ustr;
inline constexpr OUString HID_FUNC_LOG10 = u"SC_HID_FUNC_LOG10"_ustr;
inline constexpr OUString HID_FUNC_FAKULTAET = u"SC_HID_FUNC_FAKULTAET"_ustr;
inline constexpr OUString HID_FUNC_REST = u"SC_HID_FUNC_REST"_ustr;
inline constexpr OUString HID_FUNC_VORZEICHEN = u"SC_HID_FUNC_VORZEICHEN"_ustr;
inline constexpr OUString HID_FUNC_TEILERGEBNIS = u"SC_HID_FUNC_TEILERGEBNIS"_ustr;
inline constexpr OUString HID_FUNC_GANZZAHL = u"SC_HID_FUNC_GANZZAHL"_ustr;
inline constexpr OUString HID_FUNC_KUERZEN = u"SC_HID_FUNC_KUERZEN"_ustr;
inline constexpr OUString HID_FUNC_RUNDEN = u"SC_HID_FUNC_RUNDEN"_ustr;
inline constexpr OUString HID_FUNC_AUFRUNDEN = u"SC_HID_FUNC_AUFRUNDEN"_ustr;
inline constexpr OUString HID_FUNC_ABRUNDEN = u"SC_HID_FUNC_ABRUNDEN"_ustr;
inline constexpr OUString HID_FUNC_GERADE = u"SC_HID_FUNC_GERADE"_ustr;
inline constexpr OUString HID_FUNC_UNGERADE = u"SC_HID_FUNC_UNGERADE"_ustr;
inline constexpr OUString HID_FUNC_OBERGRENZE = u"SC_HID_FUNC_OBERGRENZE"_ustr;
inline constexpr OUString HID_FUNC_UNTERGRENZE = u"SC_HID_FUNC_UNTERGRENZE"_ustr;
inline constexpr OUString HID_FUNC_GGT = u"SC_HID_FUNC_GGT"_ustr;
inline constexpr OUString HID_FUNC_KGV = u"SC_HID_FUNC_KGV"_ustr;
inline constexpr OUString HID_FUNC_UMRECHNEN = u"SC_HID_FUNC_UMRECHNEN"_ustr;
inline constexpr OUString HID_FUNC_EUROCONVERT = u"SC_HID_FUNC_EUROCONVERT"_ustr;

inline constexpr OUString HID_FUNC_MSEQUENCE_MS = u"SC_HID_FUNC_MSEQUENCE_MS"_ustr;
inline constexpr OUString HID_FUNC_MTRANS = u"SC_HID_FUNC_MTRANS"_ustr;
inline constexpr OUString HID_FUNC_MMULT = u"SC_HID_FUNC_MMULT"_ustr;
inline constexpr OUString HID_FUNC_MDET = u"SC_HID_FUNC_MDET"_ustr;
inline constexpr OUString HID_FUNC_MINV = u"SC_HID_FUNC_MINV"_ustr;
inline constexpr OUString HID_FUNC_EINHEITSMATRIX = u"SC_HID_FUNC_EINHEITSMATRIX"_ustr;
inline constexpr OUString HID_FUNC_SUMMENPRODUKT = u"SC_HID_FUNC_SUMMENPRODUKT"_ustr;
inline constexpr OUString HID_FUNC_SUMMEX2MY2 = u"SC_HID_FUNC_SUMMEX2MY2"_ustr;
inline constexpr OUString HID_FUNC_SUMMEX2PY2 = u"SC_HID_FUNC_SUMMEX2PY2"_ustr;
inline constexpr OUString HID_FUNC_SUMMEXMY2 = u"SC_HID_FUNC_SUMMEXMY2"_ustr;
inline constexpr OUString HID_FUNC_HAEUFIGKEIT = u"SC_HID_FUNC_HAEUFIGKEIT"_ustr;
inline constexpr OUString HID_FUNC_RGP = u"SC_HID_FUNC_RGP"_ustr;
inline constexpr OUString HID_FUNC_RKP = u"SC_HID_FUNC_RKP"_ustr;
inline constexpr OUString HID_FUNC_TREND = u"SC_HID_FUNC_TREND"_ustr;
inline constexpr OUString HID_FUNC_VARIATION = u"SC_HID_FUNC_VARIATION"_ustr;

inline constexpr OUString HID_FUNC_ANZAHL = u"SC_HID_FUNC_ANZAHL"_ustr;
inline constexpr OUString HID_FUNC_ANZAHL2 = u"SC_HID_FUNC_ANZAHL2"_ustr;
inline constexpr OUString HID_FUNC_MAX = u"SC_HID_FUNC_MAX"_ustr;
inline constexpr OUString HID_FUNC_MIN = u"SC_HID_FUNC_MIN"_ustr;
inline constexpr OUString HID_FUNC_VARIANZ = u"SC_HID_FUNC_VARIANZ"_ustr;
inline constexpr OUString HID_FUNC_VARIANZEN = u"SC_HID_FUNC_VARIANZEN"_ustr;
inline constexpr OUString HID_FUNC_STABW = u"SC_HID_FUNC_STABW"_ustr;
inline constexpr OUString HID_FUNC_STABWN = u"SC_HID_FUNC_STABWN"_ustr;
inline constexpr OUString HID_FUNC_MITTELWERT = u"SC_HID_FUNC_MITTELWERT"_ustr;
inline constexpr OUString HID_FUNC_SUMQUADABW = u"SC_HID_FUNC_SUMQUADABW"_ustr;
inline constexpr OUString HID_FUNC_MITTELABW = u"SC_HID_FUNC_MITTELABW"_ustr;
inline constexpr OUString HID_FUNC_SCHIEFE = u"SC_HID_FUNC_SCHIEFE"_ustr;
inline constexpr OUString HID_FUNC_SKEWP = u"SC_HID_FUNC_SKEWP"_ustr;
inline constexpr OUString HID_FUNC_KURT = u"SC_HID_FUNC_KURT"_ustr;
inline constexpr OUString HID_FUNC_GEOMITTEL = u"SC_HID_FUNC_GEOMITTEL"_ustr;
inline constexpr OUString HID_FUNC_HARMITTEL = u"SC_HID_FUNC_HARMITTEL"_ustr;
inline constexpr OUString HID_FUNC_MODALWERT = u"SC_HID_FUNC_MODALWERT"_ustr;
inline constexpr OUString HID_FUNC_MEDIAN = u"SC_HID_FUNC_MEDIAN"_ustr;
inline constexpr OUString HID_FUNC_QUANTIL = u"SC_HID_FUNC_QUANTIL"_ustr;
inline constexpr OUString HID_FUNC_QUARTILE = u"SC_HID_FUNC_QUARTILE"_ustr;
inline constexpr OUString HID_FUNC_KGROESSTE = u"SC_HID_FUNC_KGROESSTE"_ustr;
inline constexpr OUString HID_FUNC_KKLEINSTE = u"SC_HID_FUNC_KKLEINSTE"_ustr;
inline constexpr OUString HID_FUNC_QUANTILSRANG = u"SC_HID_FUNC_QUANTILSRANG"_ustr;
inline constexpr OUString HID_FUNC_RANG = u"SC_HID_FUNC_RANG"_ustr;
inline constexpr OUString HID_FUNC_GESTUTZTMITTEL = u"SC_HID_FUNC_GESTUTZTMITTEL"_ustr;
inline constexpr OUString HID_FUNC_WAHRSCHBEREICH = u"SC_HID_FUNC_WAHRSCHBEREICH"_ustr;
inline constexpr OUString HID_FUNC_B = u"SC_HID_FUNC_B"_ustr;
inline constexpr OUString HID_FUNC_PHI = u"SC_HID_FUNC_PHI"_ustr;
inline constexpr OUString HID_FUNC_GAUSS = u"SC_HID_FUNC_GAUSS"_ustr;
inline constexpr OUString HID_FUNC_FISHER = u"SC_HID_FUNC_FISHER"_ustr;
inline constexpr OUString HID_FUNC_FISHERINV = u"SC_HID_FUNC_FISHERINV"_ustr;
inline constexpr OUString HID_FUNC_BINOMVERT = u"SC_HID_FUNC_BINOMVERT"_ustr;
inline constexpr OUString HID_FUNC_NEGBINOMVERT = u"SC_HID_FUNC_NEGBINOMVERT"_ustr;
inline constexpr OUString HID_FUNC_KRITBINOM = u"SC_HID_FUNC_KRITBINOM"_ustr;
inline constexpr OUString HID_FUNC_POISSON = u"SC_HID_FUNC_POISSON"_ustr;
inline constexpr OUString HID_FUNC_NORMVERT = u"SC_HID_FUNC_NORMVERT"_ustr;
inline constexpr OUString HID_FUNC_NORMINV = u"SC_HID_FUNC_NORMINV"_ustr;
inline constexpr OUString HID_FUNC_STANDNORMVERT = u"SC_HID_FUNC_STANDNORMVERT"_ustr;
inline constexpr OUString HID_FUNC_STANDNORMINV = u"SC_HID_FUNC_STANDNORMINV"_ustr;
inline constexpr OUString HID_FUNC_LOGNORMVERT = u"SC_HID_FUNC_LOGNORMVERT"_ustr;
inline constexpr OUString HID_FUNC_LOGINV = u"SC_HID_FUNC_LOGINV"_ustr;
inline constexpr OUString HID_FUNC_EXPONVERT = u"SC_HID_FUNC_EXPONVERT"_ustr;
inline constexpr OUString HID_FUNC_GAMMAVERT = u"SC_HID_FUNC_GAMMAVERT"_ustr;
inline constexpr OUString HID_FUNC_GAMMAINV = u"SC_HID_FUNC_GAMMAINV"_ustr;
inline constexpr OUString HID_FUNC_GAMMALN = u"SC_HID_FUNC_GAMMALN"_ustr;
inline constexpr OUString HID_FUNC_BETAVERT = u"SC_HID_FUNC_BETAVERT"_ustr;
inline constexpr OUString HID_FUNC_BETAINV = u"SC_HID_FUNC_BETAINV"_ustr;
inline constexpr OUString HID_FUNC_WEIBULL = u"SC_HID_FUNC_WEIBULL"_ustr;
inline constexpr OUString HID_FUNC_HYPGEOMVERT = u"SC_HID_FUNC_HYPGEOMVERT"_ustr;
inline constexpr OUString HID_FUNC_TVERT = u"SC_HID_FUNC_TVERT"_ustr;
inline constexpr OUString HID_FUNC_TINV = u"SC_HID_FUNC_TINV"_ustr;
inline constexpr OUString HID_FUNC_FVERT = u"SC_HID_FUNC_FVERT"_ustr;
inline constexpr OUString HID_FUNC_FINV = u"SC_HID_FUNC_FINV"_ustr;
inline constexpr OUString HID_FUNC_CHIVERT = u"SC_HID_FUNC_CHIVERT"_ustr;
inline constexpr OUString HID_FUNC_CHIINV = u"SC_HID_FUNC_CHIINV"_ustr;
inline constexpr OUString HID_FUNC_STANDARDISIERUNG = u"SC_HID_FUNC_STANDARDISIERUNG"_ustr;
inline constexpr OUString HID_FUNC_VARIATIONEN = u"SC_HID_FUNC_VARIATIONEN"_ustr;
inline constexpr OUString HID_FUNC_VARIATIONEN2 = u"SC_HID_FUNC_VARIATIONEN2"_ustr;
inline constexpr OUString HID_FUNC_KONFIDENZ = u"SC_HID_FUNC_KONFIDENZ"_ustr;
inline constexpr OUString HID_FUNC_GTEST = u"SC_HID_FUNC_GTEST"_ustr;
inline constexpr OUString HID_FUNC_CHITEST = u"SC_HID_FUNC_CHITEST"_ustr;
inline constexpr OUString HID_FUNC_FTEST = u"SC_HID_FUNC_FTEST"_ustr;
inline constexpr OUString HID_FUNC_TTEST = u"SC_HID_FUNC_TTEST"_ustr;
inline constexpr OUString HID_FUNC_BESTIMMTHEITSMASS = u"SC_HID_FUNC_BESTIMMTHEITSMASS"_ustr;
inline constexpr OUString HID_FUNC_ACHSENABSCHNITT = u"SC_HID_FUNC_ACHSENABSCHNITT"_ustr;
inline constexpr OUString HID_FUNC_STEIGUNG = u"SC_HID_FUNC_STEIGUNG"_ustr;
inline constexpr OUString HID_FUNC_STFEHLERYX = u"SC_HID_FUNC_STFEHLERYX"_ustr;
inline constexpr OUString HID_FUNC_PEARSON = u"SC_HID_FUNC_PEARSON"_ustr;
inline constexpr OUString HID_FUNC_KORREL = u"SC_HID_FUNC_KORREL"_ustr;
inline constexpr OUString HID_FUNC_KOVAR = u"SC_HID_FUNC_KOVAR"_ustr;
inline constexpr OUString HID_FUNC_SCHAETZER = u"SC_HID_FUNC_SCHAETZER"_ustr;
inline constexpr OUString HID_FUNC_MINA = u"SC_HID_FUNC_MINA"_ustr;
inline constexpr OUString HID_FUNC_MAXA = u"SC_HID_FUNC_MAXA"_ustr;
inline constexpr OUString HID_FUNC_MITTELWERTA = u"SC_HID_FUNC_MITTELWERTA"_ustr;
inline constexpr OUString HID_FUNC_STABWA = u"SC_HID_FUNC_STABWA"_ustr;
inline constexpr OUString HID_FUNC_STABWNA = u"SC_HID_FUNC_STABWNA"_ustr;
inline constexpr OUString HID_FUNC_VARIANZA = u"SC_HID_FUNC_VARIANZA"_ustr;
inline constexpr OUString HID_FUNC_VARIANZENA = u"SC_HID_FUNC_VARIANZENA"_ustr;
inline constexpr OUString HID_FUNC_CHISQDIST = u"SC_HID_FUNC_CHISQDIST"_ustr;
inline constexpr OUString HID_FUNC_CHISQINV = u"SC_HID_FUNC_CHISQINV"_ustr;
inline constexpr OUString HID_FUNC_GAMMA = u"SC_HID_FUNC_GAMMA"_ustr;

inline constexpr OUString HID_FUNC_ADRESSE = u"SC_HID_FUNC_ADRESSE"_ustr;
inline constexpr OUString HID_FUNC_BEREICHE = u"SC_HID_FUNC_BEREICHE"_ustr;
inline constexpr OUString HID_FUNC_WAHL = u"SC_HID_FUNC_WAHL"_ustr;
inline constexpr OUString HID_FUNC_SPALTE = u"SC_HID_FUNC_SPALTE"_ustr;
inline constexpr OUString HID_FUNC_ZEILE = u"SC_HID_FUNC_ZEILE"_ustr;
inline constexpr OUString HID_FUNC_SPALTEN = u"SC_HID_FUNC_SPALTEN"_ustr;
inline constexpr OUString HID_FUNC_ZEILEN = u"SC_HID_FUNC_ZEILEN"_ustr;
inline constexpr OUString HID_FUNC_WVERWEIS = u"SC_HID_FUNC_WVERWEIS"_ustr;
inline constexpr OUString HID_FUNC_SVERWEIS = u"SC_HID_FUNC_SVERWEIS"_ustr;
inline constexpr OUString HID_FUNC_INDEX = u"SC_HID_FUNC_INDEX"_ustr;
inline constexpr OUString HID_FUNC_INDIREKT = u"SC_HID_FUNC_INDIREKT"_ustr;
inline constexpr OUString HID_FUNC_VERWEIS = u"SC_HID_FUNC_VERWEIS"_ustr;
inline constexpr OUString HID_FUNC_VERGLEICH = u"SC_HID_FUNC_VERGLEICH"_ustr;
inline constexpr OUString HID_FUNC_VERSCHIEBUNG = u"SC_HID_FUNC_VERSCHIEBUNG"_ustr;
inline constexpr OUString HID_FUNC_FEHLERTYP = u"SC_HID_FUNC_FEHLERTYP"_ustr;
inline constexpr OUString HID_FUNC_VORLAGE = u"SC_HID_FUNC_VORLAGE"_ustr;
inline constexpr OUString HID_FUNC_DDE = u"SC_HID_FUNC_DDE"_ustr;
inline constexpr OUString HID_FUNC_TABELLE = u"SC_HID_FUNC_TABELLE"_ustr;
inline constexpr OUString HID_FUNC_TABELLEN = u"SC_HID_FUNC_TABELLEN"_ustr;
inline constexpr OUString HID_FUNC_HYPERLINK = u"SC_HID_FUNC_HYPERLINK"_ustr;
inline constexpr OUString HID_FUNC_GETPIVOTDATA = u"SC_HID_FUNC_GETPIVOTDATA"_ustr;

inline constexpr OUString HID_FUNC_CODE = u"SC_HID_FUNC_CODE"_ustr;
inline constexpr OUString HID_FUNC_DM = u"SC_HID_FUNC_DM"_ustr;
inline constexpr OUString HID_FUNC_ZEICHEN = u"SC_HID_FUNC_ZEICHEN"_ustr;
inline constexpr OUString HID_FUNC_SAEUBERN = u"SC_HID_FUNC_SAEUBERN"_ustr;
inline constexpr OUString HID_FUNC_VERKETTEN = u"SC_HID_FUNC_VERKETTEN"_ustr;
inline constexpr OUString HID_FUNC_IDENTISCH = u"SC_HID_FUNC_IDENTISCH"_ustr;
inline constexpr OUString HID_FUNC_FINDEN = u"SC_HID_FUNC_FINDEN"_ustr;
inline constexpr OUString HID_FUNC_SUCHEN = u"SC_HID_FUNC_SUCHEN"_ustr;
inline constexpr OUString HID_FUNC_GLAETTEN = u"SC_HID_FUNC_GLAETTEN"_ustr;
inline constexpr OUString HID_FUNC_GROSS2 = u"SC_HID_FUNC_GROSS2"_ustr;
inline constexpr OUString HID_FUNC_GROSS = u"SC_HID_FUNC_GROSS"_ustr;
inline constexpr OUString HID_FUNC_KLEIN = u"SC_HID_FUNC_KLEIN"_ustr;
inline constexpr OUString HID_FUNC_VALUE = u"SC_HID_FUNC_VALUE"_ustr;
inline constexpr OUString HID_FUNC_TEXT = u"SC_HID_FUNC_TEXT"_ustr;
inline constexpr OUString HID_FUNC_T = u"SC_HID_FUNC_T"_ustr;
inline constexpr OUString HID_FUNC_ERSETZEN = u"SC_HID_FUNC_ERSETZEN"_ustr;
inline constexpr OUString HID_FUNC_FEST = u"SC_HID_FUNC_FEST"_ustr;
inline constexpr OUString HID_FUNC_LAENGE = u"SC_HID_FUNC_LAENGE"_ustr;
inline constexpr OUString HID_FUNC_LINKS = u"SC_HID_FUNC_LINKS"_ustr;
inline constexpr OUString HID_FUNC_RECHTS = u"SC_HID_FUNC_RECHTS"_ustr;
inline constexpr OUString HID_FUNC_TEIL = u"SC_HID_FUNC_TEIL"_ustr;
inline constexpr OUString HID_FUNC_LENB = u"SC_HID_FUNC_LENB"_ustr;
inline constexpr OUString HID_FUNC_RIGHTB = u"SC_HID_FUNC_RIGHTB"_ustr;
inline constexpr OUString HID_FUNC_LEFTB = u"SC_HID_FUNC_LEFTB"_ustr;
inline constexpr OUString HID_FUNC_MIDB = u"SC_HID_FUNC_MIDB"_ustr;
inline constexpr OUString HID_FUNC_WIEDERHOLEN = u"SC_HID_FUNC_WIEDERHOLEN"_ustr;
inline constexpr OUString HID_FUNC_WECHSELN = u"SC_HID_FUNC_WECHSELN"_ustr;
inline constexpr OUString HID_FUNC_BASIS = u"SC_HID_FUNC_BASIS"_ustr;
inline constexpr OUString HID_FUNC_DEZIMAL = u"SC_HID_FUNC_DEZIMAL"_ustr;
inline constexpr OUString HID_FUNC_ROEMISCH = u"SC_HID_FUNC_ROEMISCH"_ustr;
inline constexpr OUString HID_FUNC_ARABISCH = u"SC_HID_FUNC_ARABISCH"_ustr;
inline constexpr OUString HID_FUNC_BAHTTEXT = u"SC_HID_FUNC_BAHTTEXT"_ustr;
inline constexpr OUString HID_FUNC_JIS = u"SC_HID_FUNC_JIS"_ustr;
inline constexpr OUString HID_FUNC_ASC = u"SC_HID_FUNC_ASC"_ustr;
inline constexpr OUString HID_FUNC_UNICODE = u"SC_HID_FUNC_UNICODE"_ustr;
inline constexpr OUString HID_FUNC_UNICHAR = u"SC_HID_FUNC_UNICHAR"_ustr;
inline constexpr OUString HID_FUNC_NUMBERVALUE = u"SC_HID_FUNC_NUMBERVALUE"_ustr;
inline constexpr OUString HID_FUNC_BITAND = u"SC_HID_FUNC_BITAND"_ustr;
inline constexpr OUString HID_FUNC_BITOR = u"SC_HID_FUNC_BITOR"_ustr;
inline constexpr OUString HID_FUNC_BITXOR = u"SC_HID_FUNC_BITXOR"_ustr;
inline constexpr OUString HID_FUNC_BITLSHIFT = u"SC_HID_FUNC_BITLSHIFT"_ustr;
inline constexpr OUString HID_FUNC_BITRSHIFT = u"SC_HID_FUNC_BITRSHIFT"_ustr;
inline constexpr OUString HID_FUNC_FILTERXML = u"SC_HID_FUNC_FILTERXML"_ustr;
inline constexpr OUString HID_FUNC_WEBSERVICE = u"SC_HID_FUNC_WEBSERVICE"_ustr;
inline constexpr OUString HID_FUNC_ENCODEURL = u"SC_HID_FUNC_ENCODEURL"_ustr;
inline constexpr OUString HID_FUNC_COLOR = u"SC_HID_FUNC_COLOR"_ustr;
inline constexpr OUString HID_FUNC_COVARIANCE_P = u"SC_HID_FUNC_COVARIANCE_P"_ustr;
inline constexpr OUString HID_FUNC_COVARIANCE_S = u"SC_HID_FUNC_COVARIANCE_S"_ustr;
inline constexpr OUString HID_FUNC_ST_DEV_P_MS = u"SC_HID_FUNC_ST_DEV_P_MS"_ustr;
inline constexpr OUString HID_FUNC_ST_DEV_S = u"SC_HID_FUNC_ST_DEV_S"_ustr;
inline constexpr OUString HID_FUNC_VAR_P_MS = u"SC_HID_FUNC_VAR_P_MS"_ustr;
inline constexpr OUString HID_FUNC_VAR_S = u"SC_HID_FUNC_VAR_S"_ustr;
inline constexpr OUString HID_FUNC_BETADIST_MS = u"SC_HID_FUNC_BETADIST_MS"_ustr;
inline constexpr OUString HID_FUNC_BETAINV_MS = u"SC_HID_FUNC_BETAINV_MS"_ustr;
inline constexpr OUString HID_FUNC_BINOM_DIST_MS = u"SC_HID_FUNC_BINOM_DIST_MS"_ustr;
inline constexpr OUString HID_FUNC_BINOM_INV_MS = u"SC_HID_FUNC_BINOM_INV_MS"_ustr;
inline constexpr OUString HID_FUNC_CHIINV_MS = u"SC_HID_FUNC_CHIINV_MS"_ustr;
inline constexpr OUString HID_FUNC_CHIVERT_MS = u"SC_HID_FUNC_CHIVERT_MS"_ustr;
inline constexpr OUString HID_FUNC_CHITEST_MS = u"SC_HID_FUNC_CHITEST_MS"_ustr;
inline constexpr OUString HID_FUNC_CHISQDIST_MS = u"SC_HID_FUNC_CHISQDIST_MS"_ustr;
inline constexpr OUString HID_FUNC_CHISQINV_MS = u"SC_HID_FUNC_CHISQINV_MS"_ustr;
inline constexpr OUString HID_FUNC_CONFIDENCE_N = u"SC_HID_FUNC_CONFIDENCE_N"_ustr;
inline constexpr OUString HID_FUNC_CONFIDENCE_T = u"SC_HID_FUNC_CONFIDENCE_T"_ustr;
inline constexpr OUString HID_FUNC_F_DIST_LT = u"SC_HID_FUNC_F_DIST_LT"_ustr;
inline constexpr OUString HID_FUNC_F_DIST_RT = u"SC_HID_FUNC_F_DIST_RT"_ustr;
inline constexpr OUString HID_FUNC_F_INV_LT = u"SC_HID_FUNC_F_INV_LT"_ustr;
inline constexpr OUString HID_FUNC_F_INV_RT = u"SC_HID_FUNC_F_INV_RT"_ustr;
inline constexpr OUString HID_FUNC_F_TEST_MS = u"SC_HID_FUNC_F_TEST_MS"_ustr;
inline constexpr OUString HID_FUNC_EXP_DIST_MS = u"SC_HID_FUNC_EXP_DIST_MS"_ustr;
inline constexpr OUString HID_FUNC_HYP_GEOM_DIST_MS = u"SC_HID_FUNC_HYP_GEOM_DIST_MS"_ustr;
inline constexpr OUString HID_FUNC_POISSON_DIST_MS = u"SC_HID_FUNC_POISSON_DIST_MS"_ustr;
inline constexpr OUString HID_FUNC_WEIBULL_DIST_MS = u"SC_HID_FUNC_WEIBULL_DIST_MS"_ustr;
inline constexpr OUString HID_FUNC_GAMMADIST_MS = u"SC_HID_FUNC_GAMMADIST_MS"_ustr;
inline constexpr OUString HID_FUNC_GAMMAINV_MS = u"SC_HID_FUNC_GAMMAINV_MS"_ustr;
inline constexpr OUString HID_FUNC_GAMMALN_MS = u"SC_HID_FUNC_GAMMALN_MS"_ustr;
inline constexpr OUString HID_FUNC_LOGNORMDIST_MS = u"SC_HID_FUNC_LOGNORMDIST_MS"_ustr;
inline constexpr OUString HID_FUNC_NORMDIST_MS = u"SC_HID_FUNC_NORMDIST_MS"_ustr;
inline constexpr OUString HID_FUNC_NORMINV_MS = u"SC_HID_FUNC_NORMINV_MS"_ustr;
inline constexpr OUString HID_FUNC_STD_NORMDIST_MS = u"SC_HID_FUNC_STD_NORMDIST_MS"_ustr;
inline constexpr OUString HID_FUNC_STD_NORMINV_MS = u"SC_HID_FUNC_STD_NORMINV_MS"_ustr;
inline constexpr OUString HID_FUNC_TDIST_2T = u"SC_HID_FUNC_TDIST_2T"_ustr;
inline constexpr OUString HID_FUNC_TDIST_MS = u"SC_HID_FUNC_TDIST_MS"_ustr;
inline constexpr OUString HID_FUNC_TDIST_RT = u"SC_HID_FUNC_TDIST_RT"_ustr;
inline constexpr OUString HID_FUNC_TINV_2T = u"SC_HID_FUNC_TINV_2T"_ustr;
inline constexpr OUString HID_FUNC_TINV_MS = u"SC_HID_FUNC_TINV_MS"_ustr;
inline constexpr OUString HID_FUNC_TTEST_MS = u"SC_HID_FUNC_TTEST_MS"_ustr;
inline constexpr OUString HID_FUNC_PERCENTILE_EXC = u"SC_HID_FUNC_PERCENTILE_EXC"_ustr;
inline constexpr OUString HID_FUNC_PERCENTILE_INC = u"SC_HID_FUNC_PERCENTILE_INC"_ustr;
inline constexpr OUString HID_FUNC_PERCENTRANK_EXC = u"SC_HID_FUNC_PERCENTRANK_EXC"_ustr;
inline constexpr OUString HID_FUNC_PERCENTRANK_INC = u"SC_HID_FUNC_PERCENTRANK_INC"_ustr;
inline constexpr OUString HID_FUNC_QUARTILE_INC = u"SC_HID_FUNC_QUARTILE_INC"_ustr;
inline constexpr OUString HID_FUNC_QUARTILE_EXC = u"SC_HID_FUNC_QUARTILE_EXC"_ustr;
inline constexpr OUString HID_FUNC_RANK_EQ = u"SC_HID_FUNC_RANK_EQ"_ustr;
inline constexpr OUString HID_FUNC_RANK_AVG = u"SC_HID_FUNC_RANK_AVG"_ustr;
inline constexpr OUString HID_FUNC_MODAL_VALUE_MS = u"SC_HID_FUNC_MODAL_VALUE_MS"_ustr;
inline constexpr OUString HID_FUNC_MODAL_VALUE_MULTI = u"SC_HID_FUNC_MODAL_VALUE_MULTI"_ustr;
inline constexpr OUString HID_FUNC_NEGBINOMDIST_MS = u"SC_HID_FUNC_NEGBINOMDIST_MS"_ustr;
inline constexpr OUString HID_FUNC_Z_TEST_MS = u"SC_HID_FUNC_Z_TEST_MS"_ustr;
inline constexpr OUString HID_FUNC_CEIL_MS = u"SC_HID_FUNC_CEIL_MS"_ustr;
inline constexpr OUString HID_FUNC_CEIL_PRECISE = u"SC_HID_FUNC_CEIL_PRECISE"_ustr;
inline constexpr OUString HID_FUNC_CEIL_ISO = u"SC_HID_FUNC_CEIL_ISO"_ustr;
inline constexpr OUString HID_FUNC_FLOOR_MS = u"SC_HID_FUNC_FLOOR_MS"_ustr;
inline constexpr OUString HID_FUNC_NETWORKDAYS = u"SC_HID_FUNC_NETWORKDAYS"_ustr;
inline constexpr OUString HID_FUNC_NETWORKDAYS_MS = u"SC_HID_FUNC_NETWORKDAYS_MS"_ustr;
inline constexpr OUString HID_FUNC_WORKDAY_MS = u"SC_HID_FUNC_WORKDAY_MS"_ustr;
inline constexpr OUString HID_FUNC_ERF_MS = u"SC_HID_FUNC_ERF_MS"_ustr;
inline constexpr OUString HID_FUNC_ERFC_MS = u"SC_HID_FUNC_ERFC_MS"_ustr;
inline constexpr OUString HID_FUNC_AGGREGATE = u"SC_HID_FUNC_AGGREGATE"_ustr;
inline constexpr OUString HID_FUNC_ERROR_TYPE_ODF = u"SC_HID_FUNC_ERROR_TYPE_ODF"_ustr;
inline constexpr OUString HID_FUNC_CEIL_MATH = u"SC_HID_FUNC_CEIL_MATH"_ustr;
inline constexpr OUString HID_FUNC_FLOOR_MATH = u"SC_HID_FUNC_FLOOR_MATH"_ustr;
inline constexpr OUString HID_FUNC_FLOOR_PRECISE = u"SC_HID_FUNC_FLOOR_PRECISE"_ustr;
inline constexpr OUString HID_FUNC_RAWSUBTRACT = u"SC_HID_FUNC_RAWSUBTRACT"_ustr;
inline constexpr OUString HID_FUNC_WEEKNUM_OOO = u"SC_HID_FUNC_WEEKNUM_OOO"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_ADD = u"SC_HID_FUNC_FORECAST_ETS_ADD"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_MUL = u"SC_HID_FUNC_FORECAST_ETS_MUL"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_PIA = u"SC_HID_FUNC_FORECAST_ETS_PIA"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_PIM = u"SC_HID_FUNC_FORECAST_ETS_PIM"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_SEA = u"SC_HID_FUNC_FORECAST_ETS_SEA"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_STA = u"SC_HID_FUNC_FORECAST_ETS_STA"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_ETS_STM = u"SC_HID_FUNC_FORECAST_ETS_STM"_ustr;
inline constexpr OUString HID_FUNC_FORECAST_LIN = u"SC_HID_FUNC_FORECAST_LIN"_ustr;
inline constexpr OUString HID_FUNC_CONCAT_MS = u"SC_HID_FUNC_CONCAT_MS"_ustr;
inline constexpr OUString HID_FUNC_TEXTJOIN_MS = u"SC_HID_FUNC_TEXTJOIN_MS"_ustr;
inline constexpr OUString HID_FUNC_IFS_MS = u"SC_HID_FUNC_IFS_MS"_ustr;
inline constexpr OUString HID_FUNC_SWITCH_MS = u"SC_HID_FUNC_SWITCH_MS"_ustr;
inline constexpr OUString HID_FUNC_MINIFS_MS = u"SC_HID_FUNC_MINIFS_MS"_ustr;
inline constexpr OUString HID_FUNC_MAXIFS_MS = u"SC_HID_FUNC_MAXIFS_MS"_ustr;
inline constexpr OUString HID_FUNC_ROUNDSIG = u"SC_HID_FUNC_ROUNDSIG"_ustr;
inline constexpr OUString HID_FUNC_REPLACEB = u"SC_HID_FUNC_REPLACEB"_ustr;
inline constexpr OUString HID_FUNC_FINDB = u"SC_HID_FUNC_FINDB"_ustr;
inline constexpr OUString HID_FUNC_SEARCHB = u"SC_HID_FUNC_SEARCHB"_ustr;
inline constexpr OUString HID_FUNC_REGEX = u"SC_HID_FUNC_REGEX"_ustr;
inline constexpr OUString HID_FUNC_FOURIER = u"SC_HID_FUNC_FOURIER"_ustr;
inline constexpr OUString HID_FUNC_RAND_NV = u"SC_HID_FUNC_RAND_NV"_ustr;
inline constexpr OUString HID_FUNC_RANDBETWEEN_NV = u"SC_HID_FUNC_RANDBETWEEN_NV"_ustr;
inline constexpr OUString HID_FUNC_RANDARRAY_MS = u"SC_HID_FUNC_RANDARRAY_MS"_ustr;
inline constexpr OUString HID_FUNC_XLOOKUP_MS = u"SC_HID_FUNC_XLOOKUP_MS"_ustr;
inline constexpr OUString HID_FUNC_XMATCH_MS = u"SC_HID_FUNC_XMATCH_MS"_ustr;
inline constexpr OUString HID_FUNC_FILTER_MS = u"SC_HID_FUNC_FILTER_MS"_ustr;
inline constexpr OUString HID_FUNC_SORT_MS = u"SC_HID_FUNC_SORT_MS"_ustr;
inline constexpr OUString HID_FUNC_SORTBY_MS = u"SC_HID_FUNC_SORTBY_MS"_ustr;
inline constexpr OUString HID_FUNC_CHOOSECOLS_MS = u"SC_HID_FUNC_CHOOSECOLS_MS"_ustr;
inline constexpr OUString HID_FUNC_CHOOSEROWS_MS = u"SC_HID_FUNC_CHOOSEROWS_MS"_ustr;
inline constexpr OUString HID_FUNC_DROP_MS = u"SC_HID_FUNC_DROP_MS"_ustr;
inline constexpr OUString HID_FUNC_EXPAND_MS = u"SC_HID_FUNC_EXPAND_MS"_ustr;
inline constexpr OUString HID_FUNC_HSTACK_MS = u"SC_HID_FUNC_HSTACK_MS"_ustr;
inline constexpr OUString HID_FUNC_VSTACK_MS = u"SC_HID_FUNC_VSTACK_MS"_ustr;
inline constexpr OUString HID_FUNC_TAKE_MS = u"SC_HID_FUNC_TAKE_MS"_ustr;
inline constexpr OUString HID_FUNC_TEXTAFTER_MS = u"SC_HID_FUNC_TEXTAFTER_MS"_ustr;
inline constexpr OUString HID_FUNC_TEXTBEFORE_MS = u"SC_HID_FUNC_TEXTBEFORE_MS"_ustr;
inline constexpr OUString HID_FUNC_TEXTSPLIT_MS = u"SC_HID_FUNC_TEXTSPLIT_MS"_ustr;
inline constexpr OUString HID_FUNC_TOCOL_MS = u"SC_HID_FUNC_TOCOL_MS"_ustr;
inline constexpr OUString HID_FUNC_TOROW_MS = u"SC_HID_FUNC_TOROW_MS"_ustr;
inline constexpr OUString HID_FUNC_UNIQUE_MS = u"SC_HID_FUNC_UNIQUE_MS"_ustr;
inline constexpr OUString HID_FUNC_LET_MS = u"SC_HID_FUNC_LET_MS"_ustr;
inline constexpr OUString HID_FUNC_WRAPCOLS_MS = u"SC_HID_FUNC_WRAPCOLS_MS"_ustr;
inline constexpr OUString HID_FUNC_WRAPROWS_MS = u"SC_HID_FUNC_WRAPROWS_MS"_ustr;

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
