/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#include <xparsmlbase.hxx>

static ::css::beans::Pair<::rtl::OUString, ::rtl::OUString>
    icustomMathmlHtmlEntitiesData[starmathdatabase::STARMATH_MATHMLHTML_ENTITY_NUMBER] = {
        // clang-format off
        { u"AElig"_ustr, u"\u00C6"_ustr },
        { u"AMP"_ustr, u"\u0026"_ustr },
        { u"Aacute"_ustr, u"\u00C1"_ustr },
        { u"Abreve"_ustr, u"\u0102"_ustr },
        { u"Acirc"_ustr, u"\u00C2"_ustr },
        { u"Acy"_ustr, u"\u0410"_ustr },
        { u"Afr"_ustr, u"\U0001D504"_ustr },
        { u"Agrave"_ustr, u"\u00C0"_ustr },
        { u"Alpha"_ustr, u"\u0391"_ustr },
        { u"Amacr"_ustr, u"\u0100"_ustr },
        { u"And"_ustr, u"\u2A53"_ustr },
        { u"Aogon"_ustr, u"\u0104"_ustr },
        { u"Aopf"_ustr, u"\U0001D538"_ustr },
        { u"ApplyFunction"_ustr, u"\u2061"_ustr },
        { u"Aring"_ustr, u"\u00C5"_ustr },
        { u"Ascr"_ustr, u"\U0001D49C"_ustr },
        { u"Assign"_ustr, u"\u2254"_ustr },
        { u"Atilde"_ustr, u"\u00C3"_ustr },
        { u"Auml"_ustr, u"\u00C4"_ustr },
        { u"Backslash"_ustr, u"\u2216"_ustr },
        { u"Barv"_ustr, u"\u2AE7"_ustr },
        { u"Barwed"_ustr, u"\u2306"_ustr },
        { u"Bcy"_ustr, u"\u0411"_ustr },
        { u"Because"_ustr, u"\u2235"_ustr },
        { u"Bernoullis"_ustr, u"\u212C"_ustr },
        { u"Beta"_ustr, u"\u0392"_ustr },
        { u"Bfr"_ustr, u"\U0001D505"_ustr },
        { u"Bopf"_ustr, u"\U0001D539"_ustr },
        { u"Breve"_ustr, u"\u02D8"_ustr },
        { u"Bscr"_ustr, u"\u212C"_ustr },
        { u"Bumpeq"_ustr, u"\u224E"_ustr },
        { u"CHcy"_ustr, u"\u0427"_ustr },
        { u"COPY"_ustr, u"\u00A9"_ustr },
        { u"Cacute"_ustr, u"\u0106"_ustr },
        { u"Cap"_ustr, u"\u22D2"_ustr },
        { u"CapitalDifferentialD"_ustr, u"\u2145"_ustr },
        { u"Cayleys"_ustr, u"\u212D"_ustr },
        { u"Ccaron"_ustr, u"\u010C"_ustr },
        { u"Ccedil"_ustr, u"\u00C7"_ustr },
        { u"Ccirc"_ustr, u"\u0108"_ustr },
        { u"Cconint"_ustr, u"\u2230"_ustr },
        { u"Cdot"_ustr, u"\u010A"_ustr },
        { u"Cedilla"_ustr, u"\u00B8"_ustr },
        { u"CenterDot"_ustr, u"\u00B7"_ustr },
        { u"Cfr"_ustr, u"\u212D"_ustr },
        { u"Chi"_ustr, u"\u03A7"_ustr },
        { u"CircleDot"_ustr, u"\u2299"_ustr },
        { u"CircleMinus"_ustr, u"\u2296"_ustr },
        { u"CirclePlus"_ustr, u"\u2295"_ustr },
        { u"CircleTimes"_ustr, u"\u2297"_ustr },
        { u"ClockwiseContourIntegral"_ustr, u"\u2232"_ustr },
        { u"CloseCurlyDoubleQuote"_ustr, u"\u201D"_ustr },
        { u"CloseCurlyQuote"_ustr, u"\u2019"_ustr },
        { u"Colon"_ustr, u"\u2237"_ustr },
        { u"Colone"_ustr, u"\u2A74"_ustr },
        { u"Congruent"_ustr, u"\u2261"_ustr },
        { u"Conint"_ustr, u"\u222F"_ustr },
        { u"ContourIntegral"_ustr, u"\u222E"_ustr },
        { u"Copf"_ustr, u"\u2102"_ustr },
        { u"Coproduct"_ustr, u"\u2210"_ustr },
        { u"CounterClockwiseContourIntegral"_ustr, u"\u2233"_ustr },
        { u"Cross"_ustr, u"\u2A2F"_ustr },
        { u"Cscr"_ustr, u"\U0001D49E"_ustr },
        { u"Cup"_ustr, u"\u22D3"_ustr },
        { u"CupCap"_ustr, u"\u224D"_ustr },
        { u"DD"_ustr, u"\u2145"_ustr },
        { u"DDotrahd"_ustr, u"\u2911"_ustr },
        { u"DJcy"_ustr, u"\u0402"_ustr },
        { u"DScy"_ustr, u"\u0405"_ustr },
        { u"DZcy"_ustr, u"\u040F"_ustr },
        { u"Dagger"_ustr, u"\u2021"_ustr },
        { u"Darr"_ustr, u"\u21A1"_ustr },
        { u"Dashv"_ustr, u"\u2AE4"_ustr },
        { u"Dcaron"_ustr, u"\u010E"_ustr },
        { u"Dcy"_ustr, u"\u0414"_ustr },
        { u"Del"_ustr, u"\u2207"_ustr },
        { u"Delta"_ustr, u"\u0394"_ustr },
        { u"Dfr"_ustr, u"\U0001D507"_ustr },
        { u"DiacriticalAcute"_ustr, u"\u00B4"_ustr },
        { u"DiacriticalDot"_ustr, u"\u02D9"_ustr },
        { u"DiacriticalDoubleAcute"_ustr, u"\u02DD"_ustr },
        { u"DiacriticalGrave"_ustr, u"\u0060"_ustr },
        { u"DiacriticalTilde"_ustr, u"\u02DC"_ustr },
        { u"Diamond"_ustr, u"\u22C4"_ustr },
        { u"DifferentialD"_ustr, u"\u2146"_ustr },
        { u"Dopf"_ustr, u"\U0001D53B"_ustr },
        { u"Dot"_ustr, u"\u00A8"_ustr },
        { u"DotDot"_ustr, u"\u20DC"_ustr },
        { u"DotEqual"_ustr, u"\u2250"_ustr },
        { u"DoubleContourIntegral"_ustr, u"\u222F"_ustr },
        { u"DoubleDot"_ustr, u"\u00A8"_ustr },
        { u"DoubleDownArrow"_ustr, u"\u21D3"_ustr },
        { u"DoubleLeftArrow"_ustr, u"\u21D0"_ustr },
        { u"DoubleLeftRightArrow"_ustr, u"\u21D4"_ustr },
        { u"DoubleLeftTee"_ustr, u"\u2AE4"_ustr },
        { u"DoubleLongLeftArrow"_ustr, u"\u27F8"_ustr },
        { u"DoubleLongLeftRightArrow"_ustr, u"\u27FA"_ustr },
        { u"DoubleLongRightArrow"_ustr, u"\u27F9"_ustr },
        { u"DoubleRightArrow"_ustr, u"\u21D2"_ustr },
        { u"DoubleRightTee"_ustr, u"\u22A8"_ustr },
        { u"DoubleUpArrow"_ustr, u"\u21D1"_ustr },
        { u"DoubleUpDownArrow"_ustr, u"\u21D5"_ustr },
        { u"DoubleVerticalBar"_ustr, u"\u2225"_ustr },
        { u"DownArrow"_ustr, u"\u2193"_ustr },
        { u"DownArrowBar"_ustr, u"\u2913"_ustr },
        { u"DownArrowUpArrow"_ustr, u"\u21F5"_ustr },
        { u"DownBreve"_ustr, u"\u0311"_ustr },
        { u"DownLeftRightVector"_ustr, u"\u2950"_ustr },
        { u"DownLeftTeeVector"_ustr, u"\u295E"_ustr },
        { u"DownLeftVector"_ustr, u"\u21BD"_ustr },
        { u"DownLeftVectorBar"_ustr, u"\u2956"_ustr },
        { u"DownRightTeeVector"_ustr, u"\u295F"_ustr },
        { u"DownRightVector"_ustr, u"\u21C1"_ustr },
        { u"DownRightVectorBar"_ustr, u"\u2957"_ustr },
        { u"DownTee"_ustr, u"\u22A4"_ustr },
        { u"DownTeeArrow"_ustr, u"\u21A7"_ustr },
        { u"Downarrow"_ustr, u"\u21D3"_ustr },
        { u"Dscr"_ustr, u"\U0001D49F"_ustr },
        { u"Dstrok"_ustr, u"\u0110"_ustr },
        { u"ENG"_ustr, u"\u014A"_ustr },
        { u"ETH"_ustr, u"\u00D0"_ustr },
        { u"Eacute"_ustr, u"\u00C9"_ustr },
        { u"Ecaron"_ustr, u"\u011A"_ustr },
        { u"Ecirc"_ustr, u"\u00CA"_ustr },
        { u"Ecy"_ustr, u"\u042D"_ustr },
        { u"Edot"_ustr, u"\u0116"_ustr },
        { u"Efr"_ustr, u"\U0001D508"_ustr },
        { u"Egrave"_ustr, u"\u00C8"_ustr },
        { u"Element"_ustr, u"\u2208"_ustr },
        { u"Emacr"_ustr, u"\u0112"_ustr },
        { u"EmptySmallSquare"_ustr, u"\u25FB"_ustr },
        { u"EmptyVerySmallSquare"_ustr, u"\u25AB"_ustr },
        { u"Eogon"_ustr, u"\u0118"_ustr },
        { u"Eopf"_ustr, u"\U0001D53C"_ustr },
        { u"Epsilon"_ustr, u"\u0395"_ustr },
        { u"Equal"_ustr, u"\u2A75"_ustr },
        { u"EqualTilde"_ustr, u"\u2242"_ustr },
        { u"Equilibrium"_ustr, u"\u21CC"_ustr },
        { u"Escr"_ustr, u"\u2130"_ustr },
        { u"Esim"_ustr, u"\u2A73"_ustr },
        { u"Eta"_ustr, u"\u0397"_ustr },
        { u"Euml"_ustr, u"\u00CB"_ustr },
        { u"Exists"_ustr, u"\u2203"_ustr },
        { u"ExponentialE"_ustr, u"\u2147"_ustr },
        { u"Fcy"_ustr, u"\u0424"_ustr },
        { u"Ffr"_ustr, u"\U0001D509"_ustr },
        { u"FilledSmallSquare"_ustr, u"\u25FC"_ustr },
        { u"FilledVerySmallSquare"_ustr, u"\u25AA"_ustr },
        { u"Fopf"_ustr, u"\U0001D53D"_ustr },
        { u"ForAll"_ustr, u"\u2200"_ustr },
        { u"Fouriertrf"_ustr, u"\u2131"_ustr },
        { u"Fscr"_ustr, u"\u2131"_ustr },
        { u"GJcy"_ustr, u"\u0403"_ustr },
        { u"GT"_ustr, u"\u003E"_ustr },
        { u"Gamma"_ustr, u"\u0393"_ustr },
        { u"Gammad"_ustr, u"\u03DC"_ustr },
        { u"Gbreve"_ustr, u"\u011E"_ustr },
        { u"Gcedil"_ustr, u"\u0122"_ustr },
        { u"Gcirc"_ustr, u"\u011C"_ustr },
        { u"Gcy"_ustr, u"\u0413"_ustr },
        { u"Gdot"_ustr, u"\u0120"_ustr },
        { u"Gfr"_ustr, u"\U0001D50A"_ustr },
        { u"Gg"_ustr, u"\u22D9"_ustr },
        { u"Gopf"_ustr, u"\U0001D53E"_ustr },
        { u"GreaterEqual"_ustr, u"\u2265"_ustr },
        { u"GreaterEqualLess"_ustr, u"\u22DB"_ustr },
        { u"GreaterFullEqual"_ustr, u"\u2267"_ustr },
        { u"GreaterGreater"_ustr, u"\u2AA2"_ustr },
        { u"GreaterLess"_ustr, u"\u2277"_ustr },
        { u"GreaterSlantEqual"_ustr, u"\u2A7E"_ustr },
        { u"GreaterTilde"_ustr, u"\u2273"_ustr },
        { u"Gscr"_ustr, u"\U0001D4A2"_ustr },
        { u"Gt"_ustr, u"\u226B"_ustr },
        { u"HARDcy"_ustr, u"\u042A"_ustr },
        { u"Hacek"_ustr, u"\u02C7"_ustr },
        { u"Hat"_ustr, u"\u005E"_ustr },
        { u"Hcirc"_ustr, u"\u0124"_ustr },
        { u"Hfr"_ustr, u"\u210C"_ustr },
        { u"HilbertSpace"_ustr, u"\u210B"_ustr },
        { u"Hopf"_ustr, u"\u210D"_ustr },
        { u"HorizontalLine"_ustr, u"\u2500"_ustr },
        { u"Hscr"_ustr, u"\u210B"_ustr },
        { u"Hstrok"_ustr, u"\u0126"_ustr },
        { u"HumpDownHump"_ustr, u"\u224E"_ustr },
        { u"HumpEqual"_ustr, u"\u224F"_ustr },
        { u"IEcy"_ustr, u"\u0415"_ustr },
        { u"IJlig"_ustr, u"\u0132"_ustr },
        { u"IOcy"_ustr, u"\u0401"_ustr },
        { u"Iacute"_ustr, u"\u00CD"_ustr },
        { u"Icirc"_ustr, u"\u00CE"_ustr },
        { u"Icy"_ustr, u"\u0418"_ustr },
        { u"Idot"_ustr, u"\u0130"_ustr },
        { u"Ifr"_ustr, u"\u2111"_ustr },
        { u"Igrave"_ustr, u"\u00CC"_ustr },
        { u"Im"_ustr, u"\u2111"_ustr },
        { u"Imacr"_ustr, u"\u012A"_ustr },
        { u"ImaginaryI"_ustr, u"\u2148"_ustr },
        { u"Implies"_ustr, u"\u21D2"_ustr },
        { u"Int"_ustr, u"\u222C"_ustr },
        { u"Integral"_ustr, u"\u222B"_ustr },
        { u"Intersection"_ustr, u"\u22C2"_ustr },
        { u"InvisibleComma"_ustr, u"\u2063"_ustr },
        { u"InvisibleTimes"_ustr, u"\u2062"_ustr },
        { u"Iogon"_ustr, u"\u012E"_ustr },
        { u"Iopf"_ustr, u"\U0001D540"_ustr },
        { u"Iota"_ustr, u"\u0399"_ustr },
        { u"Iscr"_ustr, u"\u2110"_ustr },
        { u"Itilde"_ustr, u"\u0128"_ustr },
        { u"Iukcy"_ustr, u"\u0406"_ustr },
        { u"Iuml"_ustr, u"\u00CF"_ustr },
        { u"Jcirc"_ustr, u"\u0134"_ustr },
        { u"Jcy"_ustr, u"\u0419"_ustr },
        { u"Jfr"_ustr, u"\U0001D50D"_ustr },
        { u"Jopf"_ustr, u"\U0001D541"_ustr },
        { u"Jscr"_ustr, u"\U0001D4A5"_ustr },
        { u"Jsercy"_ustr, u"\u0408"_ustr },
        { u"Jukcy"_ustr, u"\u0404"_ustr },
        { u"KHcy"_ustr, u"\u0425"_ustr },
        { u"KJcy"_ustr, u"\u040C"_ustr },
        { u"Kappa"_ustr, u"\u039A"_ustr },
        { u"Kcedil"_ustr, u"\u0136"_ustr },
        { u"Kcy"_ustr, u"\u041A"_ustr },
        { u"Kfr"_ustr, u"\U0001D50E"_ustr },
        { u"Kopf"_ustr, u"\U0001D542"_ustr },
        { u"Kscr"_ustr, u"\U0001D4A6"_ustr },
        { u"LJcy"_ustr, u"\u0409"_ustr },
        { u"LT"_ustr, u"\u003C"_ustr },
        { u"Lacute"_ustr, u"\u0139"_ustr },
        { u"Lambda"_ustr, u"\u039B"_ustr },
        { u"Lang"_ustr, u"\u27EA"_ustr },
        { u"Laplacetrf"_ustr, u"\u2112"_ustr },
        { u"Larr"_ustr, u"\u219E"_ustr },
        { u"Lcaron"_ustr, u"\u013D"_ustr },
        { u"Lcedil"_ustr, u"\u013B"_ustr },
        { u"Lcy"_ustr, u"\u041B"_ustr },
        { u"LeftAngleBracket"_ustr, u"\u27E8"_ustr },
        { u"LeftArrow"_ustr, u"\u2190"_ustr },
        { u"LeftArrowBar"_ustr, u"\u21E4"_ustr },
        { u"LeftArrowRightArrow"_ustr, u"\u21C6"_ustr },
        { u"LeftCeiling"_ustr, u"\u2308"_ustr },
        { u"LeftDoubleBracket"_ustr, u"\u27E6"_ustr },
        { u"LeftDownTeeVector"_ustr, u"\u2961"_ustr },
        { u"LeftDownVector"_ustr, u"\u21C3"_ustr },
        { u"LeftDownVectorBar"_ustr, u"\u2959"_ustr },
        { u"LeftFloor"_ustr, u"\u230A"_ustr },
        { u"LeftRightArrow"_ustr, u"\u2194"_ustr },
        { u"LeftRightVector"_ustr, u"\u294E"_ustr },
        { u"LeftTee"_ustr, u"\u22A3"_ustr },
        { u"LeftTeeArrow"_ustr, u"\u21A4"_ustr },
        { u"LeftTeeVector"_ustr, u"\u295A"_ustr },
        { u"LeftTriangle"_ustr, u"\u22B2"_ustr },
        { u"LeftTriangleBar"_ustr, u"\u29CF"_ustr },
        { u"LeftTriangleEqual"_ustr, u"\u22B4"_ustr },
        { u"LeftUpDownVector"_ustr, u"\u2951"_ustr },
        { u"LeftUpTeeVector"_ustr, u"\u2960"_ustr },
        { u"LeftUpVector"_ustr, u"\u21BF"_ustr },
        { u"LeftUpVectorBar"_ustr, u"\u2958"_ustr },
        { u"LeftVector"_ustr, u"\u21BC"_ustr },
        { u"LeftVectorBar"_ustr, u"\u2952"_ustr },
        { u"Leftarrow"_ustr, u"\u21D0"_ustr },
        { u"Leftrightarrow"_ustr, u"\u21D4"_ustr },
        { u"LessEqualGreater"_ustr, u"\u22DA"_ustr },
        { u"LessFullEqual"_ustr, u"\u2266"_ustr },
        { u"LessGreater"_ustr, u"\u2276"_ustr },
        { u"LessLess"_ustr, u"\u2AA1"_ustr },
        { u"LessSlantEqual"_ustr, u"\u2A7D"_ustr },
        { u"LessTilde"_ustr, u"\u2272"_ustr },
        { u"Lfr"_ustr, u"\U0001D50F"_ustr },
        { u"Ll"_ustr, u"\u22D8"_ustr },
        { u"Lleftarrow"_ustr, u"\u21DA"_ustr },
        { u"Lmidot"_ustr, u"\u013F"_ustr },
        { u"LongLeftArrow"_ustr, u"\u27F5"_ustr },
        { u"LongLeftRightArrow"_ustr, u"\u27F7"_ustr },
        { u"LongRightArrow"_ustr, u"\u27F6"_ustr },
        { u"Longleftarrow"_ustr, u"\u27F8"_ustr },
        { u"Longleftrightarrow"_ustr, u"\u27FA"_ustr },
        { u"Longrightarrow"_ustr, u"\u27F9"_ustr },
        { u"Lopf"_ustr, u"\U0001D543"_ustr },
        { u"LowerLeftArrow"_ustr, u"\u2199"_ustr },
        { u"LowerRightArrow"_ustr, u"\u2198"_ustr },
        { u"Lscr"_ustr, u"\u2112"_ustr },
        { u"Lsh"_ustr, u"\u21B0"_ustr },
        { u"Lstrok"_ustr, u"\u0141"_ustr },
        { u"Lt"_ustr, u"\u226A"_ustr },
        { u"Map"_ustr, u"\u2905"_ustr },
        { u"Mcy"_ustr, u"\u041C"_ustr },
        { u"MediumSpace"_ustr, u"\u205F"_ustr },
        { u"Mellintrf"_ustr, u"\u2133"_ustr },
        { u"Mfr"_ustr, u"\U0001D510"_ustr },
        { u"MinusPlus"_ustr, u"\u2213"_ustr },
        { u"Mopf"_ustr, u"\U0001D544"_ustr },
        { u"Mscr"_ustr, u"\u2133"_ustr },
        { u"Mu"_ustr, u"\u039C"_ustr },
        { u"NJcy"_ustr, u"\u040A"_ustr },
        { u"Nacute"_ustr, u"\u0143"_ustr },
        { u"Ncaron"_ustr, u"\u0147"_ustr },
        { u"Ncedil"_ustr, u"\u0145"_ustr },
        { u"Ncy"_ustr, u"\u041D"_ustr },
        { u"NegativeMediumSpace"_ustr, u"\u200B"_ustr },
        { u"NegativeThickSpace"_ustr, u"\u200B"_ustr },
        { u"NegativeThinSpace"_ustr, u"\u200B"_ustr },
        { u"NegativeVeryThinSpace"_ustr, u"\u200B"_ustr },
        { u"NestedGreaterGreater"_ustr, u"\u226B"_ustr },
        { u"NestedLessLess"_ustr, u"\u226A"_ustr },
        { u"NewLine"_ustr, u"\u000A"_ustr },
        { u"Nfr"_ustr, u"\U0001D511"_ustr },
        { u"NoBreak"_ustr, u"\u2060"_ustr },
        { u"NonBreakingSpace"_ustr, u"\u00A0"_ustr },
        { u"Nopf"_ustr, u"\u2115"_ustr },
        { u"Not"_ustr, u"\u2AEC"_ustr },
        { u"NotCongruent"_ustr, u"\u2262"_ustr },
        { u"NotCupCap"_ustr, u"\u226D"_ustr },
        { u"NotDoubleVerticalBar"_ustr, u"\u2226"_ustr },
        { u"NotElement"_ustr, u"\u2209"_ustr },
        { u"NotEqual"_ustr, u"\u2260"_ustr },
        { u"NotEqualTilde"_ustr, u"\u2242\u0338"_ustr },
        { u"NotExists"_ustr, u"\u2204"_ustr },
        { u"NotGreater"_ustr, u"\u226F"_ustr },
        { u"NotGreaterEqual"_ustr, u"\u2271"_ustr },
        { u"NotGreaterFullEqual"_ustr, u"\u2267\u0338"_ustr },
        { u"NotGreaterGreater"_ustr, u"\u226B\u0338"_ustr },
        { u"NotGreaterLess"_ustr, u"\u2279"_ustr },
        { u"NotGreaterSlantEqual"_ustr, u"\u2A7E\u0338"_ustr },
        { u"NotGreaterTilde"_ustr, u"\u2275"_ustr },
        { u"NotHumpDownHump"_ustr, u"\u224E\u0338"_ustr },
        { u"NotHumpEqual"_ustr, u"\u224F\u0338"_ustr },
        { u"NotLeftTriangle"_ustr, u"\u22EA"_ustr },
        { u"NotLeftTriangleBar"_ustr, u"\u29CF\u0338"_ustr },
        { u"NotLeftTriangleEqual"_ustr, u"\u22EC"_ustr },
        { u"NotLess"_ustr, u"\u226E"_ustr },
        { u"NotLessEqual"_ustr, u"\u2270"_ustr },
        { u"NotLessGreater"_ustr, u"\u2278"_ustr },
        { u"NotLessLess"_ustr, u"\u226A\u0338"_ustr },
        { u"NotLessSlantEqual"_ustr, u"\u2A7D\u0338"_ustr },
        { u"NotLessTilde"_ustr, u"\u2274"_ustr },
        { u"NotNestedGreaterGreater"_ustr, u"\u2AA2\u0338"_ustr },
        { u"NotNestedLessLess"_ustr, u"\u2AA1\u0338"_ustr },
        { u"NotPrecedes"_ustr, u"\u2280"_ustr },
        { u"NotPrecedesEqual"_ustr, u"\u2AAF\u0338"_ustr },
        { u"NotPrecedesSlantEqual"_ustr, u"\u22E0"_ustr },
        { u"NotReverseElement"_ustr, u"\u220C"_ustr },
        { u"NotRightTriangle"_ustr, u"\u22EB"_ustr },
        { u"NotRightTriangleBar"_ustr, u"\u29D0\u0338"_ustr },
        { u"NotRightTriangleEqual"_ustr, u"\u22ED"_ustr },
        { u"NotSquareSubset"_ustr, u"\u228F\u0338"_ustr },
        { u"NotSquareSubsetEqual"_ustr, u"\u22E2"_ustr },
        { u"NotSquareSuperset"_ustr, u"\u2290\u0338"_ustr },
        { u"NotSquareSupersetEqual"_ustr, u"\u22E3"_ustr },
        { u"NotSubset"_ustr, u"\u2282\u20D2"_ustr },
        { u"NotSubsetEqual"_ustr, u"\u2288"_ustr },
        { u"NotSucceeds"_ustr, u"\u2281"_ustr },
        { u"NotSucceedsEqual"_ustr, u"\u2AB0\u0338"_ustr },
        { u"NotSucceedsSlantEqual"_ustr, u"\u22E1"_ustr },
        { u"NotSucceedsTilde"_ustr, u"\u227F\u0338"_ustr },
        { u"NotSuperset"_ustr, u"\u2283\u20D2"_ustr },
        { u"NotSupersetEqual"_ustr, u"\u2289"_ustr },
        { u"NotTilde"_ustr, u"\u2241"_ustr },
        { u"NotTildeEqual"_ustr, u"\u2244"_ustr },
        { u"NotTildeFullEqual"_ustr, u"\u2247"_ustr },
        { u"NotTildeTilde"_ustr, u"\u2249"_ustr },
        { u"NotVerticalBar"_ustr, u"\u2224"_ustr },
        { u"Nscr"_ustr, u"\U0001D4A9"_ustr },
        { u"Ntilde"_ustr, u"\u00D1"_ustr },
        { u"Nu"_ustr, u"\u039D"_ustr },
        { u"OElig"_ustr, u"\u0152"_ustr },
        { u"Oacute"_ustr, u"\u00D3"_ustr },
        { u"Ocirc"_ustr, u"\u00D4"_ustr },
        { u"Ocy"_ustr, u"\u041E"_ustr },
        { u"Odblac"_ustr, u"\u0150"_ustr },
        { u"Ofr"_ustr, u"\U0001D512"_ustr },
        { u"Ograve"_ustr, u"\u00D2"_ustr },
        { u"Omacr"_ustr, u"\u014C"_ustr },
        { u"Omega"_ustr, u"\u03A9"_ustr },
        { u"Omicron"_ustr, u"\u039F"_ustr },
        { u"Oopf"_ustr, u"\U0001D546"_ustr },
        { u"OpenCurlyDoubleQuote"_ustr, u"\u201C"_ustr },
        { u"OpenCurlyQuote"_ustr, u"\u2018"_ustr },
        { u"Or"_ustr, u"\u2A54"_ustr },
        { u"Oscr"_ustr, u"\U0001D4AA"_ustr },
        { u"Oslash"_ustr, u"\u00D8"_ustr },
        { u"Otilde"_ustr, u"\u00D5"_ustr },
        { u"Otimes"_ustr, u"\u2A37"_ustr },
        { u"Ouml"_ustr, u"\u00D6"_ustr },
        { u"OverBar"_ustr, u"\u203E"_ustr },
        { u"OverBrace"_ustr, u"\u23DE"_ustr },
        { u"OverBracket"_ustr, u"\u23B4"_ustr },
        { u"OverParenthesis"_ustr, u"\u23DC"_ustr },
        { u"PartialD"_ustr, u"\u2202"_ustr },
        { u"Pcy"_ustr, u"\u041F"_ustr },
        { u"Pfr"_ustr, u"\U0001D513"_ustr },
        { u"Phi"_ustr, u"\u03A6"_ustr },
        { u"Pi"_ustr, u"\u03A0"_ustr },
        { u"PlusMinus"_ustr, u"\u00B1"_ustr },
        { u"Poincareplane"_ustr, u"\u210C"_ustr },
        { u"Popf"_ustr, u"\u2119"_ustr },
        { u"Pr"_ustr, u"\u2ABB"_ustr },
        { u"Precedes"_ustr, u"\u227A"_ustr },
        { u"PrecedesEqual"_ustr, u"\u2AAF"_ustr },
        { u"PrecedesSlantEqual"_ustr, u"\u227C"_ustr },
        { u"PrecedesTilde"_ustr, u"\u227E"_ustr },
        { u"Prime"_ustr, u"\u2033"_ustr },
        { u"Product"_ustr, u"\u220F"_ustr },
        { u"Proportion"_ustr, u"\u2237"_ustr },
        { u"Proportional"_ustr, u"\u221D"_ustr },
        { u"Pscr"_ustr, u"\U0001D4AB"_ustr },
        { u"Psi"_ustr, u"\u03A8"_ustr },
        { u"QUOT"_ustr, u"\u0022"_ustr },
        { u"Qfr"_ustr, u"\U0001D514"_ustr },
        { u"Qopf"_ustr, u"\u211A"_ustr },
        { u"Qscr"_ustr, u"\U0001D4AC"_ustr },
        { u"RBarr"_ustr, u"\u2910"_ustr },
        { u"REG"_ustr, u"\u00AE"_ustr },
        { u"Racute"_ustr, u"\u0154"_ustr },
        { u"Rang"_ustr, u"\u27EB"_ustr },
        { u"Rarr"_ustr, u"\u21A0"_ustr },
        { u"Rarrtl"_ustr, u"\u2916"_ustr },
        { u"Rcaron"_ustr, u"\u0158"_ustr },
        { u"Rcedil"_ustr, u"\u0156"_ustr },
        { u"Rcy"_ustr, u"\u0420"_ustr },
        { u"Re"_ustr, u"\u211C"_ustr },
        { u"ReverseElement"_ustr, u"\u220B"_ustr },
        { u"ReverseEquilibrium"_ustr, u"\u21CB"_ustr },
        { u"ReverseUpEquilibrium"_ustr, u"\u296F"_ustr },
        { u"Rfr"_ustr, u"\u211C"_ustr },
        { u"Rho"_ustr, u"\u03A1"_ustr },
        { u"RightAngleBracket"_ustr, u"\u27E9"_ustr },
        { u"RightArrow"_ustr, u"\u2192"_ustr },
        { u"RightArrowBar"_ustr, u"\u21E5"_ustr },
        { u"RightArrowLeftArrow"_ustr, u"\u21C4"_ustr },
        { u"RightCeiling"_ustr, u"\u2309"_ustr },
        { u"RightDoubleBracket"_ustr, u"\u27E7"_ustr },
        { u"RightDownTeeVector"_ustr, u"\u295D"_ustr },
        { u"RightDownVector"_ustr, u"\u21C2"_ustr },
        { u"RightDownVectorBar"_ustr, u"\u2955"_ustr },
        { u"RightFloor"_ustr, u"\u230B"_ustr },
        { u"RightTee"_ustr, u"\u22A2"_ustr },
        { u"RightTeeArrow"_ustr, u"\u21A6"_ustr },
        { u"RightTeeVector"_ustr, u"\u295B"_ustr },
        { u"RightTriangle"_ustr, u"\u22B3"_ustr },
        { u"RightTriangleBar"_ustr, u"\u29D0"_ustr },
        { u"RightTriangleEqual"_ustr, u"\u22B5"_ustr },
        { u"RightUpDownVector"_ustr, u"\u294F"_ustr },
        { u"RightUpTeeVector"_ustr, u"\u295C"_ustr },
        { u"RightUpVector"_ustr, u"\u21BE"_ustr },
        { u"RightUpVectorBar"_ustr, u"\u2954"_ustr },
        { u"RightVector"_ustr, u"\u21C0"_ustr },
        { u"RightVectorBar"_ustr, u"\u2953"_ustr },
        { u"Rightarrow"_ustr, u"\u21D2"_ustr },
        { u"Ropf"_ustr, u"\u211D"_ustr },
        { u"RoundImplies"_ustr, u"\u2970"_ustr },
        { u"Rrightarrow"_ustr, u"\u21DB"_ustr },
        { u"Rscr"_ustr, u"\u211B"_ustr },
        { u"Rsh"_ustr, u"\u21B1"_ustr },
        { u"RuleDelayed"_ustr, u"\u29F4"_ustr },
        { u"SHCHcy"_ustr, u"\u0429"_ustr },
        { u"SHcy"_ustr, u"\u0428"_ustr },
        { u"SOFTcy"_ustr, u"\u042C"_ustr },
        { u"Sacute"_ustr, u"\u015A"_ustr },
        { u"Sc"_ustr, u"\u2ABC"_ustr },
        { u"Scaron"_ustr, u"\u0160"_ustr },
        { u"Scedil"_ustr, u"\u015E"_ustr },
        { u"Scirc"_ustr, u"\u015C"_ustr },
        { u"Scy"_ustr, u"\u0421"_ustr },
        { u"Sfr"_ustr, u"\U0001D516"_ustr },
        { u"ShortDownArrow"_ustr, u"\u2193"_ustr },
        { u"ShortLeftArrow"_ustr, u"\u2190"_ustr },
        { u"ShortRightArrow"_ustr, u"\u2192"_ustr },
        { u"ShortUpArrow"_ustr, u"\u2191"_ustr },
        { u"Sigma"_ustr, u"\u03A3"_ustr },
        { u"SmallCircle"_ustr, u"\u2218"_ustr },
        { u"Sopf"_ustr, u"\U0001D54A"_ustr },
        { u"Sqrt"_ustr, u"\u221A"_ustr },
        { u"Square"_ustr, u"\u25A1"_ustr },
        { u"SquareIntersection"_ustr, u"\u2293"_ustr },
        { u"SquareSubset"_ustr, u"\u228F"_ustr },
        { u"SquareSubsetEqual"_ustr, u"\u2291"_ustr },
        { u"SquareSuperset"_ustr, u"\u2290"_ustr },
        { u"SquareSupersetEqual"_ustr, u"\u2292"_ustr },
        { u"SquareUnion"_ustr, u"\u2294"_ustr },
        { u"Sscr"_ustr, u"\U0001D4AE"_ustr },
        { u"Star"_ustr, u"\u22C6"_ustr },
        { u"Sub"_ustr, u"\u22D0"_ustr },
        { u"Subset"_ustr, u"\u22D0"_ustr },
        { u"SubsetEqual"_ustr, u"\u2286"_ustr },
        { u"Succeeds"_ustr, u"\u227B"_ustr },
        { u"SucceedsEqual"_ustr, u"\u2AB0"_ustr },
        { u"SucceedsSlantEqual"_ustr, u"\u227D"_ustr },
        { u"SucceedsTilde"_ustr, u"\u227F"_ustr },
        { u"SuchThat"_ustr, u"\u220B"_ustr },
        { u"Sum"_ustr, u"\u2211"_ustr },
        { u"Sup"_ustr, u"\u22D1"_ustr },
        { u"Superset"_ustr, u"\u2283"_ustr },
        { u"SupersetEqual"_ustr, u"\u2287"_ustr },
        { u"Supset"_ustr, u"\u22D1"_ustr },
        { u"THORN"_ustr, u"\u00DE"_ustr },
        { u"TRADE"_ustr, u"\u2122"_ustr },
        { u"TSHcy"_ustr, u"\u040B"_ustr },
        { u"TScy"_ustr, u"\u0426"_ustr },
        { u"Tab"_ustr, u"\u0009"_ustr },
        { u"Tau"_ustr, u"\u03A4"_ustr },
        { u"Tcaron"_ustr, u"\u0164"_ustr },
        { u"Tcedil"_ustr, u"\u0162"_ustr },
        { u"Tcy"_ustr, u"\u0422"_ustr },
        { u"Tfr"_ustr, u"\U0001D517"_ustr },
        { u"Therefore"_ustr, u"\u2234"_ustr },
        { u"Theta"_ustr, u"\u0398"_ustr },
        { u"ThickSpace"_ustr, u"\u205F\u200A"_ustr },
        { u"ThinSpace"_ustr, u"\u2009"_ustr },
        { u"Tilde"_ustr, u"\u223C"_ustr },
        { u"TildeEqual"_ustr, u"\u2243"_ustr },
        { u"TildeFullEqual"_ustr, u"\u2245"_ustr },
        { u"TildeTilde"_ustr, u"\u2248"_ustr },
        { u"Topf"_ustr, u"\U0001D54B"_ustr },
        { u"TripleDot"_ustr, u"\u20DB"_ustr },
        { u"Tscr"_ustr, u"\U0001D4AF"_ustr },
        { u"Tstrok"_ustr, u"\u0166"_ustr },
        { u"Uacute"_ustr, u"\u00DA"_ustr },
        { u"Uarr"_ustr, u"\u219F"_ustr },
        { u"Uarrocir"_ustr, u"\u2949"_ustr },
        { u"Ubrcy"_ustr, u"\u040E"_ustr },
        { u"Ubreve"_ustr, u"\u016C"_ustr },
        { u"Ucirc"_ustr, u"\u00DB"_ustr },
        { u"Ucy"_ustr, u"\u0423"_ustr },
        { u"Udblac"_ustr, u"\u0170"_ustr },
        { u"Ufr"_ustr, u"\U0001D518"_ustr },
        { u"Ugrave"_ustr, u"\u00D9"_ustr },
        { u"Umacr"_ustr, u"\u016A"_ustr },
        { u"UnderBar"_ustr, u"\u005F"_ustr },
        { u"UnderBrace"_ustr, u"\u23DF"_ustr },
        { u"UnderBracket"_ustr, u"\u23B5"_ustr },
        { u"UnderParenthesis"_ustr, u"\u23DD"_ustr },
        { u"Union"_ustr, u"\u22C3"_ustr },
        { u"UnionPlus"_ustr, u"\u228E"_ustr },
        { u"Uogon"_ustr, u"\u0172"_ustr },
        { u"Uopf"_ustr, u"\U0001D54C"_ustr },
        { u"UpArrow"_ustr, u"\u2191"_ustr },
        { u"UpArrowBar"_ustr, u"\u2912"_ustr },
        { u"UpArrowDownArrow"_ustr, u"\u21C5"_ustr },
        { u"UpDownArrow"_ustr, u"\u2195"_ustr },
        { u"UpEquilibrium"_ustr, u"\u296E"_ustr },
        { u"UpTee"_ustr, u"\u22A5"_ustr },
        { u"UpTeeArrow"_ustr, u"\u21A5"_ustr },
        { u"Uparrow"_ustr, u"\u21D1"_ustr },
        { u"Updownarrow"_ustr, u"\u21D5"_ustr },
        { u"UpperLeftArrow"_ustr, u"\u2196"_ustr },
        { u"UpperRightArrow"_ustr, u"\u2197"_ustr },
        { u"Upsi"_ustr, u"\u03D2"_ustr },
        { u"Upsilon"_ustr, u"\u03A5"_ustr },
        { u"Uring"_ustr, u"\u016E"_ustr },
        { u"Uscr"_ustr, u"\U0001D4B0"_ustr },
        { u"Utilde"_ustr, u"\u0168"_ustr },
        { u"Uuml"_ustr, u"\u00DC"_ustr },
        { u"VDash"_ustr, u"\u22AB"_ustr },
        { u"Vbar"_ustr, u"\u2AEB"_ustr },
        { u"Vcy"_ustr, u"\u0412"_ustr },
        { u"Vdash"_ustr, u"\u22A9"_ustr },
        { u"Vdashl"_ustr, u"\u2AE6"_ustr },
        { u"Vee"_ustr, u"\u22C1"_ustr },
        { u"Verbar"_ustr, u"\u2016"_ustr },
        { u"Vert"_ustr, u"\u2016"_ustr },
        { u"VerticalBar"_ustr, u"\u2223"_ustr },
        { u"VerticalLine"_ustr, u"\u007C"_ustr },
        { u"VerticalSeparator"_ustr, u"\u2758"_ustr },
        { u"VerticalTilde"_ustr, u"\u2240"_ustr },
        { u"VeryThinSpace"_ustr, u"\u200A"_ustr },
        { u"Vfr"_ustr, u"\U0001D519"_ustr },
        { u"Vopf"_ustr, u"\U0001D54D"_ustr },
        { u"Vscr"_ustr, u"\U0001D4B1"_ustr },
        { u"Vvdash"_ustr, u"\u22AA"_ustr },
        { u"Wcirc"_ustr, u"\u0174"_ustr },
        { u"Wedge"_ustr, u"\u22C0"_ustr },
        { u"Wfr"_ustr, u"\U0001D51A"_ustr },
        { u"Wopf"_ustr, u"\U0001D54E"_ustr },
        { u"Wscr"_ustr, u"\U0001D4B2"_ustr },
        { u"Xfr"_ustr, u"\U0001D51B"_ustr },
        { u"Xi"_ustr, u"\u039E"_ustr },
        { u"Xopf"_ustr, u"\U0001D54F"_ustr },
        { u"Xscr"_ustr, u"\U0001D4B3"_ustr },
        { u"YAcy"_ustr, u"\u042F"_ustr },
        { u"YIcy"_ustr, u"\u0407"_ustr },
        { u"YUcy"_ustr, u"\u042E"_ustr },
        { u"Yacute"_ustr, u"\u00DD"_ustr },
        { u"Ycirc"_ustr, u"\u0176"_ustr },
        { u"Ycy"_ustr, u"\u042B"_ustr },
        { u"Yfr"_ustr, u"\U0001D51C"_ustr },
        { u"Yopf"_ustr, u"\U0001D550"_ustr },
        { u"Yscr"_ustr, u"\U0001D4B4"_ustr },
        { u"Yuml"_ustr, u"\u0178"_ustr },
        { u"ZHcy"_ustr, u"\u0416"_ustr },
        { u"Zacute"_ustr, u"\u0179"_ustr },
        { u"Zcaron"_ustr, u"\u017D"_ustr },
        { u"Zcy"_ustr, u"\u0417"_ustr },
        { u"Zdot"_ustr, u"\u017B"_ustr },
        { u"ZeroWidthSpace"_ustr, u"\u200B"_ustr },
        { u"Zeta"_ustr, u"\u0396"_ustr },
        { u"Zfr"_ustr, u"\u2128"_ustr },
        { u"Zopf"_ustr, u"\u2124"_ustr },
        { u"Zscr"_ustr, u"\U0001D4B5"_ustr },
        { u"aacute"_ustr, u"\u00E1"_ustr },
        { u"abreve"_ustr, u"\u0103"_ustr },
        { u"ac"_ustr, u"\u223E"_ustr },
        { u"acE"_ustr, u"\u223E\u0333"_ustr },
        { u"acd"_ustr, u"\u223F"_ustr },
        { u"acirc"_ustr, u"\u00E2"_ustr },
        { u"acute"_ustr, u"\u00B4"_ustr },
        { u"acy"_ustr, u"\u0430"_ustr },
        { u"aelig"_ustr, u"\u00E6"_ustr },
        { u"af"_ustr, u"\u2061"_ustr },
        { u"afr"_ustr, u"\U0001D51E"_ustr },
        { u"agrave"_ustr, u"\u00E0"_ustr },
        { u"alefsym"_ustr, u"\u2135"_ustr },
        { u"aleph"_ustr, u"\u2135"_ustr },
        { u"alpha"_ustr, u"\u03B1"_ustr },
        { u"amacr"_ustr, u"\u0101"_ustr },
        { u"amalg"_ustr, u"\u2A3F"_ustr },
        { u"amp"_ustr, u"\u0026"_ustr },
        { u"and"_ustr, u"\u2227"_ustr },
        { u"andand"_ustr, u"\u2A55"_ustr },
        { u"andd"_ustr, u"\u2A5C"_ustr },
        { u"andslope"_ustr, u"\u2A58"_ustr },
        { u"andv"_ustr, u"\u2A5A"_ustr },
        { u"ang"_ustr, u"\u2220"_ustr },
        { u"ange"_ustr, u"\u29A4"_ustr },
        { u"angle"_ustr, u"\u2220"_ustr },
        { u"angmsd"_ustr, u"\u2221"_ustr },
        { u"angmsdaa"_ustr, u"\u29A8"_ustr },
        { u"angmsdab"_ustr, u"\u29A9"_ustr },
        { u"angmsdac"_ustr, u"\u29AA"_ustr },
        { u"angmsdad"_ustr, u"\u29AB"_ustr },
        { u"angmsdae"_ustr, u"\u29AC"_ustr },
        { u"angmsdaf"_ustr, u"\u29AD"_ustr },
        { u"angmsdag"_ustr, u"\u29AE"_ustr },
        { u"angmsdah"_ustr, u"\u29AF"_ustr },
        { u"angrt"_ustr, u"\u221F"_ustr },
        { u"angrtvb"_ustr, u"\u22BE"_ustr },
        { u"angrtvbd"_ustr, u"\u299D"_ustr },
        { u"angsph"_ustr, u"\u2222"_ustr },
        { u"angst"_ustr, u"\u00C5"_ustr },
        { u"angzarr"_ustr, u"\u237C"_ustr },
        { u"aogon"_ustr, u"\u0105"_ustr },
        { u"aopf"_ustr, u"\U0001D552"_ustr },
        { u"ap"_ustr, u"\u2248"_ustr },
        { u"apE"_ustr, u"\u2A70"_ustr },
        { u"apacir"_ustr, u"\u2A6F"_ustr },
        { u"ape"_ustr, u"\u224A"_ustr },
        { u"apid"_ustr, u"\u224B"_ustr },
        { u"apos"_ustr, u"\u0027"_ustr },
        { u"approx"_ustr, u"\u2248"_ustr },
        { u"approxeq"_ustr, u"\u224A"_ustr },
        { u"aring"_ustr, u"\u00E5"_ustr },
        { u"ascr"_ustr, u"\U0001D4B6"_ustr },
        { u"ast"_ustr, u"\u002A"_ustr },
        { u"asymp"_ustr, u"\u2248"_ustr },
        { u"asympeq"_ustr, u"\u224D"_ustr },
        { u"atilde"_ustr, u"\u00E3"_ustr },
        { u"auml"_ustr, u"\u00E4"_ustr },
        { u"awconint"_ustr, u"\u2233"_ustr },
        { u"awint"_ustr, u"\u2A11"_ustr },
        { u"bNot"_ustr, u"\u2AED"_ustr },
        { u"backcong"_ustr, u"\u224C"_ustr },
        { u"backepsilon"_ustr, u"\u03F6"_ustr },
        { u"backprime"_ustr, u"\u2035"_ustr },
        { u"backsim"_ustr, u"\u223D"_ustr },
        { u"backsimeq"_ustr, u"\u22CD"_ustr },
        { u"barvee"_ustr, u"\u22BD"_ustr },
        { u"barwed"_ustr, u"\u2305"_ustr },
        { u"barwedge"_ustr, u"\u2305"_ustr },
        { u"bbrk"_ustr, u"\u23B5"_ustr },
        { u"bbrktbrk"_ustr, u"\u23B6"_ustr },
        { u"bcong"_ustr, u"\u224C"_ustr },
        { u"bcy"_ustr, u"\u0431"_ustr },
        { u"bdquo"_ustr, u"\u201E"_ustr },
        { u"becaus"_ustr, u"\u2235"_ustr },
        { u"because"_ustr, u"\u2235"_ustr },
        { u"bemptyv"_ustr, u"\u29B0"_ustr },
        { u"bepsi"_ustr, u"\u03F6"_ustr },
        { u"bernou"_ustr, u"\u212C"_ustr },
        { u"beta"_ustr, u"\u03B2"_ustr },
        { u"beth"_ustr, u"\u2136"_ustr },
        { u"between"_ustr, u"\u226C"_ustr },
        { u"bfr"_ustr, u"\U0001D51F"_ustr },
        { u"bigcap"_ustr, u"\u22C2"_ustr },
        { u"bigcirc"_ustr, u"\u25EF"_ustr },
        { u"bigcup"_ustr, u"\u22C3"_ustr },
        { u"bigodot"_ustr, u"\u2A00"_ustr },
        { u"bigoplus"_ustr, u"\u2A01"_ustr },
        { u"bigotimes"_ustr, u"\u2A02"_ustr },
        { u"bigsqcup"_ustr, u"\u2A06"_ustr },
        { u"bigstar"_ustr, u"\u2605"_ustr },
        { u"bigtriangledown"_ustr, u"\u25BD"_ustr },
        { u"bigtriangleup"_ustr, u"\u25B3"_ustr },
        { u"biguplus"_ustr, u"\u2A04"_ustr },
        { u"bigvee"_ustr, u"\u22C1"_ustr },
        { u"bigwedge"_ustr, u"\u22C0"_ustr },
        { u"bkarow"_ustr, u"\u290D"_ustr },
        { u"blacklozenge"_ustr, u"\u29EB"_ustr },
        { u"blacksquare"_ustr, u"\u25AA"_ustr },
        { u"blacktriangle"_ustr, u"\u25B4"_ustr },
        { u"blacktriangledown"_ustr, u"\u25BE"_ustr },
        { u"blacktriangleleft"_ustr, u"\u25C2"_ustr },
        { u"blacktriangleright"_ustr, u"\u25B8"_ustr },
        { u"blank"_ustr, u"\u2423"_ustr },
        { u"blk12"_ustr, u"\u2592"_ustr },
        { u"blk14"_ustr, u"\u2591"_ustr },
        { u"blk34"_ustr, u"\u2593"_ustr },
        { u"block"_ustr, u"\u2588"_ustr },
        { u"bne"_ustr, u"\u003D\u20E5"_ustr },
        { u"bnequiv"_ustr, u"\u2261\u20E5"_ustr },
        { u"bnot"_ustr, u"\u2310"_ustr },
        { u"bopf"_ustr, u"\U0001D553"_ustr },
        { u"bot"_ustr, u"\u22A5"_ustr },
        { u"bottom"_ustr, u"\u22A5"_ustr },
        { u"bowtie"_ustr, u"\u22C8"_ustr },
        { u"boxDL"_ustr, u"\u2557"_ustr },
        { u"boxDR"_ustr, u"\u2554"_ustr },
        { u"boxDl"_ustr, u"\u2556"_ustr },
        { u"boxDr"_ustr, u"\u2553"_ustr },
        { u"boxH"_ustr, u"\u2550"_ustr },
        { u"boxHD"_ustr, u"\u2566"_ustr },
        { u"boxHU"_ustr, u"\u2569"_ustr },
        { u"boxHd"_ustr, u"\u2564"_ustr },
        { u"boxHu"_ustr, u"\u2567"_ustr },
        { u"boxUL"_ustr, u"\u255D"_ustr },
        { u"boxUR"_ustr, u"\u255A"_ustr },
        { u"boxUl"_ustr, u"\u255C"_ustr },
        { u"boxUr"_ustr, u"\u2559"_ustr },
        { u"boxV"_ustr, u"\u2551"_ustr },
        { u"boxVH"_ustr, u"\u256C"_ustr },
        { u"boxVL"_ustr, u"\u2563"_ustr },
        { u"boxVR"_ustr, u"\u2560"_ustr },
        { u"boxVh"_ustr, u"\u256B"_ustr },
        { u"boxVl"_ustr, u"\u2562"_ustr },
        { u"boxVr"_ustr, u"\u255F"_ustr },
        { u"boxbox"_ustr, u"\u29C9"_ustr },
        { u"boxdL"_ustr, u"\u2555"_ustr },
        { u"boxdR"_ustr, u"\u2552"_ustr },
        { u"boxdl"_ustr, u"\u2510"_ustr },
        { u"boxdr"_ustr, u"\u250C"_ustr },
        { u"boxh"_ustr, u"\u2500"_ustr },
        { u"boxhD"_ustr, u"\u2565"_ustr },
        { u"boxhU"_ustr, u"\u2568"_ustr },
        { u"boxhd"_ustr, u"\u252C"_ustr },
        { u"boxhu"_ustr, u"\u2534"_ustr },
        { u"boxminus"_ustr, u"\u229F"_ustr },
        { u"boxplus"_ustr, u"\u229E"_ustr },
        { u"boxtimes"_ustr, u"\u22A0"_ustr },
        { u"boxuL"_ustr, u"\u255B"_ustr },
        { u"boxuR"_ustr, u"\u2558"_ustr },
        { u"boxul"_ustr, u"\u2518"_ustr },
        { u"boxur"_ustr, u"\u2514"_ustr },
        { u"boxv"_ustr, u"\u2502"_ustr },
        { u"boxvH"_ustr, u"\u256A"_ustr },
        { u"boxvL"_ustr, u"\u2561"_ustr },
        { u"boxvR"_ustr, u"\u255E"_ustr },
        { u"boxvh"_ustr, u"\u253C"_ustr },
        { u"boxvl"_ustr, u"\u2524"_ustr },
        { u"boxvr"_ustr, u"\u251C"_ustr },
        { u"bprime"_ustr, u"\u2035"_ustr },
        { u"breve"_ustr, u"\u02D8"_ustr },
        { u"brvbar"_ustr, u"\u00A6"_ustr },
        { u"bscr"_ustr, u"\U0001D4B7"_ustr },
        { u"bsemi"_ustr, u"\u204F"_ustr },
        { u"bsim"_ustr, u"\u223D"_ustr },
        { u"bsime"_ustr, u"\u22CD"_ustr },
        { u"bsol"_ustr, u"\u005C"_ustr },
        { u"bsolb"_ustr, u"\u29C5"_ustr },
        { u"bsolhsub"_ustr, u"\u27C8"_ustr },
        { u"bull"_ustr, u"\u2022"_ustr },
        { u"bullet"_ustr, u"\u2022"_ustr },
        { u"bump"_ustr, u"\u224E"_ustr },
        { u"bumpE"_ustr, u"\u2AAE"_ustr },
        { u"bumpe"_ustr, u"\u224F"_ustr },
        { u"bumpeq"_ustr, u"\u224F"_ustr },
        { u"cacute"_ustr, u"\u0107"_ustr },
        { u"cap"_ustr, u"\u2229"_ustr },
        { u"capand"_ustr, u"\u2A44"_ustr },
        { u"capbrcup"_ustr, u"\u2A49"_ustr },
        { u"capcap"_ustr, u"\u2A4B"_ustr },
        { u"capcup"_ustr, u"\u2A47"_ustr },
        { u"capdot"_ustr, u"\u2A40"_ustr },
        { u"caps"_ustr, u"\u2229\uFE00"_ustr },
        { u"caret"_ustr, u"\u2041"_ustr },
        { u"caron"_ustr, u"\u02C7"_ustr },
        { u"ccaps"_ustr, u"\u2A4D"_ustr },
        { u"ccaron"_ustr, u"\u010D"_ustr },
        { u"ccedil"_ustr, u"\u00E7"_ustr },
        { u"ccirc"_ustr, u"\u0109"_ustr },
        { u"ccups"_ustr, u"\u2A4C"_ustr },
        { u"ccupssm"_ustr, u"\u2A50"_ustr },
        { u"cdot"_ustr, u"\u010B"_ustr },
        { u"cedil"_ustr, u"\u00B8"_ustr },
        { u"cemptyv"_ustr, u"\u29B2"_ustr },
        { u"cent"_ustr, u"\u00A2"_ustr },
        { u"centerdot"_ustr, u"\u00B7"_ustr },
        { u"cfr"_ustr, u"\U0001D520"_ustr },
        { u"chcy"_ustr, u"\u0447"_ustr },
        { u"check"_ustr, u"\u2713"_ustr },
        { u"checkmark"_ustr, u"\u2713"_ustr },
        { u"chi"_ustr, u"\u03C7"_ustr },
        { u"cir"_ustr, u"\u25CB"_ustr },
        { u"cirE"_ustr, u"\u29C3"_ustr },
        { u"circ"_ustr, u"\u02C6"_ustr },
        { u"circeq"_ustr, u"\u2257"_ustr },
        { u"circlearrowleft"_ustr, u"\u21BA"_ustr },
        { u"circlearrowright"_ustr, u"\u21BB"_ustr },
        { u"circledR"_ustr, u"\u00AE"_ustr },
        { u"circledS"_ustr, u"\u24C8"_ustr },
        { u"circledast"_ustr, u"\u229B"_ustr },
        { u"circledcirc"_ustr, u"\u229A"_ustr },
        { u"circleddash"_ustr, u"\u229D"_ustr },
        { u"cire"_ustr, u"\u2257"_ustr },
        { u"cirfnint"_ustr, u"\u2A10"_ustr },
        { u"cirmid"_ustr, u"\u2AEF"_ustr },
        { u"cirscir"_ustr, u"\u29C2"_ustr },
        { u"clubs"_ustr, u"\u2663"_ustr },
        { u"clubsuit"_ustr, u"\u2663"_ustr },
        { u"colon"_ustr, u"\u003A"_ustr },
        { u"colone"_ustr, u"\u2254"_ustr },
        { u"coloneq"_ustr, u"\u2254"_ustr },
        { u"comma"_ustr, u"\u002C"_ustr },
        { u"commat"_ustr, u"\u0040"_ustr },
        { u"comp"_ustr, u"\u2201"_ustr },
        { u"compfn"_ustr, u"\u2218"_ustr },
        { u"complement"_ustr, u"\u2201"_ustr },
        { u"complexes"_ustr, u"\u2102"_ustr },
        { u"cong"_ustr, u"\u2245"_ustr },
        { u"congdot"_ustr, u"\u2A6D"_ustr },
        { u"conint"_ustr, u"\u222E"_ustr },
        { u"copf"_ustr, u"\U0001D554"_ustr },
        { u"coprod"_ustr, u"\u2210"_ustr },
        { u"copy"_ustr, u"\u00A9"_ustr },
        { u"copysr"_ustr, u"\u2117"_ustr },
        { u"crarr"_ustr, u"\u21B5"_ustr },
        { u"cross"_ustr, u"\u2717"_ustr },
        { u"cscr"_ustr, u"\U0001D4B8"_ustr },
        { u"csub"_ustr, u"\u2ACF"_ustr },
        { u"csube"_ustr, u"\u2AD1"_ustr },
        { u"csup"_ustr, u"\u2AD0"_ustr },
        { u"csupe"_ustr, u"\u2AD2"_ustr },
        { u"ctdot"_ustr, u"\u22EF"_ustr },
        { u"cudarrl"_ustr, u"\u2938"_ustr },
        { u"cudarrr"_ustr, u"\u2935"_ustr },
        { u"cuepr"_ustr, u"\u22DE"_ustr },
        { u"cuesc"_ustr, u"\u22DF"_ustr },
        { u"cularr"_ustr, u"\u21B6"_ustr },
        { u"cularrp"_ustr, u"\u293D"_ustr },
        { u"cup"_ustr, u"\u222A"_ustr },
        { u"cupbrcap"_ustr, u"\u2A48"_ustr },
        { u"cupcap"_ustr, u"\u2A46"_ustr },
        { u"cupcup"_ustr, u"\u2A4A"_ustr },
        { u"cupdot"_ustr, u"\u228D"_ustr },
        { u"cupor"_ustr, u"\u2A45"_ustr },
        { u"cups"_ustr, u"\u222A\uFE00"_ustr },
        { u"curarr"_ustr, u"\u21B7"_ustr },
        { u"curarrm"_ustr, u"\u293C"_ustr },
        { u"curlyeqprec"_ustr, u"\u22DE"_ustr },
        { u"curlyeqsucc"_ustr, u"\u22DF"_ustr },
        { u"curlyvee"_ustr, u"\u22CE"_ustr },
        { u"curlywedge"_ustr, u"\u22CF"_ustr },
        { u"curren"_ustr, u"\u00A4"_ustr },
        { u"curvearrowleft"_ustr, u"\u21B6"_ustr },
        { u"curvearrowright"_ustr, u"\u21B7"_ustr },
        { u"cuvee"_ustr, u"\u22CE"_ustr },
        { u"cuwed"_ustr, u"\u22CF"_ustr },
        { u"cwconint"_ustr, u"\u2232"_ustr },
        { u"cwint"_ustr, u"\u2231"_ustr },
        { u"cylcty"_ustr, u"\u232D"_ustr },
        { u"dArr"_ustr, u"\u21D3"_ustr },
        { u"dHar"_ustr, u"\u2965"_ustr },
        { u"dagger"_ustr, u"\u2020"_ustr },
        { u"daleth"_ustr, u"\u2138"_ustr },
        { u"darr"_ustr, u"\u2193"_ustr },
        { u"dash"_ustr, u"\u2010"_ustr },
        { u"dashv"_ustr, u"\u22A3"_ustr },
        { u"dbkarow"_ustr, u"\u290F"_ustr },
        { u"dblac"_ustr, u"\u02DD"_ustr },
        { u"dcaron"_ustr, u"\u010F"_ustr },
        { u"dcy"_ustr, u"\u0434"_ustr },
        { u"dd"_ustr, u"\u2146"_ustr },
        { u"ddagger"_ustr, u"\u2021"_ustr },
        { u"ddarr"_ustr, u"\u21CA"_ustr },
        { u"ddotseq"_ustr, u"\u2A77"_ustr },
        { u"deg"_ustr, u"\u00B0"_ustr },
        { u"delta"_ustr, u"\u03B4"_ustr },
        { u"demptyv"_ustr, u"\u29B1"_ustr },
        { u"dfisht"_ustr, u"\u297F"_ustr },
        { u"dfr"_ustr, u"\U0001D521"_ustr },
        { u"dharl"_ustr, u"\u21C3"_ustr },
        { u"dharr"_ustr, u"\u21C2"_ustr },
        { u"diam"_ustr, u"\u22C4"_ustr },
        { u"diamond"_ustr, u"\u22C4"_ustr },
        { u"diamondsuit"_ustr, u"\u2666"_ustr },
        { u"diams"_ustr, u"\u2666"_ustr },
        { u"die"_ustr, u"\u00A8"_ustr },
        { u"digamma"_ustr, u"\u03DD"_ustr },
        { u"disin"_ustr, u"\u22F2"_ustr },
        { u"div"_ustr, u"\u00F7"_ustr },
        { u"divide"_ustr, u"\u00F7"_ustr },
        { u"divideontimes"_ustr, u"\u22C7"_ustr },
        { u"divonx"_ustr, u"\u22C7"_ustr },
        { u"djcy"_ustr, u"\u0452"_ustr },
        { u"dlcorn"_ustr, u"\u231E"_ustr },
        { u"dlcrop"_ustr, u"\u230D"_ustr },
        { u"dollar"_ustr, u"\u0024"_ustr },
        { u"dopf"_ustr, u"\U0001D555"_ustr },
        { u"dot"_ustr, u"\u02D9"_ustr },
        { u"doteq"_ustr, u"\u2250"_ustr },
        { u"doteqdot"_ustr, u"\u2251"_ustr },
        { u"dotminus"_ustr, u"\u2238"_ustr },
        { u"dotplus"_ustr, u"\u2214"_ustr },
        { u"dotsquare"_ustr, u"\u22A1"_ustr },
        { u"doublebarwedge"_ustr, u"\u2306"_ustr },
        { u"downarrow"_ustr, u"\u2193"_ustr },
        { u"downdownarrows"_ustr, u"\u21CA"_ustr },
        { u"downharpoonleft"_ustr, u"\u21C3"_ustr },
        { u"downharpoonright"_ustr, u"\u21C2"_ustr },
        { u"drbkarow"_ustr, u"\u2910"_ustr },
        { u"drcorn"_ustr, u"\u231F"_ustr },
        { u"drcrop"_ustr, u"\u230C"_ustr },
        { u"dscr"_ustr, u"\U0001D4B9"_ustr },
        { u"dscy"_ustr, u"\u0455"_ustr },
        { u"dsol"_ustr, u"\u29F6"_ustr },
        { u"dstrok"_ustr, u"\u0111"_ustr },
        { u"dtdot"_ustr, u"\u22F1"_ustr },
        { u"dtri"_ustr, u"\u25BF"_ustr },
        { u"dtrif"_ustr, u"\u25BE"_ustr },
        { u"duarr"_ustr, u"\u21F5"_ustr },
        { u"duhar"_ustr, u"\u296F"_ustr },
        { u"dwangle"_ustr, u"\u29A6"_ustr },
        { u"dzcy"_ustr, u"\u045F"_ustr },
        { u"dzigrarr"_ustr, u"\u27FF"_ustr },
        { u"eDDot"_ustr, u"\u2A77"_ustr },
        { u"eDot"_ustr, u"\u2251"_ustr },
        { u"eacute"_ustr, u"\u00E9"_ustr },
        { u"easter"_ustr, u"\u2A6E"_ustr },
        { u"ecaron"_ustr, u"\u011B"_ustr },
        { u"ecir"_ustr, u"\u2256"_ustr },
        { u"ecirc"_ustr, u"\u00EA"_ustr },
        { u"ecolon"_ustr, u"\u2255"_ustr },
        { u"ecy"_ustr, u"\u044D"_ustr },
        { u"edot"_ustr, u"\u0117"_ustr },
        { u"ee"_ustr, u"\u2147"_ustr },
        { u"efDot"_ustr, u"\u2252"_ustr },
        { u"efr"_ustr, u"\U0001D522"_ustr },
        { u"eg"_ustr, u"\u2A9A"_ustr },
        { u"egrave"_ustr, u"\u00E8"_ustr },
        { u"egs"_ustr, u"\u2A96"_ustr },
        { u"egsdot"_ustr, u"\u2A98"_ustr },
        { u"el"_ustr, u"\u2A99"_ustr },
        { u"elinters"_ustr, u"\u23E7"_ustr },
        { u"ell"_ustr, u"\u2113"_ustr },
        { u"els"_ustr, u"\u2A95"_ustr },
        { u"elsdot"_ustr, u"\u2A97"_ustr },
        { u"emacr"_ustr, u"\u0113"_ustr },
        { u"empty"_ustr, u"\u2205"_ustr },
        { u"emptyset"_ustr, u"\u2205"_ustr },
        { u"emptyv"_ustr, u"\u2205"_ustr },
        { u"emsp"_ustr, u"\u2003"_ustr },
        { u"emsp13"_ustr, u"\u2004"_ustr },
        { u"emsp14"_ustr, u"\u2005"_ustr },
        { u"eng"_ustr, u"\u014B"_ustr },
        { u"ensp"_ustr, u"\u2002"_ustr },
        { u"eogon"_ustr, u"\u0119"_ustr },
        { u"eopf"_ustr, u"\U0001D556"_ustr },
        { u"epar"_ustr, u"\u22D5"_ustr },
        { u"eparsl"_ustr, u"\u29E3"_ustr },
        { u"eplus"_ustr, u"\u2A71"_ustr },
        { u"epsi"_ustr, u"\u03B5"_ustr },
        { u"epsilon"_ustr, u"\u03B5"_ustr },
        { u"epsiv"_ustr, u"\u03F5"_ustr },
        { u"eqcirc"_ustr, u"\u2256"_ustr },
        { u"eqcolon"_ustr, u"\u2255"_ustr },
        { u"eqsim"_ustr, u"\u2242"_ustr },
        { u"eqslantgtr"_ustr, u"\u2A96"_ustr },
        { u"eqslantless"_ustr, u"\u2A95"_ustr },
        { u"equals"_ustr, u"\u003D"_ustr },
        { u"equest"_ustr, u"\u225F"_ustr },
        { u"equiv"_ustr, u"\u2261"_ustr },
        { u"equivDD"_ustr, u"\u2A78"_ustr },
        { u"eqvparsl"_ustr, u"\u29E5"_ustr },
        { u"erDot"_ustr, u"\u2253"_ustr },
        { u"erarr"_ustr, u"\u2971"_ustr },
        { u"escr"_ustr, u"\u212F"_ustr },
        { u"esdot"_ustr, u"\u2250"_ustr },
        { u"esim"_ustr, u"\u2242"_ustr },
        { u"eta"_ustr, u"\u03B7"_ustr },
        { u"eth"_ustr, u"\u00F0"_ustr },
        { u"euml"_ustr, u"\u00EB"_ustr },
        { u"euro"_ustr, u"\u20AC"_ustr },
        { u"excl"_ustr, u"\u0021"_ustr },
        { u"exist"_ustr, u"\u2203"_ustr },
        { u"expectation"_ustr, u"\u2130"_ustr },
        { u"exponentiale"_ustr, u"\u2147"_ustr },
        { u"fallingdotseq"_ustr, u"\u2252"_ustr },
        { u"fcy"_ustr, u"\u0444"_ustr },
        { u"female"_ustr, u"\u2640"_ustr },
        { u"ffilig"_ustr, u"\uFB03"_ustr },
        { u"fflig"_ustr, u"\uFB00"_ustr },
        { u"ffllig"_ustr, u"\uFB04"_ustr },
        { u"ffr"_ustr, u"\U0001D523"_ustr },
        { u"filig"_ustr, u"\uFB01"_ustr },
        { u"fjlig"_ustr, u"\u0066\u006A"_ustr },
        { u"flat"_ustr, u"\u266D"_ustr },
        { u"fllig"_ustr, u"\uFB02"_ustr },
        { u"fltns"_ustr, u"\u25B1"_ustr },
        { u"fnof"_ustr, u"\u0192"_ustr },
        { u"fopf"_ustr, u"\U0001D557"_ustr },
        { u"forall"_ustr, u"\u2200"_ustr },
        { u"fork"_ustr, u"\u22D4"_ustr },
        { u"forkv"_ustr, u"\u2AD9"_ustr },
        { u"fpartint"_ustr, u"\u2A0D"_ustr },
        { u"frac12"_ustr, u"\u00BD"_ustr },
        { u"frac13"_ustr, u"\u2153"_ustr },
        { u"frac14"_ustr, u"\u00BC"_ustr },
        { u"frac15"_ustr, u"\u2155"_ustr },
        { u"frac16"_ustr, u"\u2159"_ustr },
        { u"frac18"_ustr, u"\u215B"_ustr },
        { u"frac23"_ustr, u"\u2154"_ustr },
        { u"frac25"_ustr, u"\u2156"_ustr },
        { u"frac34"_ustr, u"\u00BE"_ustr },
        { u"frac35"_ustr, u"\u2157"_ustr },
        { u"frac38"_ustr, u"\u215C"_ustr },
        { u"frac45"_ustr, u"\u2158"_ustr },
        { u"frac56"_ustr, u"\u215A"_ustr },
        { u"frac58"_ustr, u"\u215D"_ustr },
        { u"frac78"_ustr, u"\u215E"_ustr },
        { u"frasl"_ustr, u"\u2044"_ustr },
        { u"frown"_ustr, u"\u2322"_ustr },
        { u"fscr"_ustr, u"\U0001D4BB"_ustr },
        { u"gE"_ustr, u"\u2267"_ustr },
        { u"gEl"_ustr, u"\u2A8C"_ustr },
        { u"gacute"_ustr, u"\u01F5"_ustr },
        { u"gamma"_ustr, u"\u03B3"_ustr },
        { u"gammad"_ustr, u"\u03DD"_ustr },
        { u"gap"_ustr, u"\u2A86"_ustr },
        { u"gbreve"_ustr, u"\u011F"_ustr },
        { u"gcirc"_ustr, u"\u011D"_ustr },
        { u"gcy"_ustr, u"\u0433"_ustr },
        { u"gdot"_ustr, u"\u0121"_ustr },
        { u"ge"_ustr, u"\u2265"_ustr },
        { u"gel"_ustr, u"\u22DB"_ustr },
        { u"geq"_ustr, u"\u2265"_ustr },
        { u"geqq"_ustr, u"\u2267"_ustr },
        { u"geqslant"_ustr, u"\u2A7E"_ustr },
        { u"ges"_ustr, u"\u2A7E"_ustr },
        { u"gescc"_ustr, u"\u2AA9"_ustr },
        { u"gesdot"_ustr, u"\u2A80"_ustr },
        { u"gesdoto"_ustr, u"\u2A82"_ustr },
        { u"gesdotol"_ustr, u"\u2A84"_ustr },
        { u"gesl"_ustr, u"\u22DB\uFE00"_ustr },
        { u"gesles"_ustr, u"\u2A94"_ustr },
        { u"gfr"_ustr, u"\U0001D524"_ustr },
        { u"gg"_ustr, u"\u226B"_ustr },
        { u"ggg"_ustr, u"\u22D9"_ustr },
        { u"gimel"_ustr, u"\u2137"_ustr },
        { u"gjcy"_ustr, u"\u0453"_ustr },
        { u"gl"_ustr, u"\u2277"_ustr },
        { u"glE"_ustr, u"\u2A92"_ustr },
        { u"gla"_ustr, u"\u2AA5"_ustr },
        { u"glj"_ustr, u"\u2AA4"_ustr },
        { u"gnE"_ustr, u"\u2269"_ustr },
        { u"gnap"_ustr, u"\u2A8A"_ustr },
        { u"gnapprox"_ustr, u"\u2A8A"_ustr },
        { u"gne"_ustr, u"\u2A88"_ustr },
        { u"gneq"_ustr, u"\u2A88"_ustr },
        { u"gneqq"_ustr, u"\u2269"_ustr },
        { u"gnsim"_ustr, u"\u22E7"_ustr },
        { u"gopf"_ustr, u"\U0001D558"_ustr },
        { u"grave"_ustr, u"\u0060"_ustr },
        { u"gscr"_ustr, u"\u210A"_ustr },
        { u"gsim"_ustr, u"\u2273"_ustr },
        { u"gsime"_ustr, u"\u2A8E"_ustr },
        { u"gsiml"_ustr, u"\u2A90"_ustr },
        { u"gt"_ustr, u"\u003E"_ustr },
        { u"gtcc"_ustr, u"\u2AA7"_ustr },
        { u"gtcir"_ustr, u"\u2A7A"_ustr },
        { u"gtdot"_ustr, u"\u22D7"_ustr },
        { u"gtlPar"_ustr, u"\u2995"_ustr },
        { u"gtquest"_ustr, u"\u2A7C"_ustr },
        { u"gtrapprox"_ustr, u"\u2A86"_ustr },
        { u"gtrarr"_ustr, u"\u2978"_ustr },
        { u"gtrdot"_ustr, u"\u22D7"_ustr },
        { u"gtreqless"_ustr, u"\u22DB"_ustr },
        { u"gtreqqless"_ustr, u"\u2A8C"_ustr },
        { u"gtrless"_ustr, u"\u2277"_ustr },
        { u"gtrsim"_ustr, u"\u2273"_ustr },
        { u"gvertneqq"_ustr, u"\u2269\uFE00"_ustr },
        { u"gvnE"_ustr, u"\u2269\uFE00"_ustr },
        { u"hArr"_ustr, u"\u21D4"_ustr },
        { u"hairsp"_ustr, u"\u200A"_ustr },
        { u"half"_ustr, u"\u00BD"_ustr },
        { u"hamilt"_ustr, u"\u210B"_ustr },
        { u"hardcy"_ustr, u"\u044A"_ustr },
        { u"harr"_ustr, u"\u2194"_ustr },
        { u"harrcir"_ustr, u"\u2948"_ustr },
        { u"harrw"_ustr, u"\u21AD"_ustr },
        { u"hbar"_ustr, u"\u210F"_ustr },
        { u"hcirc"_ustr, u"\u0125"_ustr },
        { u"hearts"_ustr, u"\u2665"_ustr },
        { u"heartsuit"_ustr, u"\u2665"_ustr },
        { u"hellip"_ustr, u"\u2026"_ustr },
        { u"hercon"_ustr, u"\u22B9"_ustr },
        { u"hfr"_ustr, u"\U0001D525"_ustr },
        { u"hksearow"_ustr, u"\u2925"_ustr },
        { u"hkswarow"_ustr, u"\u2926"_ustr },
        { u"hoarr"_ustr, u"\u21FF"_ustr },
        { u"homtht"_ustr, u"\u223B"_ustr },
        { u"hookleftarrow"_ustr, u"\u21A9"_ustr },
        { u"hookrightarrow"_ustr, u"\u21AA"_ustr },
        { u"hopf"_ustr, u"\U0001D559"_ustr },
        { u"horbar"_ustr, u"\u2015"_ustr },
        { u"hscr"_ustr, u"\U0001D4BD"_ustr },
        { u"hslash"_ustr, u"\u210F"_ustr },
        { u"hstrok"_ustr, u"\u0127"_ustr },
        { u"hybull"_ustr, u"\u2043"_ustr },
        { u"hyphen"_ustr, u"\u2010"_ustr },
        { u"iacute"_ustr, u"\u00ED"_ustr },
        { u"ic"_ustr, u"\u2063"_ustr },
        { u"icirc"_ustr, u"\u00EE"_ustr },
        { u"icy"_ustr, u"\u0438"_ustr },
        { u"iecy"_ustr, u"\u0435"_ustr },
        { u"iexcl"_ustr, u"\u00A1"_ustr },
        { u"iff"_ustr, u"\u21D4"_ustr },
        { u"ifr"_ustr, u"\U0001D526"_ustr },
        { u"igrave"_ustr, u"\u00EC"_ustr },
        { u"ii"_ustr, u"\u2148"_ustr },
        { u"iiiint"_ustr, u"\u2A0C"_ustr },
        { u"iiint"_ustr, u"\u222D"_ustr },
        { u"iinfin"_ustr, u"\u29DC"_ustr },
        { u"iiota"_ustr, u"\u2129"_ustr },
        { u"ijlig"_ustr, u"\u0133"_ustr },
        { u"imacr"_ustr, u"\u012B"_ustr },
        { u"image"_ustr, u"\u2111"_ustr },
        { u"imagline"_ustr, u"\u2110"_ustr },
        { u"imagpart"_ustr, u"\u2111"_ustr },
        { u"imath"_ustr, u"\u0131"_ustr },
        { u"imof"_ustr, u"\u22B7"_ustr },
        { u"imped"_ustr, u"\u01B5"_ustr },
        { u"in"_ustr, u"\u2208"_ustr },
        { u"incare"_ustr, u"\u2105"_ustr },
        { u"infin"_ustr, u"\u221E"_ustr },
        { u"infintie"_ustr, u"\u29DD"_ustr },
        { u"inodot"_ustr, u"\u0131"_ustr },
        { u"int"_ustr, u"\u222B"_ustr },
        { u"intcal"_ustr, u"\u22BA"_ustr },
        { u"integers"_ustr, u"\u2124"_ustr },
        { u"intercal"_ustr, u"\u22BA"_ustr },
        { u"intlarhk"_ustr, u"\u2A17"_ustr },
        { u"intprod"_ustr, u"\u2A3C"_ustr },
        { u"iocy"_ustr, u"\u0451"_ustr },
        { u"iogon"_ustr, u"\u012F"_ustr },
        { u"iopf"_ustr, u"\U0001D55A"_ustr },
        { u"iota"_ustr, u"\u03B9"_ustr },
        { u"iprod"_ustr, u"\u2A3C"_ustr },
        { u"iquest"_ustr, u"\u00BF"_ustr },
        { u"iscr"_ustr, u"\U0001D4BE"_ustr },
        { u"isin"_ustr, u"\u2208"_ustr },
        { u"isinE"_ustr, u"\u22F9"_ustr },
        { u"isindot"_ustr, u"\u22F5"_ustr },
        { u"isins"_ustr, u"\u22F4"_ustr },
        { u"isinsv"_ustr, u"\u22F3"_ustr },
        { u"isinv"_ustr, u"\u2208"_ustr },
        { u"it"_ustr, u"\u2062"_ustr },
        { u"itilde"_ustr, u"\u0129"_ustr },
        { u"iukcy"_ustr, u"\u0456"_ustr },
        { u"iuml"_ustr, u"\u00EF"_ustr },
        { u"jcirc"_ustr, u"\u0135"_ustr },
        { u"jcy"_ustr, u"\u0439"_ustr },
        { u"jfr"_ustr, u"\U0001D527"_ustr },
        { u"jmath"_ustr, u"\u0237"_ustr },
        { u"jopf"_ustr, u"\U0001D55B"_ustr },
        { u"jscr"_ustr, u"\U0001D4BF"_ustr },
        { u"jsercy"_ustr, u"\u0458"_ustr },
        { u"jukcy"_ustr, u"\u0454"_ustr },
        { u"kappa"_ustr, u"\u03BA"_ustr },
        { u"kappav"_ustr, u"\u03F0"_ustr },
        { u"kcedil"_ustr, u"\u0137"_ustr },
        { u"kcy"_ustr, u"\u043A"_ustr },
        { u"kfr"_ustr, u"\U0001D528"_ustr },
        { u"kgreen"_ustr, u"\u0138"_ustr },
        { u"khcy"_ustr, u"\u0445"_ustr },
        { u"kjcy"_ustr, u"\u045C"_ustr },
        { u"kopf"_ustr, u"\U0001D55C"_ustr },
        { u"kscr"_ustr, u"\U0001D4C0"_ustr },
        { u"lAarr"_ustr, u"\u21DA"_ustr },
        { u"lArr"_ustr, u"\u21D0"_ustr },
        { u"lAtail"_ustr, u"\u291B"_ustr },
        { u"lBarr"_ustr, u"\u290E"_ustr },
        { u"lE"_ustr, u"\u2266"_ustr },
        { u"lEg"_ustr, u"\u2A8B"_ustr },
        { u"lHar"_ustr, u"\u2962"_ustr },
        { u"lacute"_ustr, u"\u013A"_ustr },
        { u"laemptyv"_ustr, u"\u29B4"_ustr },
        { u"lagran"_ustr, u"\u2112"_ustr },
        { u"lambda"_ustr, u"\u03BB"_ustr },
        { u"lang"_ustr, u"\u27E8"_ustr },
        { u"langd"_ustr, u"\u2991"_ustr },
        { u"langle"_ustr, u"\u27E8"_ustr },
        { u"lap"_ustr, u"\u2A85"_ustr },
        { u"laquo"_ustr, u"\u00AB"_ustr },
        { u"larr"_ustr, u"\u2190"_ustr },
        { u"larrb"_ustr, u"\u21E4"_ustr },
        { u"larrbfs"_ustr, u"\u291F"_ustr },
        { u"larrfs"_ustr, u"\u291D"_ustr },
        { u"larrhk"_ustr, u"\u21A9"_ustr },
        { u"larrlp"_ustr, u"\u21AB"_ustr },
        { u"larrpl"_ustr, u"\u2939"_ustr },
        { u"larrsim"_ustr, u"\u2973"_ustr },
        { u"larrtl"_ustr, u"\u21A2"_ustr },
        { u"lat"_ustr, u"\u2AAB"_ustr },
        { u"latail"_ustr, u"\u2919"_ustr },
        { u"late"_ustr, u"\u2AAD"_ustr },
        { u"lates"_ustr, u"\u2AAD\uFE00"_ustr },
        { u"lbarr"_ustr, u"\u290C"_ustr },
        { u"lbbrk"_ustr, u"\u2772"_ustr },
        { u"lbrace"_ustr, u"\u007B"_ustr },
        { u"lbrack"_ustr, u"\u005B"_ustr },
        { u"lbrke"_ustr, u"\u298B"_ustr },
        { u"lbrksld"_ustr, u"\u298F"_ustr },
        { u"lbrkslu"_ustr, u"\u298D"_ustr },
        { u"lcaron"_ustr, u"\u013E"_ustr },
        { u"lcedil"_ustr, u"\u013C"_ustr },
        { u"lceil"_ustr, u"\u2308"_ustr },
        { u"lcub"_ustr, u"\u007B"_ustr },
        { u"lcy"_ustr, u"\u043B"_ustr },
        { u"ldca"_ustr, u"\u2936"_ustr },
        { u"ldquo"_ustr, u"\u201C"_ustr },
        { u"ldquor"_ustr, u"\u201E"_ustr },
        { u"ldrdhar"_ustr, u"\u2967"_ustr },
        { u"ldrushar"_ustr, u"\u294B"_ustr },
        { u"ldsh"_ustr, u"\u21B2"_ustr },
        { u"le"_ustr, u"\u2264"_ustr },
        { u"leftarrow"_ustr, u"\u2190"_ustr },
        { u"leftarrowtail"_ustr, u"\u21A2"_ustr },
        { u"leftharpoondown"_ustr, u"\u21BD"_ustr },
        { u"leftharpoonup"_ustr, u"\u21BC"_ustr },
        { u"leftleftarrows"_ustr, u"\u21C7"_ustr },
        { u"leftrightarrow"_ustr, u"\u2194"_ustr },
        { u"leftrightarrows"_ustr, u"\u21C6"_ustr },
        { u"leftrightharpoons"_ustr, u"\u21CB"_ustr },
        { u"leftrightsquigarrow"_ustr, u"\u21AD"_ustr },
        { u"leftthreetimes"_ustr, u"\u22CB"_ustr },
        { u"leg"_ustr, u"\u22DA"_ustr },
        { u"leq"_ustr, u"\u2264"_ustr },
        { u"leqq"_ustr, u"\u2266"_ustr },
        { u"leqslant"_ustr, u"\u2A7D"_ustr },
        { u"les"_ustr, u"\u2A7D"_ustr },
        { u"lescc"_ustr, u"\u2AA8"_ustr },
        { u"lesdot"_ustr, u"\u2A7F"_ustr },
        { u"lesdoto"_ustr, u"\u2A81"_ustr },
        { u"lesdotor"_ustr, u"\u2A83"_ustr },
        { u"lesg"_ustr, u"\u22DA\uFE00"_ustr },
        { u"lesges"_ustr, u"\u2A93"_ustr },
        { u"lessapprox"_ustr, u"\u2A85"_ustr },
        { u"lessdot"_ustr, u"\u22D6"_ustr },
        { u"lesseqgtr"_ustr, u"\u22DA"_ustr },
        { u"lesseqqgtr"_ustr, u"\u2A8B"_ustr },
        { u"lessgtr"_ustr, u"\u2276"_ustr },
        { u"lesssim"_ustr, u"\u2272"_ustr },
        { u"lfisht"_ustr, u"\u297C"_ustr },
        { u"lfloor"_ustr, u"\u230A"_ustr },
        { u"lfr"_ustr, u"\U0001D529"_ustr },
        { u"lg"_ustr, u"\u2276"_ustr },
        { u"lgE"_ustr, u"\u2A91"_ustr },
        { u"lhard"_ustr, u"\u21BD"_ustr },
        { u"lharu"_ustr, u"\u21BC"_ustr },
        { u"lharul"_ustr, u"\u296A"_ustr },
        { u"lhblk"_ustr, u"\u2584"_ustr },
        { u"ljcy"_ustr, u"\u0459"_ustr },
        { u"ll"_ustr, u"\u226A"_ustr },
        { u"llarr"_ustr, u"\u21C7"_ustr },
        { u"llcorner"_ustr, u"\u231E"_ustr },
        { u"llhard"_ustr, u"\u296B"_ustr },
        { u"lltri"_ustr, u"\u25FA"_ustr },
        { u"lmidot"_ustr, u"\u0140"_ustr },
        { u"lmoust"_ustr, u"\u23B0"_ustr },
        { u"lmoustache"_ustr, u"\u23B0"_ustr },
        { u"lnE"_ustr, u"\u2268"_ustr },
        { u"lnap"_ustr, u"\u2A89"_ustr },
        { u"lnapprox"_ustr, u"\u2A89"_ustr },
        { u"lne"_ustr, u"\u2A87"_ustr },
        { u"lneq"_ustr, u"\u2A87"_ustr },
        { u"lneqq"_ustr, u"\u2268"_ustr },
        { u"lnsim"_ustr, u"\u22E6"_ustr },
        { u"loang"_ustr, u"\u27EC"_ustr },
        { u"loarr"_ustr, u"\u21FD"_ustr },
        { u"lobrk"_ustr, u"\u27E6"_ustr },
        { u"longleftarrow"_ustr, u"\u27F5"_ustr },
        { u"longleftrightarrow"_ustr, u"\u27F7"_ustr },
        { u"longmapsto"_ustr, u"\u27FC"_ustr },
        { u"longrightarrow"_ustr, u"\u27F6"_ustr },
        { u"looparrowleft"_ustr, u"\u21AB"_ustr },
        { u"looparrowright"_ustr, u"\u21AC"_ustr },
        { u"lopar"_ustr, u"\u2985"_ustr },
        { u"lopf"_ustr, u"\U0001D55D"_ustr },
        { u"loplus"_ustr, u"\u2A2D"_ustr },
        { u"lotimes"_ustr, u"\u2A34"_ustr },
        { u"lowast"_ustr, u"\u2217"_ustr },
        { u"lowbar"_ustr, u"\u005F"_ustr },
        { u"loz"_ustr, u"\u25CA"_ustr },
        { u"lozenge"_ustr, u"\u25CA"_ustr },
        { u"lozf"_ustr, u"\u29EB"_ustr },
        { u"lpar"_ustr, u"\u0028"_ustr },
        { u"lparlt"_ustr, u"\u2993"_ustr },
        { u"lrarr"_ustr, u"\u21C6"_ustr },
        { u"lrcorner"_ustr, u"\u231F"_ustr },
        { u"lrhar"_ustr, u"\u21CB"_ustr },
        { u"lrhard"_ustr, u"\u296D"_ustr },
        { u"lrm"_ustr, u"\u200E"_ustr },
        { u"lrtri"_ustr, u"\u22BF"_ustr },
        { u"lsaquo"_ustr, u"\u2039"_ustr },
        { u"lscr"_ustr, u"\U0001D4C1"_ustr },
        { u"lsh"_ustr, u"\u21B0"_ustr },
        { u"lsim"_ustr, u"\u2272"_ustr },
        { u"lsime"_ustr, u"\u2A8D"_ustr },
        { u"lsimg"_ustr, u"\u2A8F"_ustr },
        { u"lsqb"_ustr, u"\u005B"_ustr },
        { u"lsquo"_ustr, u"\u2018"_ustr },
        { u"lsquor"_ustr, u"\u201A"_ustr },
        { u"lstrok"_ustr, u"\u0142"_ustr },
        { u"lt"_ustr, u"\u003C"_ustr },
        { u"ltcc"_ustr, u"\u2AA6"_ustr },
        { u"ltcir"_ustr, u"\u2A79"_ustr },
        { u"ltdot"_ustr, u"\u22D6"_ustr },
        { u"lthree"_ustr, u"\u22CB"_ustr },
        { u"ltimes"_ustr, u"\u22C9"_ustr },
        { u"ltlarr"_ustr, u"\u2976"_ustr },
        { u"ltquest"_ustr, u"\u2A7B"_ustr },
        { u"ltrPar"_ustr, u"\u2996"_ustr },
        { u"ltri"_ustr, u"\u25C3"_ustr },
        { u"ltrie"_ustr, u"\u22B4"_ustr },
        { u"ltrif"_ustr, u"\u25C2"_ustr },
        { u"lurdshar"_ustr, u"\u294A"_ustr },
        { u"luruhar"_ustr, u"\u2966"_ustr },
        { u"lvertneqq"_ustr, u"\u2268\uFE00"_ustr },
        { u"lvnE"_ustr, u"\u2268\uFE00"_ustr },
        { u"mDDot"_ustr, u"\u223A"_ustr },
        { u"macr"_ustr, u"\u00AF"_ustr },
        { u"male"_ustr, u"\u2642"_ustr },
        { u"malt"_ustr, u"\u2720"_ustr },
        { u"maltese"_ustr, u"\u2720"_ustr },
        { u"map"_ustr, u"\u21A6"_ustr },
        { u"mapsto"_ustr, u"\u21A6"_ustr },
        { u"mapstodown"_ustr, u"\u21A7"_ustr },
        { u"mapstoleft"_ustr, u"\u21A4"_ustr },
        { u"mapstoup"_ustr, u"\u21A5"_ustr },
        { u"marker"_ustr, u"\u25AE"_ustr },
        { u"mcomma"_ustr, u"\u2A29"_ustr },
        { u"mcy"_ustr, u"\u043C"_ustr },
        { u"mdash"_ustr, u"\u2014"_ustr },
        { u"measuredangle"_ustr, u"\u2221"_ustr },
        { u"mfr"_ustr, u"\U0001D52A"_ustr },
        { u"mho"_ustr, u"\u2127"_ustr },
        { u"micro"_ustr, u"\u00B5"_ustr },
        { u"mid"_ustr, u"\u2223"_ustr },
        { u"midast"_ustr, u"\u002A"_ustr },
        { u"midcir"_ustr, u"\u2AF0"_ustr },
        { u"middot"_ustr, u"\u00B7"_ustr },
        { u"minus"_ustr, u"\u2212"_ustr },
        { u"minusb"_ustr, u"\u229F"_ustr },
        { u"minusd"_ustr, u"\u2238"_ustr },
        { u"minusdu"_ustr, u"\u2A2A"_ustr },
        { u"mlcp"_ustr, u"\u2ADB"_ustr },
        { u"mldr"_ustr, u"\u2026"_ustr },
        { u"mnplus"_ustr, u"\u2213"_ustr },
        { u"models"_ustr, u"\u22A7"_ustr },
        { u"mopf"_ustr, u"\U0001D55E"_ustr },
        { u"mp"_ustr, u"\u2213"_ustr },
        { u"mscr"_ustr, u"\U0001D4C2"_ustr },
        { u"mstpos"_ustr, u"\u223E"_ustr },
        { u"mu"_ustr, u"\u03BC"_ustr },
        { u"multimap"_ustr, u"\u22B8"_ustr },
        { u"mumap"_ustr, u"\u22B8"_ustr },
        { u"nGg"_ustr, u"\u22D9\u0338"_ustr },
        { u"nGt"_ustr, u"\u226B\u20D2"_ustr },
        { u"nGtv"_ustr, u"\u226B\u0338"_ustr },
        { u"nLeftarrow"_ustr, u"\u21CD"_ustr },
        { u"nLeftrightarrow"_ustr, u"\u21CE"_ustr },
        { u"nLl"_ustr, u"\u22D8\u0338"_ustr },
        { u"nLt"_ustr, u"\u226A\u20D2"_ustr },
        { u"nLtv"_ustr, u"\u226A\u0338"_ustr },
        { u"nRightarrow"_ustr, u"\u21CF"_ustr },
        { u"nVDash"_ustr, u"\u22AF"_ustr },
        { u"nVdash"_ustr, u"\u22AE"_ustr },
        { u"nabla"_ustr, u"\u2207"_ustr },
        { u"nacute"_ustr, u"\u0144"_ustr },
        { u"nang"_ustr, u"\u2220\u20D2"_ustr },
        { u"nap"_ustr, u"\u2249"_ustr },
        { u"napE"_ustr, u"\u2A70\u0338"_ustr },
        { u"napid"_ustr, u"\u224B\u0338"_ustr },
        { u"napos"_ustr, u"\u0149"_ustr },
        { u"napprox"_ustr, u"\u2249"_ustr },
        { u"natur"_ustr, u"\u266E"_ustr },
        { u"natural"_ustr, u"\u266E"_ustr },
        { u"naturals"_ustr, u"\u2115"_ustr },
        { u"nbsp"_ustr, u"\u00A0"_ustr },
        { u"nbump"_ustr, u"\u224E\u0338"_ustr },
        { u"nbumpe"_ustr, u"\u224F\u0338"_ustr },
        { u"ncap"_ustr, u"\u2A43"_ustr },
        { u"ncaron"_ustr, u"\u0148"_ustr },
        { u"ncedil"_ustr, u"\u0146"_ustr },
        { u"ncong"_ustr, u"\u2247"_ustr },
        { u"ncongdot"_ustr, u"\u2A6D\u0338"_ustr },
        { u"ncup"_ustr, u"\u2A42"_ustr },
        { u"ncy"_ustr, u"\u043D"_ustr },
        { u"ndash"_ustr, u"\u2013"_ustr },
        { u"ne"_ustr, u"\u2260"_ustr },
        { u"neArr"_ustr, u"\u21D7"_ustr },
        { u"nearhk"_ustr, u"\u2924"_ustr },
        { u"nearr"_ustr, u"\u2197"_ustr },
        { u"nearrow"_ustr, u"\u2197"_ustr },
        { u"nedot"_ustr, u"\u2250\u0338"_ustr },
        { u"nequiv"_ustr, u"\u2262"_ustr },
        { u"nesear"_ustr, u"\u2928"_ustr },
        { u"nesim"_ustr, u"\u2242\u0338"_ustr },
        { u"nexist"_ustr, u"\u2204"_ustr },
        { u"nexists"_ustr, u"\u2204"_ustr },
        { u"nfr"_ustr, u"\U0001D52B"_ustr },
        { u"ngE"_ustr, u"\u2267\u0338"_ustr },
        { u"nge"_ustr, u"\u2271"_ustr },
        { u"ngeq"_ustr, u"\u2271"_ustr },
        { u"ngeqq"_ustr, u"\u2267\u0338"_ustr },
        { u"ngeqslant"_ustr, u"\u2A7E\u0338"_ustr },
        { u"nges"_ustr, u"\u2A7E\u0338"_ustr },
        { u"ngsim"_ustr, u"\u2275"_ustr },
        { u"ngt"_ustr, u"\u226F"_ustr },
        { u"ngtr"_ustr, u"\u226F"_ustr },
        { u"nhArr"_ustr, u"\u21CE"_ustr },
        { u"nharr"_ustr, u"\u21AE"_ustr },
        { u"nhpar"_ustr, u"\u2AF2"_ustr },
        { u"ni"_ustr, u"\u220B"_ustr },
        { u"nis"_ustr, u"\u22FC"_ustr },
        { u"nisd"_ustr, u"\u22FA"_ustr },
        { u"niv"_ustr, u"\u220B"_ustr },
        { u"njcy"_ustr, u"\u045A"_ustr },
        { u"nlArr"_ustr, u"\u21CD"_ustr },
        { u"nlE"_ustr, u"\u2266\u0338"_ustr },
        { u"nlarr"_ustr, u"\u219A"_ustr },
        { u"nldr"_ustr, u"\u2025"_ustr },
        { u"nle"_ustr, u"\u2270"_ustr },
        { u"nleftarrow"_ustr, u"\u219A"_ustr },
        { u"nleftrightarrow"_ustr, u"\u21AE"_ustr },
        { u"nleq"_ustr, u"\u2270"_ustr },
        { u"nleqq"_ustr, u"\u2266\u0338"_ustr },
        { u"nleqslant"_ustr, u"\u2A7D\u0338"_ustr },
        { u"nles"_ustr, u"\u2A7D\u0338"_ustr },
        { u"nless"_ustr, u"\u226E"_ustr },
        { u"nlsim"_ustr, u"\u2274"_ustr },
        { u"nlt"_ustr, u"\u226E"_ustr },
        { u"nltri"_ustr, u"\u22EA"_ustr },
        { u"nltrie"_ustr, u"\u22EC"_ustr },
        { u"nmid"_ustr, u"\u2224"_ustr },
        { u"nopf"_ustr, u"\U0001D55F"_ustr },
        { u"not"_ustr, u"\u00AC"_ustr },
        { u"notin"_ustr, u"\u2209"_ustr },
        { u"notinE"_ustr, u"\u22F9\u0338"_ustr },
        { u"notindot"_ustr, u"\u22F5\u0338"_ustr },
        { u"notinva"_ustr, u"\u2209"_ustr },
        { u"notinvb"_ustr, u"\u22F7"_ustr },
        { u"notinvc"_ustr, u"\u22F6"_ustr },
        { u"notni"_ustr, u"\u220C"_ustr },
        { u"notniva"_ustr, u"\u220C"_ustr },
        { u"notnivb"_ustr, u"\u22FE"_ustr },
        { u"notnivc"_ustr, u"\u22FD"_ustr },
        { u"npar"_ustr, u"\u2226"_ustr },
        { u"nparallel"_ustr, u"\u2226"_ustr },
        { u"nparsl"_ustr, u"\u2AFD\u20E5"_ustr },
        { u"npart"_ustr, u"\u2202\u0338"_ustr },
        { u"npolint"_ustr, u"\u2A14"_ustr },
        { u"npr"_ustr, u"\u2280"_ustr },
        { u"nprcue"_ustr, u"\u22E0"_ustr },
        { u"npre"_ustr, u"\u2AAF\u0338"_ustr },
        { u"nprec"_ustr, u"\u2280"_ustr },
        { u"npreceq"_ustr, u"\u2AAF\u0338"_ustr },
        { u"nrArr"_ustr, u"\u21CF"_ustr },
        { u"nrarr"_ustr, u"\u219B"_ustr },
        { u"nrarrc"_ustr, u"\u2933\u0338"_ustr },
        { u"nrarrw"_ustr, u"\u219D\u0338"_ustr },
        { u"nrightarrow"_ustr, u"\u219B"_ustr },
        { u"nrtri"_ustr, u"\u22EB"_ustr },
        { u"nrtrie"_ustr, u"\u22ED"_ustr },
        { u"nsc"_ustr, u"\u2281"_ustr },
        { u"nsccue"_ustr, u"\u22E1"_ustr },
        { u"nsce"_ustr, u"\u2AB0\u0338"_ustr },
        { u"nscr"_ustr, u"\U0001D4C3"_ustr },
        { u"nshortmid"_ustr, u"\u2224"_ustr },
        { u"nshortparallel"_ustr, u"\u2226"_ustr },
        { u"nsim"_ustr, u"\u2241"_ustr },
        { u"nsime"_ustr, u"\u2244"_ustr },
        { u"nsimeq"_ustr, u"\u2244"_ustr },
        { u"nsmid"_ustr, u"\u2224"_ustr },
        { u"nspar"_ustr, u"\u2226"_ustr },
        { u"nsqsube"_ustr, u"\u22E2"_ustr },
        { u"nsqsupe"_ustr, u"\u22E3"_ustr },
        { u"nsub"_ustr, u"\u2284"_ustr },
        { u"nsubE"_ustr, u"\u2AC5\u0338"_ustr },
        { u"nsube"_ustr, u"\u2288"_ustr },
        { u"nsubset"_ustr, u"\u2282\u20D2"_ustr },
        { u"nsubseteq"_ustr, u"\u2288"_ustr },
        { u"nsubseteqq"_ustr, u"\u2AC5\u0338"_ustr },
        { u"nsucc"_ustr, u"\u2281"_ustr },
        { u"nsucceq"_ustr, u"\u2AB0\u0338"_ustr },
        { u"nsup"_ustr, u"\u2285"_ustr },
        { u"nsupE"_ustr, u"\u2AC6\u0338"_ustr },
        { u"nsupe"_ustr, u"\u2289"_ustr },
        { u"nsupset"_ustr, u"\u2283\u20D2"_ustr },
        { u"nsupseteq"_ustr, u"\u2289"_ustr },
        { u"nsupseteqq"_ustr, u"\u2AC6\u0338"_ustr },
        { u"ntgl"_ustr, u"\u2279"_ustr },
        { u"ntilde"_ustr, u"\u00F1"_ustr },
        { u"ntlg"_ustr, u"\u2278"_ustr },
        { u"ntriangleleft"_ustr, u"\u22EA"_ustr },
        { u"ntrianglelefteq"_ustr, u"\u22EC"_ustr },
        { u"ntriangleright"_ustr, u"\u22EB"_ustr },
        { u"ntrianglerighteq"_ustr, u"\u22ED"_ustr },
        { u"nu"_ustr, u"\u03BD"_ustr },
        { u"num"_ustr, u"\u0023"_ustr },
        { u"numero"_ustr, u"\u2116"_ustr },
        { u"numsp"_ustr, u"\u2007"_ustr },
        { u"nvDash"_ustr, u"\u22AD"_ustr },
        { u"nvHarr"_ustr, u"\u2904"_ustr },
        { u"nvap"_ustr, u"\u224D\u20D2"_ustr },
        { u"nvdash"_ustr, u"\u22AC"_ustr },
        { u"nvge"_ustr, u"\u2265\u20D2"_ustr },
        { u"nvgt"_ustr, u"\u003E\u20D2"_ustr },
        { u"nvinfin"_ustr, u"\u29DE"_ustr },
        { u"nvlArr"_ustr, u"\u2902"_ustr },
        { u"nvle"_ustr, u"\u2264\u20D2"_ustr },
        { u"nvlt"_ustr, u"\u003C\u20D2"_ustr },
        { u"nvltrie"_ustr, u"\u22B4\u20D2"_ustr },
        { u"nvrArr"_ustr, u"\u2903"_ustr },
        { u"nvrtrie"_ustr, u"\u22B5\u20D2"_ustr },
        { u"nvsim"_ustr, u"\u223C\u20D2"_ustr },
        { u"nwArr"_ustr, u"\u21D6"_ustr },
        { u"nwarhk"_ustr, u"\u2923"_ustr },
        { u"nwarr"_ustr, u"\u2196"_ustr },
        { u"nwarrow"_ustr, u"\u2196"_ustr },
        { u"nwnear"_ustr, u"\u2927"_ustr },
        { u"oS"_ustr, u"\u24C8"_ustr },
        { u"oacute"_ustr, u"\u00F3"_ustr },
        { u"oast"_ustr, u"\u229B"_ustr },
        { u"ocir"_ustr, u"\u229A"_ustr },
        { u"ocirc"_ustr, u"\u00F4"_ustr },
        { u"ocy"_ustr, u"\u043E"_ustr },
        { u"odash"_ustr, u"\u229D"_ustr },
        { u"odblac"_ustr, u"\u0151"_ustr },
        { u"odiv"_ustr, u"\u2A38"_ustr },
        { u"odot"_ustr, u"\u2299"_ustr },
        { u"odsold"_ustr, u"\u29BC"_ustr },
        { u"oelig"_ustr, u"\u0153"_ustr },
        { u"ofcir"_ustr, u"\u29BF"_ustr },
        { u"ofr"_ustr, u"\U0001D52C"_ustr },
        { u"ogon"_ustr, u"\u02DB"_ustr },
        { u"ograve"_ustr, u"\u00F2"_ustr },
        { u"ogt"_ustr, u"\u29C1"_ustr },
        { u"ohbar"_ustr, u"\u29B5"_ustr },
        { u"ohm"_ustr, u"\u03A9"_ustr },
        { u"oint"_ustr, u"\u222E"_ustr },
        { u"olarr"_ustr, u"\u21BA"_ustr },
        { u"olcir"_ustr, u"\u29BE"_ustr },
        { u"olcross"_ustr, u"\u29BB"_ustr },
        { u"oline"_ustr, u"\u203E"_ustr },
        { u"olt"_ustr, u"\u29C0"_ustr },
        { u"omacr"_ustr, u"\u014D"_ustr },
        { u"omega"_ustr, u"\u03C9"_ustr },
        { u"omicron"_ustr, u"\u03BF"_ustr },
        { u"omid"_ustr, u"\u29B6"_ustr },
        { u"ominus"_ustr, u"\u2296"_ustr },
        { u"oopf"_ustr, u"\U0001D560"_ustr },
        { u"opar"_ustr, u"\u29B7"_ustr },
        { u"operp"_ustr, u"\u29B9"_ustr },
        { u"oplus"_ustr, u"\u2295"_ustr },
        { u"or"_ustr, u"\u2228"_ustr },
        { u"orarr"_ustr, u"\u21BB"_ustr },
        { u"ord"_ustr, u"\u2A5D"_ustr },
        { u"order"_ustr, u"\u2134"_ustr },
        { u"orderof"_ustr, u"\u2134"_ustr },
        { u"ordf"_ustr, u"\u00AA"_ustr },
        { u"ordm"_ustr, u"\u00BA"_ustr },
        { u"origof"_ustr, u"\u22B6"_ustr },
        { u"oror"_ustr, u"\u2A56"_ustr },
        { u"orslope"_ustr, u"\u2A57"_ustr },
        { u"orv"_ustr, u"\u2A5B"_ustr },
        { u"oscr"_ustr, u"\u2134"_ustr },
        { u"oslash"_ustr, u"\u00F8"_ustr },
        { u"osol"_ustr, u"\u2298"_ustr },
        { u"otilde"_ustr, u"\u00F5"_ustr },
        { u"otimes"_ustr, u"\u2297"_ustr },
        { u"otimesas"_ustr, u"\u2A36"_ustr },
        { u"ouml"_ustr, u"\u00F6"_ustr },
        { u"ovbar"_ustr, u"\u233D"_ustr },
        { u"par"_ustr, u"\u2225"_ustr },
        { u"para"_ustr, u"\u00B6"_ustr },
        { u"parallel"_ustr, u"\u2225"_ustr },
        { u"parsim"_ustr, u"\u2AF3"_ustr },
        { u"parsl"_ustr, u"\u2AFD"_ustr },
        { u"part"_ustr, u"\u2202"_ustr },
        { u"pcy"_ustr, u"\u043F"_ustr },
        { u"percnt"_ustr, u"\u0025"_ustr },
        { u"period"_ustr, u"\u002E"_ustr },
        { u"permil"_ustr, u"\u2030"_ustr },
        { u"perp"_ustr, u"\u22A5"_ustr },
        { u"pertenk"_ustr, u"\u2031"_ustr },
        { u"pfr"_ustr, u"\U0001D52D"_ustr },
        { u"phi"_ustr, u"\u03C6"_ustr },
        { u"phiv"_ustr, u"\u03D5"_ustr },
        { u"phmmat"_ustr, u"\u2133"_ustr },
        { u"phone"_ustr, u"\u260E"_ustr },
        { u"pi"_ustr, u"\u03C0"_ustr },
        { u"pitchfork"_ustr, u"\u22D4"_ustr },
        { u"piv"_ustr, u"\u03D6"_ustr },
        { u"planck"_ustr, u"\u210F"_ustr },
        { u"planckh"_ustr, u"\u210E"_ustr },
        { u"plankv"_ustr, u"\u210F"_ustr },
        { u"plus"_ustr, u"\u002B"_ustr },
        { u"plusacir"_ustr, u"\u2A23"_ustr },
        { u"plusb"_ustr, u"\u229E"_ustr },
        { u"pluscir"_ustr, u"\u2A22"_ustr },
        { u"plusdo"_ustr, u"\u2214"_ustr },
        { u"plusdu"_ustr, u"\u2A25"_ustr },
        { u"pluse"_ustr, u"\u2A72"_ustr },
        { u"plusmn"_ustr, u"\u00B1"_ustr },
        { u"plussim"_ustr, u"\u2A26"_ustr },
        { u"plustwo"_ustr, u"\u2A27"_ustr },
        { u"pm"_ustr, u"\u00B1"_ustr },
        { u"pointint"_ustr, u"\u2A15"_ustr },
        { u"popf"_ustr, u"\U0001D561"_ustr },
        { u"pound"_ustr, u"\u00A3"_ustr },
        { u"pr"_ustr, u"\u227A"_ustr },
        { u"prE"_ustr, u"\u2AB3"_ustr },
        { u"prap"_ustr, u"\u2AB7"_ustr },
        { u"prcue"_ustr, u"\u227C"_ustr },
        { u"pre"_ustr, u"\u2AAF"_ustr },
        { u"prec"_ustr, u"\u227A"_ustr },
        { u"precapprox"_ustr, u"\u2AB7"_ustr },
        { u"preccurlyeq"_ustr, u"\u227C"_ustr },
        { u"preceq"_ustr, u"\u2AAF"_ustr },
        { u"precnapprox"_ustr, u"\u2AB9"_ustr },
        { u"precneqq"_ustr, u"\u2AB5"_ustr },
        { u"precnsim"_ustr, u"\u22E8"_ustr },
        { u"precsim"_ustr, u"\u227E"_ustr },
        { u"prime"_ustr, u"\u2032"_ustr },
        { u"primes"_ustr, u"\u2119"_ustr },
        { u"prnE"_ustr, u"\u2AB5"_ustr },
        { u"prnap"_ustr, u"\u2AB9"_ustr },
        { u"prnsim"_ustr, u"\u22E8"_ustr },
        { u"prod"_ustr, u"\u220F"_ustr },
        { u"profalar"_ustr, u"\u232E"_ustr },
        { u"profline"_ustr, u"\u2312"_ustr },
        { u"profsurf"_ustr, u"\u2313"_ustr },
        { u"prop"_ustr, u"\u221D"_ustr },
        { u"propto"_ustr, u"\u221D"_ustr },
        { u"prsim"_ustr, u"\u227E"_ustr },
        { u"prurel"_ustr, u"\u22B0"_ustr },
        { u"pscr"_ustr, u"\U0001D4C5"_ustr },
        { u"psi"_ustr, u"\u03C8"_ustr },
        { u"puncsp"_ustr, u"\u2008"_ustr },
        { u"qfr"_ustr, u"\U0001D52E"_ustr },
        { u"qint"_ustr, u"\u2A0C"_ustr },
        { u"qopf"_ustr, u"\U0001D562"_ustr },
        { u"qprime"_ustr, u"\u2057"_ustr },
        { u"qscr"_ustr, u"\U0001D4C6"_ustr },
        { u"quaternions"_ustr, u"\u210D"_ustr },
        { u"quatint"_ustr, u"\u2A16"_ustr },
        { u"quest"_ustr, u"\u003F"_ustr },
        { u"questeq"_ustr, u"\u225F"_ustr },
        { u"quot"_ustr, u"\u0022"_ustr },
        { u"rAarr"_ustr, u"\u21DB"_ustr },
        { u"rArr"_ustr, u"\u21D2"_ustr },
        { u"rAtail"_ustr, u"\u291C"_ustr },
        { u"rBarr"_ustr, u"\u290F"_ustr },
        { u"rHar"_ustr, u"\u2964"_ustr },
        { u"race"_ustr, u"\u223D\u0331"_ustr },
        { u"racute"_ustr, u"\u0155"_ustr },
        { u"radic"_ustr, u"\u221A"_ustr },
        { u"raemptyv"_ustr, u"\u29B3"_ustr },
        { u"rang"_ustr, u"\u27E9"_ustr },
        { u"rangd"_ustr, u"\u2992"_ustr },
        { u"range"_ustr, u"\u29A5"_ustr },
        { u"rangle"_ustr, u"\u27E9"_ustr },
        { u"raquo"_ustr, u"\u00BB"_ustr },
        { u"rarr"_ustr, u"\u2192"_ustr },
        { u"rarrap"_ustr, u"\u2975"_ustr },
        { u"rarrb"_ustr, u"\u21E5"_ustr },
        { u"rarrbfs"_ustr, u"\u2920"_ustr },
        { u"rarrc"_ustr, u"\u2933"_ustr },
        { u"rarrfs"_ustr, u"\u291E"_ustr },
        { u"rarrhk"_ustr, u"\u21AA"_ustr },
        { u"rarrlp"_ustr, u"\u21AC"_ustr },
        { u"rarrpl"_ustr, u"\u2945"_ustr },
        { u"rarrsim"_ustr, u"\u2974"_ustr },
        { u"rarrtl"_ustr, u"\u21A3"_ustr },
        { u"rarrw"_ustr, u"\u219D"_ustr },
        { u"ratail"_ustr, u"\u291A"_ustr },
        { u"ratio"_ustr, u"\u2236"_ustr },
        { u"rationals"_ustr, u"\u211A"_ustr },
        { u"rbarr"_ustr, u"\u290D"_ustr },
        { u"rbbrk"_ustr, u"\u2773"_ustr },
        { u"rbrace"_ustr, u"\u007D"_ustr },
        { u"rbrack"_ustr, u"\u005D"_ustr },
        { u"rbrke"_ustr, u"\u298C"_ustr },
        { u"rbrksld"_ustr, u"\u298E"_ustr },
        { u"rbrkslu"_ustr, u"\u2990"_ustr },
        { u"rcaron"_ustr, u"\u0159"_ustr },
        { u"rcedil"_ustr, u"\u0157"_ustr },
        { u"rceil"_ustr, u"\u2309"_ustr },
        { u"rcub"_ustr, u"\u007D"_ustr },
        { u"rcy"_ustr, u"\u0440"_ustr },
        { u"rdca"_ustr, u"\u2937"_ustr },
        { u"rdldhar"_ustr, u"\u2969"_ustr },
        { u"rdquo"_ustr, u"\u201D"_ustr },
        { u"rdquor"_ustr, u"\u201D"_ustr },
        { u"rdsh"_ustr, u"\u21B3"_ustr },
        { u"real"_ustr, u"\u211C"_ustr },
        { u"realine"_ustr, u"\u211B"_ustr },
        { u"realpart"_ustr, u"\u211C"_ustr },
        { u"reals"_ustr, u"\u211D"_ustr },
        { u"rect"_ustr, u"\u25AD"_ustr },
        { u"reg"_ustr, u"\u00AE"_ustr },
        { u"rfisht"_ustr, u"\u297D"_ustr },
        { u"rfloor"_ustr, u"\u230B"_ustr },
        { u"rfr"_ustr, u"\U0001D52F"_ustr },
        { u"rhard"_ustr, u"\u21C1"_ustr },
        { u"rharu"_ustr, u"\u21C0"_ustr },
        { u"rharul"_ustr, u"\u296C"_ustr },
        { u"rho"_ustr, u"\u03C1"_ustr },
        { u"rhov"_ustr, u"\u03F1"_ustr },
        { u"rightarrow"_ustr, u"\u2192"_ustr },
        { u"rightarrowtail"_ustr, u"\u21A3"_ustr },
        { u"rightharpoondown"_ustr, u"\u21C1"_ustr },
        { u"rightharpoonup"_ustr, u"\u21C0"_ustr },
        { u"rightleftarrows"_ustr, u"\u21C4"_ustr },
        { u"rightleftharpoons"_ustr, u"\u21CC"_ustr },
        { u"rightrightarrows"_ustr, u"\u21C9"_ustr },
        { u"rightsquigarrow"_ustr, u"\u219D"_ustr },
        { u"rightthreetimes"_ustr, u"\u22CC"_ustr },
        { u"ring"_ustr, u"\u02DA"_ustr },
        { u"risingdotseq"_ustr, u"\u2253"_ustr },
        { u"rlarr"_ustr, u"\u21C4"_ustr },
        { u"rlhar"_ustr, u"\u21CC"_ustr },
        { u"rlm"_ustr, u"\u200F"_ustr },
        { u"rmoust"_ustr, u"\u23B1"_ustr },
        { u"rmoustache"_ustr, u"\u23B1"_ustr },
        { u"rnmid"_ustr, u"\u2AEE"_ustr },
        { u"roang"_ustr, u"\u27ED"_ustr },
        { u"roarr"_ustr, u"\u21FE"_ustr },
        { u"robrk"_ustr, u"\u27E7"_ustr },
        { u"ropar"_ustr, u"\u2986"_ustr },
        { u"ropf"_ustr, u"\U0001D563"_ustr },
        { u"roplus"_ustr, u"\u2A2E"_ustr },
        { u"rotimes"_ustr, u"\u2A35"_ustr },
        { u"rpar"_ustr, u"\u0029"_ustr },
        { u"rpargt"_ustr, u"\u2994"_ustr },
        { u"rppolint"_ustr, u"\u2A12"_ustr },
        { u"rrarr"_ustr, u"\u21C9"_ustr },
        { u"rsaquo"_ustr, u"\u203A"_ustr },
        { u"rscr"_ustr, u"\U0001D4C7"_ustr },
        { u"rsh"_ustr, u"\u21B1"_ustr },
        { u"rsqb"_ustr, u"\u005D"_ustr },
        { u"rsquo"_ustr, u"\u2019"_ustr },
        { u"rsquor"_ustr, u"\u2019"_ustr },
        { u"rthree"_ustr, u"\u22CC"_ustr },
        { u"rtimes"_ustr, u"\u22CA"_ustr },
        { u"rtri"_ustr, u"\u25B9"_ustr },
        { u"rtrie"_ustr, u"\u22B5"_ustr },
        { u"rtrif"_ustr, u"\u25B8"_ustr },
        { u"rtriltri"_ustr, u"\u29CE"_ustr },
        { u"ruluhar"_ustr, u"\u2968"_ustr },
        { u"rx"_ustr, u"\u211E"_ustr },
        { u"sacute"_ustr, u"\u015B"_ustr },
        { u"sbquo"_ustr, u"\u201A"_ustr },
        { u"sc"_ustr, u"\u227B"_ustr },
        { u"scE"_ustr, u"\u2AB4"_ustr },
        { u"scap"_ustr, u"\u2AB8"_ustr },
        { u"scaron"_ustr, u"\u0161"_ustr },
        { u"sccue"_ustr, u"\u227D"_ustr },
        { u"sce"_ustr, u"\u2AB0"_ustr },
        { u"scedil"_ustr, u"\u015F"_ustr },
        { u"scirc"_ustr, u"\u015D"_ustr },
        { u"scnE"_ustr, u"\u2AB6"_ustr },
        { u"scnap"_ustr, u"\u2ABA"_ustr },
        { u"scnsim"_ustr, u"\u22E9"_ustr },
        { u"scpolint"_ustr, u"\u2A13"_ustr },
        { u"scsim"_ustr, u"\u227F"_ustr },
        { u"scy"_ustr, u"\u0441"_ustr },
        { u"sdot"_ustr, u"\u22C5"_ustr },
        { u"sdotb"_ustr, u"\u22A1"_ustr },
        { u"sdote"_ustr, u"\u2A66"_ustr },
        { u"seArr"_ustr, u"\u21D8"_ustr },
        { u"searhk"_ustr, u"\u2925"_ustr },
        { u"searr"_ustr, u"\u2198"_ustr },
        { u"searrow"_ustr, u"\u2198"_ustr },
        { u"sect"_ustr, u"\u00A7"_ustr },
        { u"semi"_ustr, u"\u003B"_ustr },
        { u"seswar"_ustr, u"\u2929"_ustr },
        { u"setminus"_ustr, u"\u2216"_ustr },
        { u"setmn"_ustr, u"\u2216"_ustr },
        { u"sext"_ustr, u"\u2736"_ustr },
        { u"sfr"_ustr, u"\U0001D530"_ustr },
        { u"sfrown"_ustr, u"\u2322"_ustr },
        { u"sharp"_ustr, u"\u266F"_ustr },
        { u"shchcy"_ustr, u"\u0449"_ustr },
        { u"shcy"_ustr, u"\u0448"_ustr },
        { u"shortmid"_ustr, u"\u2223"_ustr },
        { u"shortparallel"_ustr, u"\u2225"_ustr },
        { u"shy"_ustr, u"\u00AD"_ustr },
        { u"sigma"_ustr, u"\u03C3"_ustr },
        { u"sigmaf"_ustr, u"\u03C2"_ustr },
        { u"sigmav"_ustr, u"\u03C2"_ustr },
        { u"sim"_ustr, u"\u223C"_ustr },
        { u"simdot"_ustr, u"\u2A6A"_ustr },
        { u"sime"_ustr, u"\u2243"_ustr },
        { u"simeq"_ustr, u"\u2243"_ustr },
        { u"simg"_ustr, u"\u2A9E"_ustr },
        { u"simgE"_ustr, u"\u2AA0"_ustr },
        { u"siml"_ustr, u"\u2A9D"_ustr },
        { u"simlE"_ustr, u"\u2A9F"_ustr },
        { u"simne"_ustr, u"\u2246"_ustr },
        { u"simplus"_ustr, u"\u2A24"_ustr },
        { u"simrarr"_ustr, u"\u2972"_ustr },
        { u"slarr"_ustr, u"\u2190"_ustr },
        { u"smallsetminus"_ustr, u"\u2216"_ustr },
        { u"smashp"_ustr, u"\u2A33"_ustr },
        { u"smeparsl"_ustr, u"\u29E4"_ustr },
        { u"smid"_ustr, u"\u2223"_ustr },
        { u"smile"_ustr, u"\u2323"_ustr },
        { u"smt"_ustr, u"\u2AAA"_ustr },
        { u"smte"_ustr, u"\u2AAC"_ustr },
        { u"smtes"_ustr, u"\u2AAC\uFE00"_ustr },
        { u"softcy"_ustr, u"\u044C"_ustr },
        { u"sol"_ustr, u"\u002F"_ustr },
        { u"solb"_ustr, u"\u29C4"_ustr },
        { u"solbar"_ustr, u"\u233F"_ustr },
        { u"sopf"_ustr, u"\U0001D564"_ustr },
        { u"spades"_ustr, u"\u2660"_ustr },
        { u"spadesuit"_ustr, u"\u2660"_ustr },
        { u"spar"_ustr, u"\u2225"_ustr },
        { u"sqcap"_ustr, u"\u2293"_ustr },
        { u"sqcaps"_ustr, u"\u2293\uFE00"_ustr },
        { u"sqcup"_ustr, u"\u2294"_ustr },
        { u"sqcups"_ustr, u"\u2294\uFE00"_ustr },
        { u"sqsub"_ustr, u"\u228F"_ustr },
        { u"sqsube"_ustr, u"\u2291"_ustr },
        { u"sqsubset"_ustr, u"\u228F"_ustr },
        { u"sqsubseteq"_ustr, u"\u2291"_ustr },
        { u"sqsup"_ustr, u"\u2290"_ustr },
        { u"sqsupe"_ustr, u"\u2292"_ustr },
        { u"sqsupset"_ustr, u"\u2290"_ustr },
        { u"sqsupseteq"_ustr, u"\u2292"_ustr },
        { u"squ"_ustr, u"\u25A1"_ustr },
        { u"square"_ustr, u"\u25A1"_ustr },
        { u"squarf"_ustr, u"\u25AA"_ustr },
        { u"squf"_ustr, u"\u25AA"_ustr },
        { u"srarr"_ustr, u"\u2192"_ustr },
        { u"sscr"_ustr, u"\U0001D4C8"_ustr },
        { u"ssetmn"_ustr, u"\u2216"_ustr },
        { u"ssmile"_ustr, u"\u2323"_ustr },
        { u"sstarf"_ustr, u"\u22C6"_ustr },
        { u"star"_ustr, u"\u2606"_ustr },
        { u"starf"_ustr, u"\u2605"_ustr },
        { u"straightepsilon"_ustr, u"\u03F5"_ustr },
        { u"straightphi"_ustr, u"\u03D5"_ustr },
        { u"strns"_ustr, u"\u00AF"_ustr },
        { u"sub"_ustr, u"\u2282"_ustr },
        { u"subE"_ustr, u"\u2AC5"_ustr },
        { u"subdot"_ustr, u"\u2ABD"_ustr },
        { u"sube"_ustr, u"\u2286"_ustr },
        { u"subedot"_ustr, u"\u2AC3"_ustr },
        { u"submult"_ustr, u"\u2AC1"_ustr },
        { u"subnE"_ustr, u"\u2ACB"_ustr },
        { u"subne"_ustr, u"\u228A"_ustr },
        { u"subplus"_ustr, u"\u2ABF"_ustr },
        { u"subrarr"_ustr, u"\u2979"_ustr },
        { u"subset"_ustr, u"\u2282"_ustr },
        { u"subseteq"_ustr, u"\u2286"_ustr },
        { u"subseteqq"_ustr, u"\u2AC5"_ustr },
        { u"subsetneq"_ustr, u"\u228A"_ustr },
        { u"subsetneqq"_ustr, u"\u2ACB"_ustr },
        { u"subsim"_ustr, u"\u2AC7"_ustr },
        { u"subsub"_ustr, u"\u2AD5"_ustr },
        { u"subsup"_ustr, u"\u2AD3"_ustr },
        { u"succ"_ustr, u"\u227B"_ustr },
        { u"succapprox"_ustr, u"\u2AB8"_ustr },
        { u"succcurlyeq"_ustr, u"\u227D"_ustr },
        { u"succeq"_ustr, u"\u2AB0"_ustr },
        { u"succnapprox"_ustr, u"\u2ABA"_ustr },
        { u"succneqq"_ustr, u"\u2AB6"_ustr },
        { u"succnsim"_ustr, u"\u22E9"_ustr },
        { u"succsim"_ustr, u"\u227F"_ustr },
        { u"sum"_ustr, u"\u2211"_ustr },
        { u"sung"_ustr, u"\u266A"_ustr },
        { u"sup"_ustr, u"\u2283"_ustr },
        { u"sup1"_ustr, u"\u00B9"_ustr },
        { u"sup2"_ustr, u"\u00B2"_ustr },
        { u"sup3"_ustr, u"\u00B3"_ustr },
        { u"supE"_ustr, u"\u2AC6"_ustr },
        { u"supdot"_ustr, u"\u2ABE"_ustr },
        { u"supdsub"_ustr, u"\u2AD8"_ustr },
        { u"supe"_ustr, u"\u2287"_ustr },
        { u"supedot"_ustr, u"\u2AC4"_ustr },
        { u"suphsol"_ustr, u"\u27C9"_ustr },
        { u"suphsub"_ustr, u"\u2AD7"_ustr },
        { u"suplarr"_ustr, u"\u297B"_ustr },
        { u"supmult"_ustr, u"\u2AC2"_ustr },
        { u"supnE"_ustr, u"\u2ACC"_ustr },
        { u"supne"_ustr, u"\u228B"_ustr },
        { u"supplus"_ustr, u"\u2AC0"_ustr },
        { u"supset"_ustr, u"\u2283"_ustr },
        { u"supseteq"_ustr, u"\u2287"_ustr },
        { u"supseteqq"_ustr, u"\u2AC6"_ustr },
        { u"supsetneq"_ustr, u"\u228B"_ustr },
        { u"supsetneqq"_ustr, u"\u2ACC"_ustr },
        { u"supsim"_ustr, u"\u2AC8"_ustr },
        { u"supsub"_ustr, u"\u2AD4"_ustr },
        { u"supsup"_ustr, u"\u2AD6"_ustr },
        { u"swArr"_ustr, u"\u21D9"_ustr },
        { u"swarhk"_ustr, u"\u2926"_ustr },
        { u"swarr"_ustr, u"\u2199"_ustr },
        { u"swarrow"_ustr, u"\u2199"_ustr },
        { u"swnwar"_ustr, u"\u292A"_ustr },
        { u"szlig"_ustr, u"\u00DF"_ustr },
        { u"target"_ustr, u"\u2316"_ustr },
        { u"tau"_ustr, u"\u03C4"_ustr },
        { u"tbrk"_ustr, u"\u23B4"_ustr },
        { u"tcaron"_ustr, u"\u0165"_ustr },
        { u"tcedil"_ustr, u"\u0163"_ustr },
        { u"tcy"_ustr, u"\u0442"_ustr },
        { u"tdot"_ustr, u"\u20DB"_ustr },
        { u"telrec"_ustr, u"\u2315"_ustr },
        { u"tfr"_ustr, u"\U0001D531"_ustr },
        { u"there4"_ustr, u"\u2234"_ustr },
        { u"therefore"_ustr, u"\u2234"_ustr },
        { u"theta"_ustr, u"\u03B8"_ustr },
        { u"thetasym"_ustr, u"\u03D1"_ustr },
        { u"thetav"_ustr, u"\u03D1"_ustr },
        { u"thickapprox"_ustr, u"\u2248"_ustr },
        { u"thicksim"_ustr, u"\u223C"_ustr },
        { u"thinsp"_ustr, u"\u2009"_ustr },
        { u"thkap"_ustr, u"\u2248"_ustr },
        { u"thksim"_ustr, u"\u223C"_ustr },
        { u"thorn"_ustr, u"\u00FE"_ustr },
        { u"tilde"_ustr, u"\u02DC"_ustr },
        { u"times"_ustr, u"\u00D7"_ustr },
        { u"timesb"_ustr, u"\u22A0"_ustr },
        { u"timesbar"_ustr, u"\u2A31"_ustr },
        { u"timesd"_ustr, u"\u2A30"_ustr },
        { u"tint"_ustr, u"\u222D"_ustr },
        { u"toea"_ustr, u"\u2928"_ustr },
        { u"top"_ustr, u"\u22A4"_ustr },
        { u"topbot"_ustr, u"\u2336"_ustr },
        { u"topcir"_ustr, u"\u2AF1"_ustr },
        { u"topf"_ustr, u"\U0001D565"_ustr },
        { u"topfork"_ustr, u"\u2ADA"_ustr },
        { u"tosa"_ustr, u"\u2929"_ustr },
        { u"tprime"_ustr, u"\u2034"_ustr },
        { u"trade"_ustr, u"\u2122"_ustr },
        { u"triangle"_ustr, u"\u25B5"_ustr },
        { u"triangledown"_ustr, u"\u25BF"_ustr },
        { u"triangleleft"_ustr, u"\u25C3"_ustr },
        { u"trianglelefteq"_ustr, u"\u22B4"_ustr },
        { u"triangleq"_ustr, u"\u225C"_ustr },
        { u"triangleright"_ustr, u"\u25B9"_ustr },
        { u"trianglerighteq"_ustr, u"\u22B5"_ustr },
        { u"tridot"_ustr, u"\u25EC"_ustr },
        { u"trie"_ustr, u"\u225C"_ustr },
        { u"triminus"_ustr, u"\u2A3A"_ustr },
        { u"triplus"_ustr, u"\u2A39"_ustr },
        { u"trisb"_ustr, u"\u29CD"_ustr },
        { u"tritime"_ustr, u"\u2A3B"_ustr },
        { u"trpezium"_ustr, u"\u23E2"_ustr },
        { u"tscr"_ustr, u"\U0001D4C9"_ustr },
        { u"tscy"_ustr, u"\u0446"_ustr },
        { u"tshcy"_ustr, u"\u045B"_ustr },
        { u"tstrok"_ustr, u"\u0167"_ustr },
        { u"twixt"_ustr, u"\u226C"_ustr },
        { u"twoheadleftarrow"_ustr, u"\u219E"_ustr },
        { u"twoheadrightarrow"_ustr, u"\u21A0"_ustr },
        { u"uArr"_ustr, u"\u21D1"_ustr },
        { u"uHar"_ustr, u"\u2963"_ustr },
        { u"uacute"_ustr, u"\u00FA"_ustr },
        { u"uarr"_ustr, u"\u2191"_ustr },
        { u"ubrcy"_ustr, u"\u045E"_ustr },
        { u"ubreve"_ustr, u"\u016D"_ustr },
        { u"ucirc"_ustr, u"\u00FB"_ustr },
        { u"ucy"_ustr, u"\u0443"_ustr },
        { u"udarr"_ustr, u"\u21C5"_ustr },
        { u"udblac"_ustr, u"\u0171"_ustr },
        { u"udhar"_ustr, u"\u296E"_ustr },
        { u"ufisht"_ustr, u"\u297E"_ustr },
        { u"ufr"_ustr, u"\U0001D532"_ustr },
        { u"ugrave"_ustr, u"\u00F9"_ustr },
        { u"uharl"_ustr, u"\u21BF"_ustr },
        { u"uharr"_ustr, u"\u21BE"_ustr },
        { u"uhblk"_ustr, u"\u2580"_ustr },
        { u"ulcorn"_ustr, u"\u231C"_ustr },
        { u"ulcorner"_ustr, u"\u231C"_ustr },
        { u"ulcrop"_ustr, u"\u230F"_ustr },
        { u"ultri"_ustr, u"\u25F8"_ustr },
        { u"umacr"_ustr, u"\u016B"_ustr },
        { u"uml"_ustr, u"\u00A8"_ustr },
        { u"uogon"_ustr, u"\u0173"_ustr },
        { u"uopf"_ustr, u"\U0001D566"_ustr },
        { u"uparrow"_ustr, u"\u2191"_ustr },
        { u"updownarrow"_ustr, u"\u2195"_ustr },
        { u"upharpoonleft"_ustr, u"\u21BF"_ustr },
        { u"upharpoonright"_ustr, u"\u21BE"_ustr },
        { u"uplus"_ustr, u"\u228E"_ustr },
        { u"upsi"_ustr, u"\u03C5"_ustr },
        { u"upsih"_ustr, u"\u03D2"_ustr },
        { u"upsilon"_ustr, u"\u03C5"_ustr },
        { u"upuparrows"_ustr, u"\u21C8"_ustr },
        { u"urcorn"_ustr, u"\u231D"_ustr },
        { u"urcorner"_ustr, u"\u231D"_ustr },
        { u"urcrop"_ustr, u"\u230E"_ustr },
        { u"uring"_ustr, u"\u016F"_ustr },
        { u"urtri"_ustr, u"\u25F9"_ustr },
        { u"uscr"_ustr, u"\U0001D4CA"_ustr },
        { u"utdot"_ustr, u"\u22F0"_ustr },
        { u"utilde"_ustr, u"\u0169"_ustr },
        { u"utri"_ustr, u"\u25B5"_ustr },
        { u"utrif"_ustr, u"\u25B4"_ustr },
        { u"uuarr"_ustr, u"\u21C8"_ustr },
        { u"uuml"_ustr, u"\u00FC"_ustr },
        { u"uwangle"_ustr, u"\u29A7"_ustr },
        { u"vArr"_ustr, u"\u21D5"_ustr },
        { u"vBar"_ustr, u"\u2AE8"_ustr },
        { u"vBarv"_ustr, u"\u2AE9"_ustr },
        { u"vDash"_ustr, u"\u22A8"_ustr },
        { u"vangrt"_ustr, u"\u299C"_ustr },
        { u"varepsilon"_ustr, u"\u03F5"_ustr },
        { u"varkappa"_ustr, u"\u03F0"_ustr },
        { u"varnothing"_ustr, u"\u2205"_ustr },
        { u"varphi"_ustr, u"\u03D5"_ustr },
        { u"varpi"_ustr, u"\u03D6"_ustr },
        { u"varpropto"_ustr, u"\u221D"_ustr },
        { u"varr"_ustr, u"\u2195"_ustr },
        { u"varrho"_ustr, u"\u03F1"_ustr },
        { u"varsigma"_ustr, u"\u03C2"_ustr },
        { u"varsubsetneq"_ustr, u"\u228A\uFE00"_ustr },
        { u"varsubsetneqq"_ustr, u"\u2ACB\uFE00"_ustr },
        { u"varsupsetneq"_ustr, u"\u228B\uFE00"_ustr },
        { u"varsupsetneqq"_ustr, u"\u2ACC\uFE00"_ustr },
        { u"vartheta"_ustr, u"\u03D1"_ustr },
        { u"vartriangleleft"_ustr, u"\u22B2"_ustr },
        { u"vartriangleright"_ustr, u"\u22B3"_ustr },
        { u"vcy"_ustr, u"\u0432"_ustr },
        { u"vdash"_ustr, u"\u22A2"_ustr },
        { u"vee"_ustr, u"\u2228"_ustr },
        { u"veebar"_ustr, u"\u22BB"_ustr },
        { u"veeeq"_ustr, u"\u225A"_ustr },
        { u"vellip"_ustr, u"\u22EE"_ustr },
        { u"verbar"_ustr, u"\u007C"_ustr },
        { u"vert"_ustr, u"\u007C"_ustr },
        { u"vfr"_ustr, u"\U0001D533"_ustr },
        { u"vltri"_ustr, u"\u22B2"_ustr },
        { u"vnsub"_ustr, u"\u2282\u20D2"_ustr },
        { u"vnsup"_ustr, u"\u2283\u20D2"_ustr },
        { u"vopf"_ustr, u"\U0001D567"_ustr },
        { u"vprop"_ustr, u"\u221D"_ustr },
        { u"vrtri"_ustr, u"\u22B3"_ustr },
        { u"vscr"_ustr, u"\U0001D4CB"_ustr },
        { u"vsubnE"_ustr, u"\u2ACB\uFE00"_ustr },
        { u"vsubne"_ustr, u"\u228A\uFE00"_ustr },
        { u"vsupnE"_ustr, u"\u2ACC\uFE00"_ustr },
        { u"vsupne"_ustr, u"\u228B\uFE00"_ustr },
        { u"vzigzag"_ustr, u"\u299A"_ustr },
        { u"wcirc"_ustr, u"\u0175"_ustr },
        { u"wedbar"_ustr, u"\u2A5F"_ustr },
        { u"wedge"_ustr, u"\u2227"_ustr },
        { u"wedgeq"_ustr, u"\u2259"_ustr },
        { u"weierp"_ustr, u"\u2118"_ustr },
        { u"wfr"_ustr, u"\U0001D534"_ustr },
        { u"wopf"_ustr, u"\U0001D568"_ustr },
        { u"wp"_ustr, u"\u2118"_ustr },
        { u"wr"_ustr, u"\u2240"_ustr },
        { u"wreath"_ustr, u"\u2240"_ustr },
        { u"wscr"_ustr, u"\U0001D4CC"_ustr },
        { u"xcap"_ustr, u"\u22C2"_ustr },
        { u"xcirc"_ustr, u"\u25EF"_ustr },
        { u"xcup"_ustr, u"\u22C3"_ustr },
        { u"xdtri"_ustr, u"\u25BD"_ustr },
        { u"xfr"_ustr, u"\U0001D535"_ustr },
        { u"xhArr"_ustr, u"\u27FA"_ustr },
        { u"xharr"_ustr, u"\u27F7"_ustr },
        { u"xi"_ustr, u"\u03BE"_ustr },
        { u"xlArr"_ustr, u"\u27F8"_ustr },
        { u"xlarr"_ustr, u"\u27F5"_ustr },
        { u"xmap"_ustr, u"\u27FC"_ustr },
        { u"xnis"_ustr, u"\u22FB"_ustr },
        { u"xodot"_ustr, u"\u2A00"_ustr },
        { u"xopf"_ustr, u"\U0001D569"_ustr },
        { u"xoplus"_ustr, u"\u2A01"_ustr },
        { u"xotime"_ustr, u"\u2A02"_ustr },
        { u"xrArr"_ustr, u"\u27F9"_ustr },
        { u"xrarr"_ustr, u"\u27F6"_ustr },
        { u"xscr"_ustr, u"\U0001D4CD"_ustr },
        { u"xsqcup"_ustr, u"\u2A06"_ustr },
        { u"xuplus"_ustr, u"\u2A04"_ustr },
        { u"xutri"_ustr, u"\u25B3"_ustr },
        { u"xvee"_ustr, u"\u22C1"_ustr },
        { u"xwedge"_ustr, u"\u22C0"_ustr },
        { u"yacute"_ustr, u"\u00FD"_ustr },
        { u"yacy"_ustr, u"\u044F"_ustr },
        { u"ycirc"_ustr, u"\u0177"_ustr },
        { u"ycy"_ustr, u"\u044B"_ustr },
        { u"yen"_ustr, u"\u00A5"_ustr },
        { u"yfr"_ustr, u"\U0001D536"_ustr },
        { u"yicy"_ustr, u"\u0457"_ustr },
        { u"yopf"_ustr, u"\U0001D56A"_ustr },
        { u"yscr"_ustr, u"\U0001D4CE"_ustr },
        { u"yucy"_ustr, u"\u044E"_ustr },
        { u"yuml"_ustr, u"\u00FF"_ustr },
        { u"zacute"_ustr, u"\u017A"_ustr },
        { u"zcaron"_ustr, u"\u017E"_ustr },
        { u"zcy"_ustr, u"\u0437"_ustr },
        { u"zdot"_ustr, u"\u017C"_ustr },
        { u"zeetrf"_ustr, u"\u2128"_ustr },
        { u"zeta"_ustr, u"\u03B6"_ustr },
        { u"zfr"_ustr, u"\U0001D537"_ustr },
        { u"zhcy"_ustr, u"\u0436"_ustr },
        { u"zigrarr"_ustr, u"\u21DD"_ustr },
        { u"zopf"_ustr, u"\U0001D56B"_ustr },
        { u"zscr"_ustr, u"\U0001D4CF"_ustr },
        { u"zwj"_ustr, u"\u200D"_ustr },
        { u"zwnj"_ustr, u"\u200C"_ustr }
        // clang-format on
    };

const ::css::uno::Sequence<::css::beans::Pair<OUString, OUString>>
    starmathdatabase::icustomMathmlHtmlEntities(
        icustomMathmlHtmlEntitiesData, starmathdatabase::STARMATH_MATHMLHTML_ENTITY_NUMBER);

static ::css::beans::Pair<::rtl::OUString, ::rtl::OUString>
    icustomMathmlHtmlEntitiesNamesExportData[2] = {
        // clang-format off
        { u"&sigma;"_ustr, u"\u03C3"_ustr},
        { u"&infin;"_ustr, u"\u221E"_ustr}
        // clang-format on
    };
const ::css::uno::Sequence<::css::beans::Pair<::rtl::OUString, ::rtl::OUString>>
    starmathdatabase::icustomMathmlHtmlEntitiesExport(icustomMathmlHtmlEntitiesNamesExportData, 2);

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
