/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0014(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0014, 0x0023), ElementsDictionaryEntry("CAD File Format", "CADFileFormat",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0024), ElementsDictionaryEntry("Component Reference System", "ComponentReferenceSystem",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0025), ElementsDictionaryEntry("Component Manufacturing Procedure", "ComponentManufacturingProcedure",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0028), ElementsDictionaryEntry("Component Manufacturer", "ComponentManufacturer",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0030), ElementsDictionaryEntry("Material Thickness", "MaterialThickness",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x0032), ElementsDictionaryEntry("Material Pipe Diameter", "MaterialPipeDiameter",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x0034), ElementsDictionaryEntry("Material Isolation Diameter", "MaterialIsolationDiameter",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x0042), ElementsDictionaryEntry("Material Grade", "MaterialGrade",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0044), ElementsDictionaryEntry("Material Properties Description", "MaterialPropertiesDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0045), ElementsDictionaryEntry("Material Properties File Format (Retired)", "MaterialPropertiesFileFormatRetired",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0046), ElementsDictionaryEntry("Material Notes", "MaterialNotes",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0050), ElementsDictionaryEntry("Component Shape", "ComponentShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0052), ElementsDictionaryEntry("Curvature Type", "CurvatureType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0054), ElementsDictionaryEntry("Outer Diameter", "OuterDiameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0056), ElementsDictionaryEntry("Inner Diameter", "InnerDiameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0100), ElementsDictionaryEntry("Component Welder IDs", "ComponentWelderIDs",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x0101), ElementsDictionaryEntry("Secondary Approval Status", "SecondaryApprovalStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0102), ElementsDictionaryEntry("Secondary Review Date", "SecondaryReviewDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0103), ElementsDictionaryEntry("Secondary Review Time", "SecondaryReviewTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0104), ElementsDictionaryEntry("Secondary Reviewer Name", "SecondaryReviewerName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0105), ElementsDictionaryEntry("Repair ID", "RepairID",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0106), ElementsDictionaryEntry("Multiple Component Approval Sequence", "MultipleComponentApprovalSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x0107), ElementsDictionaryEntry("Other Approval Status", "OtherApprovalStatus",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x0108), ElementsDictionaryEntry("Other Secondary Approval Status", "OtherSecondaryApprovalStatus",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x1010), ElementsDictionaryEntry("Actual Environmental Conditions", "ActualEnvironmentalConditions",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x1020), ElementsDictionaryEntry("Expiry Date", "ExpiryDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x1040), ElementsDictionaryEntry("Environmental Conditions", "EnvironmentalConditions",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2002), ElementsDictionaryEntry("Evaluator Sequence", "EvaluatorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2004), ElementsDictionaryEntry("Evaluator Number", "EvaluatorNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2006), ElementsDictionaryEntry("Evaluator Name", "EvaluatorName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2008), ElementsDictionaryEntry("Evaluation Attempt", "EvaluationAttempt",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2012), ElementsDictionaryEntry("Indication Sequence", "IndicationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2014), ElementsDictionaryEntry("Indication Number", "IndicationNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2016), ElementsDictionaryEntry("Indication Label", "IndicationLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2018), ElementsDictionaryEntry("Indication Description", "IndicationDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x201a), ElementsDictionaryEntry("Indication Type", "IndicationType",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x201c), ElementsDictionaryEntry("Indication Disposition", "IndicationDisposition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x201e), ElementsDictionaryEntry("Indication ROI Sequence", "IndicationROISequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2030), ElementsDictionaryEntry("Indication Physical Property Sequence", "IndicationPhysicalPropertySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2032), ElementsDictionaryEntry("Property Label", "PropertyLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2202), ElementsDictionaryEntry("Coordinate System Number of Axes", "CoordinateSystemNumberOfAxes",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2204), ElementsDictionaryEntry("Coordinate System Axes Sequence", "CoordinateSystemAxesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2206), ElementsDictionaryEntry("Coordinate System Axis Description", "CoordinateSystemAxisDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2208), ElementsDictionaryEntry("Coordinate System Data Set Mapping", "CoordinateSystemDataSetMapping",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x220a), ElementsDictionaryEntry("Coordinate System Axis Number", "CoordinateSystemAxisNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x220c), ElementsDictionaryEntry("Coordinate System Axis Type", "CoordinateSystemAxisType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x220e), ElementsDictionaryEntry("Coordinate System Axis Units", "CoordinateSystemAxisUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2210), ElementsDictionaryEntry("Coordinate System Axis Values", "CoordinateSystemAxisValues",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2220), ElementsDictionaryEntry("Coordinate System Transform Sequence", "CoordinateSystemTransformSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2222), ElementsDictionaryEntry("Transform Description", "TransformDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2224), ElementsDictionaryEntry("Transform Number of Axes", "TransformNumberOfAxes",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x2226), ElementsDictionaryEntry("Transform Order of Axes", "TransformOrderOfAxes",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x2228), ElementsDictionaryEntry("Transformed Axis Units", "TransformedAxisUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x222a), ElementsDictionaryEntry("Coordinate System Transform Rotation and Scale Matrix", "CoordinateSystemTransformRotationAndScaleMatrix",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x222c), ElementsDictionaryEntry("Coordinate System Transform Translation Matrix", "CoordinateSystemTransformTranslationMatrix",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x3011), ElementsDictionaryEntry("Internal Detector Frame Time", "InternalDetectorFrameTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3012), ElementsDictionaryEntry("Number of Frames Integrated", "NumberOfFramesIntegrated",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3020), ElementsDictionaryEntry("Detector Temperature Sequence", "DetectorTemperatureSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3022), ElementsDictionaryEntry("Sensor Name", "SensorName",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3024), ElementsDictionaryEntry("Horizontal Offset of Sensor", "HorizontalOffsetOfSensor",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3026), ElementsDictionaryEntry("Vertical Offset of Sensor", "VerticalOffsetOfSensor",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3028), ElementsDictionaryEntry("Sensor Temperature", "SensorTemperature",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3040), ElementsDictionaryEntry("Dark Current Sequence", "DarkCurrentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3050), ElementsDictionaryEntry("Dark Current Counts", "DarkCurrentCounts",  "OB or OW", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3060), ElementsDictionaryEntry("Gain Correction Reference Sequence", "GainCorrectionReferenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3070), ElementsDictionaryEntry("Air Counts", "AirCounts",  "OB or OW", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3071), ElementsDictionaryEntry("KV Used in Gain Calibration", "KVUsedInGainCalibration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3072), ElementsDictionaryEntry("MA Used in Gain Calibration", "MAUsedInGainCalibration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3073), ElementsDictionaryEntry("Number of Frames Used for Integration", "NumberOfFramesUsedForIntegration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3074), ElementsDictionaryEntry("Filter Material Used in Gain Calibration", "FilterMaterialUsedInGainCalibration",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3075), ElementsDictionaryEntry("Filter Thickness Used in Gain Calibration", "FilterThicknessUsedInGainCalibration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3076), ElementsDictionaryEntry("Date of Gain Calibration", "DateOfGainCalibration",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3077), ElementsDictionaryEntry("Time of Gain Calibration", "TimeOfGainCalibration",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3080), ElementsDictionaryEntry("Bad Pixel Image", "BadPixelImage",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3099), ElementsDictionaryEntry("Calibration Notes", "CalibrationNotes",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3100), ElementsDictionaryEntry("Linearity Correction Technique", "LinearityCorrectionTechnique",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x3101), ElementsDictionaryEntry("Beam Hardening Correction Technique", "BeamHardeningCorrectionTechnique",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4002), ElementsDictionaryEntry("Pulser Equipment Sequence", "PulserEquipmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4004), ElementsDictionaryEntry("Pulser Type", "PulserType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4006), ElementsDictionaryEntry("Pulser Notes", "PulserNotes",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4008), ElementsDictionaryEntry("Receiver Equipment Sequence", "ReceiverEquipmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x400a), ElementsDictionaryEntry("Amplifier Type", "AmplifierType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x400c), ElementsDictionaryEntry("Receiver Notes", "ReceiverNotes",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x400e), ElementsDictionaryEntry("Pre-Amplifier Equipment Sequence", "PreAmplifierEquipmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x400f), ElementsDictionaryEntry("Pre-Amplifier Notes", "PreAmplifierNotes",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4010), ElementsDictionaryEntry("Transmit Transducer Sequence", "TransmitTransducerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4011), ElementsDictionaryEntry("Receive Transducer Sequence", "ReceiveTransducerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4012), ElementsDictionaryEntry("Number of Elements", "NumberOfElements",  "US", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4013), ElementsDictionaryEntry("Element Shape", "ElementShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4014), ElementsDictionaryEntry("Element Dimension A", "ElementDimensionA",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4015), ElementsDictionaryEntry("Element Dimension B", "ElementDimensionB",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4016), ElementsDictionaryEntry("Element Pitch A", "ElementPitchA",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4017), ElementsDictionaryEntry("Measured Beam Dimension A", "MeasuredBeamDimensionA",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4018), ElementsDictionaryEntry("Measured Beam Dimension B", "MeasuredBeamDimensionB",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4019), ElementsDictionaryEntry("Location of Measured Beam Diameter", "LocationOfMeasuredBeamDiameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x401a), ElementsDictionaryEntry("Nominal Frequency", "NominalFrequency",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x401b), ElementsDictionaryEntry("Measured Center Frequency", "MeasuredCenterFrequency",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x401c), ElementsDictionaryEntry("Measured Bandwidth", "MeasuredBandwidth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x401d), ElementsDictionaryEntry("Element Pitch B", "ElementPitchB",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4020), ElementsDictionaryEntry("Pulser Settings Sequence", "PulserSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4022), ElementsDictionaryEntry("Pulse Width", "PulseWidth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4024), ElementsDictionaryEntry("Excitation Frequency", "ExcitationFrequency",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4026), ElementsDictionaryEntry("Modulation Type", "ModulationType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4028), ElementsDictionaryEntry("Damping", "Damping",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4030), ElementsDictionaryEntry("Receiver Settings Sequence", "ReceiverSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4031), ElementsDictionaryEntry("Acquired Soundpath Length", "AcquiredSoundpathLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4032), ElementsDictionaryEntry("Acquisition Compression Type", "AcquisitionCompressionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4033), ElementsDictionaryEntry("Acquisition Sample Size", "AcquisitionSampleSize",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4034), ElementsDictionaryEntry("Rectifier Smoothing", "RectifierSmoothing",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4035), ElementsDictionaryEntry("DAC Sequence", "DACSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4036), ElementsDictionaryEntry("DAC Type", "DACType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4038), ElementsDictionaryEntry("DAC Gain Points", "DACGainPoints",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x403a), ElementsDictionaryEntry("DAC Time Points", "DACTimePoints",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x403c), ElementsDictionaryEntry("DAC Amplitude", "DACAmplitude",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x4040), ElementsDictionaryEntry("Pre-Amplifier Settings Sequence", "PreAmplifierSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4050), ElementsDictionaryEntry("Transmit Transducer Settings Sequence", "TransmitTransducerSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4051), ElementsDictionaryEntry("Receive Transducer Settings Sequence", "ReceiveTransducerSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4052), ElementsDictionaryEntry("Incident Angle", "IncidentAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4054), ElementsDictionaryEntry("Coupling Technique", "CouplingTechnique",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4056), ElementsDictionaryEntry("Coupling Medium", "CouplingMedium",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4057), ElementsDictionaryEntry("Coupling Velocity", "CouplingVelocity",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4058), ElementsDictionaryEntry("Probe Center Location X", "ProbeCenterLocationX",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4059), ElementsDictionaryEntry("Probe Center Location Z", "ProbeCenterLocationZ",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x405a), ElementsDictionaryEntry("Sound Path Length", "SoundPathLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x405c), ElementsDictionaryEntry("Delay Law Identifier", "DelayLawIdentifier",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4060), ElementsDictionaryEntry("Gate Settings Sequence", "GateSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4062), ElementsDictionaryEntry("Gate Threshold", "GateThreshold",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4064), ElementsDictionaryEntry("Velocity of Sound", "VelocityOfSound",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4070), ElementsDictionaryEntry("Calibration Settings Sequence", "CalibrationSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4072), ElementsDictionaryEntry("Calibration Procedure", "CalibrationProcedure",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4074), ElementsDictionaryEntry("Procedure Version", "ProcedureVersion",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4076), ElementsDictionaryEntry("Procedure Creation Date", "ProcedureCreationDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4078), ElementsDictionaryEntry("Procedure Expiration Date", "ProcedureExpirationDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x407a), ElementsDictionaryEntry("Procedure Last Modified Date", "ProcedureLastModifiedDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x407c), ElementsDictionaryEntry("Calibration Time", "CalibrationTime",  "TM", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x407e), ElementsDictionaryEntry("Calibration Date", "CalibrationDate",  "DA", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x4080), ElementsDictionaryEntry("Probe Drive Equipment Sequence", "ProbeDriveEquipmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4081), ElementsDictionaryEntry("Drive Type", "DriveType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4082), ElementsDictionaryEntry("Probe Drive Notes", "ProbeDriveNotes",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4083), ElementsDictionaryEntry("Drive Probe Sequence", "DriveProbeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4084), ElementsDictionaryEntry("Probe Inductance", "ProbeInductance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4085), ElementsDictionaryEntry("Probe Resistance", "ProbeResistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4086), ElementsDictionaryEntry("Receive Probe Sequence", "ReceiveProbeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4087), ElementsDictionaryEntry("Probe Drive Settings Sequence", "ProbeDriveSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4088), ElementsDictionaryEntry("Bridge Resistors", "BridgeResistors",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4089), ElementsDictionaryEntry("Probe Orientation Angle", "ProbeOrientationAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x408b), ElementsDictionaryEntry("User Selected Gain Y", "UserSelectedGainY",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x408c), ElementsDictionaryEntry("User Selected Phase", "UserSelectedPhase",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x408d), ElementsDictionaryEntry("User Selected Offset X", "UserSelectedOffsetX",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x408e), ElementsDictionaryEntry("User Selected Offset Y", "UserSelectedOffsetY",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4091), ElementsDictionaryEntry("Channel Settings Sequence", "ChannelSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x4092), ElementsDictionaryEntry("Channel Threshold", "ChannelThreshold",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x409a), ElementsDictionaryEntry("Scanner Settings Sequence", "ScannerSettingsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x409b), ElementsDictionaryEntry("Scan Procedure", "ScanProcedure",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x409c), ElementsDictionaryEntry("Translation Rate X", "TranslationRateX",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x409d), ElementsDictionaryEntry("Translation Rate Y", "TranslationRateY",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x409f), ElementsDictionaryEntry("Channel Overlap", "ChannelOverlap",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x40a0), ElementsDictionaryEntry("Image Quality Indicator Type", "ImageQualityIndicatorType",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x40a1), ElementsDictionaryEntry("Image Quality Indicator Material", "ImageQualityIndicatorMaterial",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x40a2), ElementsDictionaryEntry("Image Quality Indicator Size", "ImageQualityIndicatorSize",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0014, 0x5002), ElementsDictionaryEntry("LINAC Energy", "LINACEnergy",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5004), ElementsDictionaryEntry("LINAC Output", "LINACOutput",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5100), ElementsDictionaryEntry("Active Aperture", "ActiveAperture",  "US", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5101), ElementsDictionaryEntry("Total Aperture", "TotalAperture",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5102), ElementsDictionaryEntry("Aperture Elevation", "ApertureElevation",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5103), ElementsDictionaryEntry("Main Lobe Angle", "MainLobeAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5104), ElementsDictionaryEntry("Main Roof Angle", "MainRoofAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5105), ElementsDictionaryEntry("Connector Type", "ConnectorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5106), ElementsDictionaryEntry("Wedge Model Number", "WedgeModelNumber",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5107), ElementsDictionaryEntry("Wedge Angle Float", "WedgeAngleFloat",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5108), ElementsDictionaryEntry("Wedge Roof Angle", "WedgeRoofAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5109), ElementsDictionaryEntry("Wedge Element 1 Position", "WedgeElement1Position",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x510a), ElementsDictionaryEntry("Wedge Material Velocity", "WedgeMaterialVelocity",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x510b), ElementsDictionaryEntry("Wedge Material", "WedgeMaterial",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x510c), ElementsDictionaryEntry("Wedge Offset Z", "WedgeOffsetZ",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x510d), ElementsDictionaryEntry("Wedge Origin Offset X", "WedgeOriginOffsetX",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x510e), ElementsDictionaryEntry("Wedge Time Delay", "WedgeTimeDelay",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x510f), ElementsDictionaryEntry("Wedge Name", "WedgeName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5110), ElementsDictionaryEntry("Wedge Manufacturer Name", "WedgeManufacturerName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5111), ElementsDictionaryEntry("Wedge Description", "WedgeDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5112), ElementsDictionaryEntry("Nominal Beam Angle", "NominalBeamAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5113), ElementsDictionaryEntry("Wedge Offset X", "WedgeOffsetX",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5114), ElementsDictionaryEntry("Wedge Offset Y", "WedgeOffsetY",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5115), ElementsDictionaryEntry("Wedge Total Length", "WedgeTotalLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5116), ElementsDictionaryEntry("Wedge In Contact Length", "WedgeInContactLength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5117), ElementsDictionaryEntry("Wedge Front Gap", "WedgeFrontGap",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5118), ElementsDictionaryEntry("Wedge Total Height", "WedgeTotalHeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x5119), ElementsDictionaryEntry("Wedge Front Height", "WedgeFrontHeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x511a), ElementsDictionaryEntry("Wedge Rear Height", "WedgeRearHeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x511b), ElementsDictionaryEntry("Wedge Total Width", "WedgeTotalWidth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x511c), ElementsDictionaryEntry("Wedge In Contact Width", "WedgeInContactWidth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x511d), ElementsDictionaryEntry("Wedge Chamfer Height", "WedgeChamferHeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x511e), ElementsDictionaryEntry("Wedge Curve", "WedgeCurve",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0014, 0x511f), ElementsDictionaryEntry("Radius Along the Wedge", "RadiusAlongWedge",  "DS", "1"));

    public_tags.emplace("CADFileFormat", Tag(0x0014, 0x0023));
    public_tags.emplace("ComponentReferenceSystem", Tag(0x0014, 0x0024));
    public_tags.emplace("ComponentManufacturingProcedure", Tag(0x0014, 0x0025));
    public_tags.emplace("ComponentManufacturer", Tag(0x0014, 0x0028));
    public_tags.emplace("MaterialThickness", Tag(0x0014, 0x0030));
    public_tags.emplace("MaterialPipeDiameter", Tag(0x0014, 0x0032));
    public_tags.emplace("MaterialIsolationDiameter", Tag(0x0014, 0x0034));
    public_tags.emplace("MaterialGrade", Tag(0x0014, 0x0042));
    public_tags.emplace("MaterialPropertiesDescription", Tag(0x0014, 0x0044));
    public_tags.emplace("MaterialPropertiesFileFormatRetired", Tag(0x0014, 0x0045));
    public_tags.emplace("MaterialNotes", Tag(0x0014, 0x0046));
    public_tags.emplace("ComponentShape", Tag(0x0014, 0x0050));
    public_tags.emplace("CurvatureType", Tag(0x0014, 0x0052));
    public_tags.emplace("OuterDiameter", Tag(0x0014, 0x0054));
    public_tags.emplace("InnerDiameter", Tag(0x0014, 0x0056));
    public_tags.emplace("ComponentWelderIDs", Tag(0x0014, 0x0100));
    public_tags.emplace("SecondaryApprovalStatus", Tag(0x0014, 0x0101));
    public_tags.emplace("SecondaryReviewDate", Tag(0x0014, 0x0102));
    public_tags.emplace("SecondaryReviewTime", Tag(0x0014, 0x0103));
    public_tags.emplace("SecondaryReviewerName", Tag(0x0014, 0x0104));
    public_tags.emplace("RepairID", Tag(0x0014, 0x0105));
    public_tags.emplace("MultipleComponentApprovalSequence", Tag(0x0014, 0x0106));
    public_tags.emplace("OtherApprovalStatus", Tag(0x0014, 0x0107));
    public_tags.emplace("OtherSecondaryApprovalStatus", Tag(0x0014, 0x0108));
    public_tags.emplace("ActualEnvironmentalConditions", Tag(0x0014, 0x1010));
    public_tags.emplace("ExpiryDate", Tag(0x0014, 0x1020));
    public_tags.emplace("EnvironmentalConditions", Tag(0x0014, 0x1040));
    public_tags.emplace("EvaluatorSequence", Tag(0x0014, 0x2002));
    public_tags.emplace("EvaluatorNumber", Tag(0x0014, 0x2004));
    public_tags.emplace("EvaluatorName", Tag(0x0014, 0x2006));
    public_tags.emplace("EvaluationAttempt", Tag(0x0014, 0x2008));
    public_tags.emplace("IndicationSequence", Tag(0x0014, 0x2012));
    public_tags.emplace("IndicationNumber", Tag(0x0014, 0x2014));
    public_tags.emplace("IndicationLabel", Tag(0x0014, 0x2016));
    public_tags.emplace("IndicationDescription", Tag(0x0014, 0x2018));
    public_tags.emplace("IndicationType", Tag(0x0014, 0x201a));
    public_tags.emplace("IndicationDisposition", Tag(0x0014, 0x201c));
    public_tags.emplace("IndicationROISequence", Tag(0x0014, 0x201e));
    public_tags.emplace("IndicationPhysicalPropertySequence", Tag(0x0014, 0x2030));
    public_tags.emplace("PropertyLabel", Tag(0x0014, 0x2032));
    public_tags.emplace("CoordinateSystemNumberOfAxes", Tag(0x0014, 0x2202));
    public_tags.emplace("CoordinateSystemAxesSequence", Tag(0x0014, 0x2204));
    public_tags.emplace("CoordinateSystemAxisDescription", Tag(0x0014, 0x2206));
    public_tags.emplace("CoordinateSystemDataSetMapping", Tag(0x0014, 0x2208));
    public_tags.emplace("CoordinateSystemAxisNumber", Tag(0x0014, 0x220a));
    public_tags.emplace("CoordinateSystemAxisType", Tag(0x0014, 0x220c));
    public_tags.emplace("CoordinateSystemAxisUnits", Tag(0x0014, 0x220e));
    public_tags.emplace("CoordinateSystemAxisValues", Tag(0x0014, 0x2210));
    public_tags.emplace("CoordinateSystemTransformSequence", Tag(0x0014, 0x2220));
    public_tags.emplace("TransformDescription", Tag(0x0014, 0x2222));
    public_tags.emplace("TransformNumberOfAxes", Tag(0x0014, 0x2224));
    public_tags.emplace("TransformOrderOfAxes", Tag(0x0014, 0x2226));
    public_tags.emplace("TransformedAxisUnits", Tag(0x0014, 0x2228));
    public_tags.emplace("CoordinateSystemTransformRotationAndScaleMatrix", Tag(0x0014, 0x222a));
    public_tags.emplace("CoordinateSystemTransformTranslationMatrix", Tag(0x0014, 0x222c));
    public_tags.emplace("InternalDetectorFrameTime", Tag(0x0014, 0x3011));
    public_tags.emplace("NumberOfFramesIntegrated", Tag(0x0014, 0x3012));
    public_tags.emplace("DetectorTemperatureSequence", Tag(0x0014, 0x3020));
    public_tags.emplace("SensorName", Tag(0x0014, 0x3022));
    public_tags.emplace("HorizontalOffsetOfSensor", Tag(0x0014, 0x3024));
    public_tags.emplace("VerticalOffsetOfSensor", Tag(0x0014, 0x3026));
    public_tags.emplace("SensorTemperature", Tag(0x0014, 0x3028));
    public_tags.emplace("DarkCurrentSequence", Tag(0x0014, 0x3040));
    public_tags.emplace("DarkCurrentCounts", Tag(0x0014, 0x3050));
    public_tags.emplace("GainCorrectionReferenceSequence", Tag(0x0014, 0x3060));
    public_tags.emplace("AirCounts", Tag(0x0014, 0x3070));
    public_tags.emplace("KVUsedInGainCalibration", Tag(0x0014, 0x3071));
    public_tags.emplace("MAUsedInGainCalibration", Tag(0x0014, 0x3072));
    public_tags.emplace("NumberOfFramesUsedForIntegration", Tag(0x0014, 0x3073));
    public_tags.emplace("FilterMaterialUsedInGainCalibration", Tag(0x0014, 0x3074));
    public_tags.emplace("FilterThicknessUsedInGainCalibration", Tag(0x0014, 0x3075));
    public_tags.emplace("DateOfGainCalibration", Tag(0x0014, 0x3076));
    public_tags.emplace("TimeOfGainCalibration", Tag(0x0014, 0x3077));
    public_tags.emplace("BadPixelImage", Tag(0x0014, 0x3080));
    public_tags.emplace("CalibrationNotes", Tag(0x0014, 0x3099));
    public_tags.emplace("LinearityCorrectionTechnique", Tag(0x0014, 0x3100));
    public_tags.emplace("BeamHardeningCorrectionTechnique", Tag(0x0014, 0x3101));
    public_tags.emplace("PulserEquipmentSequence", Tag(0x0014, 0x4002));
    public_tags.emplace("PulserType", Tag(0x0014, 0x4004));
    public_tags.emplace("PulserNotes", Tag(0x0014, 0x4006));
    public_tags.emplace("ReceiverEquipmentSequence", Tag(0x0014, 0x4008));
    public_tags.emplace("AmplifierType", Tag(0x0014, 0x400a));
    public_tags.emplace("ReceiverNotes", Tag(0x0014, 0x400c));
    public_tags.emplace("PreAmplifierEquipmentSequence", Tag(0x0014, 0x400e));
    public_tags.emplace("PreAmplifierNotes", Tag(0x0014, 0x400f));
    public_tags.emplace("TransmitTransducerSequence", Tag(0x0014, 0x4010));
    public_tags.emplace("ReceiveTransducerSequence", Tag(0x0014, 0x4011));
    public_tags.emplace("NumberOfElements", Tag(0x0014, 0x4012));
    public_tags.emplace("ElementShape", Tag(0x0014, 0x4013));
    public_tags.emplace("ElementDimensionA", Tag(0x0014, 0x4014));
    public_tags.emplace("ElementDimensionB", Tag(0x0014, 0x4015));
    public_tags.emplace("ElementPitchA", Tag(0x0014, 0x4016));
    public_tags.emplace("MeasuredBeamDimensionA", Tag(0x0014, 0x4017));
    public_tags.emplace("MeasuredBeamDimensionB", Tag(0x0014, 0x4018));
    public_tags.emplace("LocationOfMeasuredBeamDiameter", Tag(0x0014, 0x4019));
    public_tags.emplace("NominalFrequency", Tag(0x0014, 0x401a));
    public_tags.emplace("MeasuredCenterFrequency", Tag(0x0014, 0x401b));
    public_tags.emplace("MeasuredBandwidth", Tag(0x0014, 0x401c));
    public_tags.emplace("ElementPitchB", Tag(0x0014, 0x401d));
    public_tags.emplace("PulserSettingsSequence", Tag(0x0014, 0x4020));
    public_tags.emplace("PulseWidth", Tag(0x0014, 0x4022));
    public_tags.emplace("ExcitationFrequency", Tag(0x0014, 0x4024));
    public_tags.emplace("ModulationType", Tag(0x0014, 0x4026));
    public_tags.emplace("Damping", Tag(0x0014, 0x4028));
    public_tags.emplace("ReceiverSettingsSequence", Tag(0x0014, 0x4030));
    public_tags.emplace("AcquiredSoundpathLength", Tag(0x0014, 0x4031));
    public_tags.emplace("AcquisitionCompressionType", Tag(0x0014, 0x4032));
    public_tags.emplace("AcquisitionSampleSize", Tag(0x0014, 0x4033));
    public_tags.emplace("RectifierSmoothing", Tag(0x0014, 0x4034));
    public_tags.emplace("DACSequence", Tag(0x0014, 0x4035));
    public_tags.emplace("DACType", Tag(0x0014, 0x4036));
    public_tags.emplace("DACGainPoints", Tag(0x0014, 0x4038));
    public_tags.emplace("DACTimePoints", Tag(0x0014, 0x403a));
    public_tags.emplace("DACAmplitude", Tag(0x0014, 0x403c));
    public_tags.emplace("PreAmplifierSettingsSequence", Tag(0x0014, 0x4040));
    public_tags.emplace("TransmitTransducerSettingsSequence", Tag(0x0014, 0x4050));
    public_tags.emplace("ReceiveTransducerSettingsSequence", Tag(0x0014, 0x4051));
    public_tags.emplace("IncidentAngle", Tag(0x0014, 0x4052));
    public_tags.emplace("CouplingTechnique", Tag(0x0014, 0x4054));
    public_tags.emplace("CouplingMedium", Tag(0x0014, 0x4056));
    public_tags.emplace("CouplingVelocity", Tag(0x0014, 0x4057));
    public_tags.emplace("ProbeCenterLocationX", Tag(0x0014, 0x4058));
    public_tags.emplace("ProbeCenterLocationZ", Tag(0x0014, 0x4059));
    public_tags.emplace("SoundPathLength", Tag(0x0014, 0x405a));
    public_tags.emplace("DelayLawIdentifier", Tag(0x0014, 0x405c));
    public_tags.emplace("GateSettingsSequence", Tag(0x0014, 0x4060));
    public_tags.emplace("GateThreshold", Tag(0x0014, 0x4062));
    public_tags.emplace("VelocityOfSound", Tag(0x0014, 0x4064));
    public_tags.emplace("CalibrationSettingsSequence", Tag(0x0014, 0x4070));
    public_tags.emplace("CalibrationProcedure", Tag(0x0014, 0x4072));
    public_tags.emplace("ProcedureVersion", Tag(0x0014, 0x4074));
    public_tags.emplace("ProcedureCreationDate", Tag(0x0014, 0x4076));
    public_tags.emplace("ProcedureExpirationDate", Tag(0x0014, 0x4078));
    public_tags.emplace("ProcedureLastModifiedDate", Tag(0x0014, 0x407a));
    public_tags.emplace("CalibrationTime", Tag(0x0014, 0x407c));
    public_tags.emplace("CalibrationDate", Tag(0x0014, 0x407e));
    public_tags.emplace("ProbeDriveEquipmentSequence", Tag(0x0014, 0x4080));
    public_tags.emplace("DriveType", Tag(0x0014, 0x4081));
    public_tags.emplace("ProbeDriveNotes", Tag(0x0014, 0x4082));
    public_tags.emplace("DriveProbeSequence", Tag(0x0014, 0x4083));
    public_tags.emplace("ProbeInductance", Tag(0x0014, 0x4084));
    public_tags.emplace("ProbeResistance", Tag(0x0014, 0x4085));
    public_tags.emplace("ReceiveProbeSequence", Tag(0x0014, 0x4086));
    public_tags.emplace("ProbeDriveSettingsSequence", Tag(0x0014, 0x4087));
    public_tags.emplace("BridgeResistors", Tag(0x0014, 0x4088));
    public_tags.emplace("ProbeOrientationAngle", Tag(0x0014, 0x4089));
    public_tags.emplace("UserSelectedGainY", Tag(0x0014, 0x408b));
    public_tags.emplace("UserSelectedPhase", Tag(0x0014, 0x408c));
    public_tags.emplace("UserSelectedOffsetX", Tag(0x0014, 0x408d));
    public_tags.emplace("UserSelectedOffsetY", Tag(0x0014, 0x408e));
    public_tags.emplace("ChannelSettingsSequence", Tag(0x0014, 0x4091));
    public_tags.emplace("ChannelThreshold", Tag(0x0014, 0x4092));
    public_tags.emplace("ScannerSettingsSequence", Tag(0x0014, 0x409a));
    public_tags.emplace("ScanProcedure", Tag(0x0014, 0x409b));
    public_tags.emplace("TranslationRateX", Tag(0x0014, 0x409c));
    public_tags.emplace("TranslationRateY", Tag(0x0014, 0x409d));
    public_tags.emplace("ChannelOverlap", Tag(0x0014, 0x409f));
    public_tags.emplace("ImageQualityIndicatorType", Tag(0x0014, 0x40a0));
    public_tags.emplace("ImageQualityIndicatorMaterial", Tag(0x0014, 0x40a1));
    public_tags.emplace("ImageQualityIndicatorSize", Tag(0x0014, 0x40a2));
    public_tags.emplace("LINACEnergy", Tag(0x0014, 0x5002));
    public_tags.emplace("LINACOutput", Tag(0x0014, 0x5004));
    public_tags.emplace("ActiveAperture", Tag(0x0014, 0x5100));
    public_tags.emplace("TotalAperture", Tag(0x0014, 0x5101));
    public_tags.emplace("ApertureElevation", Tag(0x0014, 0x5102));
    public_tags.emplace("MainLobeAngle", Tag(0x0014, 0x5103));
    public_tags.emplace("MainRoofAngle", Tag(0x0014, 0x5104));
    public_tags.emplace("ConnectorType", Tag(0x0014, 0x5105));
    public_tags.emplace("WedgeModelNumber", Tag(0x0014, 0x5106));
    public_tags.emplace("WedgeAngleFloat", Tag(0x0014, 0x5107));
    public_tags.emplace("WedgeRoofAngle", Tag(0x0014, 0x5108));
    public_tags.emplace("WedgeElement1Position", Tag(0x0014, 0x5109));
    public_tags.emplace("WedgeMaterialVelocity", Tag(0x0014, 0x510a));
    public_tags.emplace("WedgeMaterial", Tag(0x0014, 0x510b));
    public_tags.emplace("WedgeOffsetZ", Tag(0x0014, 0x510c));
    public_tags.emplace("WedgeOriginOffsetX", Tag(0x0014, 0x510d));
    public_tags.emplace("WedgeTimeDelay", Tag(0x0014, 0x510e));
    public_tags.emplace("WedgeName", Tag(0x0014, 0x510f));
    public_tags.emplace("WedgeManufacturerName", Tag(0x0014, 0x5110));
    public_tags.emplace("WedgeDescription", Tag(0x0014, 0x5111));
    public_tags.emplace("NominalBeamAngle", Tag(0x0014, 0x5112));
    public_tags.emplace("WedgeOffsetX", Tag(0x0014, 0x5113));
    public_tags.emplace("WedgeOffsetY", Tag(0x0014, 0x5114));
    public_tags.emplace("WedgeTotalLength", Tag(0x0014, 0x5115));
    public_tags.emplace("WedgeInContactLength", Tag(0x0014, 0x5116));
    public_tags.emplace("WedgeFrontGap", Tag(0x0014, 0x5117));
    public_tags.emplace("WedgeTotalHeight", Tag(0x0014, 0x5118));
    public_tags.emplace("WedgeFrontHeight", Tag(0x0014, 0x5119));
    public_tags.emplace("WedgeRearHeight", Tag(0x0014, 0x511a));
    public_tags.emplace("WedgeTotalWidth", Tag(0x0014, 0x511b));
    public_tags.emplace("WedgeInContactWidth", Tag(0x0014, 0x511c));
    public_tags.emplace("WedgeChamferHeight", Tag(0x0014, 0x511d));
    public_tags.emplace("WedgeCurve", Tag(0x0014, 0x511e));
    public_tags.emplace("RadiusAlongWedge", Tag(0x0014, 0x511f));
}

}

}