/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.result.AbstractDependencyResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedDependencyResult;
import org.gradle.api.internal.artifacts.result.DefaultUnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class ResolvedComponentResultSerializer
implements Serializer<ResolvedComponentResult> {
    private final Serializer<ModuleVersionIdentifier> moduleVersionIdSerializer;
    private final Serializer<ComponentIdentifier> componentIdSerializer;
    private final Serializer<ComponentSelector> componentSelectorSerializer;
    private final Serializer<ResolvedVariantResult> resolvedVariantResultSerializer;
    private final Serializer<ComponentSelectionReasonInternal> componentSelectionReasonSerializer;

    public ResolvedComponentResultSerializer(Serializer<ModuleVersionIdentifier> moduleVersionIdSerializer, Serializer<ComponentIdentifier> componentIdSerializer, Serializer<ComponentSelector> componentSelectorSerializer, Serializer<ResolvedVariantResult> resolvedVariantResultSerializer, Serializer<ComponentSelectionReasonInternal> componentSelectionReasonSerializer) {
        this.moduleVersionIdSerializer = moduleVersionIdSerializer;
        this.componentIdSerializer = componentIdSerializer;
        this.componentSelectorSerializer = componentSelectorSerializer;
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
        this.componentSelectionReasonSerializer = componentSelectionReasonSerializer;
    }

    public ResolvedComponentResult read(Decoder decoder) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void write(Encoder encoder, ResolvedComponentResult value) throws Exception {
        DefaultResolvedComponentResult root = (DefaultResolvedComponentResult)value;
        HashMap<ResolvedComponentResult, Integer> components = new HashMap<ResolvedComponentResult, Integer>();
        this.writeComponent(encoder, root, components);
    }

    private void writeComponent(Encoder encoder, ResolvedComponentResult component, Map<ResolvedComponentResult, Integer> components) throws Exception {
        Integer id = components.get(component);
        if (id != null) {
            encoder.writeSmallInt(id.intValue());
            return;
        }
        id = components.size();
        components.put(component, id);
        encoder.writeSmallInt(id.intValue());
        this.moduleVersionIdSerializer.write(encoder, (Object)component.getModuleVersion());
        this.componentIdSerializer.write(encoder, (Object)component.getId());
        this.componentSelectionReasonSerializer.write(encoder, (Object)((ResolvedComponentResultInternal)component).getSelectionReason());
        List<ResolvedVariantResult> allVariants = ((ResolvedComponentResultInternal)component).getAvailableVariants();
        HashSet resolvedVariants = new HashSet(component.getVariants());
        encoder.writeSmallInt(allVariants.size());
        for (ResolvedVariantResult variant : allVariants) {
            this.resolvedVariantResultSerializer.write(encoder, (Object)variant);
            encoder.writeBoolean(resolvedVariants.contains(variant));
        }
        Set dependencies = component.getDependencies();
        encoder.writeSmallInt(dependencies.size());
        for (DependencyResult dependency : dependencies) {
            AbstractDependencyResult dependencyResult;
            boolean successful = dependency instanceof ResolvedDependencyResult;
            encoder.writeBoolean(successful);
            if (successful) {
                dependencyResult = (DefaultResolvedDependencyResult)dependency;
                this.componentSelectorSerializer.write(encoder, (Object)dependencyResult.getRequested());
                this.writeComponent(encoder, ((DefaultResolvedDependencyResult)dependencyResult).getSelected(), components);
                continue;
            }
            dependencyResult = (DefaultUnresolvedDependencyResult)dependency;
            this.componentSelectorSerializer.write(encoder, (Object)dependencyResult.getRequested());
        }
    }
}

