/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.jdk7;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7Symlink;

public class WindowsJdk7Symlink
extends Jdk7Symlink {
    private static boolean modifiesRealPath(Path suspectPath) {
        Path parent = suspectPath.getParent();
        if (parent == null) {
            return false;
        }
        try {
            Path realParent = parent.toRealPath(new LinkOption[0]);
            Path suspectWithRealParent = realParent.resolve(suspectPath.getFileName());
            Path realSuspect = suspectPath.toRealPath(new LinkOption[0]);
            return !suspectWithRealParent.equals(realSuspect);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public WindowsJdk7Symlink() {
        super(false);
    }

    @Override
    public void symlink(File link, File target) throws IOException {
        throw new IOException("Creation of symlinks is not supported on this platform.");
    }

    @Override
    public boolean isSymlink(File suspect) {
        try {
            Path suspectPath = suspect.toPath();
            BasicFileAttributes attrs = Files.readAttributes(suspectPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (attrs.isOther()) {
                return WindowsJdk7Symlink.modifiesRealPath(suspectPath);
            }
            return super.isSymlink(suspect);
        }
        catch (IOException e) {
            return super.isSymlink(suspect);
        }
    }
}

