/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestDefinitionProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestScanner;
import org.gradle.api.internal.tasks.testing.detection.ForkedTestClasspathFactory;
import org.gradle.api.internal.tasks.testing.detection.TestDetector;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.processors.MaxNParallelTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.processors.PatternMatchTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.processors.RestartEveryNTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.processors.RunPreviousFailedFirstTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.internal.tasks.testing.results.TestRetryShieldingTestResultProcessor;
import org.gradle.api.internal.tasks.testing.worker.ForkedTestClasspath;
import org.gradle.api.internal.tasks.testing.worker.ForkingTestDefinitionProcessor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.internal.IncubationLogger;

public class DefaultTestExecuter
implements TestExecuter<JvmTestExecutionSpec> {
    private static final Logger LOGGER = Logging.getLogger(DefaultTestExecuter.class);
    private final WorkerProcessFactory workerFactory;
    private final ActorFactory actorFactory;
    private final ForkedTestClasspathFactory testClasspathFactory;
    private final WorkerLeaseService workerLeaseService;
    private final int maxWorkerCount;
    private final Clock clock;
    private final DefaultTestFilter testFilter;
    private TestDefinitionProcessor<TestDefinition> processor;

    public DefaultTestExecuter(WorkerProcessFactory workerFactory, ActorFactory actorFactory, ModuleRegistry moduleRegistry, WorkerLeaseService workerLeaseService, int maxWorkerCount, Clock clock, DefaultTestFilter testFilter) {
        this.workerFactory = workerFactory;
        this.actorFactory = actorFactory;
        this.testClasspathFactory = new ForkedTestClasspathFactory(moduleRegistry);
        this.workerLeaseService = workerLeaseService;
        this.maxWorkerCount = maxWorkerCount;
        this.clock = clock;
        this.testFilter = testFilter;
    }

    public void execute(JvmTestExecutionSpec testExecutionSpec, TestResultProcessor testResultProcessor) {
        String canonicalName;
        TestFramework testFramework = testExecutionSpec.getTestFramework();
        WorkerTestDefinitionProcessorFactory testInstanceFactory = (WorkerTestDefinitionProcessorFactory)Cast.uncheckedNonnullCast(testFramework.getProcessorFactory());
        ForkedTestClasspath classpath = this.testClasspathFactory.create(testExecutionSpec.getClasspath(), testExecutionSpec.getModulePath());
        Factory forkingProcessorFactory = () -> new ForkingTestDefinitionProcessor((WorkerThreadRegistry)this.workerLeaseService, this.workerFactory, testInstanceFactory, testExecutionSpec.getJavaForkOptions(), classpath, testFramework.getWorkerConfigurationAction());
        Factory reforkingProcessorFactory = () -> new RestartEveryNTestDefinitionProcessor(forkingProcessorFactory, testExecutionSpec.getForkEvery());
        this.processor = new PatternMatchTestDefinitionProcessor(this.testFilter, (TestDefinitionProcessor)new RunPreviousFailedFirstTestDefinitionProcessor(testExecutionSpec.getPreviousFailedTestClasses(), Collections.emptySet(), (TestDefinitionProcessor)new MaxNParallelTestDefinitionProcessor(this.getMaxParallelForks(testExecutionSpec), reforkingProcessorFactory, this.actorFactory)));
        FileTree testClassFiles = testExecutionSpec.getCandidateClassFiles();
        Set<File> testDefinitionDirs = testExecutionSpec.getCandidateTestDefinitionDirs();
        if (testFramework.getDetector() != null) {
            TestFrameworkDetector testFrameworkDetector = testFramework.getDetector();
            testFrameworkDetector.setTestClasses(new ArrayList<File>(testExecutionSpec.getTestClassesDirs().getFiles()));
            testFrameworkDetector.setTestClasspath((List<File>)classpath.getApplicationClasspath());
        }
        if (!testDefinitionDirs.isEmpty() && this.testFilter.hasPatterns()) {
            IncubationLogger.incubatingFeatureUsed((String)"Filtering non-class-based tests");
        }
        DefaultTestScanner detector = new DefaultTestScanner(testClassFiles, testDefinitionDirs, testFramework.getDetector(), this.processor);
        if (testResultProcessor != null && (canonicalName = testResultProcessor.getClass().getCanonicalName()) != null && canonicalName.endsWith("org.gradle.testretry.internal.executer.RetryTestResultProcessor")) {
            testResultProcessor = new TestRetryShieldingTestResultProcessor(testResultProcessor);
        }
        new TestMainAction((TestDetector)detector, this.processor, testResultProcessor, this.workerLeaseService, this.clock, (Object)testExecutionSpec.getPath(), "Gradle Test Run " + testExecutionSpec.getIdentityPath()).run();
    }

    public void stopNow() {
        if (this.processor != null) {
            this.processor.stopNow();
        }
    }

    private int getMaxParallelForks(JvmTestExecutionSpec testExecutionSpec) {
        int maxParallelForks = testExecutionSpec.getMaxParallelForks();
        if (maxParallelForks > this.maxWorkerCount) {
            LOGGER.info("{}.maxParallelForks ({}) is larger than max-workers ({}), forcing it to {}", new Object[]{testExecutionSpec.getPath(), maxParallelForks, this.maxWorkerCount, this.maxWorkerCount});
            maxParallelForks = this.maxWorkerCount;
        }
        return maxParallelForks;
    }
}

