/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import org.gradle.process.JavaDebugOptions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface JvmDebugSpec {
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public @Nullable String getHost();

    public void setHost(@Nullable String var1);

    public int getPort();

    public void setPort(int var1);

    public boolean isServer();

    public void setServer(boolean var1);

    public boolean isSuspend();

    public void setSuspend(boolean var1);

    public static class JavaDebugOptionsBackedSpec
    implements JvmDebugSpec {
        private final JavaDebugOptions delegate;

        public JavaDebugOptionsBackedSpec(JavaDebugOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isEnabled() {
            return (Boolean)this.delegate.getEnabled().get();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.delegate.getEnabled().set((Object)enabled);
        }

        @Override
        public @Nullable String getHost() {
            return (String)this.delegate.getHost().getOrNull();
        }

        @Override
        public void setHost(@Nullable String host) {
            this.delegate.getHost().set((Object)host);
        }

        @Override
        public int getPort() {
            return (Integer)this.delegate.getPort().get();
        }

        @Override
        public void setPort(int port) {
            this.delegate.getPort().set((Object)port);
        }

        @Override
        public boolean isServer() {
            return (Boolean)this.delegate.getServer().get();
        }

        @Override
        public void setServer(boolean server) {
            this.delegate.getServer().set((Object)server);
        }

        @Override
        public boolean isSuspend() {
            return (Boolean)this.delegate.getSuspend().get();
        }

        @Override
        public void setSuspend(boolean suspend) {
            this.delegate.getSuspend().set((Object)suspend);
        }
    }

    public static class DefaultJvmDebugSpec
    implements JvmDebugSpec {
        private boolean enabled = false;
        private String host = null;
        private int port = 5005;
        private boolean server = true;
        private boolean suspend = true;

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public @Nullable String getHost() {
            return this.host;
        }

        @Override
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void setPort(int port) {
            this.port = port;
        }

        @Override
        public boolean isServer() {
            return this.server;
        }

        @Override
        public void setServer(boolean server) {
            this.server = server;
        }

        @Override
        public boolean isSuspend() {
            return this.suspend;
        }

        @Override
        public void setSuspend(boolean suspend) {
            this.suspend = suspend;
        }
    }
}

