/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.K1Deprecation;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.HelpersKt;
import org.jetbrains.kotlin.cli.js.IcCachesArtifacts;
import org.jetbrains.kotlin.cli.js.Ir2JsTransformer;
import org.jetbrains.kotlin.cli.js.K2JsCompilerImplBase;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.pipeline.web.js.JsBackendPipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.web.js.JsConfigurationUpdater;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CompilationOutputs;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.js.config.ModuleKind;
import org.jetbrains.kotlin.js.config.WebArtifactConfiguration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.PhaseType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J*\u0010\u001d\u001a\u00020\u00122\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsCompilerImpl;", "Lorg/jetbrains/kotlin/cli/js/K2JsCompilerImplBase;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleName", "", "outputName", "outputDir", "Ljava/io/File;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "performanceManager", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/util/PerformanceManager;)V", "checkTargetArguments", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "tryInitializeCompiler", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "compileWithIC", "icCaches", "Lorg/jetbrains/kotlin/cli/js/IcCachesArtifacts;", "targetConfiguration", "moduleKind", "Lorg/jetbrains/kotlin/js/config/ModuleKind;", "compileNoIC", "mainCallArguments", "", "module", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "cli-js"})
public final class K2JsCompilerImpl
extends K2JsCompilerImplBase {
    public K2JsCompilerImpl(@NotNull K2JSCompilerArguments arguments, @NotNull CompilerConfiguration configuration, @NotNull String moduleName2, @NotNull String outputName, @NotNull File outputDir, @NotNull MessageCollector messageCollector, @Nullable PerformanceManager performanceManager) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        super(arguments, configuration, moduleName2, outputName, outputDir, messageCollector, performanceManager);
    }

    @Override
    @Nullable
    public ExitCode checkTargetArguments() {
        if (HelpersKt.getTargetVersion(this.getArguments()) == null) {
            MessageCollector.report$default(this.getMessageCollector(), CompilerMessageSeverity.ERROR, "Unsupported ECMA version: " + this.getArguments().getTarget(), null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (this.getArguments().getScript()) {
            MessageCollector.report$default(this.getMessageCollector(), CompilerMessageSeverity.ERROR, "K/JS does not support Kotlin script (*.kts) files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (this.getArguments().getFreeArgs().isEmpty() && !UtilsKt.incrementalCompilationIsEnabledForJs(this.getArguments())) {
            if (this.getArguments().getVersion()) {
                return ExitCode.OK;
            }
            CharSequence charSequence = this.getArguments().getIncludes();
            if (charSequence == null || charSequence.length() == 0) {
                this.getMessageCollector().report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        return null;
    }

    @Override
    @K1Deprecation
    @Nullable
    public KotlinCoreEnvironment tryInitializeCompiler(@NotNull Disposable rootDisposable) {
        KotlinCoreEnvironment environmentForJS;
        block2: {
            PerformanceManager performanceManager;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
            JsConfigurationUpdater.INSTANCE.fillConfiguration$cli_js(this.getConfiguration(), this.getArguments());
            if (this.getMessageCollector().hasErrors()) {
                return null;
            }
            environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, this.getConfiguration(), EnvironmentConfigFiles.JS_CONFIG_FILES);
            List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
            if (sourcesFiles.isEmpty() && !UtilsKt.incrementalCompilationIsEnabledForJs(this.getArguments()) && ((charSequence = (CharSequence)this.getArguments().getIncludes()) == null || charSequence.length() == 0)) {
                this.getMessageCollector().report(CompilerMessageSeverity.ERROR, "No source files", null);
                return null;
            }
            PerformanceManager performanceManager2 = this.getPerformanceManager();
            if (performanceManager2 == null) break block2;
            PerformanceManager $this$tryInitializeCompiler_u24lambda_u240 = performanceManager = performanceManager2;
            boolean bl = false;
            $this$tryInitializeCompiler_u24lambda_u240.setTargetDescription(this.getModuleName());
            ModuleKind moduleKind = JSConfigurationKeysKt.getModuleKind(this.getConfiguration());
            $this$tryInitializeCompiler_u24lambda_u240.setOutputKind(moduleKind != null ? moduleKind.name() : null);
            $this$tryInitializeCompiler_u24lambda_u240.addSourcesStats(sourcesFiles.size(), environmentForJS.countLinesOfCode(sourcesFiles));
            $this$tryInitializeCompiler_u24lambda_u240.notifyPhaseFinished(PhaseType.Initialization);
        }
        return environmentForJS;
    }

    @Override
    @NotNull
    public ExitCode compileWithIC(@NotNull IcCachesArtifacts icCaches, @NotNull CompilerConfiguration targetConfiguration, @Nullable ModuleKind moduleKind) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)icCaches, (String)"icCaches");
            Intrinsics.checkNotNullParameter((Object)targetConfiguration, (String)"targetConfiguration");
            ModuleKind moduleKind2 = moduleKind;
            if (moduleKind2 == null) {
                return ExitCode.INTERNAL_ERROR;
            }
            JsBackendPipelinePhase.INSTANCE.compileIncrementally$cli_js(icCaches, this.getConfiguration(), new WebArtifactConfiguration(moduleKind2, this.getModuleName(), this.getOutputDir(), this.getOutputName(), HelpersKt.getGranularity(this.getArguments()), HelpersKt.getDtsStrategy(this.getArguments())));
            PerformanceManager performanceManager = this.getPerformanceManager();
            if (performanceManager == null) break block1;
            performanceManager.notifyCurrentPhaseFinishedIfNeeded();
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExitCode compileNoIC(@Nullable List<String> mainCallArguments, @NotNull ModulesStructure module2, @Nullable ModuleKind moduleKind) {
        PhaseConfig phaseConfig;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (!this.getArguments().getIrProduceJs()) {
            PerformanceManager performanceManager = this.getPerformanceManager();
            if (performanceManager != null) {
                performanceManager.notifyCurrentPhaseFinishedIfNeeded();
            }
            return ExitCode.OK;
        }
        JsConfigurationUpdater.INSTANCE.checkWasmArgumentsUsage$cli_js(this.getArguments(), this.getMessageCollector());
        PhaseConfig phaseConfig2 = phaseConfig = CreatePhaseConfigKt.createPhaseConfig$default(this.getArguments(), null, 2, null);
        CompilerConfiguration compilerConfiguration = this.getConfiguration();
        boolean bl = false;
        if (this.getArguments().getListPhases()) {
            void it;
            CreatePhaseConfigKt.listPhases((PhaseConfig)it, JsLoweringPhasesKt.getJsLowerings(this.getConfiguration()));
        }
        CommonConfigurationKeysKt.setPhaseConfig(compilerConfiguration, phaseConfig);
        Ir2JsTransformer ir2JsTransformer = new Ir2JsTransformer(this.getArguments(), module2, this.getMessageCollector(), mainCallArguments);
        MessageCollector messageCollector = this.getMessageCollector();
        ModuleKind moduleKind2 = moduleKind;
        Intrinsics.checkNotNull((Object)((Object)moduleKind2));
        CompilationOutputs outputs = JsBackendPipelinePhase.INSTANCE.compileNonIncrementally$cli_js(messageCollector, ir2JsTransformer, new WebArtifactConfiguration(moduleKind2, this.getModuleName(), this.getOutputDir(), this.getOutputName(), HelpersKt.getGranularity(this.getArguments()), HelpersKt.getDtsStrategy(this.getArguments())));
        return outputs != null ? ExitCode.OK : ExitCode.INTERNAL_ERROR;
    }
}

