/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.SortedMap;
import org.gradle.caching.internal.BuildCacheKeyInternal;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.changes.ChangeDetectorVisitor;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.MutableStep;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class StoreExecutionStateStep<C extends PreviousExecutionContext, R extends AfterExecutionResult>
extends MutableStep<C, R> {
    private final Step<? super C, ? extends R> delegate;

    public StoreExecutionStateStep(Step<? super C, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected R executeMutable(MutableUnitOfWork work, C context) {
        AfterExecutionResult result = (AfterExecutionResult)this.delegate.execute(work, context);
        work.getHistory().ifPresent(history -> ((CachingContext)((Object)context)).getCachingState().getCacheKeyCalculatedState().flatMap(cacheKeyCalculatedState -> result.getAfterExecutionOutputState().filter(afterExecutionState -> result.getExecution().isSuccessful() || StoreExecutionStateStep.shouldPreserveFailedState(context, afterExecutionState)).map(executionOutputState -> new DefaultAfterExecutionState(((BuildCacheKeyInternal)cacheKeyCalculatedState.getKey()).getHashCodeInternal(), cacheKeyCalculatedState.getBeforeExecutionState(), (ExecutionOutputState)executionOutputState))).ifPresent(afterExecutionState -> history.store(context.getIdentity().getUniqueId(), (AfterExecutionState)afterExecutionState)));
        return (R)result;
    }

    private static <C extends PreviousExecutionContext> boolean shouldPreserveFailedState(C context, ExecutionOutputState afterExecutionOutputState) {
        return context.getPreviousExecutionState().map(previewExecutionState -> StoreExecutionStateStep.didOutputsChange(previewExecutionState.getOutputFilesProducedByWork(), afterExecutionOutputState.getOutputFilesProducedByWork())).orElse(true);
    }

    private static boolean didOutputsChange(ImmutableSortedMap<String, FileSystemSnapshot> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        if (!previous.keySet().equals((Object)current.keySet())) {
            return true;
        }
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        OutputFileChanges changes = new OutputFileChanges((SortedMap<String, FileSystemSnapshot>)previous, (SortedMap<String, FileSystemSnapshot>)current);
        changes.accept(visitor);
        return visitor.hasAnyChanges();
    }

    private static class DefaultAfterExecutionState
    implements AfterExecutionState {
        private final BeforeExecutionState beforeExecutionState;
        private final ExecutionOutputState afterExecutionOutputState;
        private final HashCode cacheKey;

        public DefaultAfterExecutionState(HashCode cacheKey, BeforeExecutionState beforeExecutionState, ExecutionOutputState afterExecutionOutputState) {
            this.cacheKey = cacheKey;
            this.beforeExecutionState = beforeExecutionState;
            this.afterExecutionOutputState = afterExecutionOutputState;
        }

        @Override
        public ImplementationSnapshot getImplementation() {
            return this.beforeExecutionState.getImplementation();
        }

        @Override
        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.beforeExecutionState.getAdditionalImplementations();
        }

        @Override
        public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
            return this.beforeExecutionState.getInputProperties();
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
            return this.beforeExecutionState.getInputFileProperties();
        }

        @Override
        public HashCode getCacheKey() {
            return this.cacheKey;
        }

        @Override
        public boolean isSuccessful() {
            return this.afterExecutionOutputState.isSuccessful();
        }

        @Override
        public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFilesProducedByWork() {
            return this.afterExecutionOutputState.getOutputFilesProducedByWork();
        }

        @Override
        public OriginMetadata getOriginMetadata() {
            return this.afterExecutionOutputState.getOriginMetadata();
        }

        @Override
        public boolean isReused() {
            return this.afterExecutionOutputState.isReused();
        }
    }
}

