/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.codegen;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.CamelCaseAndSanitizeLambda;
import org.qtproject.qt.codegen.CppQt6AbstractCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppQt6ClientGenerator
extends CppQt6AbstractCodegen
implements CodegenConfig {
    public static final String DEFAULT_PACKAGE_NAME = "Qt6OpenAPIClient";
    public static final String COMMON_LIB_NAME_OPTION = "commonLibraryName";
    public static final String DEFAULT_COMMON_LIB_NAME = "QtOpenAPICommon";
    public static final String COMMON_LIB_OPTION = "commonLibrary";
    public static final String MAKE_OPERATIONS_VIRTUAL_NAME = "makeOperationsVirtual";
    public static final String MAKE_OPERATIONS_VIRTUAL_DESC = "Make all operations methods virtual. This makes it easy to mock the generated API class for testing purposes.";
    public static final String MAKE_QML_ENABLED = "enableQmlCode";
    public static final String MAKE_QML_ENABLED_DESC = "Enable registering C++ Types with the QML Type System";
    public static final String ADD_DOWNLOAD_PROGRESS = "addDownloadProgress";
    protected static final String CPP_COMMON_NAMESPACE = "cppCommonNamespace";
    protected static final String CPP_COMMON_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api) for the common library.";
    protected String cppCommonNamespace = "QtOpenApiCommon";
    protected String namePrefix = "";
    public static final String USE_CMAKE_FUNCTION = "useCmakeMacro";
    public static final String USE_CMAKE_FUNCTION_DESC = "Specifies if the 'qt6_add_openapi_client' CMake macro is used to generate the code. Do not change the value manually!";
    protected String packageName = "";
    protected String sourceFolder = "client";
    protected String commonLibrarySourceFolder = "common";
    protected static final String USE_COMMON_LIBRARY = "enableCommonLibGeneration";
    private final Logger LOGGER = LoggerFactory.getLogger(CppQt6ClientGenerator.class);
    protected boolean addDownloadProgress = false;
    protected boolean makeOperationsVirtual = true;
    protected boolean enableQmlCode = false;
    protected String commonLibrary;
    protected String commonLibraryName;
    protected boolean useCmakeMacro;
    protected String licenseName;

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "cpp-qt6-client";
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        this.removeImport(objs, "#include <QList>");
        return objs;
    }

    public String getHelp() {
        return "Generates a cpp-qt6-client client library.";
    }

    public CppQt6ClientGenerator() {
        this.commonLibrary = GENERATION_TYPE.CLIENT_LIB.value;
        this.commonLibraryName = DEFAULT_PACKAGE_NAME;
        this.useCmakeMacro = false;
        this.licenseName = "";
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.MultiServer}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BasicAuth}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.ApiKey}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterStyling}));
        this.outputFolder = "generated-code/cpp-qt6-client";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.addOption(CPP_COMMON_NAMESPACE, CPP_COMMON_NAMESPACE_DESC, this.cppCommonNamespace);
        this.addOption("packageName", "C++ package (library) name.", DEFAULT_PACKAGE_NAME);
        this.addSwitch(ADD_DOWNLOAD_PROGRESS, "Add support for Qt download progress", this.addDownloadProgress);
        this.addSwitch(MAKE_OPERATIONS_VIRTUAL_NAME, MAKE_OPERATIONS_VIRTUAL_DESC, this.makeOperationsVirtual);
        this.addSwitch(MAKE_QML_ENABLED, MAKE_QML_ENABLED_DESC, this.enableQmlCode);
        this.addSwitch(USE_CMAKE_FUNCTION, USE_CMAKE_FUNCTION_DESC, this.useCmakeMacro);
        this.addOption(COMMON_LIB_NAME_OPTION, "Name of the common client library, if generated.", DEFAULT_COMMON_LIB_NAME);
        CliOption commonLib = new CliOption(COMMON_LIB_OPTION, "Generate common library for the client or not.");
        HashMap<String, String> commonLibOptions = new HashMap<String, String>();
        commonLibOptions.put(GENERATION_TYPE.COMMON_LIB.value, "The common resources will be generated as a Common library.");
        commonLibOptions.put(GENERATION_TYPE.CLIENT_LIB.value, "The Client will be generated without common files at all.");
        commonLib.setEnum(commonLibOptions);
        commonLib.setDefault(this.commonLibrary);
        this.cliOptions.add(commonLib);
        this.cliOptions.add(new CliOption("licenseName", "The name of the license").defaultValue(this.licenseName));
        this.templateDir = "cpp-qt6-client";
        this.typeMapping.put("AnyType", "QJsonValue");
        this.importMapping.put("QJsonValue", "#include <QtCore/qjsonvalue.h>");
        this.reservedWords.add("valid");
        this.reservedWords.add("set");
        String pluginVersion = CppQt6ClientGenerator.class.getPackage().getImplementationVersion();
        this.additionalProperties.put("pluginVersion", pluginVersion);
        this.additionalProperties.put("prefix", this.namePrefix);
        this.additionalProperties.put("camelcase", new CamelCaseAndSanitizeLambda(false).generator((CodegenConfig)this));
        this.additionalProperties.put(CPP_COMMON_NAMESPACE, this.cppCommonNamespace);
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (this.additionalProperties.get("licenseName") == null && info.getLicense() != null) {
                License license = info.getLicense();
                this.licenseName = license.getName();
            }
        }
        this.additionalProperties.put("licenseName", this.licenseName);
    }

    @Override
    public void processOpts() {
        String[] versionParts;
        super.processOpts();
        String genVersion = (String)this.additionalProperties.get("generatorVersion");
        if (genVersion == null) {
            genVersion = DefaultGenerator.class.getPackage().getImplementationVersion();
        }
        this.additionalProperties.put("generatorVersionMajor", (versionParts = genVersion.split("\\.")).length > 0 ? versionParts[0] : "0");
        this.additionalProperties.put("generatorVersionMinor", versionParts.length > 1 ? versionParts[1] : "0");
        this.additionalProperties.put("generatorVersionPatch", versionParts.length > 2 ? versionParts[2] : "0");
        if (this.additionalProperties.containsKey(CPP_COMMON_NAMESPACE)) {
            this.cppCommonNamespace = (String)this.additionalProperties.get(CPP_COMMON_NAMESPACE);
        }
        this.additionalProperties.put("cppCommonNamespaceDeclarations", this.cppCommonNamespace.split("\\::"));
        this.packageName = this.additionalProperties.getOrDefault("packageName", DEFAULT_PACKAGE_NAME);
        this.commonLibraryName = this.additionalProperties.getOrDefault(COMMON_LIB_NAME_OPTION, DEFAULT_COMMON_LIB_NAME);
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        }
        if (this.additionalProperties.containsKey(MAKE_OPERATIONS_VIRTUAL_NAME)) {
            this.setMakeOperationsVirtual(this.convertPropertyToBooleanAndWriteBack(MAKE_OPERATIONS_VIRTUAL_NAME));
        } else {
            this.additionalProperties.put(MAKE_OPERATIONS_VIRTUAL_NAME, this.makeOperationsVirtual);
        }
        if (this.additionalProperties.containsKey(MAKE_QML_ENABLED)) {
            this.setEnableQmlCode(this.convertPropertyToBooleanAndWriteBack(MAKE_QML_ENABLED));
        } else {
            this.additionalProperties.put(MAKE_QML_ENABLED, this.enableQmlCode);
        }
        if (this.additionalProperties.containsKey(USE_CMAKE_FUNCTION)) {
            this.setUseCmakeMacro(this.convertPropertyToBooleanAndWriteBack(USE_CMAKE_FUNCTION));
        } else {
            this.additionalProperties.put(USE_CMAKE_FUNCTION, this.useCmakeMacro);
        }
        if (this.additionalProperties.containsKey(ADD_DOWNLOAD_PROGRESS)) {
            this.setAddDownloadProgress(this.convertPropertyToBooleanAndWriteBack(ADD_DOWNLOAD_PROGRESS));
        } else {
            this.additionalProperties.put(ADD_DOWNLOAD_PROGRESS, this.addDownloadProgress);
        }
        this.additionalProperties.put("packageName", this.packageName);
        String lowerPackageName = this.packageName.toLowerCase();
        this.additionalProperties.put("packageNameLowerCase", lowerPackageName);
        this.additionalProperties.put("packageNameUpperCase", this.packageName.toUpperCase());
        if (this.additionalProperties.containsKey(COMMON_LIB_OPTION) && !this.additionalProperties.get(COMMON_LIB_OPTION).toString().isEmpty()) {
            this.setCommonLibrary(this.additionalProperties.get(COMMON_LIB_OPTION).toString());
        } else {
            this.additionalProperties.put(COMMON_LIB_OPTION, this.commonLibrary);
        }
        if (this.commonLibrary.equals(GENERATION_TYPE.COMMON_LIB.value)) {
            if (this.additionalProperties.containsKey(COMMON_LIB_NAME_OPTION)) {
                this.setCommonLibraryName(this.additionalProperties.get(COMMON_LIB_NAME_OPTION).toString());
            } else {
                this.additionalProperties.put(COMMON_LIB_NAME_OPTION, this.commonLibraryName);
            }
        }
        this.additionalProperties.put(USE_COMMON_LIBRARY, this.commonLibrary.equals(GENERATION_TYPE.COMMON_LIB.value));
        if (this.useCmakeMacro && this.commonLibrary.equals(GENERATION_TYPE.COMMON_LIB.value)) {
            this.additionalProperties.put("buildingQtSources", true);
        }
        String lowerCasePrefix = "";
        if (this.additionalProperties.containsKey("prefix")) {
            this.namePrefix = this.additionalProperties.get("prefix").toString();
            lowerCasePrefix = this.namePrefix.toLowerCase();
            this.additionalProperties.put("prefixLowerCase", lowerCasePrefix);
        }
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.mustache", this.sourceFolder, "README.md"));
        this.supportingFiles.add(new SupportingFile("CMakeConfig.mustache", this.sourceFolder, "config.cmake.in"));
        if (!this.useCmakeMacro) {
            this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
        }
        this.supportingFiles.add(new SupportingFile("exports.mustache", this.sourceFolder, lowerPackageName + "exports.h"));
        this.supportingFiles.add(new SupportingFile("doc/Doxyfile.in.mustache", this.sourceFolder, "doc/Doxyfile.in"));
        this.typeMapping.put("object", this.namePrefix + "Object");
        this.typeMapping.put("file", this.namePrefix + "HttpFileElement");
        this.importMapping.put(this.namePrefix + "HttpFileElement", "#include \"" + lowerCasePrefix + "httpfileelement.h\"");
        if (this.commonLibrary.equals(GENERATION_TYPE.CLIENT_LIB.value)) {
            this.LOGGER.info("Skipping ./common/* templates generation. 'Skip-Common-Files' is ON.");
            return;
        }
        if (this.useCmakeMacro) {
            this.modelTemplateFiles.clear();
            this.apiTemplateFiles.clear();
        }
        this.supportingFiles.add(new SupportingFile("common/api-base-header.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "baseapi.h"));
        this.supportingFiles.add(new SupportingFile("common/api-base-body.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "baseapi.cpp"));
        this.supportingFiles.add(new SupportingFile("common/helpers-header.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "helpers.h"));
        this.supportingFiles.add(new SupportingFile("common/helpers-body.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "helpers.cpp"));
        this.supportingFiles.add(new SupportingFile("common/httprequest.h.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "httprequest.h"));
        this.supportingFiles.add(new SupportingFile("common/httprequest.cpp.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "httprequest.cpp"));
        this.supportingFiles.add(new SupportingFile("common/httpfileelement.h.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "httpfileelement.h"));
        this.supportingFiles.add(new SupportingFile("common/httpfileelement.cpp.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "httpfileelement.cpp"));
        this.supportingFiles.add(new SupportingFile("common/object-header.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "object.h"));
        this.supportingFiles.add(new SupportingFile("common/object-body.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "object.cpp"));
        this.supportingFiles.add(new SupportingFile("common/enum-header.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "enum.h"));
        this.supportingFiles.add(new SupportingFile("common/enum-body.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "enum.cpp"));
        this.supportingFiles.add(new SupportingFile("common/common-exports.mustache", this.commonLibrarySourceFolder, lowerPackageName + "commonexports.h"));
        this.supportingFiles.add(new SupportingFile("common/common-global.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "commonglobal.h"));
        this.supportingFiles.add(new SupportingFile("common/serverconfiguration.h.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "serverconfiguration.h"));
        this.supportingFiles.add(new SupportingFile("common/serverconfiguration.cpp.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "serverconfiguration.cpp"));
        this.supportingFiles.add(new SupportingFile("common/servervariable.h.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "servervariable.h"));
        this.supportingFiles.add(new SupportingFile("common/servervariable.cpp.mustache", this.commonLibrarySourceFolder, lowerCasePrefix + "servervariable.cpp"));
        this.supportingFiles.add(new SupportingFile("common/CMakeConfig.mustache", this.commonLibrarySourceFolder, "config.cmake.in"));
        if (!this.useCmakeMacro) {
            this.supportingFiles.add(new SupportingFile("common/CMakeLists.txt.mustache", this.commonLibrarySourceFolder, "CMakeLists.txt"));
        }
    }

    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public String escapeQuotationMark(String input) {
        return input.replace("\"", "\\\"");
    }

    public String toApiFilename(String name) {
        String apiFile = this.modelNamePrefix + this.sanitizeName(name) + "Api";
        return apiFile.toLowerCase();
    }

    @Generated
    public void setAddDownloadProgress(boolean addDownloadProgress) {
        this.addDownloadProgress = addDownloadProgress;
    }

    @Generated
    public void setMakeOperationsVirtual(boolean makeOperationsVirtual) {
        this.makeOperationsVirtual = makeOperationsVirtual;
    }

    @Generated
    public void setEnableQmlCode(boolean enableQmlCode) {
        this.enableQmlCode = enableQmlCode;
    }

    @Generated
    public void setCommonLibrary(String commonLibrary) {
        this.commonLibrary = commonLibrary;
    }

    @Generated
    public void setCommonLibraryName(String commonLibraryName) {
        this.commonLibraryName = commonLibraryName;
    }

    @Generated
    public void setUseCmakeMacro(boolean useCmakeMacro) {
        this.useCmakeMacro = useCmakeMacro;
    }

    @Generated
    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public static enum GENERATION_TYPE {
        COMMON_LIB("Gen-Common-Lib"),
        CLIENT_LIB("Gen-Client-Lib");

        public final String value;

        private GENERATION_TYPE(String value) {
            this.value = value;
        }
    }
}

