/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.freeplane.api.IconsRO;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class IconsProxy
extends AbstractProxy<NodeModel>
implements Proxy.Icons {
    IconsProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    public void add(String name) {
        this.getIconController().addIcon((NodeModel)this.getDelegate(), (NamedIcon)IconStoreFactory.ICON_STORE.getMindIcon(name));
    }

    public void addAll(Collection<String> names) {
        for (String name : names) {
            this.add(name);
        }
    }

    public void addAll(IconsRO icons) {
        for (String name : icons.getIcons()) {
            this.add(name);
        }
    }

    @Deprecated
    public void addIcon(String name) {
        this.add(name);
    }

    private int findIcon(String iconID) {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        for (int i = 0; i < icons.size(); ++i) {
            if (!((NamedIcon)icons.get(i)).getName().equals(iconID)) continue;
            return i;
        }
        return -1;
    }

    private MIconController getIconController() {
        return (MIconController)IconController.getController();
    }

    public String getAt(int index) {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        return icons.size() <= index ? null : ((NamedIcon)icons.get(index)).getName();
    }

    public String getFirst() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        return icons.isEmpty() ? null : ((NamedIcon)icons.get(0)).getName();
    }

    public boolean contains(String name) {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        for (NamedIcon icon : icons) {
            if (!icon.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        return icons.size();
    }

    public List<String> getIcons() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        int size = icons.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (NamedIcon icon : icons) {
            list.add(icon.getName());
        }
        return Collections.unmodifiableList(list);
    }

    public List<URL> getUrls() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        int size = icons.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<URL> list = new ArrayList<URL>(size);
        for (NamedIcon icon : icons) {
            if (!(icon instanceof UIIcon)) continue;
            list.add(((UIIcon)icon).getUrl());
        }
        return Collections.unmodifiableList(list);
    }

    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final Iterator<String> iterator;
            {
                this.iterator = IconsProxy.this.getIcons().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("icons iterator is read-only");
            }
        };
    }

    public boolean remove(int index) {
        if (index >= this.size()) {
            return false;
        }
        this.getIconController().removeIcon((NodeModel)this.getDelegate(), index);
        return true;
    }

    public boolean remove(String iconID) {
        int index = this.findIcon(iconID);
        if (index == -1) {
            return false;
        }
        this.getIconController().removeIcon((NodeModel)this.getDelegate(), index);
        return true;
    }

    @Deprecated
    public boolean removeIcon(String iconID) {
        return this.remove(iconID);
    }

    public void clear() {
        this.getIconController().removeAllIcons((NodeModel)this.getDelegate());
    }

    public boolean asBoolean() {
        return this.size() > 0;
    }
}

