---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Container, dependency, and vulnerability scans.
title: アプリケーションを保護する
---

GitLabは、アプリケーションのセキュリティの脆弱性をチェックできます。

| | | |
|--|--|--|
| [**はじめに**](get-started-security.md)<br>機能連携の概要 | [**アプリケーションセキュリティ**](_index.md)<br>スキャン、脆弱性、コンプライアンス、カスタマイズ、レポート | [**セキュリティ設定**](configuration/_index.md)<br>設定、テスト、コンプライアンス、スキャン、イネーブルメント |
| [**コンテナスキャン**](container_scanning/_index.md)<br>イメージの脆弱性スキャン、設定、カスタマイズ、レポート | [**依存関係スキャン**](dependency_scanning/_index.md)<br>脆弱性、修正、設定、アナライザー、レポート | [**比較**](comparison_dependency_and_container_scanning.md)<br>依存関係スキャンとコンテナスキャンの比較 |
| [**依存関係リスト**](dependency_list/_index.md)<br>脆弱性、ライセンス、フィルタリング、エクスポート | [**継続的脆弱性スキャン**](continuous_vulnerability_scanning/_index.md)<br>スキャン、依存関係、アドバイザリー、バックグラウンドジョブ | [**静的アプリケーションセキュリティテスト**](sast/_index.md)<br>スキャン、設定、アナライザー、脆弱性、レポート、カスタマイズ、インテグレーション |
| [**Infrastructure as Code（IaC）スキャン**](iac_scanning/_index.md)<br>脆弱性検出、設定分析、パイプラインの統合 | [**シークレット検出**](secret_detection/_index.md)<br>検出、防止、モニタリング、ストレージ、無効化、レポート | [**動的アプリケーションセキュリティテスト（DAST）**](dast/_index.md)<br>自動ペネトレーションテスト、脆弱性検出、Webアプリケーションスキャン、セキュリティ評価、CI/CDインテグレーション |
| [**APIセキュリティ**](api_security/_index.md)<br>保護、分析、テスト、スキャン、調査 | [**Web APIファズテスト**](api_fuzzing/_index.md)<br>テスト、セキュリティ、脆弱性、自動化、エラー | [**カバレッジガイドファズテスト**](coverage_fuzzing/_index.md)<br>カバレッジガイドファジング、ランダム入力、予期しない動作 |
| [**セキュリティダッシュボード**](security_dashboard/_index.md)<br>セキュリティダッシュボード、脆弱性の傾向、プロジェクト評価、メトリクス | [**オフライン環境**](offline_deployments/_index.md)<br>オフラインセキュリティスキャン、脆弱性の修正 | [**脆弱性レポート**](vulnerability_report/_index.md)<br>フィルタリング、グループ化、エクスポート、手動追加 |
| [**脆弱性ページ**](vulnerabilities/_index.md)<br>脆弱性の詳細、ステータス、修正、イシューへのリンク | [**脆弱性の重大度レベル**](vulnerabilities/severities.md)<br>分類、影響、優先順位、リスク評価 | [**GitLab Advisory Database**](gitlab_advisory_database/_index.md)<br>セキュリティアドバイザリー、脆弱性、依存関係、データベース、更新 |
| [**CVE IDリクエスト**](cve_id_request.md)<br>脆弱性の追跡、セキュリティ開示 | [**ポリシー**](policies/_index.md)<br>セキュリティポリシー、適用、コンプライアンス、承認、スキャン | [**セキュリティスキャナーのインテグレーション**](../../development/integrations/secure.md)<br>レポート、脆弱性、修正、追跡 |
