---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Introduction to the product.
title: 'Tutorials: Find your way around GitLab'
---

Get to know the features of GitLab and where to find them so you can get up
and running quickly.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [GitLab with Git Essentials](https://university.gitlab.com/courses/gitlab-with-git-essentials-s2)  |  Learn the basics of Git and GitLab in this self-paced course. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [How to start a free trial](https://www.youtube.com/watch?v=dIlBLrXbfrM&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=63) (3m 01s) | Learn how to start a free 30-day Ultimate trial, and create your first project. | {{< icon name="star" >}} |
| [Use the left sidebar to navigate GitLab](left_sidebar/_index.md) |  Start navigating the GitLab UI. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [GitLab Continuous Delivery overview](https://www.youtube.com/watch?v=M7rBDZYsx8U&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=193) (17m 2s) | Learn how to use GitLab features to continuously build, test, and deploy iterative code changes. | |

## Find more tutorial content

- Find learning tracks and certification options at [GitLab University](https://university.gitlab.com/).
- Find recent tutorials on the [GitLab blog](https://about.gitlab.com/blog/).
- Browse the **GitLab Snapshots** [playlist on YouTube](https://www.youtube.com/playlist?list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED)
  to find video tutorials.
