---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Mailgun private API token'
---

## Description

The response body contains content that matches the pattern of a Mailgun private API token was identified. This key allows you to perform read, write, and delete operations through various API endpoints and for any of your sending domains. A malicious actor with access to this key can perform any API request to Mailgun without restriction.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate a private API token:

- Sign in to your Mailgun account and access the dashboard at <https://app.mailgun.com/>
- On the top right-hand side, select your account profile and then select "API Security"
- Find the identified key and select the trash icon
- If you cannot select the trash icon, you must first generate a new key by selecting "Add new key"
- When prompted, select "Delete" in the "Delete API Key" dialog

For more information, please see [Mailgun's documentation on API keys](https://documentation.mailgun.com/docs/mailgun/user-manual/get-started/#primary-account-api-key).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.74 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
