/* Main module for the GyachE-Broadcaster program:
   This application is used to send webcam streams to
   Yahoo. This program has only been tested with a
   both Video4Linux-1 device: An OV511 DLink C100 USB webcam,
   and a V4L2 devive (a creative something)
   The program uses libv4l for image capture and the libJasper
   library for Jpeg-2000 image conversions.
*/

/* This program borrows alot of code from both Ayttm and 
   Gyach-E itself, as well as the old 'videodog' program
   for a few decent V4L usage examples.

   It is designed for simplicity, speed, 
   memory-friendliness, and stability: It runs as an EXTERNAL 
   program to Gyach Enhanced, so that if it DOES crash, it 
   crashes ALONE, rather than taking down an entire chat program
   with it. It is a clean, efficient SINGLE-THREADED application 
*/

/*****************************************************************************
 * main.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005 Erica Andrews (Phrozensmoke ['at'] yahoo.com)
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/
/* 
	Videodog is Copyright (C) 2000, 
	Gleicon S. Moraes - gleicon@uol.com.br rde@linuxbr.com 

	Ayttm is  Copyright (C) 2003, the Ayttm team
	and Copyright (C) 1999-2002, Torrey Searle <tsearle@uci.edu>
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/select.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <locale.h>
#include <signal.h>
#include <stdlib.h>
#include <libintl.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "camcapt.h"
#include "gyacheupload-ui.h"
#include "gyacheupload-v4l.h"

#include "gyachi_lib.h"
#include "gy_config.h"


extern GtkWidget *vstatuslabel;
int cam_app_quit=0;
unsigned long sock_sleep=250;
GtkWidget *main_window;

/* FOR TESTING */ /* 
int jpfswitch=0; 
 */

int display_disconnect_message(void *arg) {
	char gbuf[255];
	int len;
	int max = sizeof(gbuf);

	gbuf[max-1] = 0;
	strncpy(gbuf, _("You have been disconnected from Yahoo!: Broken pipe."), max-1);
	len = strlen(gbuf);

	if (len < (max-3)) {
		strncat(gbuf, "\n", max-len-1);
	}
	len = strlen(gbuf);
	strncat(gbuf, _("You have been disconnected from the Yahoo webcam server."), max-len-1);
	show_ok_dialog(gbuf, main_window, _("Webcam Broadcaster"), 0, NULL);
	cleanup_v4l(NULL);
	mem_cleanup();
	return(FALSE);
}

void SIGPIPE_Handler (int signo) {
	if (signo == SIGPIPE) {
		g_idle_add(display_disconnect_message, NULL);
	}
}


/* FOR TESTING */ /*  
void jasp_im_test()  {
	FILE *jpf;
	int jpflen=0;
	char myjpf[255]="";

	if (jpfswitch==0) {
		snprintf(myjpf, 252, "%s",  "/tmp/john_last65.jp2");
						  } else {
		snprintf(myjpf, 252, "%s",  "/tmp/sjs329.jp2");
									}

    jpf=fopen(myjpf, "rb");
    if (!jpf) {return; }
    fseek(jpf, 0, SEEK_END);
    jpflen=ftell(jpf);
	packet_size=jpflen;
    fseek(jpf, 0, SEEK_SET);
    fread(packet_data, 1, jpflen, jpf);
    fclose(jpf);

	if (!jpfswitch) {jpfswitch=1;} else {jpfswitch=0;}
	image_need_update=1;
}
 */  
/* End: FOR TESTING */

int main( int argc, char **argv ) {
	struct timeval tv;
	fd_set set;
	int ret;
	char *vid_device=NULL;
	char titlebuf[81]="";
	struct timeval next_update;
	struct timeval time_now;

	/* Takes 3-4 command-line arguments right now:
		[your_screename], string
		[web_cam_key_from_gyachE], string
		[v4l_device] - ignored for now, int
		[initial webcam-server], string
		[optional_comma_separated_friends_list]- string
	*/

		
	if ((argc>2) && (argc<4)) {
		printf("\n   Gyach Enhanced / GYachI External Webcam Broadcaster\n   Version:  %s\n   License: GNU General Public License\n   Copyright (c) 2004 Erica Andrews\n   PhrozenSmoke ['at'] yahoo.com\n\n   Copyright (c) 2006 Stefan Sikora\n   hoshy ['at'] schrauberstube.de\n\n   Copyright (c) 2008 Gregory D Hosler\n   ghosler ['at'] users.sourceforge.net\n\nUsage: gyachi-upload [your_screename] [web_cam_key_from_gyachE] [v4l_device] [webcam-server] [optional_comma_separated_friends_list]\n\n   You should be running this\n   program in Gyach Enhanced,\n   NOT on the command-line!\n\n", CAM_VERSION);
		fflush(stdout);
		exit(0);
	}

	if (argc == 2) {
		whoami = strdup("testing");
		webcam_to_view = whoami;
		webcam_key = NULL;
		vid_device = strdup(argv[1]);
		webcam_server = NULL;
	}
	else {
		whoami = strdup(argv[1]);
		webcam_to_view = whoami;
		webcam_key = strdup(argv[2]);
		vid_device = strdup(argv[3]);
		webcam_server = strdup(argv[4]);
	}

	if (argc>5) {
		friends_list=strdup(argv[4]);
		/* printf("\nFriends List: %s\n", friends_list); fflush(stdout);  */
	}

	setlocale(LC_ALL, "");
#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, LOCALEDIR);  
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain (PACKAGE);
#endif
	gtk_set_locale();

#if defined(G_THREADS_ENABLED)
	g_thread_init(NULL);
#endif
	gdk_threads_init();
	gdk_threads_enter();

	gtk_init( &argc, &argv );

	gyach_init();
	read_capturc();

	set_video_device(vid_device);

	/* init GUI */
	snprintf(titlebuf, 80, "%s: %s", webcam_to_view, _("Webcam"));
	main_window = gyache_image_window_new(320, 240, titlebuf);
	gtk_label_set_text(GTK_LABEL(vstatuslabel), _("Not Broadcasting"));

	/* Trap possible broken pipe crap with msg dialog instead of 
	    abrupt exiting of the app */

	if (signal(SIGPIPE, SIGPIPE_Handler) == SIG_ERR) {  }

	while( gtk_events_pending()) {
		gtk_main_iteration();
	}

	gettimeofday(&next_update, NULL);

	while( ! cam_app_quit ) {
		while( gtk_events_pending()) {
			gtk_main_iteration();
		}

		if (! video_paused) {
			if (cam_is_open) {
				gettimeofday(&time_now, NULL);
				if ((time_now.tv_sec > next_update.tv_sec) ||
				    ((time_now.tv_sec == next_update.tv_sec) && (time_now.tv_usec > next_update.tv_usec))) {
					update_cam(main_window);
					gettimeofday(&next_update, NULL);
					next_update.tv_usec += 1000000/max_fps;
					while (next_update.tv_usec >= 1000000) {
						next_update.tv_usec -= 1000000;
						next_update.tv_sec++;
					}
				}
			}
		}

		while( gtk_events_pending()) {
			gtk_main_iteration();
		}

		/* now check for input on our socket */
		FD_ZERO( &set );
		if (webcam_connected) {
			if ( camsocket != -1 ) {
				FD_SET( camsocket, &set );

				tv.tv_sec = 0;
				tv.tv_usec = 50000;
				ret = select( camsocket + 1, &set, NULL, NULL, &tv );

				if ( ret ) {
					show_webcam_packet(main_window);
					usleep(sock_sleep);   /* a little flow control */
				}
			} /* end if */
		}
		else {
			usleep(sock_sleep);
		}
	}  /* end while */

	mem_cleanup();
	if (vid_device) {free(vid_device); vid_device=NULL;}
	if (friends_list) {free(friends_list); friends_list=NULL;}
	return( 0 );
}
