/*****************************************************************************

Copyright (c) 2011, 2016, Oracle and/or its affiliates. All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1335 USA

*****************************************************************************/

/******************************************************************//**
@file include/fts0priv.ic
Full text search internal header file

Created 2011/11/12 Sunny Bains
***********************************************************************/

/******************************************************************//**
Write the table id to the given buffer (including final NUL). Buffer must be
at least FTS_AUX_MIN_TABLE_ID_LENGTH bytes long.
@return number of bytes written */
UNIV_INLINE
int
fts_write_object_id(
/*================*/
	ib_id_t		id,		/* in: a table/index id */
	char*		str)		/* in: buffer to write the id to */
{
	return(snprintf(str, FTS_AUX_MIN_TABLE_ID_LENGTH,
                        "%016llx", (ulonglong) id));
}

/******************************************************************//**
Read the table id from the string generated by fts_write_object_id().
@return TRUE if parse successful */
UNIV_INLINE
ibool
fts_read_object_id(
/*===============*/
	ib_id_t*	id,		/* out: an id */
	const char*	str)		/* in: buffer to read from */
{
	/* NOTE: this func doesn't care about whether current table
	is set with HEX_NAME, the user of the id read here will check
	if the id is HEX or DEC and do the right thing with it. */
	return(sscanf(str, UINT64PFx, id) == 1);
}
