#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Styx: Shards of Darkness
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250918.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='styx-2-shards-of-darkness'
GAME_NAME='Styx: Shards of Darkness'

ARCHIVE_BASE_0_NAME='setup_styx_shards_of_darkness_1.05_(64bit)_(35386).exe'
ARCHIVE_BASE_0_MD5='d8243e3c00aaea8cba64c6906521918e'
ARCHIVE_BASE_0_TYPE='innosetup'
## Extract all localised files, not limited to the English localisation.
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--collisions rename-all --lowercase'
ARCHIVE_BASE_0_PART1_NAME='setup_styx_shards_of_darkness_1.05_(64bit)_(35386)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='ba9135352ab02041024a8e16b4c97dd9'
ARCHIVE_BASE_0_PART2_NAME='setup_styx_shards_of_darkness_1.05_(64bit)_(35386)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='dfe177f7dccf41e6af7eeb2472b670f3'
ARCHIVE_BASE_0_PART3_NAME='setup_styx_shards_of_darkness_1.05_(64bit)_(35386)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='45df5b10aa2ade4789e6f5cce8ed7afd'
ARCHIVE_BASE_0_SIZE='11160684'
ARCHIVE_BASE_0_VERSION='1.05-gog35386'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/styx_shards_of_darkness'

UNREALENGINE4_NAME='styx2'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_PAKS_FILES="
${UNREALENGINE4_NAME}/content/paks"

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/${UNREALENGINE4_NAME}-win64-shipping.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=IDICON_UE4GAME'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_FR
PKG_L10N_EN
PKG_DATA_PAKS
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_FR_DESCRIPTION='French localisation'
PKG_L10N_EN_DESCRIPTION='English localisation'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_PAKS'

PKG_DATA_PAKS_ID="${PKG_DATA_ID}-paks"
PKG_DATA_PAKS_DESCRIPTION="$PKG_DATA_DESCRIPTION - paks"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
install -D --mode=644 --no-target-directory \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/goggame-2090261953.info@fr-FR" \
	"$(package_path 'PKG_L10N_FR')$(path_game_data)/goggame-2090261953.info"
install -D --mode=644 --no-target-directory \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/goggame-2090261953.info@en-US" \
	"$(package_path 'PKG_L10N_EN')$(path_game_data)/goggame-2090261953.info"
content_inclusion_default

# Write launchers.

## Do not install the Visual C++ Runtime, to prevent a launch error related to msvcp140.dll.
unrealengine4_wine_winetricks_verbs_default() { return 0; }

launchers_generation

# Build packages.

packages_generation
case "$(messages_language)" in
	('fr')
		lang_string='version %s :'
		lang_fr='française'
		lang_en='anglaise'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_fr='French'
		lang_en='English'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_fr"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_DATA_PAKS' 'PKG_L10N_FR'
printf "$lang_string" "$lang_en"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_DATA_PAKS' 'PKG_L10N_EN'

# Clean up.

working_directory_cleanup

exit 0
