// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_COMPONENTS_QUICK_ANSWERS_UTILS_QUICK_ANSWERS_UTILS_H_
#define CHROMEOS_COMPONENTS_QUICK_ANSWERS_UTILS_QUICK_ANSWERS_UTILS_H_

#include "chromeos/components/quick_answers/quick_answers_model.h"

namespace chromeos {
namespace quick_answers {

const PreprocessedOutput PreprocessRequest(const IntentInfo& intent_info);

// Build title text for Quick Answers definition result.
std::string BuildDefinitionTitleText(const std::string& query_term,
                                     const std::string& phonetics);

// Build title text for Quick Answers knowledge panel entity result.
std::string BuildKpEntityTitleText(const std::string& average_score,
                                   const std::string& aggregated_count);

// Build title text for Quick Answers translation result.
std::string BuildTranslationTitleText(const IntentInfo& intent_info);

// Build title text for Quick Answers translation result.
std::string BuildTranslationTitleText(const std::string& query_text,
                                      const std::string& locale_name);

// Unescapes the following ampersand character codes from |string|:
// &lt; &gt; &amp; &quot; &#39;
std::string UnescapeStringForHTML(const std::string& string);

}  // namespace quick_answers
}  // namespace chromeos

#endif  // CHROMEOS_COMPONENTS_QUICK_ANSWERS_UTILS_QUICK_ANSWERS_UTILS_H_
