import { BinaryView, Frag } from "@ot-builder/bin-util";
export declare enum DeltaRunFlags {
    DELTAS_ARE_ZERO = 128,
    DELTAS_ARE_WORDS = 64,
    DELTA_RUN_COUNT_MASK = 63
}
export declare enum DeltaRunType {
    Zero = 0,
    Short = 1,
    Long = 2
}
export declare const DeltaRun: {
    read(view: BinaryView, deltasParsed: number, points: number[], deltas: number[]): number;
};
export declare const PointCount: {
    read(view: BinaryView): number | null;
    write(b: Frag, x: number): void;
};
export declare enum PointNumberFlags {
    POINTS_ARE_WORDS = 128,
    POINT_RUN_COUNT_MASK = 127
}
export declare enum PointNumberRunType {
    Short = 0,
    Long = 1
}
export declare const PointNumberRun: {
    read(view: BinaryView, currentPoint: number, points: number[]): number;
};
export declare namespace DeltaRunDp {
    class Writer {
        constructor(trackLength: number);
        private readonly trackingModes;
        private readonly trackingRestMask;
        private started;
        private zero;
        private byte;
        private word;
        update(x: number): void;
        write(frag: Frag): void;
    }
}
export declare namespace PointNumberRunDp {
    class Writer {
        constructor(trackLength: number);
        private readonly trackingModes;
        private readonly trackingRestMask;
        private started;
        private byte;
        private word;
        update(x: number): void;
        write(frag: Frag): void;
    }
}
//# sourceMappingURL=runs.d.ts.map