; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -p constraint-elimination -S %s | FileCheck %s

; Tests for https://github.com/llvm/llvm-project/issues/78621.

define i1 @umin_not_used(i32 %arg) {
; CHECK-LABEL: define i1 @umin_not_used(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[ICMP:%.*]] = icmp slt i32 [[ARG]], 0
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw nsw i32 [[ARG]], 3
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.umin.i32(i32 [[SHL]], i32 80)
; CHECK-NEXT:    [[CMP2:%.*]] = shl nuw nsw i32 [[ARG]], 3
; CHECK-NEXT:    ret i1 [[ICMP]]
;
  %icmp = icmp slt i32 %arg, 0
  %shl = shl nuw nsw i32 %arg, 3
  call i32 @llvm.umin.i32(i32 %shl, i32 80)
  %cmp2 = shl nuw nsw i32 %arg, 3
  ret i1 %icmp
}

define i1 @umin_poison_is_UB_via_call(i32 %arg) {
; CHECK-LABEL: define i1 @umin_poison_is_UB_via_call(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw nsw i32 [[ARG]], 3
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.umin.i32(i32 [[SHL]], i32 80)
; CHECK-NEXT:    call void @noundef(i32 noundef [[MIN]])
; CHECK-NEXT:    [[CMP2:%.*]] = shl nuw nsw i32 [[ARG]], 3
; CHECK-NEXT:    ret i1 false
;
  %icmp = icmp slt i32 %arg, 0
  %shl = shl nuw nsw i32 %arg, 3
  %min = call i32 @llvm.umin.i32(i32 %shl, i32 80)
  call void @noundef(i32 noundef %min)
  %cmp2 = shl nuw nsw i32 %arg, 3
  ret i1 %icmp
}

define i1 @umin_poison_call_before_UB(i32 %arg) {
; CHECK-LABEL: define i1 @umin_poison_call_before_UB(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[ICMP:%.*]] = icmp slt i32 [[ARG]], 0
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw nsw i32 [[ARG]], 3
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.umin.i32(i32 [[SHL]], i32 80)
; CHECK-NEXT:    call void @fn()
; CHECK-NEXT:    call void @noundef(i32 noundef [[MIN]])
; CHECK-NEXT:    [[CMP2:%.*]] = shl nuw nsw i32 [[ARG]], 3
; CHECK-NEXT:    ret i1 [[ICMP]]
;
  %icmp = icmp slt i32 %arg, 0
  %shl = shl nuw nsw i32 %arg, 3
  %min = call i32 @llvm.umin.i32(i32 %shl, i32 80)
  call void @fn()
  call void @noundef(i32 noundef %min)
  %cmp2 = shl nuw nsw i32 %arg, 3
  ret i1 %icmp
}

declare i32 @llvm.umin.i32(i32, i32) #0

declare void @noundef(i32 noundef)
declare void @fn()
