; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes='default<O3>' < %s | FileCheck %s --check-prefixes=CHECK,DEFAULT
; RUN: opt -S -passes='lto<O3>' < %s | FileCheck %s --check-prefixes=CHECK,LTO

declare void @llvm.trap()

define void @do_trap(ptr %ptr) {
; CHECK-LABEL: @do_trap(
; CHECK-NEXT:    tail call void @llvm.trap()
; CHECK-NEXT:    unreachable
;
  call void @llvm.trap()
  unreachable
}

define internal void @capture_and_trap(ptr %ptr) noinline {
; CHECK-LABEL: @capture_and_trap(
; CHECK-NEXT:    tail call void @llvm.trap()
; CHECK-NEXT:    unreachable
;
  %alloca = alloca ptr, align 4
  store ptr %ptr, ptr %alloca, align 4
  call void @do_trap(ptr noundef nonnull %alloca)
  unreachable
}

define internal void @dead_fn1() {
  ret void
}

define internal void @dead_fn2() {
  ret void
}

define void @test(i1 %c) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    tail call fastcc void @capture_and_trap()
; CHECK-NEXT:    unreachable
;
  br i1 %c, label %if, label %else

if:
  call void @capture_and_trap(ptr @dead_fn1)
  unreachable

else:
  call void @capture_and_trap(ptr @dead_fn2)
  unreachable
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; DEFAULT: {{.*}}
; LTO: {{.*}}
