/* test-color.c generated by valac 0.10.4, the Vala compiler
 * generated from test-color.vala, do not modify */

/*
 * Tests the Color class, plus its interaction with the Config interface.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/config.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



void print_color (DesktopAgnosticColor* clr, const char* name);
void print_cfg_color (DesktopAgnosticConfigBackend* cfg, const char* name);
gint _vala_main (char** args, int args_length1);



void print_color (DesktopAgnosticColor* clr, const char* name) {
	g_return_if_fail (name != NULL);
	if (clr == NULL) {
		g_message ("test-color.vala:29: color '%s' is NULL", name);
	} else {
		char* _tmp0_;
		g_message ("test-color.vala:33: color '%s' = %s", name, _tmp0_ = desktop_agnostic_color_to_string (clr));
		_g_free0 (_tmp0_);
	}
}


void print_cfg_color (DesktopAgnosticConfigBackend* cfg, const char* name) {
	GValue val = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (cfg != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = (desktop_agnostic_config_backend_get_value (cfg, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, name, &_tmp0_, &_inner_error_), _tmp0_);
	if (_inner_error_ != NULL) {
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	val = (_tmp2_ = _tmp1_, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp2_);
	print_color (g_value_get_object (&val), name);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		DesktopAgnosticConfigSchema* schema;
		DesktopAgnosticConfigBackend* cfg;
		GValue _tmp2_ = {0};
		GValue val;
		GValueArray* array;
		{
			DesktopAgnosticColor* green;
			char* _tmp0_;
			DesktopAgnosticColor* one_char_hex;
			char* _tmp1_;
			green = desktop_agnostic_color_new_from_string ("green", &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
					goto __catch1_desktop_agnostic_color_parse_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			g_assert (desktop_agnostic_color_get_alpha (green) == G_MAXUSHORT);
			g_message ("test-color.vala:53: green = %s", _tmp0_ = desktop_agnostic_color_to_string (green));
			_g_free0 (_tmp0_);
			one_char_hex = desktop_agnostic_color_new_from_string ("#f00f", &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (green);
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
					goto __catch1_desktop_agnostic_color_parse_error;
				}
				_g_object_unref0 (green);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			g_message ("test-color.vala:55: red = %s", _tmp1_ = desktop_agnostic_color_to_string (one_char_hex));
			_g_free0 (_tmp1_);
			_g_object_unref0 (one_char_hex);
			_g_object_unref0 (green);
		}
		goto __finally1;
		__catch1_desktop_agnostic_color_parse_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("test-color.vala:59: Color parse error: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		schema = desktop_agnostic_config_schema_new ("test-color.schema-ini", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		cfg = desktop_agnostic_config_new (schema, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			goto __catch0_g_error;
		}
		print_cfg_color (cfg, "color");
		print_cfg_color (cfg, "none");
		val = (desktop_agnostic_config_backend_get_value (cfg, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "color_list", &_tmp2_, &_inner_error_), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cfg);
			_g_object_unref0 (schema);
			goto __catch0_g_error;
		}
		array = g_value_get_boxed (&val);
		{
			guint i;
			i = (guint) 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					GValue v;
					char* _tmp4_;
					if (!_tmp3_) {
						i++;
					}
					_tmp3_ = FALSE;
					if (!(i < array->n_values)) {
						break;
					}
					v = *g_value_array_get_nth (array, i);
					print_color (g_value_get_object (&v), _tmp4_ = g_strdup_printf ("color_list[%u]", i));
					_g_free0 (_tmp4_);
				}
			}
		}
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		_g_object_unref0 (cfg);
		_g_object_unref0 (schema);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-color.vala:75: Error: %s", err->message);
			result = 1;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}




