/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup PublicHighLevelCallbacks High Level Callbacks
 * @ingroup PublicHighLevelAPI
 * @brief The public part
 */
/*@{*/

#ifndef _SML_DATA_SYNC_API_CALLBACKS_H_
#define _SML_DATA_SYNC_API_CALLBACKS_H_

#include <libsyncml/data_sync_api/standard.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* required callbacks - the event handler */

typedef void (* SmlDataSyncEventCallback) (
			SmlDataSyncObject *dsObject,
			SmlDataSyncEventType type,
			void *userdata,
			SmlError *error);
typedef SmlAlertType (* SmlDataSyncGetAlertTypeCallback) (
			SmlDataSyncObject *dsObject,
			const char *source,
			SmlAlertType type,
			void *userdata,
			SmlError **error);
typedef SmlBool (* SmlDataSyncChangeCallback) (
			SmlDataSyncObject *dsObject,
			const char *source,
			SmlChangeType type,
			const char *uid,
			char *data,
			unsigned int size,
			void *userdata,
			SmlError **error);
/* FIXME: newuid must be removed before next API break */
/* FIXME: DEPRECATED */
typedef SmlBool (* SmlDataSyncChangeStatusCallback) (
			SmlDataSyncObject *dsObject,
			unsigned int code,
			const char *newuid,
			void *userdata,
			SmlError **error);
typedef SmlBool (* SmlDataSyncMappingCallback) (
			SmlDataSyncObject *dsObject,
			const char *source,
			const char *orig,
			const char *newuid,
			void *userdata,
			SmlError **error);
typedef char *(* SmlDataSyncGetAnchorCallback) (
			SmlDataSyncObject *dsObject,
			const char *name,
			void *userdata,
			SmlError **error);
typedef SmlBool (* SmlDataSyncSetAnchorCallback) (
			SmlDataSyncObject *dsObject,
			const char *name,
			const char *value,
			void *userdata,
			SmlError **error);
typedef SmlBool (* SmlDataSyncWriteDevInfCallback) (
			SmlDataSyncObject *dsObject,
			SmlDevInf *devinf,
			void *userdata,
			SmlError **error);
typedef SmlDevInf *(* SmlDataSyncReadDevInfCallback) (
			SmlDataSyncObject *dsObject,
			const char *devid,
			void *userdata,
			SmlError **error);
typedef SmlBool (* SmlDataSyncHandleRemoteDevInfCallback) (
			SmlDataSyncObject *dsObject,
			SmlDevInf *devinf,
			void *userdata,
			SmlError **error);

/* functions to register the callbacks */

void smlDataSyncRegisterEventCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncEventCallback callback,
			void *userdata);
void smlDataSyncRegisterGetAlertTypeCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncGetAlertTypeCallback callback,
			void *userdata);
void smlDataSyncRegisterChangeCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncChangeCallback callback,
			void *userdata);
void smlDataSyncRegisterMappingCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncMappingCallback callback,
			void *userdata);
void smlDataSyncRegisterGetAnchorCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncGetAnchorCallback callback,
			void *userdata);
void smlDataSyncRegisterSetAnchorCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncSetAnchorCallback callback,
			void *userdata);
void smlDataSyncRegisterWriteDevInfCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncWriteDevInfCallback callback,
			void *userdata);
void smlDataSyncRegisterReadDevInfCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncReadDevInfCallback callback,
			void *userdata);
void smlDataSyncRegisterHandleRemoteDevInfCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncHandleRemoteDevInfCallback callback,
			void *userdata);

/* ChangeStatus uses the userdata from AddChange */

void smlDataSyncRegisterChangeStatusCallback(
			SmlDataSyncObject *dsObject,
			SmlDataSyncChangeStatusCallback callback);

#ifdef __cplusplus
}
#endif

#endif /* _SML_DATA_SYNC_API_CALLBACKS_H_ */

/*@}*/

