/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JFrame;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.gui.GenericObjectEditor;
import weka.gui.Messages;
import weka.gui.PropertyValueSelector;

public class SelectedTagEditor
extends PropertyEditorSupport {
    public String getJavaInitializationString() {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        String result = "new SelectedTag(" + s.getSelectedTag().getID() + ", {\n";
        for (int i = 0; i < tags.length; ++i) {
            result = result + "new Tag(" + tags[i].getID() + ",\"" + tags[i].getReadable() + "\")";
            if (i < tags.length - 1) {
                result = result + ',';
            }
            result = result + '\n';
        }
        return result + "})";
    }

    public String getAsText() {
        SelectedTag s = (SelectedTag)this.getValue();
        return s.getSelectedTag().getReadable();
    }

    public void setAsText(String text) {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        try {
            for (int i = 0; i < tags.length; ++i) {
                if (!text.equals(tags[i].getReadable())) continue;
                this.setValue(new SelectedTag(tags[i].getID(), tags));
                return;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(text);
        }
    }

    public String[] getTags() {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        String[] result = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            result[i] = tags[i].getReadable();
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            Tag[] tagArray = new Tag[5];
            Messages.getInstance();
            tagArray[0] = new Tag(1, Messages.getString("SelectedTagEditor_Main_Tags_Text_First"));
            Messages.getInstance();
            tagArray[1] = new Tag(2, Messages.getString("SelectedTagEditor_Main_Tags_Text_Second"));
            Messages.getInstance();
            tagArray[2] = new Tag(3, Messages.getString("SelectedTagEditor_Main_Tags_Text_Third"));
            Messages.getInstance();
            tagArray[3] = new Tag(4, Messages.getString("SelectedTagEditor_Main_Tags_Text_Fourth"));
            Messages.getInstance();
            tagArray[4] = new Tag(5, Messages.getString("SelectedTagEditor_Main_Tags_Text_Fifth"));
            Tag[] tags = tagArray;
            SelectedTag initial = new SelectedTag(1, tags);
            SelectedTagEditor ce = new SelectedTagEditor();
            ce.setValue(initial);
            PropertyValueSelector ps = new PropertyValueSelector(ce);
            JFrame f = new JFrame();
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)ps, "Center");
            f.pack();
            f.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

