/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.ChartEvent;
import weka.gui.beans.ChartListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.Messages;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;

public class IncrementalClassifierEvaluator
extends AbstractEvaluator
implements IncrementalClassifierListener,
EventConstraints {
    private static final long serialVersionUID = -3105419818939541291L;
    private transient Evaluation m_eval;
    private transient Classifier m_classifier;
    private Vector m_listeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Vector m_dataLegend = new Vector();
    private ChartEvent m_ce = new ChartEvent(this);
    private double[] m_dataPoint = new double[1];
    private boolean m_reset = false;
    private double m_min = Double.MAX_VALUE;
    private double m_max = Double.MIN_VALUE;
    private int m_statusFrequency = 100;
    private int m_instanceCount = 0;
    private boolean m_outputInfoRetrievalStats = false;

    public IncrementalClassifierEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/IncrementalClassifierEvaluator.gif", "weka/gui/beans/icons/IncrementalClassifierEvaluator_animated.gif");
        this.m_visual.setText("IncrementalClassifierEvaluator");
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("IncrementalClassifierEvaluator_GlobalInfo_Text");
    }

    public void acceptClassifier(IncrementalClassifierEvent ce) {
        try {
            if (ce.getStatus() == 0) {
                this.m_eval = new Evaluation(ce.getStructure());
                this.m_eval.useNoPriors();
                this.m_dataLegend = new Vector();
                this.m_reset = true;
                this.m_dataPoint = new double[0];
                Instances inst = ce.getStructure();
                Messages.getInstance();
                System.err.println(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_Error_Text"));
                this.m_instanceCount = 0;
                if (this.m_logger != null) {
                    StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                    Messages.getInstance();
                    this.m_logger.statusMessage(stringBuilder.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_StatusMessage_Text_First")).toString());
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_LogMessage_Text_First")).append(this.statusMessagePrefix());
                    Messages.getInstance();
                    this.m_logger.logMessage(stringBuilder3.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_LogMessage_Text_Second")).toString());
                }
            } else {
                if (this.m_instanceCount > 0 && this.m_instanceCount % this.m_statusFrequency == 0 && this.m_logger != null) {
                    StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                    Messages.getInstance();
                    StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_StatusMessage_Text_Second")).append(this.m_instanceCount);
                    Messages.getInstance();
                    this.m_logger.statusMessage(stringBuilder4.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_StatusMessage_Text_Third")).toString());
                }
                ++this.m_instanceCount;
                Instance inst = ce.getCurrentInstance();
                double[] dist = ce.getClassifier().distributionForInstance(inst);
                double pred = 0.0;
                if (!inst.isMissing(inst.classIndex())) {
                    if (this.m_outputInfoRetrievalStats) {
                        this.m_eval.evaluateModelOnceAndRecordPrediction(dist, inst);
                    } else {
                        this.m_eval.evaluateModelOnce(dist, inst);
                    }
                } else {
                    pred = ce.getClassifier().classifyInstance(inst);
                }
                if (inst.classIndex() >= 0) {
                    if (inst.attribute(inst.classIndex()).isNominal()) {
                        if (!inst.isMissing(inst.classIndex())) {
                            if (this.m_dataPoint.length < 2) {
                                this.m_dataPoint = new double[2];
                                this.m_dataLegend.addElement("Accuracy");
                                this.m_dataLegend.addElement("RMSE (prob)");
                            }
                            this.m_dataPoint[1] = this.m_eval.rootMeanSquaredError();
                        } else if (this.m_dataPoint.length < 1) {
                            this.m_dataPoint = new double[1];
                            this.m_dataLegend.addElement("Confidence");
                        }
                        double primaryMeasure = 0.0;
                        primaryMeasure = !inst.isMissing(inst.classIndex()) ? 1.0 - this.m_eval.errorRate() : dist[Utils.maxIndex(dist)];
                        this.m_dataPoint[0] = primaryMeasure;
                        this.m_ce.setLegendText(this.m_dataLegend);
                        this.m_ce.setMin(0.0);
                        this.m_ce.setMax(1.0);
                        this.m_ce.setDataPoint(this.m_dataPoint);
                        this.m_ce.setReset(this.m_reset);
                        this.m_reset = false;
                    } else {
                        if (this.m_dataPoint.length < 1) {
                            this.m_dataPoint = new double[1];
                            if (inst.isMissing(inst.classIndex())) {
                                this.m_dataLegend.addElement("Prediction");
                            } else {
                                this.m_dataLegend.addElement("RMSE");
                            }
                        }
                        if (!inst.isMissing(inst.classIndex())) {
                            double update = !inst.isMissing(inst.classIndex()) ? this.m_eval.rootMeanSquaredError() : pred;
                            this.m_dataPoint[0] = update;
                            if (update > this.m_max) {
                                this.m_max = update;
                            }
                            if (update < this.m_min) {
                                this.m_min = update;
                            }
                        }
                        this.m_ce.setLegendText(this.m_dataLegend);
                        this.m_ce.setMin(inst.isMissing(inst.classIndex()) ? this.m_min : 0.0);
                        this.m_ce.setMax(this.m_max);
                        this.m_ce.setDataPoint(this.m_dataPoint);
                        this.m_ce.setReset(this.m_reset);
                        this.m_reset = false;
                    }
                    this.notifyChartListeners(this.m_ce);
                    if (ce.getStatus() == 2) {
                        if (this.m_logger != null) {
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_LogMessage_Text_Third")).append(this.statusMessagePrefix());
                            Messages.getInstance();
                            this.m_logger.logMessage(stringBuilder5.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_LogMessage_Text_Fourth")).toString());
                            StringBuilder stringBuilder6 = new StringBuilder().append(this.statusMessagePrefix());
                            Messages.getInstance();
                            this.m_logger.statusMessage(stringBuilder6.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_StatusMessage_Text_Fourth")).toString());
                        }
                        if (this.m_textListeners.size() > 0) {
                            String textTitle = ce.getClassifier().getClass().getName();
                            textTitle = textTitle.substring(textTitle.lastIndexOf(46) + 1, textTitle.length());
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder7 = stringBuilder.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_Result_Text_First")).append(textTitle);
                            Messages.getInstance();
                            String results = stringBuilder7.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_Result_Text_Second")).append(inst.dataset().relationName()).append("\n\n").append(this.m_eval.toSummaryString()).toString();
                            if (inst.classIndex() >= 0 && inst.classAttribute().isNominal() && this.m_outputInfoRetrievalStats) {
                                results = results + "\n" + this.m_eval.toClassDetailsString();
                            }
                            if (inst.classIndex() >= 0 && inst.classAttribute().isNominal()) {
                                results = results + "\n" + this.m_eval.toMatrixString();
                            }
                            StringBuilder stringBuilder8 = new StringBuilder();
                            Messages.getInstance();
                            textTitle = stringBuilder8.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_TextTitle_Text")).append(textTitle).toString();
                            TextEvent te = new TextEvent(this, results, textTitle);
                            this.notifyTextListeners(te);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            if (this.m_logger != null) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder9 = stringBuilder.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_LogMessage_Text_Fifth")).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.logMessage(stringBuilder9.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_LogMessage_Text_Sixth")).append(ex.getMessage()).toString());
                StringBuilder stringBuilder10 = new StringBuilder().append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_logger.statusMessage(stringBuilder10.append(Messages.getString("IncrementalClassifierEvaluator_AcceptClassifier_StatusMessage_Text_Fifth")).toString());
            }
            ex.printStackTrace();
            this.stop();
        }
    }

    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("incrementalClassifier");
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    public boolean isBusy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChartListeners(ChartEvent ce) {
        Vector l;
        IncrementalClassifierEvaluator incrementalClassifierEvaluator = this;
        synchronized (incrementalClassifierEvaluator) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((ChartListener)l.elementAt(i)).acceptDataPoint(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent te) {
        Vector l;
        IncrementalClassifierEvaluator incrementalClassifierEvaluator = this;
        synchronized (incrementalClassifierEvaluator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(te);
            }
        }
    }

    public void setStatusFrequency(int s) {
        this.m_statusFrequency = s;
    }

    public int getStatusFrequency() {
        return this.m_statusFrequency;
    }

    public String statusFrequencyTipText() {
        Messages.getInstance();
        return Messages.getString("IncrementalClassifierEvaluator_StatusFrequencyTipText_Text");
    }

    public void setOutputPerClassInfoRetrievalStats(boolean i) {
        this.m_outputInfoRetrievalStats = i;
    }

    public boolean getOutputPerClassInfoRetrievalStats() {
        return this.m_outputInfoRetrievalStats;
    }

    public String outputPerClassInfoRetrievalStatsTipText() {
        Messages.getInstance();
        return Messages.getString("IncrementalClassifierEvaluator_OutputPerClassInfoRetrievalStatsTipText_Text");
    }

    public synchronized void addChartListener(ChartListener cl) {
        this.m_listeners.addElement(cl);
    }

    public synchronized void removeChartListener(ChartListener cl) {
        this.m_listeners.remove(cl);
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

