/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.core.FastVector;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.Messages;

public class BIFParser
implements GraphConstants {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected String graphName;
    protected String inString;
    protected InputStream inStream;

    public BIFParser(String input, FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.inString = input;
    }

    public BIFParser(InputStream instream, FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.inStream = instream;
    }

    public String parse() throws Exception {
        GraphEdge e;
        int i;
        int j;
        GraphNode n;
        int i2;
        Document dc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (this.inStream != null) {
            dc = db.parse(this.inStream);
        } else if (this.inString != null) {
            dc = db.parse(new InputSource(new StringReader(this.inString)));
        } else {
            Messages.getInstance();
            throw new Exception(Messages.getString("BIFParser_Parse_Exception_Text"));
        }
        NodeList nl = dc.getElementsByTagName("NETWORK");
        if (nl.getLength() == 0) {
            Messages.getInstance();
            throw new BIFFormatException(Messages.getString("BIFParser_Parse_BIFFormatException_Text_First"));
        }
        NodeList templist = ((Element)nl.item(0)).getElementsByTagName("NAME");
        this.graphName = templist.item(0).getFirstChild().getNodeValue();
        nl = dc.getElementsByTagName("VARIABLE");
        for (i2 = 0; i2 < nl.getLength(); ++i2) {
            templist = ((Element)nl.item(i2)).getElementsByTagName("NAME");
            if (templist.getLength() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                throw new BIFFormatException(stringBuilder.append(Messages.getString("BIFParser_Parse_BIFFormatException_Text_Second")).append(i2 + 1).toString());
            }
            String nodename = templist.item(0).getFirstChild().getNodeValue();
            n = new GraphNode(nodename, nodename, 3);
            this.m_nodes.addElement(n);
            templist = ((Element)nl.item(i2)).getElementsByTagName("PROPERTY");
            for (j = 0; j < templist.getLength(); ++j) {
                if (!templist.item(j).getFirstChild().getNodeValue().startsWith("position")) continue;
                String xy = templist.item(j).getFirstChild().getNodeValue();
                n.x = Integer.parseInt(xy.substring(xy.indexOf(40) + 1, xy.indexOf(44)).trim());
                n.y = Integer.parseInt(xy.substring(xy.indexOf(44) + 1, xy.indexOf(41)).trim());
                break;
            }
            templist = ((Element)nl.item(i2)).getElementsByTagName("OUTCOME");
            n.outcomes = new String[templist.getLength()];
            for (j = 0; j < templist.getLength(); ++j) {
                n.outcomes[j] = templist.item(j).getFirstChild().getNodeValue();
            }
        }
        nl = dc.getElementsByTagName("DEFINITION");
        for (i2 = 0; i2 < nl.getLength(); ++i2) {
            templist = ((Element)nl.item(i2)).getElementsByTagName("FOR");
            String nid = templist.item(0).getFirstChild().getNodeValue();
            n = (GraphNode)this.m_nodes.elementAt(0);
            for (j = 1; j < this.m_nodes.size() && !n.ID.equals(nid); ++j) {
                n = (GraphNode)this.m_nodes.elementAt(j);
            }
            templist = ((Element)nl.item(i2)).getElementsByTagName("GIVEN");
            int parntOutcomes = 1;
            for (int j2 = 0; j2 < templist.getLength(); ++j2) {
                nid = templist.item(j2).getFirstChild().getNodeValue();
                GraphNode n2 = (GraphNode)this.m_nodes.elementAt(0);
                for (int k = 1; k < this.m_nodes.size() && !n2.ID.equals(nid); ++k) {
                    n2 = (GraphNode)this.m_nodes.elementAt(k);
                }
                this.m_edges.addElement(new GraphEdge(this.m_nodes.indexOf(n2), this.m_nodes.indexOf(n), 1));
                parntOutcomes *= n2.outcomes.length;
            }
            templist = ((Element)nl.item(i2)).getElementsByTagName("TABLE");
            if (templist.getLength() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                throw new BIFFormatException(stringBuilder.append(Messages.getString("BIFParser_Parse_BIFFormatException_Text_Second_Alpha")).append(n.ID).toString());
            }
            String probs = templist.item(0).getFirstChild().getNodeValue();
            StringTokenizer tk = new StringTokenizer(probs, " \n\t");
            if (parntOutcomes * n.outcomes.length > tk.countTokens()) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("BIFParser_Parse_BIFFormatException_Text_Third")).append(n.ID);
                Messages.getInstance();
                throw new BIFFormatException(stringBuilder2.append(Messages.getString("BIFParser_Parse_BIFFormatException_Text_Fourth")).toString());
            }
            if (parntOutcomes * n.outcomes.length < tk.countTokens()) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("BIFParser_Parse_BIFFormatException_Text_Fifth")).append(n.ID);
                Messages.getInstance();
                throw new BIFFormatException(stringBuilder3.append(Messages.getString("BIFParser_Parse_BIFFormatException_Text_Sixth")).toString());
            }
            n.probs = new double[parntOutcomes][n.outcomes.length];
            for (int r = 0; r < parntOutcomes; ++r) {
                for (int c = 0; c < n.outcomes.length; ++c) {
                    n.probs[r][c] = Double.parseDouble(tk.nextToken());
                    continue;
                }
            }
        }
        int[] noOfEdgesOfNode = new int[this.m_nodes.size()];
        int[] noOfPrntsOfNode = new int[this.m_nodes.size()];
        for (i = 0; i < this.m_edges.size(); ++i) {
            e = (GraphEdge)this.m_edges.elementAt(i);
            int n2 = e.src;
            noOfEdgesOfNode[n2] = noOfEdgesOfNode[n2] + 1;
            int n3 = e.dest;
            noOfPrntsOfNode[n3] = noOfPrntsOfNode[n3] + 1;
        }
        for (i = 0; i < this.m_edges.size(); ++i) {
            int k;
            e = (GraphEdge)this.m_edges.elementAt(i);
            GraphNode n4 = (GraphNode)this.m_nodes.elementAt(e.src);
            GraphNode n2 = (GraphNode)this.m_nodes.elementAt(e.dest);
            if (n4.edges == null) {
                n4.edges = new int[noOfEdgesOfNode[e.src]][2];
                for (k = 0; k < n4.edges.length; ++k) {
                    n4.edges[k][0] = -1;
                }
            }
            if (n2.prnts == null) {
                n2.prnts = new int[noOfPrntsOfNode[e.dest]];
                for (k = 0; k < n2.prnts.length; ++k) {
                    n2.prnts[k] = -1;
                }
            }
            k = 0;
            while (n4.edges[k][0] != -1) {
                ++k;
            }
            n4.edges[k][0] = e.dest;
            n4.edges[k][1] = e.type;
            k = 0;
            while (n2.prnts[k] != -1) {
                ++k;
            }
            n2.prnts[k] = e.src;
        }
        return this.graphName;
    }

    public static void writeXMLBIF03(String filename, String graphName, FastVector nodes, FastVector edges) {
        try {
            GraphNode n;
            int nodeidx;
            FileWriter outfile = new FileWriter(filename);
            StringBuffer text = new StringBuffer();
            text.append("<?xml version=\"1.0\"?>\n");
            text.append("<!-- DTD for the XMLBIF 0.3 format -->\n");
            text.append("<!DOCTYPE BIF [\n");
            text.append("\t<!ELEMENT BIF ( NETWORK )*>\n");
            text.append("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
            text.append("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
            text.append("\t<!ELEMENT NAME (#PCDATA)>\n");
            text.append("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
            text.append("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
            text.append("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
            text.append("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
            text.append("\t<!ELEMENT FOR (#PCDATA)>\n");
            text.append("\t<!ELEMENT GIVEN (#PCDATA)>\n");
            text.append("\t<!ELEMENT TABLE (#PCDATA)>\n");
            text.append("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
            text.append("]>\n");
            text.append("\n");
            text.append("\n");
            text.append("<BIF VERSION=\"0.3\">\n");
            text.append("<NETWORK>\n");
            text.append("<NAME>" + BIFParser.XMLNormalize(graphName) + "</NAME>\n");
            for (nodeidx = 0; nodeidx < nodes.size(); ++nodeidx) {
                n = (GraphNode)nodes.elementAt(nodeidx);
                if (n.nodeType != 3) continue;
                text.append("<VARIABLE TYPE=\"nature\">\n");
                text.append("\t<NAME>" + BIFParser.XMLNormalize(n.ID) + "</NAME>\n");
                if (n.outcomes != null) {
                    for (int outidx = 0; outidx < n.outcomes.length; ++outidx) {
                        text.append("\t<OUTCOME>" + BIFParser.XMLNormalize(n.outcomes[outidx]) + "</OUTCOME>\n");
                    }
                } else {
                    text.append("\t<OUTCOME>true</OUTCOME>\n");
                }
                text.append("\t<PROPERTY>position = (" + n.x + "," + n.y + ")</PROPERTY>\n");
                text.append("</VARIABLE>\n");
            }
            for (nodeidx = 0; nodeidx < nodes.size(); ++nodeidx) {
                n = (GraphNode)nodes.elementAt(nodeidx);
                if (n.nodeType != 3) continue;
                text.append("<DEFINITION>\n");
                text.append("<FOR>" + BIFParser.XMLNormalize(n.ID) + "</FOR>\n");
                int parntOutcomes = 1;
                if (n.prnts != null) {
                    for (int pidx = 0; pidx < n.prnts.length; ++pidx) {
                        GraphNode prnt = (GraphNode)nodes.elementAt(n.prnts[pidx]);
                        text.append("\t<GIVEN>" + BIFParser.XMLNormalize(prnt.ID) + "</GIVEN>\n");
                        if (prnt.outcomes == null) continue;
                        parntOutcomes *= prnt.outcomes.length;
                    }
                }
                text.append("<TABLE>\n");
                for (int i = 0; i < parntOutcomes; ++i) {
                    if (n.outcomes != null) {
                        for (int outidx = 0; outidx < n.outcomes.length; ++outidx) {
                            text.append(n.probs[i][outidx] + " ");
                        }
                    } else {
                        text.append("1");
                    }
                    text.append('\n');
                }
                text.append("</TABLE>\n");
                text.append("</DEFINITION>\n");
            }
            text.append("</NETWORK>\n");
            text.append("</BIF>\n");
            outfile.write(text.toString());
            outfile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static String XMLNormalize(String sStr) {
        StringBuffer sStr2 = new StringBuffer();
        block7: for (int iStr = 0; iStr < sStr.length(); ++iStr) {
            char c = sStr.charAt(iStr);
            switch (c) {
                case '&': {
                    sStr2.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sStr2.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sStr2.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sStr2.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sStr2.append("&gt;");
                    continue block7;
                }
                default: {
                    sStr2.append(c);
                }
            }
        }
        return sStr2.toString();
    }
}

